---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: 'Containerd charm '
  description: Containerd container runtime subordinate
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.21/charm-containerd.html
layout:
    - base
    - ubuntu-com
toc: false
charm_revision: '105'
bundle_release: '1.21'
---

This subordinate charm deploys the [Containerd](https://containerd.io/)
engine within a running Juju model. Containerd is an open platform
for developers and sysadmins to build, ship, and run distributed applications
in containers.

Containerd focuses on distributing applications as containers that can be quickly
assembled from components that are run the same on different servers without
environmental dependencies. This eliminates the friction between development,
QA, and production environments.

## States

The following states are set by this subordinate:

* `endpoint.{relation name}.available`

  This state is set when containerd is available for use.


## Using the Containerd subordinate charm

The Containerd subordinate charm is to be used with principal
charms that need a container runtime.  To use, we deploy
the Containerd subordinate charm and then relate it to the
principal charm.

```
juju deploy cs:~containers/containerd
juju add-relation containerd [principal charm]
```

## Scale out Usage

This charm will automatically scale out with the
principal charm.

## Configuration

<!-- CONFIG STARTS -->
<!--AUTOGENERATED CONFIG TEXT - DO NOT EDIT -->


| name | type   | Default      | Description                               |
|------|--------|--------------|-------------------------------------------|
| <a id="table-custom_registries"> </a> custom_registries | string | [] | [See notes](#custom_registries-description)  |
| <a id="table-disable-juju-proxy"> </a> disable-juju-proxy | boolean | False | Ignore juju-http(s) proxy settings on this charm. If set to true, all juju https proxy settings will be ignored  |
| <a id="table-enable-cgroups"> </a> enable-cgroups | boolean | False | Enable GRUB cgroup overrides cgroup_enable=memory swapaccount=1. WARNING changing this option will reboot the host - use with caution on production services.  |
| <a id="table-gpu_driver"> </a> gpu_driver | string | auto | Override GPU driver installation.  Options are "auto", "nvidia", "none".  |
| <a id="table-http_proxy"> </a> http_proxy | string |  | URL to use for HTTP_PROXY to be used by Containerd. Useful in egress-filtered environments where a proxy is the only option for accessing the registry to pull images.  |
| <a id="table-https_proxy"> </a> https_proxy | string |  | URL to use for HTTPS_PROXY to be used by Containerd. Useful in egress-filtered environments where a proxy is the only option for accessing the registry to pull images.  |
| <a id="table-no_proxy"> </a> no_proxy | string |  | [See notes](#no_proxy-description)  |
| <a id="table-runtime"> </a> runtime | string | auto | Set a custom containerd runtime.  Set "auto" to select based on hardware.  |
| <a id="table-shim"> </a> shim | string | containerd-shim | Set a custom containerd shim.  |

---

### custom_registries


<a id="custom_registries-description"> </a>
**Description:**

Registry credentials. Setting this config allows Kubelet to pull images from
registries where auth is required.

The value for this config must be a JSON array of credential objects, like this:
  `[{"url": "https://my.registry:port", "username": "user", "password": "pass"}]`

[Back to table](#table-custom_registries)


### no_proxy


<a id="no_proxy-description"> </a>
**Description:**

Comma-separated list of destinations (either domain names or IP
addresses) which should be accessed directly, rather than through
the proxy defined in http_proxy or https_proxy. Must be less than
2023 characters long.

[Back to table](#table-no_proxy)



<!-- CONFIG ENDS -->

## Actions

<!-- ACTIONS STARTS -->
<!-- AUTOGENERATED TEXT - DO NOT EDIT -->

You can run an action with the following

```bash
juju run-action containerd ACTION [parameters] [--wait]
```
<div class="row">
  <div class="col-2">
    <h5>
      debug
    </h5>
  </div>
  <div class="col-5">
    <p>
      Collect debug data
    </p>
  </div>
</div>
<hr>
<div class="row">
  <div class="col-2">
    <h5>
      upgrade-containerd
    </h5>
  </div>
  <div class="col-5">
    <p>
      Force upgrades Containerd to latest repository version
    </p>
  </div>
</div>
<hr>

<!-- ACTIONS ENDS -->


## Containerd links

  - The [Containerd homepage](https://containerd.io/)
