---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: 'Kubeapi-load-balancer charm '
  description: Nginx Load Balancer
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.20/charm-kubeapi-load-balancer.html
layout:
    - base
    - ubuntu-com
toc: false
charm_revision: '757'
bundle_release: '1.20'
---

Simple NGINX reverse proxy to lend a hand in HA kubernetes-master deployments.

## Configuration

<!-- CONFIG STARTS -->
<!--AUTOGENERATED CONFIG TEXT - DO NOT EDIT -->


| name | type   | Default      | Description                               |
|------|--------|--------------|-------------------------------------------|
| <a id="table-extra_packages"> </a> extra_packages | string |  | Space separated list of extra deb packages to install.  |
| <a id="table-extra_sans"> </a> extra_sans | string |  | Space-separated list of extra SAN entries to add to the x509 certificate created for the load balancers.  |
| <a id="table-ha-cluster-dns"> </a> ha-cluster-dns | string |  | DNS entry to use with the HA Cluster subordinate charm. Mutually exclusive with ha-cluster-vip.  |
| <a id="table-ha-cluster-vip"> </a> ha-cluster-vip | string |  | Virtual IP for the charm to use with the HA Cluster subordinate charm Mutually exclusive with ha-cluster-dns. Multiple virtual IPs are separated by spaces.  |
| <a id="table-host"> </a> host | string | 127.0.0.1 | listen address  |
| <a id="table-install_keys"> </a> install_keys | string |  | [See notes](#install_keys-description)  |
| <a id="table-install_sources"> </a> install_sources | string |  | [See notes](#install_sources-description)  |
| <a id="table-loadbalancer-ips"> </a> loadbalancer-ips | string |  | [See notes](#loadbalancer-ips-description)  |
| <a id="table-nagios_context"> </a> nagios_context | string | juju | [See notes](#nagios_context-description)  |
| <a id="table-nagios_servicegroups"> </a> nagios_servicegroups | string |  | A comma-separated list of nagios servicegroups. If left empty, the nagios_context will be used as the servicegroup  |
| <a id="table-package_status"> </a> package_status | string | install | The status of service-affecting packages will be set to this value in the dpkg database. Valid values are "install" and "hold".  |
| <a id="table-port"> </a> port | int | 443 | The port to run the loadbalancer  |
| <a id="table-proxy_read_timeout"> </a> proxy_read_timeout | int | 600 | Timeout in seconds for reading a response from proxy server.  |

---

### install_keys


<a id="install_keys-description"> </a>
**Description:**

List of signing keys for install_sources package sources, per charmhelpers standard format (a yaml list of strings encoded as a string). The keys should be the full ASCII armoured GPG public keys. While GPG key ids are also supported and looked up on a keyserver, operators should be aware that this mechanism is insecure. null can be used if a standard package signing key is used that will already be installed on the machine, and for PPA sources where the package signing key is securely retrieved from Launchpad.

[Back to table](#table-install_keys)


### install_sources


<a id="install_sources-description"> </a>
**Description:**

List of extra apt sources, per charm-helpers standard format (a yaml list of strings encoded as a string). Each source may be either a line that can be added directly to sources.list(5), or in the form ppa:<user>/<ppa-name> for adding Personal Package Archives, or a distribution component to enable.

[Back to table](#table-install_sources)


### loadbalancer-ips


<a id="loadbalancer-ips-description"> </a>
**Description:**

Space seperated list of IP addresses of loadbalancers in front of control plane.
A common case for this is virtual IP addresses that are floated in front of the
kubeapi-load-balancer charm. The workers will alternate IP addresses from this
list to distribute load. If you have 2 IPs and 4 workers, each IP will be used
by 2 workers.

[Back to table](#table-loadbalancer-ips)


### nagios_context


<a id="nagios_context-description"> </a>
**Description:**

Used by the nrpe subordinate charms.
A string that will be prepended to instance name to set the host name
in nagios. So for instance the hostname would be something like:

```
    juju-myservice-0
```

If you're running multiple environments with the same services in them
this allows you to differentiate between them.

[Back to table](#table-nagios_context)



<!-- CONFIG ENDS -->

## Certificates and extra SANs

See the [Certificates and trust documentation][certs-and-trust] for an overview of certificate
handling in **Charmed Kubernetes**.

For adding extra SANs and regenerating certificates, refer to the related
[documentation of the kubernetes-master charm][kubernetes-master]

<!-- ACTIONS STARTS -->
<!-- AUTOGENERATED TEXT - DO NOT EDIT -->

You can run an action with the following

```bash
juju run-action kubeapi-load-balancer ACTION [parameters] [--wait]
```
<div class="row">
  <div class="col-2">
    <h5>
      debug
    </h5>
  </div>
  <div class="col-5">
    <p>
      Collect debug data
    </p>
  </div>
</div>
<hr>

<!-- ACTIONS ENDS -->

<!-- LINKS -->

[kubernetes-master]: /kubernetes/docs/charm-kubernetes-master#extra_sans
[certs-and-trust]: /kubernetes/docs/certs-and-trust