---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: 'Docker charm '
  description: Docker container runtime subordinate
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.20/charm-docker.html
layout:
    - base
    - ubuntu-com
toc: false
charm_revision: '92'
bundle_release: '1.20'
---

This subordinate charm deploys the [Docker](http://docker.com) engine within
a running Juju charm application. Docker is an open platform for developers
and sysadmins to build, ship, and run distributed applications in containers.

Docker containers wrap a piece of software in a complete file system that
contains everything needed to run an application on a server.

Docker focuses on distributing applications as containers that can be quickly
assembled from components that are run the same on different servers without
environmental dependencies. This eliminates the friction between development,
QA, and production environments.

# States

The following states are set by this subordinate:

* `endpoint.{relation name}.available`

  This state is set when docker is available for use.


## Using the Docker subordinate charm

The Docker subordinate charm is to be used with principal
charms that need a container runtime.  To use, we deploy
the Docker subordinate charm and then relate it to the
principal charm.

```
juju deploy cs:~containers/docker
juju add-relation docker [principal charm]
```

## Scale out Usage

This charm will automatically scale out with the
principal charm.

# Configuration

<!-- CONFIG STARTS -->
<!--AUTOGENERATED CONFIG TEXT - DO NOT EDIT -->


| name | type   | Default      | Description                               |
|------|--------|--------------|-------------------------------------------|
| <a id="table-apt-key-server"> </a> apt-key-server | string | [See notes](#apt-key-server-default) | APT Key Server  |
| <a id="table-cuda_repo"> </a> cuda_repo | string | 10.0.130-1 | The cuda-repo package version to install.  |
| <a id="table-disable-juju-proxy"> </a> disable-juju-proxy | boolean | False | Ignore juju-http(s) proxy settings on this charm. If set to true, all juju https proxy settings will be ignored  |
| <a id="table-docker-ce-package"> </a> docker-ce-package | string | [See notes](#docker-ce-package-default) | The pinned version of docker-ce package installed with nvidia-docker.  |
| <a id="table-docker-logins"> </a> docker-logins | string | [] | [See notes](#docker-logins-description)  |
| <a id="table-docker-opts"> </a> docker-opts | string |  | Extra options to pass to the Docker daemon. e.g. --insecure-registry.  |
| <a id="table-docker_runtime"> </a> docker_runtime | string | auto | [See notes](#docker_runtime-description)  |
| <a id="table-docker_runtime_key_url"> </a> docker_runtime_key_url | string |  | Custom Docker repository validation key URL.  |
| <a id="table-docker_runtime_package"> </a> docker_runtime_package | string |  | Custom Docker repository package name.  |
| <a id="table-docker_runtime_repo"> </a> docker_runtime_repo | string |  | [See notes](#docker_runtime_repo-description)  |
| <a id="table-enable-cgroups"> </a> enable-cgroups | boolean | False | Enable GRUB cgroup overrides cgroup_enable=memory swapaccount=1. WARNING changing this option will reboot the host - use with caution on production services.  |
| <a id="table-http_proxy"> </a> http_proxy | string |  | URL to use for HTTP_PROXY to be used by Docker. Useful in egress-filtered environments where a proxy is the only option for accessing the registry to pull images.  |
| <a id="table-https_proxy"> </a> https_proxy | string |  | URL to use for HTTPS_PROXY to be used by Docker. Useful in egress-filtered environments where a proxy is the only option for accessing the registry to pull images.  |
| <a id="table-no_proxy"> </a> no_proxy | string |  | [See notes](#no_proxy-description)  |
| <a id="table-nvidia-container-runtime-package"> </a> nvidia-container-runtime-package | string | [See notes](#nvidia-container-runtime-package-default) | The pinned version of nvidia-container-runtime package.  |
| <a id="table-nvidia-docker-package"> </a> nvidia-docker-package | string | [See notes](#nvidia-docker-package-default) | The pinned version of nvidia-docker2 package.  |

---

### apt-key-server


<a id="apt-key-server-default"> </a>
**Default:**

```
hkp://keyserver.ubuntu.com:80
```


[Back to table](#table-apt-key-server)


### docker-ce-package


<a id="docker-ce-package-default"> </a>
**Default:**

```
docker-ce=5:18.09.1~3-0~ubuntu-bionic
```


[Back to table](#table-docker-ce-package)


### docker-logins


<a id="docker-logins-description"> </a>
**Description:**

Docker login credentials. Setting this config allows Kubelet to pull images from
registries where auth is required.

The value for this config must be a JSON array of credential objects, like this:
  [{"server": "my.registry", "username": "myUser", "password": "myPass"}]

[Back to table](#table-docker-logins)


### docker_runtime


<a id="docker_runtime-description"> </a>
**Description:**

Docker runtime to install valid values are "upstream" (Docker PPA), "nvidia" (Nvidia PPA),
"apt" (Ubuntu archive), "auto" (Nvidia PPA or Ubuntu archive, based on your hardware),
or "custom" (must have set `docker_runtime_repo` URL, `docker_runtime_key_url` URL and
`docker_runtime_package` name).

[Back to table](#table-docker_runtime)


### docker_runtime_repo


<a id="docker_runtime_repo-description"> </a>
**Description:**

Custom Docker repository, given in deb format.  Use `{ARCH}` to determine architecture at
runtime.  Use `{CODE}` to set release codename.  E.g.
`deb [arch={ARCH}] https://download.docker.com/linux/ubuntu {CODE} stable`.

[Back to table](#table-docker_runtime_repo)


### no_proxy


<a id="no_proxy-description"> </a>
**Description:**

Comma-separated list of destinations (either domain names or IP
addresses) which should be accessed directly, rather than through
the proxy defined in http_proxy or https_proxy. Must be less than
2023 characters long.

[Back to table](#table-no_proxy)


### nvidia-container-runtime-package


<a id="nvidia-container-runtime-package-default"> </a>
**Default:**

```
nvidia-container-runtime=2.0.0+docker18.09.1-1
```


[Back to table](#table-nvidia-container-runtime-package)


### nvidia-docker-package


<a id="nvidia-docker-package-default"> </a>
**Default:**

```
nvidia-docker2=2.0.3+docker18.09.1-1
```


[Back to table](#table-nvidia-docker-package)



<!-- CONFIG ENDS -->













## Docker Compose

This charm also installs the 'docker-compose' python package using pip. So
once the charm has finished installing you have the ability to use [Docker
Compose](https://docs.docker.com/compose/) functionality such as control files,
and logging.


## Docker links

  - The [Docker homepage](https://www.docker.com/)
  - Docker [documentation](https://docs.docker.com/) for help with Docker
  commands.
  - Docker [forums](https://forums.docker.com/) for community discussions.
  - Check the Docker [issue tracker](https://github.com/docker/docker/issues)
  for bugs or problems with the Docker software.
  - The [charm-docker](https://github.com/juju-solutions/charm-docker) is
  the GitHub repository that contains the reactive code to build this Charm.
  - Check the charm-docker
  [issue-tracker](https://github.com/juju-solutions/charm-docker/issues) for
  bugs or problems related to the Charm.