---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: 'Tigera-secure-ee charm '
  description: Tigera Secure Enterprise Edition
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.19/charm-tigera-secure-ee.html
layout:
    - base
    - ubuntu-com
toc: false
charm_revision: '151'
charm_name: tigera-secure-ee
bundle_release: '1.19'
---

This charm will deploy Tigera Secure Enterprise Edition (EE) as a background
service, and configure CNI for use with Tigera Secure EE, on any principal
charm that implements the [kubernetes-cni][] interface.

[kubernetes-cni]: https://github.com/juju-solutions/interface-kubernetes-cni

## Usage

The tigera-secure-ee charm is a [subordinate][]. This charm will require a
principal charm that implements the `kubernetes-cni` interface in order to
properly deploy.

[subordinate]: https://juju.is/docs/sdk#heading--subordinate-charms



## Configuration

<!-- CONFIG STARTS -->
<!--AUTOGENERATED CONFIG TEXT - DO NOT EDIT -->


| name | type   | Default      | Description                               |
|------|--------|--------------|-------------------------------------------|
| <a id="table-calico-node-image"> </a> calico-node-image | string | [See notes](#calico-node-image-default) | The image id to use for cnx node.  |
| <a id="table-calicoctl-image"> </a> calicoctl-image | string | [See notes](#calicoctl-image-default) | The image id to use for calicoctl.  |
| <a id="table-enable-elasticsearch-operator"> </a> enable-elasticsearch-operator | boolean | True | [See notes](#enable-elasticsearch-operator-description)  |
| <a id="table-ipip"> </a> ipip | string | Never | IPIP mode. Must be one of "Always", "CrossSubnet", or "Never".  |
| <a id="table-license-key"> </a> license-key | string |  | Tigera EE license key, base64-encoded. Example:  juju config tigera-secure-ee license-key=$(base64 -w0 license.yaml)  |
| <a id="table-nat-outgoing"> </a> nat-outgoing | boolean | True | NAT outgoing traffic  |
| <a id="table-registry"> </a> registry | string |  | Registry to use for images. If unspecified, defaults will be used: docker.io, quay.io, docker.elastic.co  |
| <a id="table-registry-credentials"> </a> registry-credentials | string |  | Private docker registry credentials, in the form of a base64-encoded docker config.json file. Example:  juju config tigera-secure-ee registry-credentials=$(base64 -w0 config.json)  |

---

### calico-node-image


<a id="calico-node-image-default"> </a>
**Default:**

```
tigera/cnx-node:v2.3.0
```


[Back to table](#table-calico-node-image)


### calicoctl-image


<a id="calicoctl-image-default"> </a>
**Default:**

```
tigera/calicoctl:v2.3.0
```


[Back to table](#table-calicoctl-image)


### enable-elasticsearch-operator


<a id="enable-elasticsearch-operator-description"> </a>
**Description:**

Enable deployment of elasticsearch-operator into Kubernetes. This
provides a monitoring and metrics solution for use with Tigera EE that
is suitable for proof-of-concept purposes, but is not recommended for
production use.

[Back to table](#table-enable-elasticsearch-operator)



<!-- CONFIG ENDS -->

<!-- ACTIONS STARTS -->

<!-- ACTIONS ENDS -->

## Further information

- [Tigera Secure EE Homepage](https://www.tigera.io/tigera-products/calico-enterprise/)