---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: 'Canal charm '
  description: A Software Defined Network based on Flannel and Calico
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.19/charm-canal.html
layout:
    - base
    - ubuntu-com
toc: false
charm_revision: '746'
charm_name: canal
bundle_release: '1.19'
---

Canal is a community-driven initiative that aims to allow users to easily
deploy Calico and flannel networking together as a unified networking
solution - combining Calico's industry-leading network policy enforcement with
the rich superset of Calico and flannel overlay and non-overlay network
connectivity options.

This charm will deploy flannel and calico as background services, and configure
CNI to use them, on any principal charm that implements the [kubernetes-cni][]
interface.

[kubernetes-cni]: https://github.com/juju-solutions/interface-kubernetes-cni

## Usage

The canal charm is a [subordinate][]. This charm will require a principal charm
that implements the `kubernetes-cni` interface in order to properly deploy.

[subordinate]: https://juju.is/docs/sdk#heading--subordinate-charms

```
juju deploy cs:~containers/canal
juju deploy cs:~containers/etcd
juju deploy cs:~containers/kubernetes-master
juju deploy cs:~containers/kubernetes-worker
juju add-relation canal etcd
juju add-relation canal kubernetes-master
juju add-relation canal kubernetes-worker
```

## Configuration

<!-- CONFIG STARTS -->
<!--AUTOGENERATED CONFIG TEXT - DO NOT EDIT -->


| name | type   | Default      | Description                               |
|------|--------|--------------|-------------------------------------------|
| <a id="table-calico-node-image"> </a> calico-node-image | string | [See notes](#calico-node-image-default) | The image id to use for calico/node.  |
| <a id="table-calico-policy-image"> </a> calico-policy-image | string | [See notes](#calico-policy-image-default) | The image id to use for calico/kube-controllers.  |
| <a id="table-cidr"> </a> cidr | string | 10.1.0.0/16 | Network CIDR to assign to Flannel  |
| <a id="table-iface"> </a> iface | string |  | The interface to bind flannel overlay networking. The default value is the interface bound to the cni endpoint.  |
| <a id="table-nagios_context"> </a> nagios_context | string | juju | [See notes](#nagios_context-description)  |
| <a id="table-nagios_servicegroups"> </a> nagios_servicegroups | string |  | A comma-separated list of nagios servicegroups. If left empty, the nagios_context will be used as the servicegroup  |

---

### calico-node-image


<a id="calico-node-image-default"> </a>
**Default:**

```
rocks.canonical.com:443/cdk/calico/node:v3.10.1
```


[Back to table](#table-calico-node-image)


### calico-policy-image


<a id="calico-policy-image-default"> </a>
**Default:**

```
rocks.canonical.com:443/cdk/calico/kube-controllers:v3.10.1
```


[Back to table](#table-calico-policy-image)


### nagios_context


<a id="nagios_context-description"> </a>
**Description:**

Used by the nrpe subordinate charms.
A string that will be prepended to instance name to set the host name
in nagios. So for instance the hostname would be something like:

```
    juju-myservice-0
```

If you're running multiple environments with the same services in them
this allows you to differentiate between them.

[Back to table](#table-nagios_context)



<!-- CONFIG ENDS -->


## Known Limitations

This subordinate does not support being co-located with other deployments of
the canal subordinate (to gain 2 vlans on a single application). If you
require this support please file a bug.

This subordinate also leverages juju-resources, so it is currently only
available on juju 2.0+ controllers.

<!-- ACTIONS STARTS -->

<!-- ACTIONS ENDS -->


## Further information

- [Canal Project Page](https://github.com/projectcalico/canal)