---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: 'Calico charm '
  description: A robust Software Defined Network from Project Calico
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.19/charm-calico.html
layout:
    - base
    - ubuntu-com
toc: false
charm_revision: '755'
charm_name: calico
bundle_release: '1.19'
---

Calico is a new approach to virtual networking and network security for containers,
VMs, and bare metal services, that provides a rich set of security enforcement
capabilities running on top of a highly scalable and efficient virtual network fabric.

This charm will deploy calico as a background service, and configure CNI for
use with calico, on any principal charm that implements the [kubernetes-cni][]
interface.

[kubernetes-cni]: https://github.com/juju-solutions/interface-kubernetes-cni

## Usage

The calico charm is a [subordinate][]. This charm will require a principal charm
that implements the `kubernetes-cni` interface in order to properly deploy.

[subordinate]: https://juju.is/docs/sdk#heading--subordinate-charms


```
juju deploy cs:~containers/calico
juju deploy cs:~containers/etcd
juju deploy cs:~containers/kubernetes-master
juju deploy cs:~containers/kubernetes-worker
juju add-relation calico etcd
juju add-relation calico kubernetes-master
juju add-relation calico kubernetes-worker
```

<!-- CONFIG STARTS -->
<!--AUTOGENERATED CONFIG TEXT - DO NOT EDIT -->


| name | type   | Default      | Description                               |
|------|--------|--------------|-------------------------------------------|
| <a id="table-calico-node-image"> </a> calico-node-image | string | [See notes](#calico-node-image-default) | The image id to use for calico/node.  |
| <a id="table-calico-policy-image"> </a> calico-policy-image | string | [See notes](#calico-policy-image-default) | The image id to use for calico/kube-controllers.  |
| <a id="table-cidr"> </a> cidr | string | 192.168.0.0/16 | Network CIDR assigned to Calico. This is applied to the default Calico pool, and is also communicated to the Kubernetes charms for use in kube-proxy configuration.  |
| <a id="table-global-as-number"> </a> global-as-number | int | 64512 | Global AS number.  |
| <a id="table-global-bgp-peers"> </a> global-bgp-peers | string | [] | List of global BGP peers. Each BGP peer is specified with an address and an as-number.  Example value: "[{address: 10.0.0.1, as-number: 65000}, {address: 10.0.0.2, as-number: 65001}]"  |
| <a id="table-ipip"> </a> ipip | string | Never | IPIP mode. Must be one of "Always", "CrossSubnet", or "Never".  |
| <a id="table-manage-pools"> </a> manage-pools | boolean | True | If true, a default pool is created using the cidr and ipip charm configuration values.  Warning: When manage-pools is enabled, the charm will delete any pools that are unrecognized.  |
| <a id="table-nat-outgoing"> </a> nat-outgoing | boolean | True | NAT outgoing traffic  |
| <a id="table-node-to-node-mesh"> </a> node-to-node-mesh | boolean | True | When enabled, each Calico node will peer with every other Calico node in the cluster.  |
| <a id="table-route-reflector-cluster-ids"> </a> route-reflector-cluster-ids | string | {} | Mapping of unit IDs to route reflector cluster IDs. Assigning a route reflector cluster ID allows the node to function as a route reflector.  Example value: "{0: 224.0.0.1, 2: 224.0.0.1}"  |
| <a id="table-subnet-as-numbers"> </a> subnet-as-numbers | string | {} | [See notes](#subnet-as-numbers-description)  |
| <a id="table-subnet-bgp-peers"> </a> subnet-bgp-peers | string | {} | [See notes](#subnet-bgp-peers-description)  |
| <a id="table-unit-as-numbers"> </a> unit-as-numbers | string | {} | [See notes](#unit-as-numbers-description)  |
| <a id="table-unit-bgp-peers"> </a> unit-bgp-peers | string | {} | [See notes](#unit-bgp-peers-description)  |

---

### calico-node-image


<a id="calico-node-image-default"> </a>
**Default:**

```
rocks.canonical.com:443/cdk/calico/node:v3.10.1
```


[Back to table](#table-calico-node-image)


### calico-policy-image


<a id="calico-policy-image-default"> </a>
**Default:**

```
rocks.canonical.com:443/cdk/calico/kube-controllers:v3.10.1
```


[Back to table](#table-calico-policy-image)


### subnet-as-numbers


<a id="subnet-as-numbers-description"> </a>
**Description:**

Mapping of subnets to AS numbers, specified as YAML. Each Calico node
will be assigned an AS number based on the entries in this mapping.

Example value: "{10.0.0.0/24: 64512, 10.0.1.0/24: 64513}"

If a node's IP matches any of the specified subnets, then the
corresponding AS number is used instead of the global one.

If a node's IP matches no subnets, then the global AS number will be
used instead.

If a node's IP matches multiple subnets, then the most specific subnet
will be used, e.g. a /24 subnet will take precedence over a /16.

[Back to table](#table-subnet-as-numbers)


### subnet-bgp-peers


<a id="subnet-bgp-peers-description"> </a>
**Description:**

Mapping of subnets to lists of BGP peers. Each BGP peer is specified with
an address and an as-number.

Example value: "{10.0.0.0/24: [{address: 10.0.0.1, as-number: 65000}, {address: 10.0.0.2, as-number: 65001}], 10.0.1.0/24: [{address: 10.0.1.1, as-number: 65002}]}"

If a node's IP matches multiple subnets, then peerings will be added for
each matched subnet.

[Back to table](#table-subnet-bgp-peers)


### unit-as-numbers


<a id="unit-as-numbers-description"> </a>
**Description:**

Mapping of unit IDs to AS numbers, specified as YAML. Each Calico node
will be assigned an AS number based on the entries in this mapping.

Example value: "{0: 64512, 1: 64513}"

This takes precedence over global-as-number and subnet-as-numbers.

[Back to table](#table-unit-as-numbers)


### unit-bgp-peers


<a id="unit-bgp-peers-description"> </a>
**Description:**

Mapping of unit IDs to lists of BGP peers. Each BGP peer is specified
with an address and an as-number.

Example value: "{0: [{address: 10.0.0.1, as-number: 65000}, {address: 10.0.0.2, as-number: 65001}], 1: [{address: 10.0.1.1, as-number: 65002}]}"

[Back to table](#table-unit-bgp-peers)



<!-- CONFIG ENDS -->

<!-- ACTIONS STARTS -->

<!-- ACTIONS ENDS -->


## Further information

- [Calico Homepage](https://www.projectcalico.org/)