---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: Components of Charmed Kubernetes 1.18
  description: Detailed description of Charmed Kubernetes release
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.18/components.html
layout:
    - base
    - ubuntu-com
toc: false
bundle_revision: '485'
bundle_release: '1.18'
---

<!-- THIS PAGE IS AUTOGENERATED -->
<!-- If you find an error in this page, it is likely to be in the original
source of the information - please file a bug rather than editing the text -->

This page details the charms, snaps, images and other components
which comprise the 1.18 release of Charmed Kubernetes.

Other information about this release can be found on the following pages:

<a class='p-button--brand' href='/kubernetes/docs/1.18/release-notes'>Release notes </a>
<a class='p-button--brand' href='/kubernetes/docs/1.18/upgrading'>Upgrading </a>
<a class='p-button--brand' href='https://bugs.launchpad.net/charmed-kubernetes'>Bugs </a>
<a class='p-button--brand' href='https://github.com/charmed-kubernetes/bundle'>Source </a>
<a class='p-button--brand' href='https://launchpad.net/charmed-kubernetes/+milestone/1.18'>Milestone </a>

## What's new

For a list of new features, changes, deprecations, and bug fixes in this
release, please see the [Release notes](release-notes).

## Core charms

These charms are the core components or official optional components of the
release. These charms are maintained by the Charmed Kubernetes team.

<table class ="u-table-layout--auto">
  <thead>
    <tr>
      <th>Charm</th>
      <th>Summary</th>
      <th>docs</th>
      <th>source</th>
      <th>bugs</th>
      <th>version</th>
      <th>notes</th>
    </tr>
  </thead>
  <tbody>
<tr>
  <td> aws-iam </td>
  <td> A charm that enables using AWS IAM to authenticate with Kubernetes </td>
  <td> <a href="/kubernetes/docs/1.18/charm-aws-iam">docs</a> </td> <td> <a href="https://github.com/charmed-kubernetes/charm-aws-iam"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 50 </td>
  <td> -- </td>
</tr>
<tr>
  <td> aws-integrator </td>
  <td> Charm to enable AWS integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.18/charm-aws-integrator">docs</a> </td> <td> <a href="https://github.com/juju-solutions/charm-aws-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 58 </td>
  <td> -- </td>
</tr>
<tr>
  <td> azure-integrator </td>
  <td> Proxy charm to enable Azure integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.18/charm-azure-integrator">docs</a> </td> <td> <a href="https://github.com/juju-solutions/charm-azure-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 43 </td>
  <td> -- </td>
</tr>
<tr>
  <td> calico </td>
  <td> A robust Software Defined Network from Project Calico </td>
  <td> <a href="/kubernetes/docs/1.18/charm-calico">docs</a> </td> <td> <a href="https://github.com/juju-solutions/layer-calico"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 741 </td>
  <td> -- </td>
</tr>
<tr>
  <td> canal </td>
  <td> A Software Defined Network based on Flannel and Calico </td>
  <td> <a href="/kubernetes/docs/1.18/charm-canal">docs</a> </td> <td> <a href="https://github.com/juju-solutions/layer-canal"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 736 </td>
  <td> -- </td>
</tr>
<tr>
  <td> containerd </td>
  <td> Containerd container runtime subordinate </td>
  <td> <a href="/kubernetes/docs/1.18/charm-containerd">docs</a> </td> <td> <a href=""> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 88 </td>
  <td> -- </td>
</tr>
<tr>
  <td> docker </td>
  <td> Docker container runtime subordinate </td>
  <td> <a href="/kubernetes/docs/1.18/charm-docker">docs</a> </td> <td> <a href=""> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 81 </td>
  <td> -- </td>
</tr>
<tr>
  <td> docker-registry </td>
  <td> Registry for docker images </td>
  <td> <a href="/kubernetes/docs/1.18/charm-docker-registry">docs</a> </td> <td> <a href="https://github.com/CanonicalLtd/docker-registry-charm"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 163 </td>
  <td> -- </td>
</tr>
<tr>
  <td> easyrsa </td>
  <td> Delivers EasyRSA to create a Certificate Authority (CA). </td>
  <td> <a href="/kubernetes/docs/1.18/charm-easyrsa">docs</a> </td> <td> <a href="https://github.com/charmed-kubernetes/layer-easyrsa"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 325 </td>
  <td> -- </td>
</tr>
<tr>
  <td> etcd </td>
  <td> Deploy a TLS terminated ETCD Cluster </td>
  <td> <a href="/kubernetes/docs/1.18/charm-etcd">docs</a> </td> <td> <a href="https://github.com/charmed-kubernetes/layer-etcd"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 531 </td>
  <td> -- </td>
</tr>
<tr>
  <td> flannel </td>
  <td> A charm that provides a robust Software Defined Network </td>
  <td> <a href="/kubernetes/docs/1.18/charm-flannel">docs</a> </td> <td> <a href="https://github.com/coreos/flannel"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 501 </td>
  <td> -- </td>
</tr>
<tr>
  <td> gcp-integrator </td>
  <td> Charm to enable GCP integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.18/charm-gcp-integrator">docs</a> </td> <td> <a href="https://github.com/juju-solutions/charm-gcp-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 50 </td>
  <td> -- </td>
</tr>
<tr>
  <td> kata </td>
  <td> Kata untrusted container runtime subordinate </td>
  <td> <a href="/kubernetes/docs/1.18/charm-kata">docs</a> </td> <td> <a href=""> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 55 </td>
  <td> -- </td>
</tr>
<tr>
  <td> keepalived </td>
  <td> Failover and monitoring daemon for LVS clusters </td>
  <td> <a href="/kubernetes/docs/1.18/charm-keepalived">docs</a> </td> <td> <a href="https://github.com/juju-solutions/charm-keepalived"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 28 </td>
  <td> -- </td>
</tr>
<tr>
  <td> kubeapi-load-balancer </td>
  <td> Nginx Load Balancer </td>
  <td> <a href="/kubernetes/docs/1.18/charm-kubeapi-load-balancer">docs</a> </td> <td> <a href="https://nginx.org/en/"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 742 </td>
  <td> -- </td>
</tr>
<tr>
  <td> kubernetes-master </td>
  <td> The Kubernetes control plane. </td>
  <td> <a href="/kubernetes/docs/1.18/charm-kubernetes-master">docs</a> </td> <td> <a href="https://github.com/charmed-kubernetes/charm-kubernetes-master"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 865 </td>
  <td> -- </td>
</tr>
<tr>
  <td> kubernetes-worker </td>
  <td> The workload bearing units of a kubernetes cluster </td>
  <td> <a href="/kubernetes/docs/1.18/charm-kubernetes-worker">docs</a> </td> <td> <a href="https://github.com/charmed-kubernetes/charm-kubernetes-worker"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 692 </td>
  <td> -- </td>
</tr>
<tr>
  <td> openstack-integrator </td>
  <td> Proxy charm to enable OpenStack integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.18/charm-openstack-integrator">docs</a> </td> <td> <a href="https://github.com/juju-solutions/charm-openstack-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 81 </td>
  <td> -- </td>
</tr>
<tr>
  <td> tigera-secure-ee </td>
  <td> Tigera Secure Enterprise Edition </td>
  <td> <a href="/kubernetes/docs/1.18/charm-tigera-secure-ee">docs</a> </td> <td> <a href=""> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 141 </td>
  <td> -- </td>
</tr>
<tr>
  <td> vsphere-integrator </td>
  <td> Proxy charm to enable VMware vSphere integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.18/charm-vsphere-integrator">docs</a> </td> <td> <a href="https://github.com/juju-solutions/charm-vsphere-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 39 </td>
  <td> -- </td>
</tr>

 </tbody>
 </table>

## Compatible Charms

These charms are frequently used with Charmed Kubernetes.

<table class ="u-table-layout--auto">
  <thead>
    <tr>
      <th>Charm</th>
      <th>Summary</th>
      <th>Store page</th>
      <th>notes</th>
    </tr>
  </thead>
  <tbody>
<tr>
  <td> apache2 </td>
  <td> Apache HTTP Server metapackage </td>
  <td> <a href="https://jaas.ai/apache2">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> ceph-osd </td>
  <td> Highly scalable distributed storage - Ceph OSD storage </td>
  <td> <a href="https://jaas.ai/ceph-osd">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> elasticsearch </td>
  <td> Open Source, Distributed, RESTful, Search Engine built on Apache Lucene </td>
  <td> <a href="https://jaas.ai/elasticsearch">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> filebeat </td>
  <td> Filebeat is a lightweight, open source shipper for log file data. </td>
  <td> <a href="https://jaas.ai/filebeat">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> grafana </td>
  <td> Graph and Dashboard builder </td>
  <td> <a href="https://jaas.ai/grafana">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> graylog </td>
  <td> Graylog log management system </td>
  <td> <a href="https://jaas.ai/graylog">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> hacluster </td>
  <td> Corosync Cluster Engine - membership, messaging and quorum </td>
  <td> <a href="https://jaas.ai/hacluster">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> mongodb </td>
  <td> An open-source document database, and the leading NoSQL database </td>
  <td> <a href="https://jaas.ai/mongodb">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> nagios </td>
  <td> Nagios Core 3 monitoring. </td>
  <td> <a href="https://jaas.ai/nagios">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> nfs </td>
  <td> NFS server </td>
  <td> <a href="https://jaas.ai/nfs">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> nrpe </td>
  <td> Nagios Remote Plugin Executor Server </td>
  <td> <a href="https://jaas.ai/nrpe">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> prometheus2 </td>
  <td> Monitoring system and timeseries database. v2.0 and later only </td>
  <td> <a href="https://jaas.ai/prometheus2">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> telegraf </td>
  <td> The plugin-driven server agent for collecting & reporting metrics. </td>
  <td> <a href="https://jaas.ai/telegraf">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> vault </td>
  <td> a tool for managing secrets </td>
  <td> <a href="https://jaas.ai/vault">docs</a> </td>
  <td>  </td>
</tr>

 </tbody>
 </table>


## Images

These are the container images used by this release:

<!-- GENERATED CONTAINER IMAGES -->

- addon-resizer-amd64:1.8.5
- addon-resizer-arm64:1.8.5
- addon-resizer-ppc64le:1.8.5
- addon-resizer-s390x:1.8.5
- cephcsi/cephfsplugin:v1.0.0
- cephcsi/rbdplugin:v1.0.0
- coredns/coredns:1.6.7
- coreos/kube-state-metrics:v1.9.5
- defaultbackend-amd64:1.5
- defaultbackend-arm64:1.5
- defaultbackend-s390x:1.4
- external_storage/nfs-client-provisioner:v3.1.0-k8s1.11
- k8s-dns-dnsmasq-nanny:1.14.13
- k8s-dns-kube-dns:1.14.13
- k8s-dns-sidecar:1.14.13
- k8scloudprovider/cinder-csi-plugin:v1.17.0
- k8scloudprovider/k8s-keystone-auth:latest
- k8scloudprovider/openstack-cloud-controller-manager:v1.17.0
- k8scsi/csi-attacher:v1.0.1
- k8scsi/csi-attacher:v2.0.0
- k8scsi/csi-node-driver-registrar:v1.0.2
- k8scsi/csi-node-driver-registrar:v1.1.0
- k8scsi/csi-provisioner:v1.0.2
- k8scsi/csi-provisioner:v1.4.0
- k8scsi/csi-resizer:v0.3.0
- k8scsi/csi-snapshotter:v1.0.2
- k8scsi/csi-snapshotter:v1.2.2
- kubernetes-ingress-controller/nginx-ingress-controller-amd64:0.30.0
- kubernetes-ingress-controller/nginx-ingress-controller-arm64:0.30.0
- kubernetes-ingress-controller/nginx-ingress-controller-s390x:0.20.0
- kubernetesui/dashboard-amd64:v2.0.0-rc5
- kubernetesui/dashboard-arm64:v2.0.0-rc5
- kubernetesui/dashboard-ppc64le:v2.0.0-rc5
- kubernetesui/dashboard-s390x:v2.0.0-rc5
- kubernetesui/metrics-scraper:v1.0.3
- metrics-server-amd64:v0.3.6
- metrics-server-arm64:v0.3.6
- metrics-server-ppc64le:v0.3.6
- metrics-server-s390x:v0.3.6
- microbot-amd64:latest
- microbot-arm64:latest
- nvidia/k8s-device-plugin:v0.7.0-rc.7
- pause-amd64:3.2
- pause-arm64:3.2
- pause-ppc64le:3.2
- pause-s390x:3.2
- rancher/rancher:latest
- registry-amd64:2.6
- registry-arm64:2.6
- sonatype/nexus3:latest

<!-- CONTAINER IMAGES END -->

## Snaps

The following snaps are used by this release of Charmed Kubernetes:


| snap  | confinement | summary | link |
|-------|-------------|---------|------|
|aws-cli| classic | Resource to side-load aws-cli snap in network-restricted deployments. | [store page](https://snapcraft.io/aws-cli) |
|core| strict | core snap | [store page](https://snapcraft.io/core) |
|etcd| classic | Snap package of etcd | [store page](https://snapcraft.io/etcd) |
|gcloud| ? | Resource to side-load gcloud snap in network-restricted deployments. | ? |
|cdk-addons| strict | CDK addons snap | [store page](https://snapcraft.io/cdk-addons) |
|kube-apiserver| strict | kube-apiserver snap | [store page](https://snapcraft.io/kube-apiserver) |
|kube-controller-manager| strict | kube-controller-manager snap | [store page](https://snapcraft.io/kube-controller-manager) |
|kube-proxy| classic | kube-proxy snap | [store page](https://snapcraft.io/kube-proxy) |
|kube-scheduler| strict | kube-scheduler snap | [store page](https://snapcraft.io/kube-scheduler) |
|kubectl| classic | kubectl snap | [store page](https://snapcraft.io/kubectl) |
|kubelet| classic | kubelet snap | [store page](https://snapcraft.io/kubelet) |
|openstackclients| classic | Resource to side-load openstackclients snap in network-restricted deployments. | [store page](https://snapcraft.io/openstackclients) |







<!-- LINKS -->
[documentation]: /kubernetes/docs/
[release notes]: /kubernetes/docs/release-notes#1.18
[upgrade notes]: /kubernetes/docs/
[bugs]: /kubernetes/docs/
[source]: https://github.com/charmed-kubernetes
[1.18 milestone]: https://launchpad.net/charmed-kubernetes/+milestone/1.18
