---
bundle_release: '1.18'
charm_name: kubernetes-worker
charm_revision: '692'
context:
  description: The workload bearing units of a kubernetes cluster
  title: 'Kubernetes-worker charm '
keywords: component, charms, versions, release
layout:
- base
- ubuntu-com
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
permalink: 1.18/charm-kubernetes-worker.html
sidebar: k8smain-sidebar
tags:
- reference
toc: false
wrapper_template: "templates/docs/markdown.html"
---

This charm deploys a container runtime and the Kubernetes
worker applications: kubelet, and kube-proxy.

In order for this charm to be useful, it should be deployed with its companion
charm kubernetes-master and linked with an SDN-Plugin and a container runtime
such as containerd.

This charm is part of the [Charmed Kubernetes bundle](https://jaas.ai/charmed-kubernetes/bundle) bundle which can be deployed with a single command::

```bash
juju deploy charmed-kubernetes
```

For more information about Charmed Kubernetes see the [overview documentation](/kubernetes/docs/overview)

## Scale out

To add additional compute capacity to your Kubernetes workers, you may
`juju add-unit kubernetes-worker` to scale the cluster. The new units will
automatically join any related kubernetes-master, and enlist themselves as
ready once the deployment is complete.

## Snap Configuration

The Kubernetes resources used by this charm are snap packages. When not
specified during deployment, these resources come from the public store. By
default, the snapd daemon will refresh all snaps installed from the store
four (4) times per day. A charm configuration option is provided for operators
to control this refresh frequency.


### Examples:

##### refresh kubernetes-worker snaps every tuesday

```bash
juju config kubernetes-worker snapd_refresh="tue"
```

##### refresh snaps at 11pm on the last (5th) friday of the month

```bash
juju config kubernetes-worker snapd_refresh="fri5,23:00"
```
##### delay the refresh as long as possible

```bash
juju config kubernetes-worker snapd_refresh="max"
```

##### use the system default refresh timer

```bash
juju config kubernetes-worker snapd_refresh=""
```


For more information, see the [snap documentation](/kubernetes/docs/snap-refresh).

## Configuration

This charm supports some configuration options to set up a Kubernetes cluster
that works in your environment, detailed in the section below.

For some specific Kubernetes service configuration tasks, please also see the
section on [configuring K8s services](#k8s-services).
Please also see the [`kubernetes-master` charm configuration][charm-kubernetes-master]
for other settings relating to Kubernetes services.

<!-- CONFIG STARTS -->
<!--AUTOGENERATED CONFIG TEXT - DO NOT EDIT -->


| name | type   | Default      | Description                               |
|------|--------|--------------|-------------------------------------------|
| <a id="table-allow-privileged"> </a> allow-privileged | string | true | This option is now deprecated and has no effect.  |
| <a id="table-channel"> </a> channel | string | 1.17/stable | Snap channel to install Kubernetes worker services from  |
| <a id="table-default-backend-image"> </a> default-backend-image | string | auto | Docker image to use for the default backend. Auto will select an image based on architecture.  |
| <a id="table-ingress"> </a> ingress | boolean | True | Deploy the default http backend and ingress controller to handle ingress requests.  |
| <a id="table-ingress-ssl-chain-completion"> </a> ingress-ssl-chain-completion | boolean | False | [See notes](#ingress-ssl-chain-completion-description)  |
| <a id="table-ingress-ssl-passthrough"> </a> ingress-ssl-passthrough | boolean | False | Enable ssl passthrough on ingress server. This allows passing the ssl connection through to the workloads and not terminating it at the ingress controller.  |
| <a id="table-kubelet-extra-args"> </a> kubelet-extra-args | string |  | [See notes](#kubelet-extra-args-description)  |
| <a id="table-kubelet-extra-config"> </a> kubelet-extra-config | string | {} | [See notes](#kubelet-extra-config-description)  |
| <a id="table-labels"> </a> labels | string |  | Labels can be used to organize and to select subsets of nodes in the cluster. Declare node labels in key=value format, separated by spaces.  |
| <a id="table-nagios_context"> </a> nagios_context | string | juju | [See notes](#nagios_context-description)  |
| <a id="table-nagios_servicegroups"> </a> nagios_servicegroups | string |  | A comma-separated list of nagios servicegroups. If left empty, the nagios_context will be used as the servicegroup  |
| <a id="table-nginx-image"> </a> nginx-image | string | auto | Docker image to use for the nginx ingress controller. Auto will select an image based on architecture.  |
| <a id="table-proxy-extra-args"> </a> proxy-extra-args | string |  | [See notes](#proxy-extra-args-description)  |
| <a id="table-require-manual-upgrade"> </a> require-manual-upgrade | boolean | True | When true, worker services will not be upgraded until the user triggers it manually by running the upgrade action.  |
| <a id="table-snap_proxy"> </a> snap_proxy | string |  | DEPRECATED. Use snap-http-proxy and snap-https-proxy model configuration settings. HTTP/HTTPS web proxy for Snappy to use when accessing the snap store.  |
| <a id="table-snap_proxy_url"> </a> snap_proxy_url | string |  | DEPRECATED. Use snap-store-proxy model configuration setting. The address of a Snap Store Proxy to use for snaps e.g. http://snap-proxy.example.com  |
| <a id="table-snapd_refresh"> </a> snapd_refresh | string | max | [See notes](#snapd_refresh-description)  |
| <a id="table-sysctl"> </a> sysctl | string | [See notes](#sysctl-default) | [See notes](#sysctl-description)  |

---

### ingress-ssl-chain-completion


<a id="ingress-ssl-chain-completion-description"> </a>
**Description:**

Enable chain completion for TLS certificates used by the nginx ingress
controller.  Set this to true if you would like the ingress controller
to attempt auto-retrieval of intermediate certificates.  The default
(false) is recommended for all production kubernetes installations, and
any environment which does not have outbound Internet access.

[Back to table](#table-ingress-ssl-chain-completion)


### kubelet-extra-args


<a id="kubelet-extra-args-description"> </a>
**Description:**

Space separated list of flags and key=value pairs that will be passed as arguments to
kubelet. For example a value like this:

```
  runtime-config=batch/v2alpha1=true profiling=true
```

will result in kubelet being run with the following options:

```
  --runtime-config=batch/v2alpha1=true --profiling=true
```

Note: As of Kubernetes 1.10.x, many of Kubelet's args have been deprecated, and can
be set with kubelet-extra-config instead.

[Back to table](#table-kubelet-extra-args)


### kubelet-extra-config


<a id="kubelet-extra-config-description"> </a>
**Description:**

Extra configuration to be passed to kubelet. Any values specified in this
config will be merged into a KubeletConfiguration file that is passed to
the kubelet service via the --config flag. This can be used to override
values provided by the charm.

Requires Kubernetes 1.10+.

The value for this config must be a YAML mapping that can be safely
merged with a KubeletConfiguration file. For example:

```
  {evictionHard: {memory.available: 200Mi}}
```


For more information about KubeletConfiguration, see upstream docs:
https://kubernetes.io/docs/tasks/administer-cluster/kubelet-config-file/

[Back to table](#table-kubelet-extra-config)


### nagios_context


<a id="nagios_context-description"> </a>
**Description:**

Used by the nrpe subordinate charms.
A string that will be prepended to instance name to set the host name
in nagios. So for instance the hostname would be something like:

```
    juju-myservice-0
```

If you're running multiple environments with the same services in them
this allows you to differentiate between them.

[Back to table](#table-nagios_context)


### proxy-extra-args


<a id="proxy-extra-args-description"> </a>
**Description:**

Space separated list of flags and key=value pairs that will be passed as arguments to
kube-proxy. For example a value like this:

```
  runtime-config=batch/v2alpha1=true profiling=true
```

will result in kube-apiserver being run with the following options:
  --runtime-config=batch/v2alpha1=true --profiling=true

[Back to table](#table-proxy-extra-args)


### snapd_refresh


<a id="snapd_refresh-description"> </a>
**Description:**

How often snapd handles updates for installed snaps. Setting an empty
string will check 4x per day. Set to "max" to delay the refresh as long
as possible. You may also set a custom string as described in the
'refresh.timer' section here:
  https://forum.snapcraft.io/t/system-options/87

[Back to table](#table-snapd_refresh)


### sysctl


<a id="sysctl-default"> </a>
**Default:**

```
{ net.ipv4.conf.all.forwarding : 1, net.ipv4.neigh.default.gc_thresh1 : 128, net.ipv4.neigh.default.gc_thresh2 : 28672, net.ipv4.neigh.default.gc_thresh3 : 32768, net.ipv6.neigh.default.gc_thresh1 : 128, net.ipv6.neigh.default.gc_thresh2 : 28672, net.ipv6.neigh.default.gc_thresh3 : 32768, fs.inotify.max_user_instances : 8192, fs.inotify.max_user_watches: 1048576 }
```


[Back to table](#table-sysctl)


<a id="sysctl-description"> </a>
**Description:**

YAML formatted associative array of sysctl values, e.g.:
'{kernel.pid_max : 4194303 }'. Note that kube-proxy handles
the conntrack settings. The proper way to alter them is to
use the proxy-extra-args config to set them, e.g.:

```
  juju config kubernetes-master proxy-extra-args="conntrack-min=1000000 conntrack-max-per-core=250000"
  juju config kubernetes-worker proxy-extra-args="conntrack-min=1000000 conntrack-max-per-core=250000"
```

The proxy-extra-args conntrack-min and conntrack-max-per-core can be set to 0 to ignore
kube-proxy's settings and use the sysctl settings instead. Note the fundamental difference between
the setting of conntrack-max-per-core vs nf_conntrack_max.

[Back to table](#table-sysctl)



<!-- CONFIG ENDS -->


<a id="k8s-services"> </a>
## Configuring K8s services

### IPVS (IP Virtual Server)

This requires configuration of both the `kubernetes-master` and
`kubernetes-worker` charms. Please see the configuration section on
the [kubernetes-master page](/kubernetes/docs/charm-kubernetes-master#config-ipvs).

### Configuring kubelet

Each worker runs the node agent, `kubelet` with a set of arguments and
configuration set by this charm. In some cases it may be desirable to add
options or arguments, for which the charm provides two mechanisms

[kubelet-extra-args](#kubelet-extra-args-description) for command line options.
[kubelet-extra-config](#kubelet-extra-config-description) for configuration.

The definitive reference for `kubelet` is the [upstream documentation][kubelet-docs].

### HugePages

HugePages are a standard memory management feature of the Linux kernel to
decrease overhead for processes which consume large amounts of memory.

Kubernetes includes support for using HugePages with pods (see the
[upstream documentation](https://kubernetes.io/docs/tasks/manage-hugepages/scheduling-hugepages/)).

To use HugePages in your pods with **Charmed Kubernetes**, it is necessary to
update the configuration for the workers:

1.  Fetch the current 'sysctl' configuration from the worker:
    ```bash
    juju config kubernetes-worker sysctl
    ```
    This should return a string of config options, e.g.:
    ```
    { net.ipv4.conf.all.forwarding : 1, net.ipv4.neigh.default.gc_thresh1 : 128, net.ipv4.neigh.default.gc_thresh2 : 28672, net.ipv4.neigh.default.gc_thresh3 : 32768, net.ipv6.neigh.default.gc_thresh1 : 128, net.ipv6.neigh.default.gc_thresh2 : 28672, net.ipv6.neigh.default.gc_thresh3 : 32768, fs.inotify.max_user_instances : 8192, fs.inotify.max_user_watches: 1048576 }
    ```
2.  The config option for HugePages is `vm.nr_hugepages`. To add this
    configuration, you should **append** it to the string and set the whole
    configuration. For example, for 100 2Mi pages:
    ```bash
    juju config kubernetes-worker sysctl="{ net.ipv4.conf.all.forwarding : 1, net.ipv4.neigh.default.gc_thresh1 : 128, net.ipv4.neigh.default.gc_thresh2 : 28672, net.ipv4.neigh.default.gc_thresh3 : 32768, net.ipv6.neigh.default.gc_thresh1 : 128, net.ipv6.neigh.default.gc_thresh2 : 28672, net.ipv6.neigh.default.gc_thresh3 : 32768, fs.inotify.max_user_instances : 8192, fs.inotify.max_user_watches: 1048576, vm.nr_hugepages: 100}"
    ```
3.  HugePages can now be consumed via container level resource requirements
    using the resource name <code>hugepages-&lt;size&gt;</code>.

    For example:

    ```yaml
    apiVersion: v1
    kind: Pod
    metadata:
      name: hugepages-test
    spec:
      containers:
      - image: ubuntu:latest
        command:
        - sleep
        - inf
        name: example
        volumeMounts:
        - mountPath: /hugepages
          name: hugepage
        resources:
          limits:
            hugepages-2Mi: 100Mi
            memory: 100Mi
          requests:
            memory: 100Mi      
      volumes:
      - name: hugepage
        emptyDir:
          medium: HugePages  
    ```
    Huge page usage in a namespace can be managed with ResourceQuota,
    similar to other compute resources.
4.  To verify, you can exec into the pod and check the `/proc/meminfo`.
    ```
    kubectl exec hugepage-test cat /proc/meminfo | grep HugePages_
    ```

## Actions

<!-- ACTIONS STARTS -->
<!-- AUTOGENERATED TEXT - DO NOT EDIT -->

You can run an action with the following

```bash
juju run-action kubernetes-worker ACTION [parameters] [--wait]
```
<div class="row">
  <div class="col-2">
    <h5>
      cis-benchmark
    </h5>
  </div>
  <div class="col-5">
    <p>
      Run the CIS Kubernetes Benchmark against snap-based components.
    </p>
  </div>
</div>
<div class="row">
  <div class="col-2"></div>
  <div class="col-5">
    <p>
      This action has the following parameters:
    </p>
    <hr>
    <pre>apply</pre>
    <p>
      Apply remediations to address benchmark failures. The default, 'none', will not attempt to fix any reported failures. Set to 'conservative' to resolve simple failures. Set to 'dangerous' to attempt to resolve all failures. Note: Applying any remediation may result in an unusable cluster.
    </p>
    <p>
      <strong>Default:</strong> none
    </p><br>
    <pre>config</pre>
    <p>
      Archive containing configuration files to use when running kube-bench. The default value is known to be compatible with snap components. When using a custom URL, append '#&lt;hash_type&gt;=&lt;checksum&gt;' to verify the archive integrity when downloaded.
    </p>
    <p>
      <strong>Default:</strong> https://github.com/charmed-kubernetes/kube-bench-c onfig/archive/cis-1.5.zip#sha1=cb8e78712ee5bfeab87 d0ed7c139a83e88915530
    </p><br>
    <pre>release</pre>
    <p>
      Set the kube-bench release to run. If set to 'upstream', the action will compile and use a local kube-bench binary built from the master branch of the upstream repository: https://github.com/aquasecurity/kube-bench This value may also be set to an accessible archive containing a pre-built kube-bench binary, for example: https://github.com/aquasecurity/kube- bench/releases/download/v0.0.34/kube-bench_0.0.34_ linux_amd64.tar.gz#sha256=f96d1fcfb84b18324f1299db 074d41ef324a25be5b944e79619ad1a079fca077
    </p>
    <p>
      <strong>Default:</strong> https://github.com/aquasecurity/kube- bench/releases/download/v0.2.3/kube-bench_0.2.3_li nux_amd64.tar.gz#sha256=429a1db271689aafec009434de d1dea07a6685fee85a1deea638097c8512d548
    </p><br>
  </div>
</div>
<hr>
<div class="row">
  <div class="col-2">
    <h5>
      debug
    </h5>
  </div>
  <div class="col-5">
    <p>
      Collect debug data
    </p>
  </div>
</div>
<hr>
<div class="row">
  <div class="col-2">
    <h5>
      microbot
    </h5>
  </div>
  <div class="col-5">
    <p>
      Launch microbot containers
    </p>
  </div>
</div>
<div class="row">
  <div class="col-2"></div>
  <div class="col-5">
    <p>
      This action has the following parameters:
    </p>
    <hr>
    <pre>delete</pre>
    <p>
      Remove a microbots deployment, service, and ingress if True.
    </p>
    <p>
      <strong>Default:</strong> False
    </p><br>
    <pre>replicas</pre>
    <p>
      Number of microbots to launch in Kubernetes.
    </p>
    <p>
      <strong>Default:</strong> 3
    </p><br>
  </div>
</div>
<hr>
<div class="row">
  <div class="col-2">
    <h5>
      pause
    </h5>
  </div>
  <div class="col-5">
    <p>
      Mark the node as unschedulable to prevent new pods from arriving, and evict existing pods.
    </p>
  </div>
</div>
<div class="row">
  <div class="col-2"></div>
  <div class="col-5">
    <p>
      This action has the following parameters:
    </p>
    <hr>
    <pre>delete-local-data</pre>
    <p>
      Continue even if there are pods using emptyDir (local data that will be deleted when the node is drained).
    </p>
    <p>
      <strong>Default:</strong> False
    </p><br>
    <pre>force</pre>
    <p>
      Continue even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet.
    </p>
    <p>
      <strong>Default:</strong> False
    </p><br>
  </div>
</div>
<hr>
<div class="row">
  <div class="col-2">
    <h5>
      registry
    </h5>
  </div>
  <div class="col-5">
    <p>
      Create a private Docker registry. DEPRECATED: See https://ubuntu.com/kubernetes/docs/docker-registry
    </p>
  </div>
</div>
<div class="row">
  <div class="col-2"></div>
  <div class="col-5">
    <p>
      This action has the following parameters:
    </p>
    <hr>
    <pre>delete</pre>
    <p>
      Remove a registry replication controller, service, and ingress if True.
    </p>
    <p>
      <strong>Default:</strong> False
    </p><br>
    <pre>domain</pre>
    <p>
      The domain name for the registry. Must match the Common Name of the certificate.
    </p>
    <p>
      <strong>Default:</strong>
    </p><br>
    <pre>htpasswd</pre>
    <p>
      base64 encoded htpasswd file used for authentication.
    </p>
    <p>
      <strong>Default:</strong>
    </p><br>
    <pre>htpasswd-plain</pre>
    <p>
      base64 encoded plaintext version of the htpasswd file, needed by docker daemons to authenticate to the registry.
    </p>
    <p>
      <strong>Default:</strong>
    </p><br>
    <pre>ingress</pre>
    <p>
      Create an Ingress resource for the registry (or delete resource object if "delete" is True)
    </p>
    <p>
      <strong>Default:</strong> False
    </p><br>
    <pre>tlscert</pre>
    <p>
      base64 encoded TLS certificate for the registry. Common Name must match the domain name of the registry.
    </p>
    <p>
      <strong>Default:</strong>
    </p><br>
    <pre>tlskey</pre>
    <p>
      base64 encoded TLS key for the registry.
    </p>
    <p>
      <strong>Default:</strong>
    </p><br>
  </div>
</div>
<hr>
<div class="row">
  <div class="col-2">
    <h5>
      resume
    </h5>
  </div>
  <div class="col-5">
    <p>
      Mark node as schedulable.
    </p>
  </div>
</div>
<hr>
<div class="row">
  <div class="col-2">
    <h5>
      upgrade
    </h5>
  </div>
  <div class="col-5">
    <p>
      Upgrade the kubernetes snaps
    </p>
  </div>
</div>
<hr>

<!-- ACTIONS ENDS -->



<!-- LINKS -->
[charm-kubernetes-master]: /charm-kubernetes-master
[kubelet-docs]: https://kubernetes.io/docs/reference/command-line-tools-reference/kubelet/