---
bundle_release: '1.18'
charm_name: azure-integrator
charm_revision: '43'
context:
  description: 'Proxy charm to enable Azure integrations via Juju relations.

    '
  title: 'Azure-integrator charm '
keywords: component, charms, versions, release
layout:
- base
- ubuntu-com
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
permalink: 1.18/charm-azure-integrator.html
sidebar: k8smain-sidebar
tags:
- reference
toc: false
wrapper_template: "templates/docs/markdown.html"
---

This charm acts as a proxy to Azure and provides an [interface][] to apply a
certain set of changes via roles, profiles, and tags to the instances of
the applications that are related to this charm.

## Usage

When on Azure, this charm can be deployed, granted trust via Juju to access Azure,
and then related to an application that supports the [interface][].  The set
of permissions that the related application could request is documented in the
interface's [Requires API documentation][api-doc].

For example, Charmed Kubernetes has support for this, and can be deployed with the
following bundle overlay ([download it here][asset-azure-overlay]):

```yaml
description: Charmed Kubernetes overlay to add native Azure support.
applications:
  aws-integrator:
    annotations:
      gui-x: "600"
      gui-y: "300"
    charm: cs:~containers/azure-integrator
    num_units: 1
    trust: true
relations:
  - ['azure-integrator', 'kubernetes-master']
  - ['azure-integrator', 'kubernetes-worker']
  ```

To use this overlay with the **Charmed Kubernetes** bundle, it is specified
during deploy like this:

```bash
juju deploy charmed-kubernetes  --overlay azure-overlay.yaml --trust
```


To deploy with earlier versions of Juju, or if you wish to provide it different
credentials, you will need to provide the cloud credentials via the `credentials`,
charm config options.

**Note:** The credentials used must have rights to use the API to inspect the
instances connecting to it, enable a Managed Service Identity (MSI) for those
instances, assign roles to those instances, and create custom roles.  This may
be different from the access permissions that Juju itself requires.

## Resource Usage Note

By relating to this charm, other charms can directly allocate resources, such
as managed disks and load balancers, which could lead to cloud charges and
count against quotas.  Because these resources are not managed by Juju, they
will not be automatically deleted when the models or applications are
destroyed, nor will they show up in Juju's status or GUI.  It is therefore up
to the operator to manually delete these resources when they are no longer
needed, using the Azure management website or API.

## Examples

Following are some examples using Azure integration with
**Charmed Kubernetes**.

### Creating a pod with a Disk Storage-backed volume

This script creates a busybox pod with a persistent volume claim backed by
Azure's Disk Storage.

```sh
#!/bin/bash

# create a storage class using the `kubernetes.io/azure-disk` provisioner
kubectl create -f - <<EOY
apiVersion: storage.k8s.io/v1
kind: StorageClass
metadata:
  name: azure-standard
provisioner: kubernetes.io/azure-disk
parameters:
  storageaccounttype: Standard_LRS
  kind: managed
EOY

# create a persistent volume claim using that storage class
kubectl create -f - <<EOY
kind: PersistentVolumeClaim
apiVersion: v1
metadata:
  name: testclaim
spec:
  accessModes:
    - ReadWriteOnce
  resources:
    requests:
      storage: 100Mi
  storageClassName: azure-standard
EOY

# create the busybox pod with a volume using that PVC:
kubectl create -f - <<EOY
apiVersion: v1
kind: Pod
metadata:
  name: busybox
  namespace: default
spec:
  containers:
    - image: busybox
      command:
        - sleep
        - "3600"
      imagePullPolicy: IfNotPresent
      name: busybox
      volumeMounts:
        - mountPath: "/pv"
          name: testvolume
  restartPolicy: Always
  volumes:
    - name: testvolume
      persistentVolumeClaim:
        claimName: testclaim
EOY
```

### Creating a service with an Azure load-balancer

The following script starts the hello-world pod behind an Azure-backed load-balancer.

```bash
kubectl create deployment hello-world --image=gcr.io/google-samples/node-hello:1.0
kubectl scale deployment hello-world --replicas=5
kubectl expose deployment hello-world --type=LoadBalancer --name=hello --port=8080
watch kubectl get svc hello -o wide
```

## Configuration

<!-- CONFIG STARTS -->
<!--AUTOGENERATED CONFIG TEXT - DO NOT EDIT -->


| name | type   | Default      | Description                               |
|------|--------|--------------|-------------------------------------------|
| <a id="table-credentials"> </a> credentials | string |  | [See notes](#credentials-description) |
| <a id="table-extra_packages"> </a> extra_packages | string |  | Space separated list of extra deb packages to install. |
| <a id="table-install_keys"> </a> install_keys | string | [See notes](#install_keys-default) | [See notes](#install_keys-description) |
| <a id="table-install_sources"> </a> install_sources | string | [See notes](#install_sources-default) | [See notes](#install_sources-description) |
| <a id="table-package_status"> </a> package_status | string | install | The status of service-affecting packages will be set to this value in the dpkg database. Valid values are "install" and "hold". |

---

### credentials



<a id="credentials-description"> </a>
**Description:**

The base64-encoded JSON credentials data, which must include the 'application-id',
'application-password', and the 'subscription-id'.  These values can be retrieved
from Juju using the 'credentials' command and extracting the value of the 'details'
key for the appropriate credential. For example, using 'jq', replace '<credential-name>'
in the following:


```
    juju credentials --format=json --show-secrets azure | jq '.["local-credentials"]["azure"]["cloud-credentials"]["<credential-name>"]["details"]'
```


This can be used from bundles with 'include-base64://' (see
https://discourse.charmhub.io/t/bundle-reference/1158),
or from the command-line with 'juju config aws credentials="$(base64 /path/to/file)"'.

This option will take precedence over the individual config options, if set.

It is strongly recommended that you use 'juju trust' instead, if available.
since config values can be read by anyone with read access to the model.

[Back to table](#table-credentials)




### install_keys



<a id="install_keys-default"> </a>
**Default:**

```
- |
  -----BEGIN PGP PUBLIC KEY BLOCK-----
  Version: GnuPG v1.4.7 (GNU/Linux)

  mQENBFYxWIwBCADAKoZhZlJxGNGWzqV+1OG1xiQeoowKhssGAKvd+buXCGISZJwT
  LXZqIcIiLP7pqdcZWtE9bSc7yBY2MalDp9Liu0KekywQ6VVX1T72NPf5Ev6x6DLV
  7aVWsCzUAF+eb7DC9fPuFLEdxmOEYoPjzrQ7cCnSV4JQxAqhU4T6OjbvRazGl3ag
  OeizPXmRljMtUUttHQZnRhtlzkmwIrUivbfFPD+fEoHJ1+uIdfOzZX8/oKHKLe2j
  H632kvsNzJFlROVvGLYAk2WRcLu+RjjggixhwiB+Mu/A8Tf4V6b+YppS44q8EvVr
  M+QvY7LNSOffSO6Slsy9oisGTdfE39nC7pVRABEBAAG0N01pY3Jvc29mdCAoUmVs
  ZWFzZSBzaWduaW5nKSA8Z3Bnc2VjdXJpdHlAbWljcm9zb2Z0LmNvbT6JATUEEwEC
  AB8FAlYxWIwCGwMGCwkIBwMCBBUCCAMDFgIBAh4BAheAAAoJEOs+lK2+EinPGpsH
  /32vKy29Hg51H9dfFJMx0/a/F+5vKeCeVqimvyTM04C+XENNuSbYZ3eRPHGHFLqe
  MNGxsfb7C7ZxEeW7J/vSzRgHxm7ZvESisUYRFq2sgkJ+HFERNrqfci45bdhmrUsy
  7SWw9ybxdFOkuQoyKD3tBmiGfONQMlBaOMWdAsic965rvJsd5zYaZZFI1UwTkFXV
  KJt3bp3Ngn1vEYXwijGTa+FXz6GLHueJwF0I7ug34DgUkAFvAs8Hacr2DRYxL5RJ
  XdNgj4Jd2/g6T9InmWT0hASljur+dJnzNiNCkbn9KbX7J/qK1IbR8y560yRmFsU+
  NdCFTW7wY0Fb1fWJ+/KTsC4=
  =J6gs
  -----END PGP PUBLIC KEY BLOCK-----

```


[Back to table](#table-install_keys)



<a id="install_keys-description"> </a>
**Description:**

List of signing keys for install_sources package sources, per charmhelpers standard format (a yaml list of strings encoded as a string). The keys should be the full ASCII armoured GPG public keys. While GPG key ids are also supported and looked up on a keyserver, operators should be aware that this mechanism is insecure. null can be used if a standard package signing key is used that will already be installed on the machine, and for PPA sources where the package signing key is securely retrieved from Launchpad.

[Back to table](#table-install_keys)




### install_sources



<a id="install_sources-default"> </a>
**Default:**

```
- deb https://packages.microsoft.com/repos/azure-cli/ xenial main

```


[Back to table](#table-install_sources)



<a id="install_sources-description"> </a>
**Description:**

List of extra apt sources, per charm-helpers standard format (a yaml list of strings encoded as a string). Each source may be either a line that can be added directly to sources.list(5), or in the form ppa:<user>/<ppa-name> for adding Personal Package Archives, or a distribution component to enable.

[Back to table](#table-install_sources)





<!-- CONFIG ENDS -->




[asset-azure-overlay]: https://raw.githubusercontent.com/charmed-kubernetes/bundle/main/overlays/azure-overlay.yaml
[interface]: https://github.com/juju-solutions/interface-azure-integration
[api-doc]: https://github.com/juju-solutions/interface-azure-integration/blob/master/docs/requires.md
