---
wrapper_template: "templates/docs/markdown.html"
markdown_includes:
  nav: kubernetes/docs/shared/_side-navigation.md
context:
  title: Components of Charmed Kubernetes 1.16
  description: Detailed description of Charmed Kubernetes release
keywords: component, charms, versions, release
tags:
    - reference
sidebar: k8smain-sidebar
permalink: 1.16/components.html
layout:
    - base
    - ubuntu-com
toc: false
bundle_revision: '316'
bundle_release: '1.16'
---

<!-- THIS PAGE IS AUTOGENERATED -->
<!-- If you find an error in this page, it is likely to be in the original
source of the information - please file a bug rather than editing the text -->

This page details the charms, snaps, images and other components
which comprise the 1.16 release of Charmed Kubernetes.

Other information about this release can be found on the following pages:

<a class='p-button--brand' href='/kubernetes/docs'> Documentation </a>
<a class='p-button--brand' href='/kubernetes/docs/1.16/release-notes'>Release notes </a>
<a class='p-button--brand' href='/kubernetes/docs/1.16/upgrading'>Upgrading </a>
<a class='p-button--brand' href='https://bugs.launchpad.net/charmed-kubernetes'>Bugs </a>
<a class='p-button--brand' href='https://github.com/charmed-kubernetes'>Source </a>
<a class='p-button--brand' href='https://launchpad.net/charmed-kubernetes/+milestone/1.16'>Milestone </a>

## What's new

For a list of new features, changes, deprecations, and bug fixes in this
release, please see the [Release notes](release-notes).

## Core charms

These charms are the core components or official optional components of the
release. These charms are maintained by the Charmed Kubernetes team.

<table class ="u-table-layout--auto">
  <thead>
    <tr>
      <th>Charm</th>
      <th>Summary</th>
      <th>docs</th>
      <th>source</th>
      <th>bugs</th>
      <th>version</th>
      <th>notes</th>
    </tr>
  </thead>
  <tbody>
<tr>
  <td> aws-iam </td>
  <td> A charm that enables using AWS IAM to authenticate with Kubernetes </td>
  <td> <a href="/kubernetes/docs/1.16/charm-aws-iam">docs</a> </td> <td> <a href="https://github.com/charmed-kubernetes/charm-aws-iam"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 20 </td>
  <td> -- </td>
</tr>
<tr>
  <td> aws-integrator </td>
  <td> Charm to enable AWS integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.16/charm-aws-integrator">docs</a> </td> <td> <a href="https://github.com/juju-solutions/charm-aws-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 28 </td>
  <td> -- </td>
</tr>
<tr>
  <td> azure-integrator </td>
  <td> Proxy charm to enable Azure integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.16/charm-azure-integrator">docs</a> </td> <td> <a href="https://github.com/juju-solutions/charm-azure-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 15 </td>
  <td> -- </td>
</tr>
<tr>
  <td> calico </td>
  <td> A robust Software Defined Network from Project Calico </td>
  <td> <a href="/kubernetes/docs/1.16/charm-calico">docs</a> </td> <td> <a href="https://github.com/juju-solutions/layer-calico"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 689 </td>
  <td> -- </td>
</tr>
<tr>
  <td> canal </td>
  <td> A Software Defined Network based on Flannel and Calico </td>
  <td> <a href="/kubernetes/docs/1.16/charm-canal">docs</a> </td> <td> <a href="https://github.com/juju-solutions/layer-canal"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 690 </td>
  <td> -- </td>
</tr>
<tr>
  <td> containerd </td>
  <td> Containerd container runtime subordinate </td>
  <td> <a href="/kubernetes/docs/1.16/charm-containerd">docs</a> </td> <td> <a href=""> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 46 </td>
  <td> -- </td>
</tr>
<tr>
  <td> docker </td>
  <td> Docker container runtime subordinate </td>
  <td> <a href="/kubernetes/docs/1.16/charm-docker">docs</a> </td> <td> <a href=""> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 51 </td>
  <td> -- </td>
</tr>
<tr>
  <td> docker-registry </td>
  <td> Registry for docker images </td>
  <td> <a href="/kubernetes/docs/1.16/charm-docker-registry">docs</a> </td> <td> <a href="https://github.com/CanonicalLtd/docker-registry-charm"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 152 </td>
  <td> -- </td>
</tr>
<tr>
  <td> easyrsa </td>
  <td> Delivers EasyRSA to create a Certificate Authority (CA). </td>
  <td> <a href="/kubernetes/docs/1.16/charm-easyrsa">docs</a> </td> <td> <a href="https://github.com/charmed-kubernetes/layer-easyrsa"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 289 </td>
  <td> -- </td>
</tr>
<tr>
  <td> etcd </td>
  <td> Deploy a TLS terminated ETCD Cluster </td>
  <td> <a href="/kubernetes/docs/1.16/charm-etcd">docs</a> </td> <td> <a href="https://github.com/charmed-kubernetes/layer-etcd"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 478 </td>
  <td> -- </td>
</tr>
<tr>
  <td> flannel </td>
  <td> A charm that provides a robust Software Defined Network </td>
  <td> <a href="/kubernetes/docs/1.16/charm-flannel">docs</a> </td> <td> <a href="https://github.com/coreos/flannel"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 462 </td>
  <td> -- </td>
</tr>
<tr>
  <td> gcp-integrator </td>
  <td> Charm to enable GCP integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.16/charm-gcp-integrator">docs</a> </td> <td> <a href="https://github.com/juju-solutions/charm-gcp-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 20 </td>
  <td> -- </td>
</tr>
<tr>
  <td> kata </td>
  <td> Kata untrusted container runtime subordinate </td>
  <td> <a href="/kubernetes/docs/1.16/charm-kata">docs</a> </td> <td> <a href=""> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 26 </td>
  <td> -- </td>
</tr>
<tr>
  <td> keepalived </td>
  <td> Failover and monitoring daemon for LVS clusters </td>
  <td> <a href="/kubernetes/docs/1.16/charm-keepalived">docs</a> </td> <td> <a href="https://github.com/juju-solutions/charm-keepalived"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 28 </td>
  <td> -- </td>
</tr>
<tr>
  <td> kubeapi-load-balancer </td>
  <td> Nginx Load Balancer </td>
  <td> <a href="/kubernetes/docs/1.16/charm-kubeapi-load-balancer">docs</a> </td> <td> <a href="https://nginx.org/en/"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 695 </td>
  <td> -- </td>
</tr>
<tr>
  <td> kubernetes-master </td>
  <td> The Kubernetes control plane. </td>
  <td> <a href="/kubernetes/docs/1.16/charm-kubernetes-master">docs</a> </td> <td> <a href="https://github.com/charmed-kubernetes/charm-kubernetes-master"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 778 </td>
  <td> -- </td>
</tr>
<tr>
  <td> kubernetes-worker </td>
  <td> The workload bearing units of a kubernetes cluster </td>
  <td> <a href="/kubernetes/docs/1.16/charm-kubernetes-worker">docs</a> </td> <td> <a href="https://github.com/charmed-kubernetes/charm-kubernetes-worker"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 613 </td>
  <td> -- </td>
</tr>
<tr>
  <td> openstack-integrator </td>
  <td> Proxy charm to enable OpenStack integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.16/charm-openstack-integrator">docs</a> </td> <td> <a href="https://github.com/juju-solutions/charm-openstack-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 49 </td>
  <td> -- </td>
</tr>
<tr>
  <td> tigera-secure-ee </td>
  <td> Tigera Secure Enterprise Edition </td>
  <td> <a href="/kubernetes/docs/1.16/charm-tigera-secure-ee">docs</a> </td> <td> <a href=""> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 86 </td>
  <td> -- </td>
</tr>
<tr>
  <td> vsphere-integrator </td>
  <td> Proxy charm to enable VMware vSphere integrations via Juju relations. </td>
  <td> <a href="/kubernetes/docs/1.16/charm-vsphere-integrator">docs</a> </td> <td> <a href="https://github.com/juju-solutions/charm-vsphere-integrator"> source </a> </td>
  <td> <a href="https://bugs.launchpad.net/charmed-kubernetes"> bugs</a> </td>
  <td> 7 </td>
  <td> -- </td>
</tr>

 </tbody>
 </table>

## Compatible Charms

These charms are frequently used with Charmed Kubernetes.

<table class ="u-table-layout--auto">
  <thead>
    <tr>
      <th>Charm</th>
      <th>Summary</th>
      <th>Store page</th>
      <th>notes</th>
    </tr>
  </thead>
  <tbody>
<tr>
  <td> apache2 </td>
  <td> Apache HTTP Server metapackage </td>
  <td> <a href="https://jaas.ai/apache2">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> ceph-osd </td>
  <td> Highly scalable distributed storage - Ceph OSD storage </td>
  <td> <a href="https://jaas.ai/ceph-osd">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> elasticsearch </td>
  <td> Open Source, Distributed, RESTful, Search Engine built on Apache Lucene </td>
  <td> <a href="https://jaas.ai/elasticsearch">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> filebeat </td>
  <td> Filebeat is a lightweight, open source shipper for log file data. </td>
  <td> <a href="https://jaas.ai/filebeat">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> grafana </td>
  <td> Graph and Dashboard builder </td>
  <td> <a href="https://jaas.ai/grafana">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> graylog </td>
  <td> Graylog log management system </td>
  <td> <a href="https://jaas.ai/graylog">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> hacluster </td>
  <td> Corosync Cluster Engine - membership, messaging and quorum </td>
  <td> <a href="https://jaas.ai/hacluster">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> mongodb </td>
  <td> An open-source document database, and the leading NoSQL database </td>
  <td> <a href="https://jaas.ai/mongodb">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> nagios </td>
  <td> Nagios Core 3 monitoring. </td>
  <td> <a href="https://jaas.ai/nagios">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> nfs </td>
  <td> NFS server </td>
  <td> <a href="https://jaas.ai/nfs">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> nrpe </td>
  <td> Nagios Remote Plugin Executor Server </td>
  <td> <a href="https://jaas.ai/nrpe">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> prometheus2 </td>
  <td> Monitoring system and timeseries database. v2.0 and later only </td>
  <td> <a href="https://jaas.ai/prometheus2">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> telegraf </td>
  <td> The plugin-driven server agent for collecting & reporting metrics. </td>
  <td> <a href="https://jaas.ai/telegraf">docs</a> </td>
  <td>  </td>
</tr>
<tr>
  <td> vault </td>
  <td> a tool for managing secrets </td>
  <td> <a href="https://jaas.ai/vault">docs</a> </td>
  <td>  </td>
</tr>

 </tbody>
 </table>


## Images


The [addons][] installed alongside Kubernetes make use of additional container
images. These are the ones used by this release:

<!-- GENERATED CONTAINER IMAGES -->

-   addon-resizer-amd64:1.8.5
-   addon-resizer-arm64:1.8.5
-   addon-resizer-ppc64le:1.8.5
-   addon-resizer-s390x:1.8.5
-   cephcsi/rbdplugin:v1.0.0
-   coredns/coredns:1.6.2
-   defaultbackend-amd64:1.5
-   defaultbackend-arm64:1.5
-   defaultbackend-s390x:1.4
-   external_storage/nfs-client-provisioner:latest
-   external_storage/nfs-client-provisioner:v3.1.0-k8s1.11
-   heapster-amd64:v1.6.0-beta.1
-   heapster-arm64:v1.6.0-beta.1
-   heapster-grafana-amd64:v4.4.3
-   heapster-grafana-arm64:v4.4.3
-   heapster-grafana-ppc64le:v4.4.3
-   heapster-grafana-s390x:v4.4.3
-   heapster-influxdb-amd64:v1.3.3
-   heapster-influxdb-arm64:v1.3.3
-   heapster-influxdb-ppc64le:v1.3.3
-   heapster-influxdb-s390x:v1.3.3
-   heapster-ppc64le:v1.6.0-beta.1
-   heapster-s390x:v1.6.0-beta.1
-   k8s-dns-dnsmasq-nanny:1.14.13
-   k8s-dns-kube-dns:1.14.13
-   k8s-dns-sidecar:1.14.13
-   k8scloudprovider/cinder-csi-plugin:v1.15.0
-   k8scloudprovider/k8s-keystone-auth:latest
-   k8scloudprovider/openstack-cloud-controller-manager:v1.15.0
-   k8scsi/csi-attacher:v1.0.1
-   k8scsi/csi-node-driver-registrar:v1.0.2
-   k8scsi/csi-node-driver-registrar:v1.1.0
-   k8scsi/csi-provisioner:v1.0.2
-   k8scsi/csi-snapshotter:v1.0.2
-   kubernetes-ingress-controller/nginx-ingress-controller-amd64:0.25.1
-   kubernetes-ingress-controller/nginx-ingress-controller-arm64:0.25.1
-   kubernetes-ingress-controller/nginx-ingress-controller-s390x:0.20.0
-   kubernetesui/dashboard-amd64:v2.0.0-beta4
-   kubernetesui/dashboard-arm64:v2.0.0-beta4
-   kubernetesui/dashboard-ppc64le:v2.0.0-beta4
-   kubernetesui/metrics-scraper:v1.0.1
-   metrics-server-amd64:v0.3.6
-   metrics-server-arm64:v0.3.6
-   metrics-server-ppc64le:v0.3.6
-   metrics-server-s390x:v0.3.6
-   nvidia/k8s-device-plugin:1.0.0-beta5
-   pause-amd64:3.1
-   pause-arm64:3.1
-   pause-ppc64le:3.1
-   pause-s390x:3.1
-   rancher/rancher:latest
-   sonatype/nexus3:latest
<!-- CONTAINER IMAGES END -->


To list all of the Charmed Kubernetes container images in the Canonical registry:

```bash
curl https://rocks.canonical.com/v2/_catalog | python3 -mjson.tool | grep -E '^\s*"cdk/'
```

To list the tags available for a specific image use the following command,
indicating the path of the package. For example, for the `coredns-amd64` image:

```bash
curl https://rocks.canonical.com/v2/cdk/coredns/coredns-amd64/tags/list
```

...or for the arm64 version of the metrics server:

```bash
curl https://rocks.canonical.com/v2/cdk/metrics-server-arm64/tags/list
```


## Snaps

The following snaps are used by this release of Charmed Kubernetes:


| snap  | confinement | summary | link |
|-------|-------------|---------|------|
|aws-cli| classic | Resource to side-load aws-cli snap in network-restricted deployments. | [store page](https://snapcraft.io/aws-cli) |
|core| strict | core snap | [store page](https://snapcraft.io/core) |
|etcd| classic | Snap package of etcd | [store page](https://snapcraft.io/etcd) |
|gcloud| ? | Resource to side-load gcloud snap in network-restricted deployments. | ? |
|cdk-addons| strict | CDK addons snap | [store page](https://snapcraft.io/cdk-addons) |
|kube-apiserver| strict | kube-apiserver snap | [store page](https://snapcraft.io/kube-apiserver) |
|kube-controller-manager| strict | kube-controller-manager snap | [store page](https://snapcraft.io/kube-controller-manager) |
|kube-proxy| classic | kube-proxy snap | [store page](https://snapcraft.io/kube-proxy) |
|kube-scheduler| strict | kube-scheduler snap | [store page](https://snapcraft.io/kube-scheduler) |
|kubectl| classic | kubectl snap | [store page](https://snapcraft.io/kubectl) |
|kubelet| classic | kubelet snap | [store page](https://snapcraft.io/kubelet) |
|openstackclients| classic | Resource to side-load openstackclients snap in network-restricted deployments. | [store page](https://snapcraft.io/openstackclients) |






<!-- LINKS -->
[addons]: /kubernetes/docs/cdk-addons
[documentation]: /kubernetes/docs/
[release notes]: /kubernetes/docs/release-notes#1.16
[upgrade notes]: /kubernetes/docs/
[bugs]: /kubernetes/docs/
[source]: https://github.com/charmed-kubernetes
[1.16 milestone]: https://launchpad.net/charmed-kubernetes/+milestone/1.16
