---
wrapper_template: "appliance/shared/_base_appliance_index.html"
context:
  name: "OpenHAB"
  short_name: "openhab"
  appliance_name: "OpenHAB"
  company_name: "openHAB Foundation e.V."
  logo: "https://assets.ubuntu.com/v1/f4632e06-openhab-logo.png"
  category: "Smart Home"
  meta_description: "Build your openHAB appliance with the Ubuntu Appliance image's preinstalled snaps. openHAB puts the control of your data and your home at your finger tips. openHAB is the most flexible tool available to make almost any home automation wish come true."
  downloads:
    raspberrypi: True
    pc: True
    intelnuc: True
  pi:
    2: True
    3: True
    4: True
  screenshots:
    1: https://assets.ubuntu.com/v1/56268be0-openhab-screenshot-1.png
    2: https://assets.ubuntu.com/v1/07b4d31f-openhab-screenshot-2.png
    3: https://assets.ubuntu.com/v1/a0d79df1-openhab-screenshot-3.png
    4: https://assets.ubuntu.com/v1/8d38f054-openhab-screenshot-4.png
  links:
    1:
      title: "OpenHAB Privacy Policies"
      url: "https://www.openhab.org/privacy.html"
    2:
      title: "OpenHAB website"
      url: "https://www.openhab.org/"
    3:
      title: "OpenHAB license"
      url: "https://github.com/openhab/openhab-distro/blob/master/LICENSE"
  compliance:
    1: "EU GDPR"
    2: "California law"
  base: "core18"
  published_date: "2020-06-16"
  maintenance_date: "2030-06-16"
  certification_note: "Not guaranteed to work on the Raspberry Pi 3A+"
  snaps:
    1:
      name: "openhab"
      icon: "https://assets.ubuntu.com/v1/f4632e06-openhab-logo.png"
      link: "https://snapcraft.io/openhab"
      publisher: "openHAB Foundation e.V."
      channel: "latest/stable"
      version: "2.5.5"
      published_date: "19 May 2020"
---

#### Empowering the smart home

The open Home Automation Bus (openHAB, pronounced ˈəʊpənˈhæb) is an open source, technology agnostic home automation platform which runs as the center of your smart home!

Some of openHAB's strengths are:

- Its ability to integrate a multitude of other devices and systems. openHAB includes other home automation systems, (smart) devices and other technologies into a single solution
- To provide a uniform user interface and a common approach to automation rules across the entire system, regardless of the number of manufacturers and sub-systems involved
- Giving you the most flexible tool available to make almost any home automation wish come true; if you can think it, odds are that you can implement it with openHAB

When home automation just seems to work, it is always the result of hard work. Home automation is fascinating and requires a considerable investment of your time. Here are some key considerations especially for new users. To be successful, you will need to:

- Start slowly and one step at a time
- Be prepared to learn
- Remain flexible in how you want to achieve your goal
- Celebrate all the small successes

Remember, openHAB is just a computer program. The computer will only do what you tell it to do. openHAB can provide many default solutions that are easy to setup. On the flip side, the more you insist that everything should look and work exactly as you want it, the more work you will have to do. openHAB is fully customizable, but doing so will require substantial effort on your part.
