#!/usr/bin/perl;

# this script tests a specific set of redirects against a specific set of expected pages
# successes go to STDERR
# errors go to STDOUT
# so you can run it like `perl test-redirects.pl > errors.txt` and get errors
# some will error, but I think these are ok, but should be checked
# it also has all good urls from ubuntu.com as of 5 January 2018

my @redirects = ("files/server-survey-2010.pdf", "files/server/UbuntuServerBrochure804LTS.pdf", "files/u1/BulkCDOrderForm.pdf", "files/u1/CustomsChinese.pdf", "files/u1/CustomsLetterBrazil.pdf", "files/u1/CustomsLetterMalay-1.pdf", "files/u1/CustomsLetterPortuguese.pdf", "files/u1/CustomsLetterRussian.pdf", "files/u1/CustomsSpanish-1.pdf", "files/u1/html-small.jpg", "files/u1/server_report_v2.pdf", "files/u1/ubu_m...tion_A4_aw.pdf", "files/u1/ubu_mob_edition_A4_aw.pdf", "files/u3/Contact.pdf", "files/wikimedia_casestudy_v1.pdf", "files/LTS_ISV_Desktop_Datasheet_05.pdf", "files/LTS_ISV_Server_Datasheet_02.pdf", "files/active/02_ubuntu/U_business/lvm_canonical_english_slides.pdf", "getubuntu/purchase", "getubuntu/purchase/africa", "getubuntu/purchase/asia", "getubuntu/purchase/australia", "getubuntu/purchase/europe", "getubuntu/purchase/north-america", "getubuntu/purchase/south-america", "getubuntu/purchase/worldwide", "download/ubuntu/alternative-download.", "download/ubuntu/alternative-download", "download/ubuntu/windows-install", "download/ubuntu/windows-installer)", "download/ubuntu/windows-installer", "download/ubuntu/windows", "download/server05:04", "download/serverGyakorl", "download/serverLive", "download/serverNotas", "education", "education/benefit", "education/management", "aboutus/trademarkpolicy)", "aboutus/trademarkpolicy.", "aboutus/trademarkpolicy.Kind", "aboutus/trademarkpolicy", "business/cloud", "business/cloud/cloudcomputing", "business/cloud/deploy-anywhere", "business/cloud/on-demand-computing", "business/cloud/overview", "business/cloud/reduce-costs", "business/cloud/secure-and-robust", "business/cloud/technical-resources", "business/cloud/whyubuntu", "business/desktop", "business/desktop/business-as-usual", "business/desktop/easy-to-manage", "business/desktop/long-term-support", "business/desktop/overview", "business/desktop/reduce-costs", "business/desktop/remix", "business/desktop/remix/download", "business/desktop/secure-and-robust", "business/desktop/services", "business/desktop/windows-compatible", "business/get-ubuntu/server", "business/get-ubuntu/server/CDs", "business/get-ubuntu/server/download", "business/server/", "business/server", "business/server/built-in-security", "business/server/cloud", "business/server/easy-integration", "business/server/minimise-administration", "business/server/overview%20/", "business/server/overview.I", "business/server/overview.be", "business/server/overview/", "business/server/reduce-costs", "business/server/services", "business/server/technical-resources", "business/server/virtualisation", "business/whats-new", "business/whats-new/lvm", "business/whats-new/thank-you", "cloud/jumpstart-training", "cloud/jumpstart-training/contact-us", "cloud/jumpstart-training/order", "cloud/jumpstart", "cloud/jumpstart/contact-us", "cloud/jumpstart/contact-us/thank-you", "cloud/insights", "cloud/insights/beginners-guide", "cloud/tools/jumpstart-training", "cloud/tools/jumpstart-training/contact-us", "cloud/tools/jumpstart-training/order", "cloud/tools/jumpstart", "cloud/tools/jumpstart/contact-us", "desktop/features/games-apps", "desktop/features/more-apps", "desktop/features/music-and-mobile", "desktop/features/office-applications", "desktop/features/personal-cloud", "desktop/features/photos-and-videos", "desktop/features/social-and-email", "desktop/features/web-browsing", "desktop/get-ubuntu/alternative-download)", "desktop/get-ubuntu/alternative-download", "desktop/get-ubuntu/alternative-downloads", "desktop/get-ubuntu/download-zh%20/", "desktop/get-ubuntu/download-zh/", "desktop/get-ubuntu/alternative-download", "desktop/get-Ubuntu/download", "desktop/get-ubuntu", "desktop/get-ubuntu/cd-and-dvd", "desktop/get-ubuntu/cds)", "desktop/get-ubuntu/cds", "desktop/get-ubuntu/dowload", "desktop/get-ubuntu/downl", "desktop/get-ubuntu/downloa", "desktop/get-ubuntu/download%20/", "desktop/get-ubuntu/download).", "desktop/get-ubuntu/download)", "desktop/get-ubuntu/download-ko", "desktop/get-ubuntu/download-kr", "desktop/get-ubuntu/download.", "desktop/get-ubuntu/download/:", "desktop/get-ubuntu/windows-installer", "desktop/get-ubuntu/windows-installer/downloads", "desktop/get-ubuntu/windows-installer/faq.php", "desktop/get-ubuntu/windows-installer/index.php", "desktop/get-ubuntu/windows-installer/latest.php", "desktop/get-ubuntu/windows-installer/please", "desktop/get-ubuntu/windows-installer/screenshots.php", "desktop/get-ubuntu/windows-installer2Run", "desktop/get-ubuntu/windowsinstaller", "desktop/getubuntu/download", "desktop/getubuntu/windowsinstaller", "download/desktop/windows-installer.", "download/desktop/windows-installer", "download/desktop/windows-installers", "download/releasenotes/510", "download/releasenotes/606", "download/releasenotes/610", "download/releasenotes/804", "download/releasenotes", "system/files/AD_whitepaper_20090807.pdf", "system/files/CentralLogging-v4-20090901-03.pdf", "system/files/PSEServiceSheet20090616.pdf", "system/files/UEC_Brochure.pdf", "system/files/UbuntuEnterpriseCloudWP-Architecture-20090820.pdf", "system/files/emphony_v2.pdf", "system/files/equitec_v3.pdf", "system/files/introduction-to-cloud-computing_server_cloud.pdf", "system/files/metal_sales_v3.pdf", "system/files/u1/AutomatedDeploymentsWP-20090126.pdf", "system/files/u1/server_report_v2.pdf", "system/files/u35/Openbravo-final.pdf", "tag/ec2/page/13", "tag/featured/page/18", "tag/planet/page/32", "tag/ubuntu-server/page/5", "tag/ubuntu/page/27", "support/training", "support/training/course-descriptions", "support/training/course-descriptions/certified-professional", "support/training/course-descriptions/deploying-clouds", "support/training/course-descriptions/deploying-server", "support/training/course-descriptions/desktop-course", "support/training/course-types", "support/services", "support/services/advanced", "support/services/advanced/features", "support/services/assurance", "support/services/desktopcomparison", "support/services/desktopfeatures", "support/services/enterprise", "support/services/enterprisedesktop", "support/services/professional", "support/services/professional/features", "support/services/professionalservices", "support/services/pse", "support/services/server", "support/services/starter", "support/services/starter/features", "support/paid", "support/paid/login", "support/paid/professionalservices/assessments", "support/paid/professionalservices/deploymentservices", "support/paid/professionalservices/proofofconcept", "support/paid/webtolead", "support/paid/webtoleadthanks", "support/releasenotes510", "support/releasenotes604", "support/supportoptions", "support/supportoptions/local", "support/supportoptions/paidsupport", "support/supportoptions/paidsupport]", "testing/1004rc", "testing/710rc", "testing/804rc", "testing/810rc", "testing/910rc", "testing", "testing/beta", "testing/dapperbeta", "testing/dapperrc", "testing/download", "testing/feistybeta", "testing/flight2", "testing/flight4", "testing/flight5", "testing/flight6", "testing/flight7", "testing/gutsybeta", "testing/hardy", "testing/hardy/alpha1", "testing/hardy/alpha2", "testing/hardy/alpha3", "testing/hardy/alpha4", "testing/hardy/alpha5", "testing/hardy/alpha6", "testing/hardy/beta", "testing/herd1", "testing/herd2", "testing/herd3,", "testing/herd3", "testing/herd4", "testing/herd5,", "testing/herd5", "testing/intrepid/alpha1", "testing/intrepid/alpha2", "testing/intrepid/alpha3", "testing/intrepid/alpha4", "testing/intrepid/alpha5", "testing/intrepid/alpha6", "testing/intrepid/beta", "testing/intrepid/temp", "testing/jaun", "testing/jaunty/alpha2", "testing/jaunty/alpha3", "testing/jaunty/alpha4", "testing/jaunty/alpha5", "testing/jaunty/alpha6", "testing/jaunty/beta", "testing/karmic/alpha1", "testing/karmic/alpha2", "testing/karmic/alpha3", "testing/karmic/alpha4", "testing/karmic/alpha5", "testing/karmic/alpha6", "testing/karmic/alpha6", "testing/karmic/beta", "testing/karmic/beta1", "testing/karmic/rc", "testing/knot2", "testing/knot3", "testing/lucid", "testing/lucid/Alpha3", "testing/lucid/alpha1", "testing/lucid/alpha1:", "testing/lucid/alpha2", "testing/lucid/alpha3", "testing/lucid/beta1", "testing/lucid/beta2", "testing/maverick/alpha1", "testing/maverick/alpha2", "testing/maverick/alpha3", "testing/maverick/beta%20ubuntu.com", "testing/maverick/beta", "testing/maverick<br%20/>/beta", "testing/nat", "testing/natty/alpha1", "testing/natty/alpha1accesso:17", "testing/natty/alpha2", "testing/natty/alpha3", "testing/natty/beta.", "testing/natty/beta", "testing/oneiric/alpha1", "testing/oneiric/alpha2", "testing/oneiric/alpha3", "testing/oneiric/beta", "testing/oneiric/beta1", "testing/precise/alpha1", "testing/precise/alpha2", "testing/precise/beta1", "testing/precise/beta2", "testing/quantal/alpha1", "testing/quantal/alpha2", "testing/quantal/alpha3", "testing/quantal/beta1", "testing/quantal/beta2", "testing/tribe1", "testing/tribe2", "testing/tribe3", "testing/tribe4", "testing/tribe5", "testing/variables", "taxonomy/term/1%202/0/feed", "taxonomy/term/1+2/0/feed", "taxonomy/term/1/0/feed", "taxonomy/term/2/0/feed", "taxonomy/term/1%202/0", "taxonomy/term/1%202", "taxonomy/term/1+2/0", "taxonomy/term/2/0", "taxonomy/term/2", "taxonomy/term/5", "taxonomy/term", "training", "training/certificationcourses", "training/certificationcourses/accelerated-deploy", "training/certificationcourses/accelerated-deploy/objectives", "training/certificationcourses/atl", "training/certificationcourses/professional", "training/certificationcourses/professional/curriculum2", "training/certificationcourses/server", "training/certificationcourses/server/objectives", "training/certificationcourses/server/prerequisites", "training/certificationcourses/serverhttp://www.ubuntu.com/training/certificationcourses/server", "training/certificationcourses/supporting", "training/certificationcourses/supporting/objectives", "training/certificationcourses/ucp", "training/certificationcourses/ucp/exam", "training/certificationcourses/ucp/objectives", "training/certificationcourses/ucp/prerequisites", "training/deployingcloud", "training/desktop", "training/e-learning", "training/e-learning/desktop", "training/e-learning/ucp", "training/exams", "training/trainingpartner/locate", "traning/cirtificationcourses/ucp/objectives", "traning/desktop", "ubuntu/features%20title=", "ubuntu/features", "ubuntu/features/find-more-apps", "ubuntu/features/more-apps", "ubuntu/features/music-and-mobile", "ubuntu/features/office-applications", "ubuntu/features/personal-cloud", "ubuntu/features/photos-and-videos", "ubuntu/features/social-and-email", "ubuntu/features/ubuntu-one", "ubuntu/features/ubuntu-software-centre", "ubuntu/features/web-brow", "ubuntu/features/web-browsing", "ubuntu/relationshi", "ubuntu/relationship", "uhs", "uhs2010", "uhs2010Ubuntu", "uhs2011", "wiki", "wiki/BinaryDriverHowTo", "wiki/DanishTeam", "wiki/FrontPage", "wiki/HardwareSupport", "wiki/LoCoTeamList", "wiki/RestrictedFormats", "wiki/RootSudo", "wiki/SetupNdiswrapperHowto", "wiki/UbuntuDownUnder", "s/ubuntu/13/1013.shtml", "s/ubuntu/13/1016.shtml", "s/ubuntu/13/1019.shtml", "s/ubuntu/13/1038.shtml", "s/ubuntu/13/1051.shtml", "s/ubuntu/13/106.shtml", "s/ubuntu/13/1067.shtml", "s/ubuntu/13/1103.shtml", "s/ubuntu/13/1141.shtml", "s/ubuntu/13/1151.shtml", "s/ubuntu/13/1236.shtml", "s/ubuntu/13/124.shtml", "s/ubuntu/13/1270.shtml", "s/ubuntu/13/128.shtml", "s/ubuntu/13/1281.shtml", "s/ubuntu/13/1331.shtml", "s/ubuntu/13/14.shtml", "s/ubuntu/13/164.shtml", "s/ubuntu/13/185.shtml", "s/ubuntu/13/230.shtml", "s/ubuntu/13/237.shtml", "s/ubuntu/13/240.shtml", "s/ubuntu/13/243.shtml", "s/ubuntu/13/292.shtml", "s/ubuntu/13/295.shtml", "s/ubuntu/13/299.shtml", "s/ubuntu/13/349.shtml", "s/ubuntu/13/363.shtml", "s/ubuntu/13/388.shtml", "s/ubuntu/13/396.shtml", "s/ubuntu/13/431.shtml", "s/ubuntu/13/439.shtml", "s/ubuntu/13/446.shtml", "s/ubuntu/13/47.shtml", "s/ubuntu/13/499.shtml", "s/ubuntu/13/514.shtml", "s/ubuntu/13/545.shtml", "s/ubuntu/13/568.shtml", "s/ubuntu/13/613.shtml", "s/ubuntu/13/635.shtml", "s/ubuntu/13/706.shtml", "s/ubuntu/13/73.shtml", "s/ubuntu/13/771.shtml", "s/ubuntu/13/789.shtml", "s/ubuntu/13/832.shtml", "s/ubuntu/13/886.shtml", "s/ubuntu/13/889.shtml", "s/ubuntu/13/914.shtml", "s/ubuntu/13/93.shtml", "s/ubuntu/13/948.shtml", "s/ubuntu/13/968.shtml", "s/ubuntu/13/99.shtml", "server/features/administration", "server/features/cloud", "server/features", "server/features/reduce-costs", "server/features/security", "server/features/system-integration", "server/features/virtualisation", "promo/extra-secure", "promo/lighter-os", "promo/no-viruses", "promo/super-fast", "products/whatisubuntu/serveredition/cloud-old", "products/whatisubuntu/serveredition/cloud", "products/whatisubuntu/serveredition/cloud/UEC", "products/whatisubuntu/serveredition/cloud/faq", "products/whatisubuntu/serveredition/cloud/services", "products/whatisubuntu/serveredition/cloud/services/assess", "products/whatisubuntu/serveredition/cloud/services/audit", "products/whatisubuntu/serveredition/cloud/services/deploy", "products/whatisubuntu/serveredition/cloud/services/manage", "products/whatisubuntu/serveredition/cloud/services/manage/landscape", "products/whatisubuntu/serveredition/cloud/services/poc", "products/whatisubuntu/serveredition/cloud/services/support", "products/whatisubuntu/serveredition/cloud/services/train", "products/whatisubuntu/serveredition/cloud/uec-old", "products/whatisubuntu/serveredition/cloud/uec", "products/whatisubuntu/serveredition/cloud/videos", "products/whatisubuntu/serveredition/ Ubuntu Server", "products/whatisubuntu/serveredition", "products/whatisubuntu/serveredition/benefits", "products/whatisubuntu/serveredition/benefits/lifecycle", "products/whatisubuntu/serveredition/benefits/opentools", "products/whatisubuntu/serveredition/benefits/packagemgmt", "products/whatisubuntu/serveredition/benefits/simplicity", "products/whatisubuntu/serveredition/documentation", "products/whatisubuntu/serveredition/features", "products/whatisubuntu/serveredition/features/apparmor", "products/whatisubuntu/serveredition/features/autodeploy", "products/whatisubuntu/serveredition/features/ec2", "products/whatisubuntu/serveredition/features/fileprint", "products/whatisubuntu/serveredition/features/integration", "products/whatisubuntu/serveredition/features/kernel.", "products/whatisubuntu/serveredition/features/kernel", "products/whatisubuntu/serveredition/features/mailserver", "products/whatisubuntu/serveredition/features/powermanagement", "products/whatisubuntu/serveredition/features/security", "products/whatisubuntu/serveredition/features/webappserver", "products/whatisubuntu/serveredition/jeos.", "products/whatisubuntu/serveredition/jeos", "products/whatisubuntu/serveredition/jeostitolo:Ubuntu", "products/whatisubuntu/serveredition/netinfra", "products/whatisubuntu/serveredition/surveyresults-ty", "products/whatisubuntu/serveredition/surveyresults-view", "products/whatisubuntu/serveredition/surveyresults", "products/whatisubuntu/serveredition/technologies", "products/whatisubuntu/serveredition/technologies/debpackages", "products/whatisubuntu/serveredition/technologies/hwarchitectures", "products/whatisubuntu/serveredition/technologies/ltsp", "products/whatisubuntu/serveredition/technologies/storage", "products/whatisubuntu/serveredition/technologies/virtualization", "products/whatisubuntu/serveredition/techspecs/8.04LTS", "products/whatisubuntu/serveredition/techspecs/9.10I", "products/whatisubuntu/serveredition/techspecs", "products/whatisubuntu/serveredition/techspecs/whatsnew", "products/whatisubuntu/serveredition/validatedhardware", "products/whatisubuntu/serveredition>", "products/whatisubuntu/1004features", "products/whatisubuntu/1010features", "products/whatisubuntu/1204features", "products/whatisubuntu/804features", "products/whatisubuntu/804features/music", "products/whatisubuntu/804features/office-tools", "products/whatisubuntu/804features/productivity-tools", "products/whatisubuntu/810features", "products/whatisubuntu/810features/music", "products/whatisubuntu/810features/office-tools", "products/whatisubuntu/904features", "products/whatisubuntu/904features/accessibility", "products/whatisubuntu/904features/music", "products/whatisubuntu/904features/productivity-tools", "products/whatisubuntu/910features", "products/whatisubuntu/910features/iNdEx.php", "products/casestudies.", "products/casestudies", "products/casestudies/Andalusia deploys 220,000 Ubuntu desktops in schools throughout the region", "products/casestudies/ContactAir", "products/casestudies/KRUU", "products/casestudies/Skegness", "products/casestudies/amtron", "products/casestudies/context-doubles-advertising-performance", "products/casestudies/emphony-achieves-100-percent-uptime", "products/casestudies/equitec-financial-services-chooses-ubuntu-server&", "products/casestudies/equitec-financial-services-chooses-ubuntu-server", "products/casestudies/french-national-police-force-saves-2-million-year-ubuntu", "products/casestudies/johns-hopkins", "products/casestudies/locatrix-mobile-applications", "products/casestudies/oakland-university", "products/casestudies/plus-server-focuses-on-competition", "products/casestudies/wikimedia", "products/GetUb...irect=download", "products/GetUbuntu", "products/GetUbuntu/d...direct=download", "products/GetUbuntu/download.", "products/GetUbuntu/download", "mirror_hit/download/ubuntu/12.04.1/ubuntu-12.04.1-desktop-amd64/iso/certification/Asus/K53U", "mirror_hit/download/ubuntu/12.04.1/ubuntu-12.04.1-desktop-amd64/iso/certification/Lenovo/V480s", "mirror_hit/download/ubuntu/12.04.1/ubuntu-12.04.1-server-amd64/iso/certification/IBM/x220", "mirror_hit/download/ubuntu/12.04.2/ubuntu-12.04.2-desktop-amd64/iso/certification/HP/650", "mirror_hit/download/ubuntu/12.04.2/ubuntu-12.04.2-desktop-amd64/iso/certification/HP/655", "mirror_hit/download/ubuntu/12.04.2/ubuntu-12.04.2-desktop-amd64/iso/certification/Lenovo/B470e", "mirror_hit/download/ubuntu/12.04.2/ubuntu-12.04.2-desktop-amd64/iso/certification/Lenovo/B490", "mirror_hit/download/ubuntu/12.04.2/ubuntu-12.04.2-desktop-amd64/iso/certification/Lenovo/B570e", "mirror_hit/download/ubuntu/12.04.2/ubuntu-12.04.2-desktop-amd64/iso/certification/Lenovo/B590", "mirror_hit/download/ubuntu/12.04.2/ubuntu-12.04.2-desktop-amd64/iso/certification/Lenovo/K49", "mirror_hit/download/ubuntu/12.04.2/ubuntu-12.04.2-desktop-amd64/iso/certification/Lenovo/V580", "mirror_hit/download/ubuntu/12.04.3/ubuntu-12.04.3-desktop-amd64/iso/certification/Lenovo/B490", "mirror_hit/download/ubuntu/12.04.3/ubuntu-12.04.3-desktop-amd64/iso/certification/Lenovo/B490s", "mirror_hit/download/ubuntu/12.04.3/ubuntu-12.04.3-desktop-amd64/iso/certification/Lenovo/B580", "mirror_hit/download/ubuntu/12.04.3/ubuntu-12.04.3-desktop-amd64/iso/certification/Lenovo/K29", "mirror_hit/download/ubuntu/12.04.4/ubuntu-12.04.4-desktop-amd64/iso/certification/Lenovo/B490s", "mirror_hit/download/ubuntu/12.04/ubuntu-12.04-desktop-amd64/iso/certification/Asus/K54C", "mirror_hit/download/ubuntu/12.04/ubuntu-12.04-desktop-amd64/iso/certification/Asus/K54H", "mirror_hit/download/ubuntu/12.04/ubuntu-12.04-desktop-amd64/iso/certification/Dell/M101z", "mirror_hit/download/ubuntu/12.04/ubuntu-12.04-desktop-amd64/iso/certification/HP/rp5800", "mirror_hit/download/ubuntu/12.04/ubuntu-12.04-desktop-amd64/iso/certification/Lenovo/X121e", "mirror_hit/download/ubuntu/12.04/ubuntu-12.04-desktop-amd64/iso/certification/Lenovo/X201", "mirror_hit/download/ubuntu/12.04/ubuntu-12.04-server-amd64/iso/certification/IBM/HS22v", "mirror_hit/download/ubuntu/12.04/ubuntu-12.04-server-amd64/iso/certification/IBM/x3455", "netbook", "netbook/features", "netbook/get-ubuntu", "netbook/get-ubuntu/alternative-download", "netbook/get-ubuntu/download", "netbook/get-ubuntu/upgrade", "netbook/get", "netbook/how-can-it-be-free", "netbookp/get-ubuntu/download", "partner/occs", "partners", "partners/IHV", "partners/ISV", "partners/ISV/benefits", "partners/SolutionProvider/benefits", "partners/affiliate", "partners/arm", "partners/asus", "partners/backed-by-canonical", "partners/become", "partners/casestudies", "partners/certification", "partners/certification/hardware", "partners/certification/pro", "partners/certified-software", "partners/certified/northernmicro", "partners/contact-us", "partners/dell", "partners/dell/dellxps", "partners/eucalyptus", "partners/faq", "partners/featured-partners/arm", "partners/find-a-partner", "partners/find-a-partner/hardware", "partners/find-a-partner/isv", "partners/find-a-partner/oem", "partners/find-a-partner/reseller", "partners/find", "partners/findapartner", "partners/gold", "partners/hardware-summit-2009-sept-en", "partners/hardware-summit-2009-sept", "partners/hardwareprogramme", "partners/hardwareprogramme/freesoftware", "partners/ibm", "partners/ibm/db2", "partners/icsw", "partners/icswVirtual", "partners/isv", "partners/marketplace/join", "partners/morepartnerinformation", "partners/occs", "partners/partner-programmes", "partners/partner-services", "partners/partners/training/course_locator", "partners/program", "partners/programme", "partners/programmetracks", "partners/silver", "partners/softwareprogramme", "partners/solutionprovider", "partners/sun", "partners/systembuilder", "partners/systembuilder/benefits", "partners/training", "partners/training/certificationcourses", "partners/training/certificationcourses/professional", "partners/training/certificationcourses/professional/curriculum", "partners/training/certificationcourses/user", "partners/training/contact", "partners/training/course_locator", "partners/training/exams", "partners/trainingpartner", "partners/trainingpartner/locate", "packages/kde351", "packages/kde351/dists/breezy/main/binary-i386/Packages.gz", "desktop/get-ubuntu/windows-installer", "desktop/get-ubuntu/windows-installer/downloads", "desktop/get-ubuntu/windows-installer/faq.php", "desktop/get-ubuntu/windows-installer/index.php", "desktop/get-ubuntu/windows-installer/latest.php", "desktop/get-ubuntu/windows-installer/please", "desktop/get-ubuntu/windows-installer/screenshots.php", "desktop/get-ubuntu/windows-installer2Run", "desktop/get-ubuntu/windowsinstaller", "ubuntu/11.04", "ubuntu/5.10", "ubuntu/6.10", "ubuntu/8.10", "ubuntu/9.10", "ubuntu/+mirror", "ubuntu/+mirror/edugraf-ubuntu-cds", "ubuntu/+mirror/ftp.dei.uc.pt-release", "", "cloud", "openstack", "financial-services", "telecommunications", "security", "server", "containers", "kubernetes", "desktop", "core", "internet-of-things", "support", "resources", "download", "about", "legal", "resources?", "resources?topic=cloud-and-server", "resources?topic=internet-of-things", "resources?topic=desktop", "resources?topic=cloud-and-server&page=2", "resources?topic=internet-of-things&page=2", "resources?topic=desktop&page=2", "resources?topic=cloud-and-server&page=1", "resources?topic=cloud-and-server&page=3", "resources?topic=internet-of-things&page=1", "resources?topic=desktop&page=1", "resources?topic=desktop&page=3", "resources?topic=cloud-and-server&page=4", "resources?topic=cloud-and-server&page=5", "resources?topic=cloud-and-server&page=6", "resources?topic=cloud-and-server&page=7", "resources?topic=cloud-and-server&page=8", "resources?topic=cloud-and-server&page=9", "about/", "about/contact-us", "about/about-ubuntu", "about/canonical-and-ubuntu", "about-ubuntu/", "about/about-ubuntu/our-philosophy", "about/about-ubuntu/licensing", "about/about-ubuntu/governance", "about/about-ubuntu/conduct", "about/about-ubuntu/diversity", "about/about-ubuntu/ubuntu-and-debian", "about/about-ubuntu/flavours", "contact-us/", "about/contact-us/form?product=generic-contact-us", "about/contact-us/form", "cloud/", "cloud/managed-cloud", "cloud/public-cloud", "cloud/juju", "cloud/storage", "cloud/partners", "cloud/foundation-cloud", "cloud/training", "cloud/contact-us?product=openstack", "cloud/contact-us?product=contextual-footer-cloud", "cloud/contact-us?product=openstack-managed-cloud", "cloud/contact-us?product=contextual-footer-openstack-managed-cloud", "cloud/contact-us?product=ubuntu-advantage-storage", "cloud/contact-us?product=foundation-cloud", "cloud/contact-us?product=openstack-training-onsite", "cloud/contact-us?proudct=openstack-training-server-admin", "cloud/contact-us?product=openstack-training", "cloud/contact-us", "cloud/contact-us?product=openstack-overview", "cloud/contact-us?product=openstack-openstack", "cloud/contact-us?product=openstack-build-openstack", "containers/", "containers/lxd", "containers/docker-ubuntu", "containers/contact-us?product=containers-overview", "containers/contact-us?product=containers-lxd", "containers/contact-us", "containers/contact-us?product=containers-kubernetes-foundation", "containers/contact-us?product=containers-kubernetes-support", "containers/contact-us?product=containers-managed-kubernetes", "containers/contact-us?product=containers-docker", "core/", "core/contact-us?product=core-overview", "core/contact-us", "desktop/", "desktop/features", "desktop/enterprise", "desktop/education", "desktop/government", "desktop/developers", "desktop/partners", "desktop/snappy", "desktop/1710", "desktop/contact-us?product=desktop-enterprise", "desktop/contact-us?product=contextual-footer-desktop", "desktop/contact-us?product=desktop-education", "desktop/contact-us?product=desktop-government", "desktop/contact-us", "download/", "download/cloud", "download/server", "download/desktop", "download/alternative-downloads", "download/ubuntu-flavours", "cloud/", "download/cloud/try-openstack", "download/cloud/build-openstack", "desktop/", "download/desktop/thank-you?country=GB&version=16.04.3&architecture=amd64", "download/desktop/thank-you", "server/", "download/server/provisioning", "download/server/arm", "download/server/power8", "download/server/linuxone", "download/server/thank-you?country=GB&version=16.04.3&architecture=amd64", "download/server/thank-you?country=GB&version=17.10&architecture=amd64", "download/server/thank-you-linuxone", "download/server/thank-you", "info/", "info/release-end-of-life", "internet-of-things/", "internet-of-things/digital-signage", "internet-of-things/robotics", "internet-of-things/gateways", "internet-of-things/contact-us?product=iot-overview", "internet-of-things/contact-us?product=digital-signage", "internet-of-things/contact-us?product=robotics", "internet-of-things/contact-us?product=gateways", "internet-of-things/contact-us", "kubernetes/", "kubernetes/managed", "legal/", "legal/terms-and-policies", "legal/ubuntu-advantage", "legal/bootstack", "legal/contributors", "legal/short-terms", "bootstack", "legal/bootstack/service-description", "legal/bootstack/privacy", "contributors/", "legal/contributors/licence-agreement-faq", "legal/contributors/submit", "short-terms/", "legal/short-terms/ja", "legal/short-terms/2016-06-24", "legal/short-terms/2016-05-20", "legal/short-terms/2015-09-09", "legal/short-terms/2015-06-24", "terms-and-policies/", "legal/terms-and-policies/privacy-policy", "legal/terms-and-policies/contact-us", "legal/terms-and-policies/terms", "legal/terms-and-policies/intellectual-property-policy", "legal/terms-and-policies/online-account-terms", "legal/terms-and-policies/terms-of-service", "legal/terms-and-policies/confidentiality-agreement", "legal/terms-and-policies/developer-terms-and-conditions", "legal/terms-and-policies/livepatch-terms-of-service", "legal/terms-and-policies/jaas-beta-terms-of-service", "legal/terms-and-policies/font-licence", "developer-terms-and-conditions", "legal/terms-and-policies/developer-terms-and-conditions/2016-04-06", "font-licence/", "legal/terms-and-policies/font-licence/faq", "legal/terms-and-policies/font-licence/differences", "intellectual-property-policy/", "legal/terms-and-policies/intellectual-property-policy/2013-05-14", "privacy-policy/", "legal/terms-and-policies/privacy-policy/2013-03-25", "legal/terms-and-policies/privacy-policy/third-parties", "ubuntu-advantage", "legal/ubuntu-advantage/assurance", "legal/ubuntu-advantage/service-description", "legal/ubuntu-advantage/service-description-ja", "service-description-ja/", "legal/ubuntu-advantage/service-description-ja/2017-02-09", "server/", "server/maas", "server/hyperscale", "server/livepatch", "server/contact-us?product=server-overview", "server/contact-us?product=contextual-footer-ua", "server/contact-us?product=server-hyperscale", "server/contact-us", "server/contact-us?product=contextual-footer-server-maas", "server/contact-us?product=server-arm", "maas/", "server/maas/contact-us", "support/", "support/community-support", "support/plans-and-pricing", "support/esm", "support/contact-us", "support/contact-us?product=support-overview", "support/contact-us?product=contextual-footer-landscape", "support/contact-us?product=support-pricing", "support/contact-us?product=server-esm");

my @test = ("https://insights.ubuntu.com/","https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://shop.canonical.com/index.php?cPath=17", "https://shop.canonical.com/index.php?cPath=17", "https://shop.canonical.com/index.php?cPath=17", "https://shop.canonical.com/index.php?cPath=17", "https://shop.canonical.com/index.php?cPath=17", "https://shop.canonical.com/index.php?cPath=17", "https://shop.canonical.com/index.php?cPath=17", "https://shop.canonical.com/index.php?cPath=17", "/download/alternative-downloads", "/download/alternative-downloads", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/server", "/download/server", "/download/server", "/download/server", "/desktop/education", "/desktop/education", "/desktop/education", "/legal/intellectual-property-policy", "/legal/intellectual-property-policy", "/legal/intellectual-property-policy", "/legal/intellectual-property-policy", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/desktop/enterprise", "/desktop/enterprise", "/desktop/enterprise", "/desktop/enterprise", "/desktop/enterprise", "/desktop/enterprise", "/desktop/enterprise", "/desktop/enterprise", "/desktop/enterprise", "/desktop/enterprise", "/desktop/enterprise", "/download/server", "/download/server", "/download/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server/management", "/server", "/server", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "/cloud/training", "/cloud/contact-us?product=openstack-training", "/cloud/contact-us?product=openstack-training", "/cloud/training", "/cloud/contact-us?product=openstack-training", "/cloud", "https://insights.ubuntu.com/cloud-and-server/", "https://insights.ubuntu.com/cloud-and-server/", "/cloud/training", "/cloud/contact-us?product=openstack-training", "/cloud/contact-us?product=openstack-training", "/cloud/training", "/cloud/contact-us?product=openstack-training", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/download/alternative-downloads", "/download/alternative-downloads", "/download/alternative-downloads", "/download/desktop", "/download/ubuntu-kylin", "/download/alternative-downloads", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "https://wiki.ubuntu.com/Releases", "https://wiki.ubuntu.com/Releases", "https://wiki.ubuntu.com/Releases", "https://wiki.ubuntu.com/Releases", "https://wiki.ubuntu.com/Releases", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "/support", "https://wiki.ubuntu.com/Releases", "https://wiki.ubuntu.com/Releases", "/support", "/support", "/support", "/support", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "/info/testing", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/OneiricOcelot/TechnicalOverview/Alpha1", "https://wiki.ubuntu.com/OneiricOcelot/TechnicalOverview/Alpha2", "https://wiki.ubuntu.com/OneiricOcelot/TechnicalOverview/Alpha3", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/OneiricOcelot/TechnicalOverview/Beta1", "https://wiki.ubuntu.com/PrecisePangolin/TechnicalOverview/Alpha1", "https://wiki.ubuntu.com/PrecisePangolin/TechnicalOverview/Alpha2", "https://wiki.ubuntu.com/PrecisePangolin/TechnicalOverview/Beta1", "https://wiki.ubuntu.com/PrecisePangolin/TechnicalOverview/Beta2", "https://wiki.ubuntu.com/QuantalQuetzal/TechnicalOverview/Alpha1", "https://wiki.ubuntu.com/QuantalQuetzal/TechnicalOverview/Alpha2", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://wiki.ubuntu.com/QATeam", "https://insights.ubuntu.com/feed", "https://insights.ubuntu.com/feed", "https://insights.ubuntu.com/feed", "https://insights.ubuntu.com/feed", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/cloud/training", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/about/canonical-and-ubuntu", "/about/canonical-and-ubuntu", "https://insights.ubuntu.com/2010/09/21/canonical-hosts-leading-odms-at-ubuntu-hardware-summit/", "https://insights.ubuntu.com/2010/09/21/canonical-hosts-leading-odms-at-ubuntu-hardware-summit/", "https://insights.ubuntu.com/2010/09/21/canonical-hosts-leading-odms-at-ubuntu-hardware-summit/", "https://insights.ubuntu.com/2010/09/21/canonical-hosts-leading-odms-at-ubuntu-hardware-summit/", "https://wiki.ubuntu.com/", "https://wiki.ubuntu.com/", "https://wiki.ubuntu.com/", "https://wiki.ubuntu.com/", "https://wiki.ubuntu.com/", "https://wiki.ubuntu.com/", "https://wiki.ubuntu.com/", "https://wiki.ubuntu.com/", "https://wiki.ubuntu.com/", "https://wiki.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "https://insights.ubuntu.com/", "/server/management", "/cloud", "/server", "/server", "/server", "/server", "/server", "/download", "/download", "/download", "/download", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/cloud", "/server", "/cloud", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/cloud/public-cloud", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/server", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "/desktop/features", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "https://insights.ubuntu.com/case-studies/", "/download", "/download", "/download", "/download", "/download", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "/desktop", "/desktop/features", "/download/desktop", "/download/desktop", "/download/desktop", "/tutorials/tutorial-upgrading-ubuntu-desktop", "/download/desktop", "/download/desktop", "/download/desktop", "https://partners.ubuntu.com/ibm", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/programmes/hardware", "https://partners.ubuntu.com/programmes/software", "https://partners.ubuntu.com/programmes/software", "https://partners.ubuntu.com/programmes/reseller", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/arm", "https://partners.ubuntu.com/asus", "https://partners.ubuntu.com/partnering-with-us", "https://partners.ubuntu.com/", "https://insights.ubuntu.com/case-studies", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/programmes/software", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/contact-us", "https://partners.ubuntu.com/dell", "https://partners.ubuntu.com/dell", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/programmes/software", "https://partners.ubuntu.com/arm", "https://partners.ubuntu.com/find-a-partner", "https://partners.ubuntu.com/programmes/hardware", "https://partners.ubuntu.com/programmes/software", "https://partners.ubuntu.com/find-a-partner", "https://partners.ubuntu.com/programmes/reseller", "https://partners.ubuntu.com/find-a-partner", "https://partners.ubuntu.com/find-a-partner", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/programmes/hardware", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/ibm", "https://partners.ubuntu.com/ibm", "https://partners.ubuntu.com/programmes/software", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/programmes/software", "https://partners.ubuntu.com/programmes/software", "https://partners.ubuntu.com/programmes/software", "https://partners.ubuntu.com/ibm", "https://partners.ubuntu.com/programmes", "https://partners.ubuntu.com/", "/cloud/training", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/programmes", "https://partners.ubuntu.com/programmes", "https://partners.ubuntu.com/programmes", "https://partners.ubuntu.com/programmes/software", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/programmes/reseller", "https://partners.ubuntu.com/programmes/reseller", "/cloud/training", "/cloud/training", "https://partners.ubuntu.com/", "https://partners.ubuntu.com/", "/cloud/training", "/cloud/training", "/cloud/training", "https://partners.ubuntu.com/", "/cloud/training", "https://partners.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "/download/desktop", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://releases.ubuntu.com/", "https://wiki.ubuntu.com/Mirrors", "https://wiki.ubuntu.com/Mirrors", "https://wiki.ubuntu.com/Mirrors","/", "/cloud", "/openstack", "/financial-services", "/telecommunications", "/security", "/server", "/containers", "/kubernetes", "/desktop", "/core", "/internet-of-things", "/support", "/resources", "/download", "/about", "/legal", "/resources?", "/resources?topic=cloud-and-server", "/resources?topic=internet-of-things", "/resources?topic=desktop", "/resources?topic=cloud-and-server&page=2", "/resources?topic=internet-of-things&page=2", "/resources?topic=desktop&page=2", "/resources?topic=cloud-and-server&page=1", "/resources?topic=cloud-and-server&page=3", "/resources?topic=internet-of-things&page=1", "/resources?topic=desktop&page=1", "/resources?topic=desktop&page=3", "/resources?topic=cloud-and-server&page=4", "/resources?topic=cloud-and-server&page=5", "/resources?topic=cloud-and-server&page=6", "/resources?topic=cloud-and-server&page=7", "/resources?topic=cloud-and-server&page=8", "/resources?topic=cloud-and-server&page=9", "/about", "/about/contact-us", "/about/about-ubuntu", "/about/canonical-and-ubuntu", "/about-ubuntu", "/about/about-ubuntu/our-philosophy", "/about/about-ubuntu/licensing", "/about/about-ubuntu/governance", "/about/about-ubuntu/conduct", "/about/about-ubuntu/diversity", "/about/about-ubuntu/ubuntu-and-debian", "/about/about-ubuntu/flavours", "/about/contact-us", "/about/contact-us/form?product=generic-contact-us", "/about/contact-us/form", "/cloud", "/cloud/managed-cloud", "/cloud/public-cloud", "/cloud/juju", "/cloud/storage", "/cloud/partners", "/cloud/foundation-cloud", "/cloud/training", "/cloud/contact-us?product=openstack", "/cloud/contact-us?product=contextual-footer-cloud", "/cloud/contact-us?product=openstack-managed-cloud", "/cloud/contact-us?product=contextual-footer-openstack-managed-cloud", "/cloud/contact-us?product=ubuntu-advantage-storage", "/cloud/contact-us?product=foundation-cloud", "/cloud/contact-us?product=openstack-training-onsite", "/cloud/contact-us?proudct=openstack-training-server-admin", "/cloud/contact-us?product=openstack-training", "/cloud/contact-us", "/cloud/contact-us?product=openstack-overview", "/cloud/contact-us?product=openstack-openstack", "/cloud/contact-us?product=openstack-build-openstack", "/containers", "/containers/lxd", "/containers/docker-ubuntu", "/containers/contact-us?product=containers-overview", "/containers/contact-us?product=containers-lxd", "/containers/contact-us", "/containers/contact-us?product=containers-kubernetes-foundation", "/containers/contact-us?product=containers-kubernetes-support", "/containers/contact-us?product=containers-managed-kubernetes", "/containers/contact-us?product=containers-docker", "/core", "/core/contact-us?product=core-overview", "/core/contact-us", "/desktop", "/desktop/features", "/desktop/enterprise", "/desktop/education", "/desktop/government", "/desktop/developers", "/desktop/partners", "/desktop/snappy", "/desktop/1710", "/desktop/contact-us?product=desktop-enterprise", "/desktop/contact-us?product=contextual-footer-desktop", "/desktop/contact-us?product=desktop-education", "/desktop/contact-us?product=desktop-government", "/desktop/contact-us", "/download", "/download/cloud", "/download/server", "/download/desktop", "/download/alternative-downloads", "/download/ubuntu-flavours", "/cloud", "/download/cloud/try-openstack", "/download/cloud/build-openstack", "/desktop", "/download/desktop/thank-you?country=GB&version=16.04.3&architecture=amd64", "/download/desktop/thank-you", "/server", "/download/server/provisioning", "/download/server/arm", "/download/server/power8", "/download/server/linuxone", "/download/server/thank-you?country=GB&version=16.04.3&architecture=amd64", "/download/server/thank-you?country=GB&version=17.10&architecture=amd64", "/download/server/thank-you-linuxone", "/download/server/thank-you", "/info", "/info/release-end-of-life", "/internet-of-things", "/internet-of-things/digital-signage", "/internet-of-things/robotics", "/internet-of-things/gateways", "/internet-of-things/contact-us?product=iot-overview", "/internet-of-things/contact-us?product=digital-signage", "/internet-of-things/contact-us?product=robotics", "/internet-of-things/contact-us?product=gateways", "/internet-of-things/contact-us", "/kubernetes", "/kubernetes/managed", "/legal", "/legal/terms-and-policies", "/legal/ubuntu-advantage", "/legal/managed-services", "/legal/contributors", "/legal/short-terms", "/cloud/managed-cloud", "/legal/managed-services-description", "/legal/managed-services-privacy", "/contributors", "/legal/contributors/licence-agreement-faq", "/legal/contributors/submit", "/short-terms", "/legal/short-terms/ja", "/legal/short-terms/2016-06-24", "/legal/short-terms/2016-05-20", "/legal/short-terms/2015-09-09", "/legal/short-terms/2015-06-24", "/terms-and-policies", "/legal/privacy-policy", "/legal/terms-and-policies/contact-us", "/legal/terms", "/legal/intellectual-property-policy", "/legal/online-account-terms", "/legal/terms-of-service", "/legal/confidentiality-agreement", "/legal/developer-terms-and-conditions", "/legal/livepatch-terms-of-service", "/legal/jaas-beta-terms-of-service", "/legal/font-licence", "/legal/developer-terms-and-conditions", "/legal/developer-terms-and-conditions/2016-04-06", "/font-licence", "/legal/font-licence/faq", "/legal/font-licence/differences", "/legal/intellectual-property-policy", "/legal/intellectual-property-policy/2013-05-14", "/legal/privacy-policy", "/legal/privacy-policy/2013-03-25", "/legal/privacy-policy/third-parties", "/support", "/legal/ubuntu-advantage-assurance", "/legal/ubuntu-advantage-service-description", "/legal/ubuntu-advantage-service-description/ja", "/service-description-ja", "/legal/ubuntu-advantage/service-description-ja/2017-02-09", "/server", "/server/maas", "/server/hyperscale", "/livepatch", "/server/contact-us?product=server-overview", "/server/contact-us?product=contextual-footer-ua", "/server/contact-us?product=server-hyperscale", "/server/contact-us", "/server/contact-us?product=contextual-footer-server-maas", "/server/contact-us?product=server-arm", "/server/maas", "/server/contact-us?product=server-maas", "/support", "/support/community-support", "/support/plans-and-pricing", "/support/esm", "/support/contact-us", "/support/contact-us?product=support-overview", "/support/contact-us?product=contextual-footer-landscape", "/support/contact-us?product=support-pricing", "/support/contact-us?product=server-esm");

my $counter = 0;
foreach (@redirects) {

  $result = `curl --silent --location --head --output /dev/null --write-out '%{url_effective}' -- 'http://0.0.0.0:8001/$_'`;

  my $flag = "";

  $test[$counter] = qq|http://0.0.0.0:8001|.$test[$counter] if ($test[$counter] !~ /http/); # add localhost if none.

  my $no_slash = $test[$counter];
  $no_slash =~ s/\/$//;
  print STDERR "$no_slash\n";

  if ($result eq $test[$counter] || $results eq $no_slash) {
    print STDERR qq|$counter: $_ -> $result = $test[$counter] \n|;
  } elsif ($result eq $test[$counter]) {
    print STDERR qq|$counter: $_ -> $result = $test[$counter] \n|;
  } else {
    print qq|$counter\t$_\t$result\t$test[$counter]\n|;
  }
  $counter++;
}

exit;
