import { defineConfig, devices } from '@playwright/test';
import * as dotenv from 'dotenv';
import * as path from "path";
 
dotenv.config({
    path:  path.join(__dirname, ".env.local")
});

/**
 * See https://playwright.dev/docs/test-configuration.
 */
export default defineConfig({
  testDir: path.join(__dirname, "tests/playwright/tests"),
  testIgnore: '**\/pro/**',
  /* Run tests in files in parallel */
  fullyParallel: true,
  /* Fail the build on CI if you accidentally left test.only in the source code. */
  forbidOnly: !!process.env.CI,
  /* Retry on CI only */
  retries: process.env.CI ? 2 : 0,
  /* Opt out of parallel tests on CI. */
  workers: process.env.CI ? 1 : undefined,
  /* Reporter to use. See https://playwright.dev/docs/test-reporters */
  reporter: 'html',
  /* Shared settings for all the projects below. See https://playwright.dev/docs/api/class-testoptions. */
  timeout: 30000,
  use: {
    baseURL: "http://0.0.0.0:8001",
    /* Collect trace when retrying the failed test. See https://playwright.dev/docs/trace-viewer */
    trace: 'on-first-retry',
    ignoreHTTPSErrors: true,
    headless: true,
  },
  
  /* Configure projects for major browsers */
  projects: [
    {
      name: 'checkout',
      testMatch: "*.spec.ts",
      use: { ...devices['Desktop Chrome']},
    },
  ],
});
