# [Summary.Samples.InheritDocBase](../src/Core/Samples/InheritDocSample.cs#L19)
```cs
public class InheritDocBase
```

Summary.

_Remarks section._

## Delegates
### [Delegate1(int, int)](../src/Core/Samples/InheritDocSample.cs#L27)
```cs
public void Delegate1(int x, int y)
```

A sample delegate.

#### Parameters
- `x`: First parameter.
- `y`: Second parameter.

#### Returns
Nothing.

### [Delegate2(int, int)](../src/Core/Samples/InheritDocSample.cs#L30)
```cs
public void Delegate2(int x, int y)
```

A sample delegate.

#### Parameters
- `x`: First parameter.
- `y`: Second parameter.

#### Returns
Nothing.

### [Delegate3(int, int)](../src/Core/Samples/InheritDocSample.cs#L33)
```cs
public void Delegate3(int x, int y)
```

## Events
### [Event1](../src/Core/Samples/InheritDocSample.cs#L66)
```cs
public virtual event Action Event1
```

An event.

## Fields
### [Field1](../src/Core/Samples/InheritDocSample.cs#L38)
```cs
public int Field1
```

A field.

### [Field2](../src/Core/Samples/InheritDocSample.cs#L41)
```cs
public int Field2
```

A field.

## Properties
### [Property1](../src/Core/Samples/InheritDocSample.cs#L49)
```cs
public virtual int Property1 { get; set; }
```

A property.

_Property remarks._

### [Property2](../src/Core/Samples/InheritDocSample.cs#L52)
```cs
public virtual int Property2 { get; set; }
```

A property.

_Property remarks._

### [Property3](../src/Core/Samples/InheritDocSample.cs#L55)
```cs
public int Property3 { get; set; }
```

A property.

_Property remarks._

## Indexers
### [this[int]](../src/Core/Samples/InheritDocSample.cs#L61)
```cs
public virtual int this[int i] { get; }
```

An indexer.

#### Parameters
- `i`: A parameter to the indexer.

## Methods
### [Sum(int, int)](../src/Core/Samples/InheritDocSample.cs#L74)
```cs
public virtual int Sum(int x, int y)
```

Calculates the sum.

#### Parameters
- `x`: The first parameter.
- `y`: The second parameter.

#### Returns
Returns the sum of two values.

### [Sum&lt;T&gt;(byte, byte)](../src/Core/Samples/InheritDocSample.cs#L83)
```cs
public byte Sum<T>(byte x, byte y)
```

Calculates the byte sum.

#### Type Parameters
- `T`: The type parameter.

#### Parameters
- `x`: The first byte parameter.
- `y`: The second byte parameter.

#### Returns
Returns the sum of two values.

### [Sum(short, short)](../src/Core/Samples/InheritDocSample.cs#L86)
```cs
public short Sum(short x, short y)
```

Calculates the byte sum.

#### Parameters
- `x`: The first byte parameter.
- `y`: The second byte parameter.

#### Returns
Returns the sum of two values.

### [Sum2(short, short)](../src/Core/Samples/InheritDocSample.cs#L89)
```cs
public short Sum2(short x, short y)
```

Calculates the byte sum.

#### Parameters
- `x`: The first byte parameter.
- `y`: The second byte parameter.

#### Returns
Returns the sum of two values.

### [Sum3(short, short)](../src/Core/Samples/InheritDocSample.cs#L92)
```cs
public short Sum3(short x, short y)
```

Calculates the byte sum.

#### Parameters
- `x`: The first byte parameter.
- `y`: The second byte parameter.

#### Returns
Returns the sum of two values.

### [Sum4(short, short)](../src/Core/Samples/InheritDocSample.cs#L95)
```cs
public short Sum4(short x, short y)
```

Calculates the byte sum.

#### Parameters
- `x`: The first byte parameter.
- `y`: The second byte parameter.

#### Returns
Returns the sum of two values.

