# [Summary.DocProperty](../src/Core/DocProperty.cs#L8)
```cs
public record DocProperty : DocMember
```

A [`DocMember`](./Summary.DocMember.md) that represents a documented property in the parsed source code.

## Properties
### [Type](../src/Core/DocProperty.cs#L13)
```cs
public required DocType Type { get; init; }
```

The type of the property.

### [Accessors](../src/Core/DocProperty.cs#L18)
```cs
public required DocPropertyAccessor[] Accessors { get; init; }
```

The accessors of the property (e.g., `get`, `set`, `init`).

### [Generated](../src/Core/DocProperty.cs#L23)
```cs
public required bool Generated { get; init; }
```

Whether this property was generated by compiler (e.g., it's a property of a record).

### [Event](../src/Core/DocProperty.cs#L29)
```cs
public required bool Event { get; init; }
```

Whether this property represents an event.

### [AccessorsDeclaration](../src/Core/DocProperty.cs#L34)
```cs
public string AccessorsDeclaration { get; }
```

The declaration of property accessors as they declared in the C# source code.

