import {twJoin} from 'tailwind-merge';

// @region Copy Button

const COPY_ICON_CLASSNAME = twJoin(
  'size-5',
  'text-neutral-400',
  'dark:text-neutral-500',
);

const COPY_ICON = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="${COPY_ICON_CLASSNAME}"><path d="M7.5 3H14.6C16.8402 3 17.9603 3 18.816 3.43597C19.5686 3.81947 20.1805 4.43139 20.564 5.18404C21 6.03969 21 7.15979 21 9.4V16.5M6.2 21H14.3C15.4201 21 15.9802 21 16.408 20.782C16.7843 20.5903 17.0903 20.2843 17.282 19.908C17.5 19.4802 17.5 18.9201 17.5 17.8V9.7C17.5 8.57989 17.5 8.01984 17.282 7.59202C17.0903 7.21569 16.7843 6.90973 16.408 6.71799C15.9802 6.5 15.4201 6.5 14.3 6.5H6.2C5.0799 6.5 4.51984 6.5 4.09202 6.71799C3.71569 6.90973 3.40973 7.21569 3.21799 7.59202C3 8.01984 3 8.57989 3 9.7V17.8C3 18.9201 3 19.4802 3.21799 19.908C3.40973 20.2843 3.71569 20.5903 4.09202 20.782C4.51984 21 5.0799 21 6.2 21Z" class="size-3"></path></svg>`;

const CHECK_ICON_CLASSNAME = twJoin(
  'size-5',
  'text-green-600',
  'dark:text-green-500',
);

const CHECK_ICON = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"  class="${CHECK_ICON_CLASSNAME}"><path d="M20 6L9 17L4 12"></path></svg>`;

const COPY_BUTTON_CLASSNAME = twJoin(
  'absolute',
  'top-4',
  'right-4',
  'disabled:cursor-not-allowed',
);

export function addCopyButtonToPreTags() {
  const preTags = document.querySelectorAll<HTMLPreElement>('pre');
  const cleanupFns: (() => void)[] = [];

  preTags.forEach((parent) => {
    const parentCss = getComputedStyle(parent);
    const parentPos = parentCss.position;

    parent.style.position = parentPos === 'static' ? 'relative' : parentPos;

    const button = document.createElement('button');

    button.type = 'button';
    button.innerHTML = COPY_ICON;
    button.ariaLabel = 'Copy code';
    button.className = COPY_BUTTON_CLASSNAME;

    const snippet = parent.innerText.trim();

    let timeout: NodeJS.Timeout;

    async function handleClick() {
      await navigator.clipboard.writeText(snippet);

      button.disabled = true;
      button.innerHTML = CHECK_ICON;

      timeout = setTimeout(() => {
        button.disabled = false;
        button.innerHTML = COPY_ICON;

        clearTimeout(timeout);
      }, 2500);
    }

    button.addEventListener('click', handleClick);
    parent.appendChild(button);

    cleanupFns.push(() => {
      button.removeEventListener('click', handleClick);
      parent.removeChild(button);
      parent.style.position = parentPos;
      if (timeout) clearTimeout(timeout);
    });
  });

  return () => cleanupFns.forEach((fn) => fn());
}

// @endregion
