Mimiker wiki
---

Before you pick up any task please read *chapter "Operating system design"* from [*Modern Operating Systems*](http://www.pearsonhighered.com/educator/product/Modern-Operating-Systems/9780133591620.page) by Andrew Tanenbaum and Herbert Bos.

### Guiding Principles

>  _"Perfection is reached not when there is no longer anything to add, but when there is no longer anything to take away."_ - Antoine de St. Exupery

When you design and implement an interface, please keep in mind following practices and principles:

1. [Keep it simple, stupid](https://en.wikipedia.org/wiki/KISS_principle)
2. [Worse is better](https://en.wikipedia.org/wiki/Worse_is_better)
3. [Single Source of Truth](https://en.wikipedia.org/wiki/Single_Source_of_Truth)
4. [Separation of concerns](https://en.wikipedia.org/wiki/Separation_of_concerns)
5. [Separation of mechanism and policy](https://en.wikipedia.org/wiki/Separation_of_mechanism_and_policy)
6. [You aren't gonna need it](https://en.wikipedia.org/wiki/You_aren%27t_gonna_need_it)
7. [Law of Demeter](https://en.wikipedia.org/wiki/Law_of_Demeter)

### Useful links:

* [L4 Kernel Reference Manual](http://www.l4ka.org/l4ka/l4-x2-r7.pdf) Version X.2
* [Linux Kernel Cross Reference](http://lxr.free-electrons.com/)
* [FreeBSD Kernel Cross Reference](http://fxr.watson.org/fxr/source/)
* [Minix 3.3.0 Cross Reference](http://users.sosdg.org/~qiyong/mxr/source/minix/kernel/)

### Documentation

Useful sites:
* [OSDev wiki](http://wiki.osdev.org)

Toolchain documentation:
* [Extensions to the C Language Family](https://gcc.gnu.org/onlinedocs/gcc/C-Extensions.html)
* [Debugging with GDB](https://sourceware.org/gdb/onlinedocs/gdb/index.html)
* [Linker scripts](https://sourceware.org/binutils/docs/ld/Scripts.html)
