                            L  4   
 R E S _ M A P C O D E       0 
        <!DOCTYPE html>
<html>
<head>
  <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
  <meta http-equiv="Pragma" content="no-cache" />
  <meta http-equiv="Expires" content="0" />

  <style type="text/css"> 
    html { height: 100% } 
    body { height: 100%; margin: 0px; padding: 0px } 
    #map_canvas { height: 100% } 
  </style>

  <script>
    var map = null;
    var mapOptions = null;
    var trafficLayer = null;
    var transitLayer = null;
    var bicyclingLayer = null;
    var kmlLayer = null;
  </script>

  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script type="text/javascript" src="transform.js" charset="utf-8"></script>
  <script type="text/javascript" src="map.js" charset="utf-8"></script>
  <script type="text/javascript" src="latlngbounds.js" charset="utf-8"></script>

  <script type="text/javascript">  // 
    function doMap() {
      /*mapOptions = {
                    center: new google.maps.LatLng(0,0),
                    zoom: 8                   
                   };*/
      map = new google.maps.Map(document.getElementById("googleMap"), mapOptions);
      
      mapAssignEvents();
    }

    $.fn.serializeObject = function() {
      var o = {};
      var a = this.serializeArray();
      $.each(a, function() {
        if (o[this.name]) {
          if (!o[this.name].push) {
            o[this.name] = [o[this.name]];
          }
          o[this.name].push(this.value || '');
        } 
        else {
          o[this.name] = this.value || '';
        }
      }
      );
      return o;
    };

    function getFormToJson() {
      var jsonStr = 
              '{' + 
              '"eventsMap":' + JSON.stringify($("#eventsMap").serializeObject()) + ',' +
              '"llbResults":' + JSON.stringify($("#llbResults").serializeObject()) + 
              '}';
      console.log(jsonStr);
          
      if (jsonStr.length >= 1) {
        window.chrome.webview.postMessage(jsonStr);
      }
      else {
        window.chrome.webview.postMessage("");
      }
    }
  </script>
  
</head>

<body>
<!--
  <p>
    <button onclick="setMapOptions('#00FF00',42.539898,1.578505,false,true,true,'','',false,'cpRIGHT_TOP','ghAuto',0,true,true,true,'mtHYBRID;mtROADMAP;mtTERRAIN','cpTOP_RIGHT','mtcDROPDOWN_MENU','mtROADMAP',0,0,false,0,0,0,0,false,false,true,'cpTOP_LEFT',true,'scsDEFAULT',true,'cpTOP_LEFT',0,10,true,'cpTOP_LEFT');">SetOptions</button>
    <button onclick="doMap()">DoMap</button>
    <button onclick="ShowLayers(false,false,false,true)">Layers On</button>
    <button onclick="ShowLayers(false,false,false,false)">Layers Off</button>
  </p>
-->
  
  <form action="#" id="eventsMap" name="eventsMap"> 
    <input type="hidden" id="eventsMapEventFired" name="eventsMapEventFired" value="0"/> 

    <input type="hidden" id="eventsMapLat" name="eventsMapLat" value="0"/> 
    <input type="hidden" id="eventsMapLng" name="eventsMapLng" value="0"/> 
    <input type="hidden" id="eventsMapX" name="eventsMapX" value="0"/> 
    <input type="hidden" id="eventsMapY" name="eventsMapY" value="0"/> 
    <input type="hidden" id="eventsMapCenterChange" name="eventsMapCenterChange" value="0"/> 
    <input type="hidden" id="eventsMapClick" name="eventsMapClick" value="0"/> 
    <input type="hidden" id="eventsMapContextmenu" name="eventsMapContextmenu" value="0"/> 
    <input type="hidden" id="eventsMapDblclick" name="eventsMapDblclick" value="0"/> 
    <input type="hidden" id="eventsMapMouseMove" name="eventsMapMouseMove" value="0"/> 
    <input type="hidden" id="eventsMapMouseOut" name="eventsMapMouseOut" value="0"/> 
    <input type="hidden" id="eventsMapMouseOver" name="eventsMapMouseOver" value="0"/> 

    <input type="hidden" id="eventsMapDrag" name="eventsMapDrag" value="0"/> 
    <input type="hidden" id="eventsMapDragEnd" name="eventsMapDragEnd" value="0"/> 
    <input type="hidden" id="eventsMapDragStart" name="eventsMapDragStart" value="0"/> 

    <input type="hidden" id="eventsMapMapTypeId" name="eventsMapMapTypeId" value=""/> 
    <input type="hidden" id="eventsMapMapTypeId_changed" name="eventsMapMapTypeId_changed" value="0"/> 

    <input type="hidden" id="eventsMapTilesLoaded" name="eventsMapTilesLoaded" value="0"/> 

    <input type="hidden" id="eventsMapSwLat" name="eventsMapSwLat" value="0"/> 
    <input type="hidden" id="eventsMapSwLng" name="eventsMapSwLng" value="0"/> 
    <input type="hidden" id="eventsMapNeLat" name="eventsMapNeLat" value="0"/> 
    <input type="hidden" id="eventsMapNeLng" name="eventsMapNeLng" value="0"/> 
    <input type="hidden" id="eventsMapBoundsChange" name="eventsMapBoundsChange" value="0"/> 

    <input type="hidden" id="eventsMapZoom" name="eventsMapZoom" value="0"/> 
    <input type="hidden" id="eventsMapZoomChanged" name="eventsMapZoomChanged" value="0"/> 
  </form> 

  <form action="#" id="llbResults" name="llbResults"> 
    <input type="hidden" id="llbResultsMapisnull" name="llbResultsMapisnull" value="0"/> 
    <input type="hidden" id="llbResultsBoolVal" name="llbResultsBoolVal" value="0"/> 
    <input type="hidden" id="llbResultsSwLat" name="llbResultsSwLat" value="0"/> 
    <input type="hidden" id="llbResultsSwLng" name="llbResultsSwLng" value="0"/> 
    <input type="hidden" id="llbResultsNeLat" name="llbResultsNeLat" value="0"/> 
    <input type="hidden" id="llbResultsNeLng" name="llbResultsNeLng" value="0"/> 
    <input type="hidden" id="llbResultsLat" name="llbResultsLat" value="0"/> 
    <input type="hidden" id="llbResultsLng" name="llbResultsLng" value="0"/> 
  </form> 
 
  <div id="googleMap" style="width:100%;height:100%;"></div>

<!--
  <script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?v=weekly&key=&region=ES&language=ca"></script>
--> 

  <script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?v=API_VER&key=API_KEY&region=API_REGION&language=API_LAN"></script>

  <form action="#" id="eventsMap" name="eventsMap">
    <input type="hidden" name="test" value="0"/>
  </form> 
  

</body>
</html>
  H   
 R E S _ L A T L N G B O U N D S C O D E         0 
        /* **********************************
  this function check if a LatLngBounds contains a LatLng. 
********************************** */
function llbContains(                       
                     Lat,       // --> Lat from LatLng to check
                     Lng,       // --> Lng from LatLng to check
                     SWLat, 
                     SWLng, 
                     NELat, 
                     NELng 
                    ) {
  document.getElementById('llbResultsMapisnull').value = "0"; 
  if (map != null) { 
    var latlng = new google.maps.LatLng(Lat, Lng); 
    var Bounds = new google.maps.LatLngBounds(new google.maps.LatLng(SWLat, SWLng), new google.maps.LatLng(NELat, NELng)); 
    document.getElementById('llbResultsBoolVal').value = "0";
    if (Bounds.contains(latlng))  
      document.getElementById('llbResultsBoolVal').value = "1"; 
  } 
  else 
    document.getElementById('llbResultsMapisnull').value = "1"; 
}

/* **********************************
  this function extends a LatLngBounds with a LatLng. 
********************************** */
function llbExtend(                       
                   Lat,       // --> Lat that must be into bounds
                   Lng,       // --> Lng that must be into bounds
                   SWLat, 
                   SWLng, 
                   NELat, 
                   NELng 
                  ) { 
  document.getElementById('llbResultsMapisnull').value = "0"; 
  if (map != null) { 
    var latlng = new google.maps.LatLng(Lat, Lng); 
    var Bounds = new google.maps.LatLngBounds(new google.maps.LatLng(SWLat, SWLng), new google.maps.LatLng(NELat, NELng)); 
    Bounds = Bounds.extend(latlng); 
    document.getElementById('llbResultsSwLat').value = Bounds.getSouthWest().lat(); 
    document.getElementById('llbResultsSwLng').value = Bounds.getSouthWest().lng(); 
    document.getElementById('llbResultsNeLat').value = Bounds.getNorthEast().lat(); 
    document.getElementById('llbResultsNeLng').value = Bounds.getNorthEast().lng(); 
  } 
  else 
    document.getElementById('llbResultsMapisnull').value = "1"; 
}

/* **********************************
  this function get center of a bounds. 
********************************** */
function llbGetCenter(                       
                      SWLat, 
                      SWLng, 
                      NELat, 
                      NELng 
                     ) { 
  document.getElementById('llbResultsMapisnull').value = "0"; 
  if (map != null) { 
    var Bounds = new google.maps.LatLngBounds(new google.maps.LatLng(SWLat, SWLng), new google.maps.LatLng(NELat, NELng)); 
    var LatLng = Bounds.getCenter();
    document.getElementById('llbResultsLat').value = LatLng.lat(); 
    document.getElementById('llbResultsLng').value = LatLng.lng(); 
  } 
  else 
    document.getElementById('llbResultsMapisnull').value = "1"; 
} 

/* **********************************
  this function returns true if this bounds shares any points with the other bounds. 
********************************** */
function llbIntersects(                       
                      OtherSWLat, 
                      OtherSWLng, 
                      OtherNELat, 
                      OtherNELng,
                      SWLat, 
                      SWLng, 
                      NELat, 
                      NELng 
                     ) { 
  document.getElementById('llbResultsMapisnull').value = "0"; 
  if (map != null) { 
    var Bounds = new google.maps.LatLngBounds(new google.maps.LatLng(SWLat, SWLng), new google.maps.LatLng(NELat, NELng)); 
    var OtherBounds = new google.maps.LatLngBounds(new google.maps.LatLng(OtherSWLat, OtherSWLng), new google.maps.LatLng(OtherNELat, OtherNELng)); 
    document.getElementById('llbResultsBoolVal').value = "0";
    if (Bounds.intersects(OtherBounds))  
      document.getElementById('llbResultsBoolVal').value = "1"; 
  } 
  else 
    document.getElementById('llbResultsMapisnull').value = "1"; 
} 

/* **********************************
  this function converts the given bounds to a lat/lng span.
********************************** */
function llbToSpan(                       
                   SWLat, 
                   SWLng, 
                   NELat, 
                   NELng 
                  ) { 
  document.getElementById('llbResultsMapisnull').value = "0"; 
  if (map != null) { 
    var Bounds = new google.maps.LatLngBounds(new google.maps.LatLng(SWLat, SWLng), new google.maps.LatLng(NELat, NELng)); 
    var LatLng = Bounds.toSpan();
    document.getElementById('llbResultsLat').value = LatLng.lat(); 
    document.getElementById('llbResultsLng').value = LatLng.lng(); 
  } 
  else 
    document.getElementById('llbResultsMapisnull').value = "1"; 
} 

/* **********************************
  this function extends the bounds to contain the union of this and the given bounds.
********************************** */
function llbUnion(                       
                  OtherSWLat, 
                  OtherSWLng, 
                  OtherNELat, 
                  OtherNELng,
                  SWLat, 
                  SWLng, 
                  NELat, 
                  NELng 
                 ) { 
  document.getElementById('llbResultsMapisnull').value = "0"; 
  if (map != null) { 
    var Bounds = new google.maps.LatLngBounds(new google.maps.LatLng(SWLat, SWLng), new google.maps.LatLng(NELat, NELng)); 
    var OtherBounds = new google.maps.LatLngBounds(new google.maps.LatLng(OtherSWLat, OtherSWLng), new google.maps.LatLng(OtherNELat, OtherNELng)); 
    Bounds = Bounds.union(OtherBounds); 
    document.getElementById('llbResultsSwLat').value = Bounds.getSouthWest().lat(); 
    document.getElementById('llbResultsSwLng').value = Bounds.getSouthWest().lng(); 
    document.getElementById('llbResultsNeLat').value = Bounds.getNorthEast().lat(); 
    document.getElementById('llbResultsNeLng').value = Bounds.getNorthEast().lng(); 
  } 
  else 
    document.getElementById('llbResultsMapisnull').value = "1"; 
} 
 X  8   
 R E S _ M A P J S C O D E       0 
        
/* **********************************
  this function activates the map events
********************************** */
function mapAssignEvents() {
  google.maps.event.addListener(map, 
                                "bounds_changed", 
                                function() { 
                                             var LatLngBounds = map.getBounds(); 
                                             var SW = LatLngBounds.getSouthWest(); 
                                             var NE = LatLngBounds.getNorthEast(); 
                               
                                             document.getElementById('eventsMapSwLat').value = SW.lat(); 
                                             document.getElementById('eventsMapSwLng').value = SW.lng(); 
                                             document.getElementById('eventsMapNeLat').value = NE.lat(); 
                                             document.getElementById('eventsMapNeLng').value = NE.lng(); 
                                             document.getElementById('eventsMapBoundsChange').value = "1"; 
                                             document.getElementById('eventsMapEventFired').value = "1"; 
                                           }
                               ); 
  google.maps.event.addListener(map, 
                                "center_changed", 
                                function() { 
                                             var LatLng = map.getCenter(); 
                                             var proj = map.getProjection();
                                             var point = proj.fromLatLngToPoint(LatLng);
                                             
                                             document.getElementById('eventsMapX').value = point.x; 
                                             document.getElementById('eventsMapY').value = point.y; 
                                             document.getElementById('eventsMapLat').value = LatLng.lat(); 
                                             document.getElementById('eventsMapLng').value = LatLng.lng(); 
                                             document.getElementById('eventsMapCenterChange').value = "1"; 
                                             document.getElementById('eventsMapEventFired').value = "1"; 
                                           }
                               ); 
  google.maps.event.addListener(map, 
                                "click", 
                                function(event) { 
                                                  var proj = map.getProjection();
                                                  var point = proj.fromLatLngToPoint(event.latLng);
                                                  
                                                 document.getElementById('eventsMapX').value = point.x; 
                                                 document.getElementById('eventsMapY').value = point.y; 
                                                 document.getElementById('eventsMapLat').value = event.latLng.lat(); 
                                                 document.getElementById('eventsMapLng').value = event.latLng.lng(); 
                                                 document.getElementById('eventsMapClick').value = "1"; 
                                                 document.getElementById('eventsMapEventFired').value = "1"; 
                                                }
                               ); 
  google.maps.event.addListener(map, 
                                "contextmenu", 
                                function(event) { 
                                                  var proj = map.getProjection();
                                                  var point = proj.fromLatLngToPoint(event.latLng);
                                                  
                                                 document.getElementById('eventsMapX').value = point.x; 
                                                 document.getElementById('eventsMapY').value = point.y; 
                                                 document.getElementById('eventsMapLat').value = event.latLng.lat(); 
                                                 document.getElementById('eventsMapLng').value = event.latLng.lng(); 
                                                 document.getElementById('eventsMapContextmenu').value = "1"; 
                                                 document.getElementById('eventsMapEventFired').value = "1"; 
                                                }
                               ); 
  google.maps.event.addListener(map, 
                                "dblclick", 
                                function(event) { 
                                                  var proj = map.getProjection();
                                                  var point = proj.fromLatLngToPoint(event.latLng);
                                                  
                                                 document.getElementById('eventsMapX').value = point.x; 
                                                 document.getElementById('eventsMapY').value = point.y; 
                                                 document.getElementById('eventsMapLat').value = event.latLng.lat(); 
                                                 document.getElementById('eventsMapLng').value = event.latLng.lng(); 
                                                 document.getElementById('eventsMapDblclick').value = "1"; 
                                                 document.getElementById('eventsMapEventFired').value = "1"; 
                                                }
                               ); 
  google.maps.event.addListener(map, 
                                "drag", 
                                function() { 
                                             document.getElementById('eventsMapDrag').value = "1"; 
                                             document.getElementById('eventsMapEventFired').value = "1"; 
                                           }
                               ); 
  google.maps.event.addListener(map, 
                                "dragend", 
                                function() { 
                                             document.getElementById('eventsMapDragEnd').value = "1"; 
                                             document.getElementById('eventsMapEventFired').value = "1"; 
                                           }
                               ); 
  google.maps.event.addListener(map, 
                                "dragstart", 
                                function() { 
                                             document.getElementById('eventsMapDragStart').value = "1"; 
                                             document.getElementById('eventsMapEventFired').value = "1"; 
                                           }
                               ); 
  google.maps.event.addListener(map,
                                "maptypeid_changed", 
                                function() { 
                                             var MapType = map.getMapTypeId(); 
                                             
                                             document.getElementById('eventsMapMapTypeId').value = MapTypeIdToStr(MapType); 
                                             document.getElementById('eventsMapMapTypeId_changed').value = "1"; 
                                             document.getElementById('eventsMapEventFired').value = "1"; 
                                           }
                               ); 
  google.maps.event.addListener(map, 
                                "mousemove", 
                                function(event) {
                                                 var proj = map.getProjection();
                                                 var point = proj.fromLatLngToPoint(event.latLng);

                                                 document.getElementById('eventsMapX').value = point.x; 
                                                 document.getElementById('eventsMapY').value = point.y; 
                                                 document.getElementById('eventsMapLat').value = event.latLng.lat(); 
                                                 document.getElementById('eventsMapLng').value = event.latLng.lng(); 
                                                 document.getElementById('eventsMapMouseMove').value = "1";
                                                 document.getElementById('eventsMapEventFired').value = "1"; 
                                                }
                               );
  google.maps.event.addListener(map, 
                                "mouseout", 
                                function(event) { 
                                                  var proj = map.getProjection();
                                                  var point = proj.fromLatLngToPoint(event.latLng);

                                                 document.getElementById('eventsMapX').value = point.x; 
                                                 document.getElementById('eventsMapY').value = point.y; 
                                                 document.getElementById('eventsMapLat').value = event.latLng.lat(); 
                                                 document.getElementById('eventsMapLng').value = event.latLng.lng(); 
                                                 document.getElementById('eventsMapMouseOut').value = "1";
                                                 document.getElementById('eventsMapEventFired').value = "1"; 
                                                }
                               ); 
  google.maps.event.addListener(map, 
                                "mouseover", 
                                function(event) { 
                                                  var proj = map.getProjection();
                                                  var point = proj.fromLatLngToPoint(event.latLng);

                                                 document.getElementById('eventsMapX').value = point.x; 
                                                 document.getElementById('eventsMapY').value = point.y; 
                                                 document.getElementById('eventsMapLat').value = event.latLng.lat(); 
                                                 document.getElementById('eventsMapLng').value = event.latLng.lng(); 
                                                 document.getElementById('eventsMapMouseOver').value = "1";
                                                 document.getElementById('eventsMapEventFired').value = "1"; 
                                                }
                               ); 
  google.maps.event.addListener(map, 
                                "tilesloaded", 
                                function() { 
                                             document.getElementById('eventsMapTilesLoaded').value = "1"; 
                                             document.getElementById('eventsMapEventFired').value = "1"; 
                                           }
                               ); 
  google.maps.event.addListener(map, 
                                "zoom_changed", 
                                function() { 
                                             document.getElementById('eventsMapZoom').value = map.getZoom(); 
                                             document.getElementById('eventsMapZoomChanged').value = "1"; 
                                             document.getElementById('eventsMapEventFired').value = "1"; 
                                           }
                               ); 
}

/* **********************************
  this function establish MapOptions object used to define the properties that can be set on a Map. 
********************************** */
function setMapOptions(BackgroundColor, 
                       Lat,                              // --> Center
                       Lng,                              // --> Center
                       NoWrap,                           // --> Center
                       ClickableIcons,
                       DisableDoubleClickZoom,
                       DraggableCursor,
                       DraggingCursor,
                       FullscreenControl,
                       FullscreenControlOptionsPosition, // --> fullscreenControlOptions
                       GestureHandling,
                       Heading,
                       IsFractionalZoomEnabled,
                       KeyboardShortcuts,
                       MapTypeControl,
                       MapTypeControlOptionsMapTypeIds,  // --> mapTypeControlOptions
                       MapTypeControlOptionsPosition,    // --> mapTypeControlOptions
                       MapTypeControlOptionsStyle,       // --> mapTypeControlOptions
                       MapTypeId,
                       MaxZoom,
                       MinZoom,
                       NoClear,
                       RestrictionSwLat,                 // --> restriction
                       RestrictionSwLng,                 // --> restriction
                       RestrictionNeLat,                 // --> restriction
                       RestrictionNeLng,                 // --> restriction
                       RestrictionStrictBounds,          // --> restriction
                       RestrictionEnabled,               // --> restriction
                       RotateControl,
                       RotateControlOptionsPosition,     // --> rotateControlOptions
                       ScaleControl, 
                       ScaleControlOptionsStyle,         // --> scaleControlOptions
                       StreetViewControl,
                       StreetViewControlOptionsPosition, // --> streetViewControlOptions
                       Tilt,
                       Zoom,
                       ZoomControl,
                       ZoomControlOptionsPosition        // --> zoomControlOptions
                       ) {
  FullscreenControlOptionsPosition = StrToPosition(FullscreenControlOptionsPosition); 
  GestureHandling = StrToGestureHandling(GestureHandling); 
  MapTypeControlOptionsMapTypeIds = MapTypeControlOptionsMapTypeIds.split(";"); 
  for (i = 0; i < MapTypeControlOptionsMapTypeIds.length; i++) { 
    MapTypeControlOptionsMapTypeIds[i] = StrToMapTypeId(MapTypeControlOptionsMapTypeIds[i]);
  };
  MapTypeId = StrToMapTypeId(MapTypeId);
  MapTypeControlOptionsPosition = StrToPosition(MapTypeControlOptionsPosition); 
  MapTypeControlOptionsStyle = StrToMapTypeControlStyle(MapTypeControlOptionsStyle);
  RotateControlOptionsPosition = StrToPosition(RotateControlOptionsPosition); 
  ScaleControlOptionsStyle = StrToScaleControlStyle(ScaleControlOptionsStyle);
  ZoomControlOptionsPosition = StrToPosition(ZoomControlOptionsPosition); 
  StreetViewControlOptionsPosition = StrToPosition(StreetViewControlOptionsPosition); 
  Restriction = null;
  if (RestrictionEnabled) {
    Restriction = {
                    latLngBounds: new google.maps.LatLngBounds(
                                                                new google.maps.LatLng(RestrictionSwLat, RestrictionSwLng), 
                                                                new google.maps.LatLng(RestrictionNeLat, RestrictionNeLng)
                                                              ),
                    strictBounds: RestrictionStrictBounds
                  }
  }
  mapOptions = {
                    backgroundColor: BackgroundColor,
                    center: new google.maps.LatLng(Lat, Lng, NoWrap),
                    clickableIcons: ClickableIcons,
                    //controlSize: --> not coded
                    //disableDefaultUI: --> not coded
                    disableDoubleClickZoom: DisableDoubleClickZoom,
                    //draggable: --> deprecated, not coded
                    draggableCursor: DraggableCursor,
                    draggingCursor: DraggingCursor,
                    fullscreenControl: FullscreenControl,
                    fullscreenControlOptions: {
                                               position: FullscreenControlOptionsPosition
                                              },
                    gestureHandling: GestureHandling,
                    heading: Heading,
                    isFractionalZoomEnabled: IsFractionalZoomEnabled,
                    keyboardShortcuts: KeyboardShortcuts,
                    //mapId: --> not coded 
                    mapTypeControl: MapTypeControl,
                    mapTypeControlOptions: {
                                            mapTypeIds: MapTypeControlOptionsMapTypeIds,
                                            position: MapTypeControlOptionsPosition,
                                            style: MapTypeControlOptionsStyle
                                           },
                    mapTypeId: MapTypeId,
                    maxZoom: MaxZoom,
                    minZoom: MinZoom,
                    noClear: NoClear,
                    restriction: Restriction,
                    rotateControl: RotateControl,
                    rotateControlOptions: {
                                           position: RotateControlOptionsPosition
                                          },
                    scaleControl: ScaleControl,
                    scaleControlOptions: {
                                          style: ScaleControlOptionsStyle
                                         },
                    //scrollwheel: --> not recommended, use gestureHandling instead
                    //streetView:  --> to code
                    streetViewControl: StreetViewControl,
                    streetViewControlOptions: {
                                               position: StreetViewControlOptionsPosition
                                              },
                    //styles: --> to code
                    tilt: Tilt,
                    zoom: Zoom,
                    zoomControl: ZoomControl,
                    zoomControlOptions: {
                                         position: ZoomControlOptionsPosition
                                        }
                   };
  if (map != null) {                  
    map.setOptions(mapOptions);  
  }
}

/* **********************************
  this function update layers.
********************************** */
function ShowLayers(TrafficShow,                // --> trafficLayer
                    TrafficAutoRefresh,         // --> trafficLayer
                    TransitShow,                // --> transitLayer
                    BicyclingShow,              // --> bicyclingLayer
                    KmlShow,                    // --> KmlLayer
                    KmlClickable,               // --> KmlLayer
                    KmlPreserveViewport,        // --> KmlLayer
                    KmlScreenOverlays,          // --> KmlLayer
                    KmlSuppressInfoWindows,     // --> KmlLayer
                    KmlUrl                      // --> KmlLayer
                   ) {
  // traffic layer
  var trafficOpts = {
                     autoRefresh: TrafficAutoRefresh
                    };
         
  if (trafficLayer == null)                   
    trafficLayer = new google.maps.TrafficLayer(trafficOpts);
  else 
    trafficLayer.setOptions(trafficOpts);
  
  if (TrafficShow) trafficLayer.setMap(map);
  else trafficLayer.setMap(null);

  // transit layer 
  if (transitLayer == null)                   
    transitLayer = new google.maps.TransitLayer();
  
  if (TransitShow) transitLayer.setMap(map);
  else transitLayer.setMap(null);

  // bicycling layer 
  if (bicyclingLayer == null)                   
    bicyclingLayer = new google.maps.BicyclingLayer();
  
  if (BicyclingShow) bicyclingLayer.setMap(map);
  else bicyclingLayer.setMap(null);
  
  // kml layer
  var kmlOpts = {
                 clickable: KmlClickable,
                 preserveViewport: KmlPreserveViewport,
                 screenOverlays: KmlScreenOverlays,
                 suppressInfoWindows: KmlSuppressInfoWindows,
                 url: KmlUrl
                }
  if (KmlUrl == '') 
    KmlShow = false;

  if (kmlLayer == null) 
    kmlLayer = new google.maps.KmlLayer(kmlOpts);
  else 
    kmlLayer.setOptions(kmlOpts);
  
  if (KmlShow) kmlLayer.setMap(map);
  else kmlLayer.setMap(null);
}

/* **********************************
  this function initialize eventsMap form.
********************************** */
function iniEventsMapForm() {
  document.getElementById('eventsMapEventFired').value = "0"; 
  document.getElementById('eventsMapLat').value = "0"; 
  document.getElementById('eventsMapLng').value = "0"; 
  document.getElementById('eventsMapX').value = "0"; 
  document.getElementById('eventsMapY').value = "0"; 
  document.getElementById('eventsMapCenterChange').value = "0"; 
  document.getElementById('eventsMapClick').value = "0"; 
  document.getElementById('eventsMapContextmenu').value = "0"; 
  document.getElementById('eventsMapDblclick').value = "0"; 
  document.getElementById('eventsMapMouseMove').value = "0"; 
  document.getElementById('eventsMapMouseOut').value = "0"; 
  document.getElementById('eventsMapMouseOver').value = "0"; 
  document.getElementById('eventsMapDrag').value = "0"; 
  document.getElementById('eventsMapDragEnd').value = "0"; 
  document.getElementById('eventsMapDragStart').value = "0"; 
  document.getElementById('eventsMapMapTypeId').value = "0"; 
  document.getElementById('eventsMapMapTypeId_changed').value = "0"; 
  document.getElementById('eventsMapTilesLoaded').value = "0"; 
  document.getElementById('eventsMapSwLat').value = "0"; 
  document.getElementById('eventsMapSwLng').value = "0"; 
  document.getElementById('eventsMapNeLat').value = "0"; 
  document.getElementById('eventsMapNeLng').value = "0"; 
  document.getElementById('eventsMapBoundsChange').value = "0"; 
  document.getElementById('eventsMapZoom').value = "0"; 
  document.getElementById('eventsMapZoomChanged').value = "0"; 
}
     @   
 R E S _ T R A N S F O R M C O D E       0 
        /* ----------------------------------------------------------------------------------
   Functions JavaScript to Delphi 
---------------------------------------------------------------------------------- */
/* **********************************
  this function transforms a Google Maps ControlPosition to a string ControlPosition. 
********************************** */
function PositionToStr(Value) { 
  switch (Value) { 
    case google.maps.ControlPosition.BOTTOM_CENTER: return "cpBOTTOM_CENTER"; break; 
    case google.maps.ControlPosition.BOTTOM_LEFT: return "cpBOTTOM_LEFT"; break; 
    case google.maps.ControlPosition.BOTTOM_RIGHT: return "cpBOTTOM_RIGHT"; break; 
    case google.maps.ControlPosition.LEFT_BOTTOM: return "cpLEFT_BOTTOM"; break; 
    case google.maps.ControlPosition.LEFT_CENTER: return "cpLEFT_CENTER"; break; 
    case google.maps.ControlPosition.LEFT_TOP: return "cpLEFT_TOP"; break; 
    case google.maps.ControlPosition.RIGHT_BOTTOM: return "cpRIGHT_BOTTOM"; break; 
    case google.maps.ControlPosition.RIGHT_CENTER: return "cpRIGHT_CENTER"; break; 
    case google.maps.ControlPosition.RIGHT_TOP: return "cpRIGHT_TOP"; break; 
    case google.maps.ControlPosition.TOP_CENTER: return "cpTOP_CENTER"; break; 
    case google.maps.ControlPosition.TOP_LEFT: return "cpTOP_LEFT"; break; 
    case google.maps.ControlPosition.TOP_RIGHT: return "cpTOP_RIGHT"; break; 
    default: return "cpTOP_RIGHT"; 
  } 
} 

/* **********************************
  this function transforms a Google Maps GestureHandling to a string GestureHandling. 
********************************** */
function GestureHandlingToStr(Value) {
  switch (Value) { 
    case "cooperative": return "ghCooperative"; break; 
    case "greedy": return "ghGreedy"; break; 
    case "none": return "ghNone"; break; 
    case "auto": return "ghAuto"; break; 
    default: return "ghAuto"; 
  } 
}

/* **********************************
  this function transforms a Google Maps MapTypeId to a string MapTypeId. 
********************************** */
function MapTypeIdToStr(Value) { 
  switch (Value) { 
    case google.maps.MapTypeId.HYBRID: return "mtHYBRID"; break; 
    case google.maps.MapTypeId.ROADMAP: return "mtROADMAP"; break; 
    case google.maps.MapTypeId.SATELLITE: return "mtSATELLITE"; break; 
    case google.maps.MapTypeId.TERRAIN: return "mtTERRAIN"; break; 
    default: return ""; 
  } 
} 

/* **********************************
  this function transforms a Google Maps MapTypeControlStyle to a string MapTypeControlStyle. 
********************************** */
function MapTypeControlStyleToStr(Value) { 
  switch (Value) { 
    case google.maps.MapTypeControlStyle.DEFAULT: return "mtcDEFAULT"; break; 
    case google.maps.MapTypeControlStyle.DROPDOWN_MENU: return "mtcDROPDOWN_MENU"; break; 
    case google.maps.MapTypeControlStyle.HORIZONTAL_BAR: return "mtcHORIZONTAL_BAR"; break; 
    default: return ""; 
  } 
} 

/* **********************************
  this function transforms a Google Maps ScaleControlStyle to a string ScaleControlStyle. 
********************************** */
function ScaleControlStyleToStr(Value) { 
  switch (Value) { 
    case google.maps.ScaleControlStyle.DEFAULT: return "scsDEFAULT"; break; 
    default: return "scsDEFAULT"; 
  } 
} 


/* ----------------------------------------------------------------------------------
   Functions Delphi to JavaScript
---------------------------------------------------------------------------------- */
/* **********************************
  this function transforms a string ControlPosition to a Google Maps ControlPosition. 
********************************** */
function StrToPosition(Value) { 
  switch (Value) { 
    case "cpBOTTOM_CENTER": return google.maps.ControlPosition.BOTTOM_CENTER; break; 
    case "cpBOTTOM_LEFT": return google.maps.ControlPosition.BOTTOM_LEFT; break; 
    case "cpBOTTOM_RIGHT": return google.maps.ControlPosition.BOTTOM_RIGHT; break; 
    case "cpLEFT_BOTTOM": return google.maps.ControlPosition.LEFT_BOTTOM; break; 
    case "cpLEFT_CENTER": return google.maps.ControlPosition.LEFT_CENTER; break; 
    case "cpLEFT_TOP": return google.maps.ControlPosition.LEFT_TOP; break; 
    case "cpRIGHT_BOTTOM": return google.maps.ControlPosition.RIGHT_BOTTOM; break; 
    case "cpRIGHT_CENTER": return google.maps.ControlPosition.RIGHT_CENTER; break; 
    case "cpRIGHT_TOP": return google.maps.ControlPosition.RIGHT_TOP; break; 
    case "cpTOP_CENTER": return google.maps.ControlPosition.TOP_CENTER; break; 
    case "cpTOP_LEFT": return google.maps.ControlPosition.TOP_LEFT; break; 
    case "cpTOP_RIGHT": return google.maps.ControlPosition.TOP_RIGHT; break; 
    default: return google.maps.ControlPosition.TOP_RIGHT; 
  } 
} 

/* **********************************
  this function transforms a string GestureHandling to a Google Maps GestureHandling. 
********************************** */
function StrToGestureHandling(Value) {
  switch (Value) { 
    case "ghCooperative": return "cooperative"; break; 
    case "ghGreedy": return "greedy"; break; 
    case "ghNone": return "none"; break; 
    case "ghAuto": return "auto"; break; 
    default: return "auto"; 
  } 
}

/* **********************************
  this function transforms a string MapTypeId to a Google Maps MapTypeId. 
********************************** */
  function StrToMapTypeId(Value) { 
    switch (Value) { 
      case "mtHYBRID": return google.maps.MapTypeId.HYBRID; break; 
      case "mtROADMAP": return google.maps.MapTypeId.ROADMAP; break; 
      case "mtSATELLITE": return google.maps.MapTypeId.SATELLITE; break; 
      default: return google.maps.MapTypeId.TERRAIN; 
    } 
  } 

/* **********************************
  this function transforms a string MapTypeControlStyle to a Google Maps MapTypeControlStyle. 
********************************** */
  function StrToMapTypeControlStyle(Value) { 
    switch (Value) { 
      case "mtcDEFAULT": return google.maps.MapTypeControlStyle.DEFAULT; break; 
      case "mtcDROPDOWN_MENU": return google.maps.MapTypeControlStyle.DROPDOWN_MENU; break; 
      case "mtcHORIZONTAL_BAR": return google.maps.MapTypeControlStyle.HORIZONTAL_BAR; break; 
      default: return google.maps.MapTypeControlStyle.DEFAULT; 
    } 
  } 
 
/* **********************************
  this function transforms a string ScaleControlStyle to a Google Maps ScaleControlStyle. 
********************************** */
  function StrToScaleControlStyle(Value) { 
    switch (Value) { 
      case "scsDEFAULT": return google.maps.ScaleControlStyle.DEFAULT; break; 
      default: return google.maps.ScaleControlStyle.DEFAULT; 
    } 
  } 

