# Google Maps Library v2

Google Maps Library is an open source library that encapsulates the Google Maps API. Compatible with TEdgeBrowser (RADStudio 11 and later) and TChromium (CEF4Delphi by Salvador Díaz Fau) it is compiled in RAD Studio 11 (Delphi and C++).

It can be compiled in earlier versions, but only maintaining compatibility with TChromium.

For more information about CEF4Delphi see [this link](https://github.com/salvadordf/CEF4Delphi).

Help file generated with [PasDoc](https://github.com/pasdoc/pasdoc/) by Michalis Kamburelis

GMLib was developed and tested on Delphi 11.1 but (theoretically) you can compile it in previous versions that include generics and the new Json units.

GMLib demos have been tested in Windows 10 and Windows 11.

Don't use master branch, it's the developpement branch and perhaps there are errors. Use instead [released packages](https://github.com/cadetill/gmlib_v2/releases)

## What part of the Google Maps API is implemented?

The following Google Maps API classes are currently implemented

- [google.maps.Map](https://developers.google.com/maps/documentation/javascript/reference/map) and associated classes to display a map
- All basic layers
    - [google.maps.TrafficLayer](https://developers.google.com/maps/documentation/javascript/reference/map#TrafficLayer)
    - [google.maps.TransitLayer](https://developers.google.com/maps/documentation/javascript/reference/map#TransitLayer)
    - [google.maps.BicyclingLayer](https://developers.google.com/maps/documentation/javascript/reference/map#BicyclingLayer)
    - [google.maps.KmlLayer](https://developers.google.com/maps/documentation/javascript/reference/kml)

## TODO list or road map

- Markers (in progress)
- Polygons
- Geocoder
- Directions
- Elevation
- Heatmaps

## Do you find a bug?

Please, open an [issue](https://github.com/cadetill/gmlib_v2/issues)

## Do you need some feature?

Please, open an [issue](https://github.com/cadetill/gmlib_v2/issues)

## Links

* [Help file](http://htmlpreview.github.io/?https://github.com/cadetill/gmlib_v2/master/Help/HTML/index.html)
* [CEF4Delphi](https://github.com/salvadordf/CEF4Delphi)
* [PasDoc](https://github.com/pasdoc/pasdoc/)
* [jsontodelphi](https://jsontodelphi.com/)