/**
* @project Console Art Cybernetic - https://cacybernetic.github.io
* @fileoverview Defines language textuals data.
* @author Obrymec - obrymecsprinces@gmail.com
* @supported DESKTOP, MOBILE
* @created 2023-08-26
* @updated 2023-09-28
* @file french.js
* @version 0.0.2
* @type {French}
*/

/**
 * @description The french language's
 *  data.
 * @constant {{
 *  data: Object<String, String>,
 *  keywords: Array<String>,
 *  name: String
 * }}
 * @public
 * @field
 */
const french = {
  name: "french",
  keywords: [
    "français",
    "france",
    "québec",
    "europe",
    "europa",
    "fr",
    "qc"
  ],
  data: {
    tr1: "Pourquoi GitLab",
    tr2: "Plate-forme",
    tr3: "Solutions",
    tr4: "Tarifs",
    tr5: "Ressources",
    tr6: "Entreprise",
    tr7: "Contact",
    tr8: "Connexion",
    tr9: "Essai gratuit",
    tr10: `
      Découvrez GitLab Duo: Des 
      workflows basés sur l'IA →
    `,
    tr11: "Logiciel. Rapide.",
    tr12: "GitLab est le plus complet",
    tr13: `
      Plate-forme DevSecOps alimentée 
      par l'IA.
    `,
    tr14: "Qu'est-ce que GitLab ?",
    tr15: "Approuvé par",
    tr16: "Démarrez avec GitLab",
    tr17: "Explorer les ressources",
    tr18: `
      Nouveau sur GitLab et vous ne 
      savez pas par où commencer ? 
      Nous allons vous parlez des 
      bases pour que vous sachiez 
      à quoi vous attendre en 
      cours de route.
    `,
    tr19: `
      Le Forrester Wave™: Un logiciel 
      intégré de livraison de services, 
      Q2 2023
    `,
    tr20: `
      GitLab est le seul leader 
      dans le rapport qui compare 
      13 fournisseurs sur 26 
      critères.
    `,
    tr21: "Lire le rapport",
    tr22: `
      GitLab assisté par l'IA, 
      Suggestions de codes
    `,
    tr23: `
      Réduire la charge cognitive et 
      accroître l'efficacité avec 
      l'aide de l'IA générative 
      qui suggère du code au fur 
      et à mesure que vous tapez.
    `,
    tr24: "En savoir plus",
    tr25: `
      Lockheed Martin gagne du temps, 
      l'argent et la technologie 
      avec GitLab
    `,
    tr26: "Lire la suite",
    tr27: "Alan Hohn",
    tr28: `
      constructions de pipeline 
      CI plus rapides
    `,
    tr29 : `
      Directeur de la Stratégie 
      Logicielle
    `,
    tr30: "Lockheed Martin",
    tr31: `
      de moins de temps passé sur 
      l'entretien du système
    `,
    tr32: `
      En passant à GitLab et 
      automatisation du déploiement, 
      des équipes avez déménagé du 
      mensuel ou livraisons hebdomadaires 
      à quotidiennes ou plusieurs 
      livraisons quotidiennes.
    `,
    tr33: "Jason Monoharan",
    tr34: "heures",
    tr35: `
      approximatives d'économies 
      par an
    `,
    tr36: "VP de la technologie",
    tr37: "Iron Mountain",
    tr38: `
      économisé en temps d'intégration 
      par projet
    `,
    tr39: `
      La vision qu'a GitLab en termes de 
      stratégie de vente liée à la portée 
      et le code est très puissant. je 
      suis reconnaissant pour le niveau 
      d'investissement qu'ils ont 
      continuer à faire sur la 
      plate-forme.
    `,
    tr40: "Evan O'Connor",
    tr41: `
      des utilisateurs mensuels ont 
      sécurisés le secret des 
      travaux du scanner
    `,
    tr42: `
      Responsable de l'ingénierie 
      de la plate-forme
    `,
    tr43: "Haven Technologies",
    tr44: `
      des utilisateurs mensuels 
      ont utilisé le secret des 
      travaux de détection
    `,
    tr45: `
      L'engagement de GitLab en faveur 
      d'un environnement ouvert à la 
      communauté source signifierait qu'on 
      pourrait s'engager directement avec 
      des ingénieurs pour travailler sur 
      les problèmes difficile. 
    `,
    tr46: "millions",
    tr47: "Rick Carey",
    tr48: "Utilisateurs actifs de GitLab",
    tr49: `
      Directeur de Group Technology 
      Officer
    `,
    tr50: "UBS",
    tr51: `
      des premières constructions 
      réussites en six mois
    `,
    tr52: `
      Nous avons une expression à l'UBS, 
      Tous les développeurs attendent au 
      même vitesse, donc tout ce que nous 
      peuvont faire pour réduire leur 
      temps attente est une valeur 
      ajoutée. Et GitLab nous permet 
      d'avoir l'expérience intégrée.
    `,
    tr53: "Regardez la vidéo",
    tr54: "Lakshmi Venkatraman",
    tr55: "Chef de projet",
    tr56: "Singleron Biotechnologies",
    tr57: `
      GitLab nous permet de collaborer 
      très bien avec les membres de 
      l'équipe et entre différentes 
      équipes. Comme un chef de projet, 
      étant capable de suivre un projet 
      ou la charge de travail d'un membre 
      de l'équipe aide à prévenir un projet 
      des retards. Quand le projet est 
      terminé, nous pouvons facilement 
      automatiser un processus d'emballage 
      et renvoyer les résultats au client. 
      Et avec GitLab, tous résident dans 
      une seule maison.
    `,
    tr58: `
      La façon dont DevSecOps 
      devrait être
    `,
    tr59: `
      Accélérez votre transformation 
      digital
    `,
    tr60: `
      Atteignez les objectifs de votre 
      transformation numérique le plus 
      rapidement que possible avec une 
      plate-forme DevSecOps pour 
      l'ensemble de votre 
      organisation.
    `,
    tr61: `
      Livrer les logiciels plus 
      rapidement
    `,
    tr62: `
      Automatisez le processus de livraison 
      de vos logiciels afin que vous 
      puissiez apporter de la valeur 
      au code.
    `,
    tr63: "Assurer la conformité",
    tr64: `
      Simplifiez la conformité des 
      logiciels tout en définissant, 
      en appliquant et rendre compte 
      sur une seule plate-forme.
    `,
    tr65: "Construire la sécurité",
    tr66: `
      Adoptez les pratiques DevSecOps 
      avec une sécurité logicielle 
      continue à chaque étape.
    `,
    tr67: `
      Améliorer la collaboration 
      et la visibilité
    `,
    tr68: `
      Donnez à chacun, une plate-forme 
      pour collaborer et tout voir 
      de la planification à la 
      production.
    `,
    tr69: `
      GitLab est la plate-forme 
      DevSecOps
    `,
    tr70: "Leaders du DevSecOps",
    tr71: "Recherche d'analystes industriels",
    tr72: "Nos utilisateurs ont parlé.",
    tr73: `
      GitLab se classe parmi les 
      G2 Leader dans l'ensemble 
      des catégories du DevSecOps
    `,
    tr74: "Par utilisateur/mois",
    tr75: "Tarifs",
    tr76: "Gratuit",
    tr77: "Premium",
    tr78: "Ultime",
    tr79: "Fonctionnalités gratuites",
    tr80: "Commencer",
    tr81: `
      Caractéristiques essentielles 
      pour les utilisateurs individuels
    `,
    tr82: "Aucune carte de crédit requise",
    tr83: "5Go de stockage",
    tr84: "Transfert de 10Go par mois",
    tr85: "400 minutes de calcul par mois",
    tr86: `
      5 utilisateurs par groupe de 
      niveau supérieur
    `,
    tr87: "Tout depuis Free, plus",
    tr88: "Achetez GitLab Premium",
    tr89: "Facturé annuellement à $348 USD",
    tr90: "Premium",
    tr91: `
      Améliorer la productivité 
      des équipes et coordination
    `,
    tr92: `
      Propriété du code et 
      Branches protégées
    `,
    tr93: `
      Fusionner les demandes avec 
      Règles d'approbation
    `,
    tr94: "Planification agile d'entreprise",
    tr95: "CI/CD avancé",
    tr96: `
      Utilisateur d'entreprise et 
      la gestion des incidents
    `,
    tr97: "Aide",
    tr98: "50Go de stockage",
    tr99: "Transfert de 100Go par mois",
    tr100: `
      10 000 minutes de calcul
      par mois
    `,
    tr101: `
      Tout depuis Premium, plus
    `,
    tr102: "Achetez GitLab Ultimate",
    tr103: `
      Facturé annuellement à $1188 USD
    `,
    tr104: "Ultime",
    tr105: `
      Sécurité à l'échelle de l'organisation, 
      conformité et planification
    `,
    tr106: "Réviseurs suggérés",
    tr107: `
      Application dynamique de
      tests de sécurité
    `,
    tr108: "Tableaux de bord de sécurité",
    tr109: "Gestion des vulnérabilités",
    tr110: "Analyse des dépendances",
    tr111: "Analyse des conteneurs",
    tr112: `
      Tests de sécurité des applications 
      statiques
    `,
    tr113: "Épopées multi-niveaux",
    tr114: "Gestion des flux de valeur",
    tr115: "250Go de stockage",
    tr116: "Transfert de 500Go par mois",
    tr117: `
      50 000 minutes de calcul par mois
    `,
    tr118: "Utilisateurs invités gratuits",
    tr119: "Ressources",
    tr120: "Afficher toutes les ressources",
    tr121: "Livre électronique",
    tr122: "Guide du débutant sur DevOps",
    tr123: "Qu'est-ce que CI/CD?",
    tr124: "Sujets",
    tr125: `
      DevSecOps mondial 2023,
      série de rapports
    `,
    tr126: "Rapport",
    tr127: `
      AI/ML dans la série DevSecOps
    `,
    tr128: "Article de blog",
    tr129: `
      Découvrez les avantages 
      de GitLab sur AWS
    `,
    tr130: "Partenaires",
    tr131: `
      GitLab 16.1 publié avec une 
      toute nouvelle navigation
    `,
    tr132: "Libérer",
    tr133: "Essayez GitLab",
    tr134: `
      Découvrez ce que votre équipe 
      pourrait faire avec la 
      plate-forme DevSecOps.
    `,
    tr135: `
      Avez-vous des questions? Nous 
      somme ici pour aider.
    `,
    tr136: "Parler à un expert",
    tr137: "Plate-forme DevSecOps",
    tr138: "Voir les plans",
    tr139: "Pourquoi premium?",
    tr140: "Pourquoi Ultime?",
    tr141: "Transformation numérique",
    tr142: "Sécurité et conformité",
    tr143: `
      Livraison automatisée de 
      logiciels
    `,
    tr144: "Développement agile",
    tr145: "Transformation cloud",
    tr146: "SCM",
    tr147: "CI/CD",
    tr148: "Gestion des flux de valeur",
    tr149: "GitOps",
    tr150: "Entreprise",
    tr151: "Petite entreprise",
    tr152: "Secteur public",
    tr153: "Éducation",
    tr154: "Services financiers",
    tr155: "Installation",
    tr156: `
      Listes de contrôle de 
      configuration rapide
    `,
    tr157: "Apprendre",
    tr158: "Documents",
    tr159: "Blogs",
    tr160: "Témoignages de clients",
    tr161: "À distance",
    tr162: "ÉquipeOps",
    tr163: "Communauté",
    tr164: "Forum",
    tr165: "Événements",
    tr166: "Partenaires",
    tr167: "À propos",
    tr168: "Emplois",
    tr169: "Leadership",
    tr170: "Équipe",
    tr171: "Manuel",
    tr172: "Relations investisseurs",
    tr173: "Centre de confiance",
    tr174: "Newsletter",
    tr175: "Appuyez",
    tr176: "Contacter un expert",
    tr177: "Obtenir de l'aide",
    tr178: "Portail client",
    tr179: "Statut",
    tr180: "Conditions d'utilisation",
    tr181: `
      Déclaration de confidentialité
    `,
    tr182: `
      Préférences en matière de cookies
    `,
    tr183: "Langue",
    tr184: `
      Git est une marque commerciale 
      de Software Freedom Conservancy 
      et notre utilisation de 'GitLab' 
      est sous Licence
    `,
    tr185: "Voir",
    tr186: "source de la page",
    tr187: "Modifier cette page",
    tr188: "veuillez contribuer.",
    tr189: `
      Vous êtes maintenant connecté 
      à Internet.
    `,
    tr190: `
      Vous n'êtes pas connecté à Internet. 
      Vérifiez votre câble réseau ou 
      modem et assurez-vous que vous 
      êtes connecté à l'Internet.
    `
  }
}

/**
 * @description Exports this
 *  field by default.
 * @exports french
 */
export default french;
