pub(crate) const OK: u8 = 0b0000_0000;
pub(crate) const END_OF_STRING: u8 = 0b0000_0001;
pub(crate) const DECODED: u8 = 0b0000_0010;
pub(crate) const CONTINUE: u8 = 0b0000_0011;
pub(crate) const ERROR: u8 = 0b0000_0100;

pub(crate) const DECODE_TABLE: &[[(u8, u8, u8); 16]; 256] = &[
  [
    (4, 0, OK),
    (5, 0, OK),
    (7, 0, OK),
    (8, 0, OK),
    (11, 0, OK),
    (12, 0, OK),
    (16, 0, OK),
    (19, 0, OK),
    (25, 0, OK),
    (28, 0, OK),
    (32, 0, OK),
    (35, 0, OK),
    (42, 0, OK),
    (49, 0, OK),
    (57, 0, OK),
    (64, 0, END_OF_STRING),
  ],
  [
    (0, 48, DECODED),
    (0, 49, DECODED),
    (0, 50, DECODED),
    (0, 97, DECODED),
    (0, 99, DECODED),
    (0, 101, DECODED),
    (0, 105, DECODED),
    (0, 111, DECODED),
    (0, 115, DECODED),
    (0, 116, DECODED),
    (13, 0, OK),
    (14, 0, OK),
    (17, 0, OK),
    (18, 0, OK),
    (20, 0, OK),
    (21, 0, OK),
  ],
  [
    (1, 48, DECODED),
    (22, 48, CONTINUE),
    (1, 49, DECODED),
    (22, 49, CONTINUE),
    (1, 50, DECODED),
    (22, 50, CONTINUE),
    (1, 97, DECODED),
    (22, 97, CONTINUE),
    (1, 99, DECODED),
    (22, 99, CONTINUE),
    (1, 101, DECODED),
    (22, 101, CONTINUE),
    (1, 105, DECODED),
    (22, 105, CONTINUE),
    (1, 111, DECODED),
    (22, 111, CONTINUE),
  ],
  [
    (2, 48, DECODED),
    (9, 48, DECODED),
    (23, 48, DECODED),
    (40, 48, CONTINUE),
    (2, 49, DECODED),
    (9, 49, DECODED),
    (23, 49, DECODED),
    (40, 49, CONTINUE),
    (2, 50, DECODED),
    (9, 50, DECODED),
    (23, 50, DECODED),
    (40, 50, CONTINUE),
    (2, 97, DECODED),
    (9, 97, DECODED),
    (23, 97, DECODED),
    (40, 97, CONTINUE),
  ],
  [
    (3, 48, DECODED),
    (6, 48, DECODED),
    (10, 48, DECODED),
    (15, 48, DECODED),
    (24, 48, DECODED),
    (31, 48, DECODED),
    (41, 48, DECODED),
    (56, 48, CONTINUE),
    (3, 49, DECODED),
    (6, 49, DECODED),
    (10, 49, DECODED),
    (15, 49, DECODED),
    (24, 49, DECODED),
    (31, 49, DECODED),
    (41, 49, DECODED),
    (56, 49, CONTINUE),
  ],
  [
    (3, 50, DECODED),
    (6, 50, DECODED),
    (10, 50, DECODED),
    (15, 50, DECODED),
    (24, 50, DECODED),
    (31, 50, DECODED),
    (41, 50, DECODED),
    (56, 50, CONTINUE),
    (3, 97, DECODED),
    (6, 97, DECODED),
    (10, 97, DECODED),
    (15, 97, DECODED),
    (24, 97, DECODED),
    (31, 97, DECODED),
    (41, 97, DECODED),
    (56, 97, CONTINUE),
  ],
  [
    (2, 99, DECODED),
    (9, 99, DECODED),
    (23, 99, DECODED),
    (40, 99, CONTINUE),
    (2, 101, DECODED),
    (9, 101, DECODED),
    (23, 101, DECODED),
    (40, 101, CONTINUE),
    (2, 105, DECODED),
    (9, 105, DECODED),
    (23, 105, DECODED),
    (40, 105, CONTINUE),
    (2, 111, DECODED),
    (9, 111, DECODED),
    (23, 111, DECODED),
    (40, 111, CONTINUE),
  ],
  [
    (3, 99, DECODED),
    (6, 99, DECODED),
    (10, 99, DECODED),
    (15, 99, DECODED),
    (24, 99, DECODED),
    (31, 99, DECODED),
    (41, 99, DECODED),
    (56, 99, CONTINUE),
    (3, 101, DECODED),
    (6, 101, DECODED),
    (10, 101, DECODED),
    (15, 101, DECODED),
    (24, 101, DECODED),
    (31, 101, DECODED),
    (41, 101, DECODED),
    (56, 101, CONTINUE),
  ],
  [
    (3, 105, DECODED),
    (6, 105, DECODED),
    (10, 105, DECODED),
    (15, 105, DECODED),
    (24, 105, DECODED),
    (31, 105, DECODED),
    (41, 105, DECODED),
    (56, 105, CONTINUE),
    (3, 111, DECODED),
    (6, 111, DECODED),
    (10, 111, DECODED),
    (15, 111, DECODED),
    (24, 111, DECODED),
    (31, 111, DECODED),
    (41, 111, DECODED),
    (56, 111, CONTINUE),
  ],
  [
    (1, 115, DECODED),
    (22, 115, CONTINUE),
    (1, 116, DECODED),
    (22, 116, CONTINUE),
    (0, 32, DECODED),
    (0, 37, DECODED),
    (0, 45, DECODED),
    (0, 46, DECODED),
    (0, 47, DECODED),
    (0, 51, DECODED),
    (0, 52, DECODED),
    (0, 53, DECODED),
    (0, 54, DECODED),
    (0, 55, DECODED),
    (0, 56, DECODED),
    (0, 57, DECODED),
  ],
  [
    (2, 115, DECODED),
    (9, 115, DECODED),
    (23, 115, DECODED),
    (40, 115, CONTINUE),
    (2, 116, DECODED),
    (9, 116, DECODED),
    (23, 116, DECODED),
    (40, 116, CONTINUE),
    (1, 32, DECODED),
    (22, 32, CONTINUE),
    (1, 37, DECODED),
    (22, 37, CONTINUE),
    (1, 45, DECODED),
    (22, 45, CONTINUE),
    (1, 46, DECODED),
    (22, 46, CONTINUE),
  ],
  [
    (3, 115, DECODED),
    (6, 115, DECODED),
    (10, 115, DECODED),
    (15, 115, DECODED),
    (24, 115, DECODED),
    (31, 115, DECODED),
    (41, 115, DECODED),
    (56, 115, CONTINUE),
    (3, 116, DECODED),
    (6, 116, DECODED),
    (10, 116, DECODED),
    (15, 116, DECODED),
    (24, 116, DECODED),
    (31, 116, DECODED),
    (41, 116, DECODED),
    (56, 116, CONTINUE),
  ],
  [
    (2, 32, DECODED),
    (9, 32, DECODED),
    (23, 32, DECODED),
    (40, 32, CONTINUE),
    (2, 37, DECODED),
    (9, 37, DECODED),
    (23, 37, DECODED),
    (40, 37, CONTINUE),
    (2, 45, DECODED),
    (9, 45, DECODED),
    (23, 45, DECODED),
    (40, 45, CONTINUE),
    (2, 46, DECODED),
    (9, 46, DECODED),
    (23, 46, DECODED),
    (40, 46, CONTINUE),
  ],
  [
    (3, 32, DECODED),
    (6, 32, DECODED),
    (10, 32, DECODED),
    (15, 32, DECODED),
    (24, 32, DECODED),
    (31, 32, DECODED),
    (41, 32, DECODED),
    (56, 32, CONTINUE),
    (3, 37, DECODED),
    (6, 37, DECODED),
    (10, 37, DECODED),
    (15, 37, DECODED),
    (24, 37, DECODED),
    (31, 37, DECODED),
    (41, 37, DECODED),
    (56, 37, CONTINUE),
  ],
  [
    (3, 45, DECODED),
    (6, 45, DECODED),
    (10, 45, DECODED),
    (15, 45, DECODED),
    (24, 45, DECODED),
    (31, 45, DECODED),
    (41, 45, DECODED),
    (56, 45, CONTINUE),
    (3, 46, DECODED),
    (6, 46, DECODED),
    (10, 46, DECODED),
    (15, 46, DECODED),
    (24, 46, DECODED),
    (31, 46, DECODED),
    (41, 46, DECODED),
    (56, 46, CONTINUE),
  ],
  [
    (1, 47, DECODED),
    (22, 47, CONTINUE),
    (1, 51, DECODED),
    (22, 51, CONTINUE),
    (1, 52, DECODED),
    (22, 52, CONTINUE),
    (1, 53, DECODED),
    (22, 53, CONTINUE),
    (1, 54, DECODED),
    (22, 54, CONTINUE),
    (1, 55, DECODED),
    (22, 55, CONTINUE),
    (1, 56, DECODED),
    (22, 56, CONTINUE),
    (1, 57, DECODED),
    (22, 57, CONTINUE),
  ],
  [
    (2, 47, DECODED),
    (9, 47, DECODED),
    (23, 47, DECODED),
    (40, 47, CONTINUE),
    (2, 51, DECODED),
    (9, 51, DECODED),
    (23, 51, DECODED),
    (40, 51, CONTINUE),
    (2, 52, DECODED),
    (9, 52, DECODED),
    (23, 52, DECODED),
    (40, 52, CONTINUE),
    (2, 53, DECODED),
    (9, 53, DECODED),
    (23, 53, DECODED),
    (40, 53, CONTINUE),
  ],
  [
    (3, 47, DECODED),
    (6, 47, DECODED),
    (10, 47, DECODED),
    (15, 47, DECODED),
    (24, 47, DECODED),
    (31, 47, DECODED),
    (41, 47, DECODED),
    (56, 47, CONTINUE),
    (3, 51, DECODED),
    (6, 51, DECODED),
    (10, 51, DECODED),
    (15, 51, DECODED),
    (24, 51, DECODED),
    (31, 51, DECODED),
    (41, 51, DECODED),
    (56, 51, CONTINUE),
  ],
  [
    (3, 52, DECODED),
    (6, 52, DECODED),
    (10, 52, DECODED),
    (15, 52, DECODED),
    (24, 52, DECODED),
    (31, 52, DECODED),
    (41, 52, DECODED),
    (56, 52, CONTINUE),
    (3, 53, DECODED),
    (6, 53, DECODED),
    (10, 53, DECODED),
    (15, 53, DECODED),
    (24, 53, DECODED),
    (31, 53, DECODED),
    (41, 53, DECODED),
    (56, 53, CONTINUE),
  ],
  [
    (2, 54, DECODED),
    (9, 54, DECODED),
    (23, 54, DECODED),
    (40, 54, CONTINUE),
    (2, 55, DECODED),
    (9, 55, DECODED),
    (23, 55, DECODED),
    (40, 55, CONTINUE),
    (2, 56, DECODED),
    (9, 56, DECODED),
    (23, 56, DECODED),
    (40, 56, CONTINUE),
    (2, 57, DECODED),
    (9, 57, DECODED),
    (23, 57, DECODED),
    (40, 57, CONTINUE),
  ],
  [
    (3, 54, DECODED),
    (6, 54, DECODED),
    (10, 54, DECODED),
    (15, 54, DECODED),
    (24, 54, DECODED),
    (31, 54, DECODED),
    (41, 54, DECODED),
    (56, 54, CONTINUE),
    (3, 55, DECODED),
    (6, 55, DECODED),
    (10, 55, DECODED),
    (15, 55, DECODED),
    (24, 55, DECODED),
    (31, 55, DECODED),
    (41, 55, DECODED),
    (56, 55, CONTINUE),
  ],
  [
    (3, 56, DECODED),
    (6, 56, DECODED),
    (10, 56, DECODED),
    (15, 56, DECODED),
    (24, 56, DECODED),
    (31, 56, DECODED),
    (41, 56, DECODED),
    (56, 56, CONTINUE),
    (3, 57, DECODED),
    (6, 57, DECODED),
    (10, 57, DECODED),
    (15, 57, DECODED),
    (24, 57, DECODED),
    (31, 57, DECODED),
    (41, 57, DECODED),
    (56, 57, CONTINUE),
  ],
  [
    (26, 0, OK),
    (27, 0, OK),
    (29, 0, OK),
    (30, 0, OK),
    (33, 0, OK),
    (34, 0, OK),
    (36, 0, OK),
    (37, 0, OK),
    (43, 0, OK),
    (46, 0, OK),
    (50, 0, OK),
    (53, 0, OK),
    (58, 0, OK),
    (61, 0, OK),
    (65, 0, OK),
    (68, 0, END_OF_STRING),
  ],
  [
    (0, 61, DECODED),
    (0, 65, DECODED),
    (0, 95, DECODED),
    (0, 98, DECODED),
    (0, 100, DECODED),
    (0, 102, DECODED),
    (0, 103, DECODED),
    (0, 104, DECODED),
    (0, 108, DECODED),
    (0, 109, DECODED),
    (0, 110, DECODED),
    (0, 112, DECODED),
    (0, 114, DECODED),
    (0, 117, DECODED),
    (38, 0, OK),
    (39, 0, OK),
  ],
  [
    (1, 61, DECODED),
    (22, 61, CONTINUE),
    (1, 65, DECODED),
    (22, 65, CONTINUE),
    (1, 95, DECODED),
    (22, 95, CONTINUE),
    (1, 98, DECODED),
    (22, 98, CONTINUE),
    (1, 100, DECODED),
    (22, 100, CONTINUE),
    (1, 102, DECODED),
    (22, 102, CONTINUE),
    (1, 103, DECODED),
    (22, 103, CONTINUE),
    (1, 104, DECODED),
    (22, 104, CONTINUE),
  ],
  [
    (2, 61, DECODED),
    (9, 61, DECODED),
    (23, 61, DECODED),
    (40, 61, CONTINUE),
    (2, 65, DECODED),
    (9, 65, DECODED),
    (23, 65, DECODED),
    (40, 65, CONTINUE),
    (2, 95, DECODED),
    (9, 95, DECODED),
    (23, 95, DECODED),
    (40, 95, CONTINUE),
    (2, 98, DECODED),
    (9, 98, DECODED),
    (23, 98, DECODED),
    (40, 98, CONTINUE),
  ],
  [
    (3, 61, DECODED),
    (6, 61, DECODED),
    (10, 61, DECODED),
    (15, 61, DECODED),
    (24, 61, DECODED),
    (31, 61, DECODED),
    (41, 61, DECODED),
    (56, 61, CONTINUE),
    (3, 65, DECODED),
    (6, 65, DECODED),
    (10, 65, DECODED),
    (15, 65, DECODED),
    (24, 65, DECODED),
    (31, 65, DECODED),
    (41, 65, DECODED),
    (56, 65, CONTINUE),
  ],
  [
    (3, 95, DECODED),
    (6, 95, DECODED),
    (10, 95, DECODED),
    (15, 95, DECODED),
    (24, 95, DECODED),
    (31, 95, DECODED),
    (41, 95, DECODED),
    (56, 95, CONTINUE),
    (3, 98, DECODED),
    (6, 98, DECODED),
    (10, 98, DECODED),
    (15, 98, DECODED),
    (24, 98, DECODED),
    (31, 98, DECODED),
    (41, 98, DECODED),
    (56, 98, CONTINUE),
  ],
  [
    (2, 100, DECODED),
    (9, 100, DECODED),
    (23, 100, DECODED),
    (40, 100, CONTINUE),
    (2, 102, DECODED),
    (9, 102, DECODED),
    (23, 102, DECODED),
    (40, 102, CONTINUE),
    (2, 103, DECODED),
    (9, 103, DECODED),
    (23, 103, DECODED),
    (40, 103, CONTINUE),
    (2, 104, DECODED),
    (9, 104, DECODED),
    (23, 104, DECODED),
    (40, 104, CONTINUE),
  ],
  [
    (3, 100, DECODED),
    (6, 100, DECODED),
    (10, 100, DECODED),
    (15, 100, DECODED),
    (24, 100, DECODED),
    (31, 100, DECODED),
    (41, 100, DECODED),
    (56, 100, CONTINUE),
    (3, 102, DECODED),
    (6, 102, DECODED),
    (10, 102, DECODED),
    (15, 102, DECODED),
    (24, 102, DECODED),
    (31, 102, DECODED),
    (41, 102, DECODED),
    (56, 102, CONTINUE),
  ],
  [
    (3, 103, DECODED),
    (6, 103, DECODED),
    (10, 103, DECODED),
    (15, 103, DECODED),
    (24, 103, DECODED),
    (31, 103, DECODED),
    (41, 103, DECODED),
    (56, 103, CONTINUE),
    (3, 104, DECODED),
    (6, 104, DECODED),
    (10, 104, DECODED),
    (15, 104, DECODED),
    (24, 104, DECODED),
    (31, 104, DECODED),
    (41, 104, DECODED),
    (56, 104, CONTINUE),
  ],
  [
    (1, 108, DECODED),
    (22, 108, CONTINUE),
    (1, 109, DECODED),
    (22, 109, CONTINUE),
    (1, 110, DECODED),
    (22, 110, CONTINUE),
    (1, 112, DECODED),
    (22, 112, CONTINUE),
    (1, 114, DECODED),
    (22, 114, CONTINUE),
    (1, 117, DECODED),
    (22, 117, CONTINUE),
    (0, 58, DECODED),
    (0, 66, DECODED),
    (0, 67, DECODED),
    (0, 68, DECODED),
  ],
  [
    (2, 108, DECODED),
    (9, 108, DECODED),
    (23, 108, DECODED),
    (40, 108, CONTINUE),
    (2, 109, DECODED),
    (9, 109, DECODED),
    (23, 109, DECODED),
    (40, 109, CONTINUE),
    (2, 110, DECODED),
    (9, 110, DECODED),
    (23, 110, DECODED),
    (40, 110, CONTINUE),
    (2, 112, DECODED),
    (9, 112, DECODED),
    (23, 112, DECODED),
    (40, 112, CONTINUE),
  ],
  [
    (3, 108, DECODED),
    (6, 108, DECODED),
    (10, 108, DECODED),
    (15, 108, DECODED),
    (24, 108, DECODED),
    (31, 108, DECODED),
    (41, 108, DECODED),
    (56, 108, CONTINUE),
    (3, 109, DECODED),
    (6, 109, DECODED),
    (10, 109, DECODED),
    (15, 109, DECODED),
    (24, 109, DECODED),
    (31, 109, DECODED),
    (41, 109, DECODED),
    (56, 109, CONTINUE),
  ],
  [
    (3, 110, DECODED),
    (6, 110, DECODED),
    (10, 110, DECODED),
    (15, 110, DECODED),
    (24, 110, DECODED),
    (31, 110, DECODED),
    (41, 110, DECODED),
    (56, 110, CONTINUE),
    (3, 112, DECODED),
    (6, 112, DECODED),
    (10, 112, DECODED),
    (15, 112, DECODED),
    (24, 112, DECODED),
    (31, 112, DECODED),
    (41, 112, DECODED),
    (56, 112, CONTINUE),
  ],
  [
    (2, 114, DECODED),
    (9, 114, DECODED),
    (23, 114, DECODED),
    (40, 114, CONTINUE),
    (2, 117, DECODED),
    (9, 117, DECODED),
    (23, 117, DECODED),
    (40, 117, CONTINUE),
    (1, 58, DECODED),
    (22, 58, CONTINUE),
    (1, 66, DECODED),
    (22, 66, CONTINUE),
    (1, 67, DECODED),
    (22, 67, CONTINUE),
    (1, 68, DECODED),
    (22, 68, CONTINUE),
  ],
  [
    (3, 114, DECODED),
    (6, 114, DECODED),
    (10, 114, DECODED),
    (15, 114, DECODED),
    (24, 114, DECODED),
    (31, 114, DECODED),
    (41, 114, DECODED),
    (56, 114, CONTINUE),
    (3, 117, DECODED),
    (6, 117, DECODED),
    (10, 117, DECODED),
    (15, 117, DECODED),
    (24, 117, DECODED),
    (31, 117, DECODED),
    (41, 117, DECODED),
    (56, 117, CONTINUE),
  ],
  [
    (2, 58, DECODED),
    (9, 58, DECODED),
    (23, 58, DECODED),
    (40, 58, CONTINUE),
    (2, 66, DECODED),
    (9, 66, DECODED),
    (23, 66, DECODED),
    (40, 66, CONTINUE),
    (2, 67, DECODED),
    (9, 67, DECODED),
    (23, 67, DECODED),
    (40, 67, CONTINUE),
    (2, 68, DECODED),
    (9, 68, DECODED),
    (23, 68, DECODED),
    (40, 68, CONTINUE),
  ],
  [
    (3, 58, DECODED),
    (6, 58, DECODED),
    (10, 58, DECODED),
    (15, 58, DECODED),
    (24, 58, DECODED),
    (31, 58, DECODED),
    (41, 58, DECODED),
    (56, 58, CONTINUE),
    (3, 66, DECODED),
    (6, 66, DECODED),
    (10, 66, DECODED),
    (15, 66, DECODED),
    (24, 66, DECODED),
    (31, 66, DECODED),
    (41, 66, DECODED),
    (56, 66, CONTINUE),
  ],
  [
    (3, 67, DECODED),
    (6, 67, DECODED),
    (10, 67, DECODED),
    (15, 67, DECODED),
    (24, 67, DECODED),
    (31, 67, DECODED),
    (41, 67, DECODED),
    (56, 67, CONTINUE),
    (3, 68, DECODED),
    (6, 68, DECODED),
    (10, 68, DECODED),
    (15, 68, DECODED),
    (24, 68, DECODED),
    (31, 68, DECODED),
    (41, 68, DECODED),
    (56, 68, CONTINUE),
  ],
  [
    (44, 0, OK),
    (45, 0, OK),
    (47, 0, OK),
    (48, 0, OK),
    (51, 0, OK),
    (52, 0, OK),
    (54, 0, OK),
    (55, 0, OK),
    (59, 0, OK),
    (60, 0, OK),
    (62, 0, OK),
    (63, 0, OK),
    (66, 0, OK),
    (67, 0, OK),
    (69, 0, OK),
    (72, 0, END_OF_STRING),
  ],
  [
    (0, 69, DECODED),
    (0, 70, DECODED),
    (0, 71, DECODED),
    (0, 72, DECODED),
    (0, 73, DECODED),
    (0, 74, DECODED),
    (0, 75, DECODED),
    (0, 76, DECODED),
    (0, 77, DECODED),
    (0, 78, DECODED),
    (0, 79, DECODED),
    (0, 80, DECODED),
    (0, 81, DECODED),
    (0, 82, DECODED),
    (0, 83, DECODED),
    (0, 84, DECODED),
  ],
  [
    (1, 69, DECODED),
    (22, 69, CONTINUE),
    (1, 70, DECODED),
    (22, 70, CONTINUE),
    (1, 71, DECODED),
    (22, 71, CONTINUE),
    (1, 72, DECODED),
    (22, 72, CONTINUE),
    (1, 73, DECODED),
    (22, 73, CONTINUE),
    (1, 74, DECODED),
    (22, 74, CONTINUE),
    (1, 75, DECODED),
    (22, 75, CONTINUE),
    (1, 76, DECODED),
    (22, 76, CONTINUE),
  ],
  [
    (2, 69, DECODED),
    (9, 69, DECODED),
    (23, 69, DECODED),
    (40, 69, CONTINUE),
    (2, 70, DECODED),
    (9, 70, DECODED),
    (23, 70, DECODED),
    (40, 70, CONTINUE),
    (2, 71, DECODED),
    (9, 71, DECODED),
    (23, 71, DECODED),
    (40, 71, CONTINUE),
    (2, 72, DECODED),
    (9, 72, DECODED),
    (23, 72, DECODED),
    (40, 72, CONTINUE),
  ],
  [
    (3, 69, DECODED),
    (6, 69, DECODED),
    (10, 69, DECODED),
    (15, 69, DECODED),
    (24, 69, DECODED),
    (31, 69, DECODED),
    (41, 69, DECODED),
    (56, 69, CONTINUE),
    (3, 70, DECODED),
    (6, 70, DECODED),
    (10, 70, DECODED),
    (15, 70, DECODED),
    (24, 70, DECODED),
    (31, 70, DECODED),
    (41, 70, DECODED),
    (56, 70, CONTINUE),
  ],
  [
    (3, 71, DECODED),
    (6, 71, DECODED),
    (10, 71, DECODED),
    (15, 71, DECODED),
    (24, 71, DECODED),
    (31, 71, DECODED),
    (41, 71, DECODED),
    (56, 71, CONTINUE),
    (3, 72, DECODED),
    (6, 72, DECODED),
    (10, 72, DECODED),
    (15, 72, DECODED),
    (24, 72, DECODED),
    (31, 72, DECODED),
    (41, 72, DECODED),
    (56, 72, CONTINUE),
  ],
  [
    (2, 73, DECODED),
    (9, 73, DECODED),
    (23, 73, DECODED),
    (40, 73, CONTINUE),
    (2, 74, DECODED),
    (9, 74, DECODED),
    (23, 74, DECODED),
    (40, 74, CONTINUE),
    (2, 75, DECODED),
    (9, 75, DECODED),
    (23, 75, DECODED),
    (40, 75, CONTINUE),
    (2, 76, DECODED),
    (9, 76, DECODED),
    (23, 76, DECODED),
    (40, 76, CONTINUE),
  ],
  [
    (3, 73, DECODED),
    (6, 73, DECODED),
    (10, 73, DECODED),
    (15, 73, DECODED),
    (24, 73, DECODED),
    (31, 73, DECODED),
    (41, 73, DECODED),
    (56, 73, CONTINUE),
    (3, 74, DECODED),
    (6, 74, DECODED),
    (10, 74, DECODED),
    (15, 74, DECODED),
    (24, 74, DECODED),
    (31, 74, DECODED),
    (41, 74, DECODED),
    (56, 74, CONTINUE),
  ],
  [
    (3, 75, DECODED),
    (6, 75, DECODED),
    (10, 75, DECODED),
    (15, 75, DECODED),
    (24, 75, DECODED),
    (31, 75, DECODED),
    (41, 75, DECODED),
    (56, 75, CONTINUE),
    (3, 76, DECODED),
    (6, 76, DECODED),
    (10, 76, DECODED),
    (15, 76, DECODED),
    (24, 76, DECODED),
    (31, 76, DECODED),
    (41, 76, DECODED),
    (56, 76, CONTINUE),
  ],
  [
    (1, 77, DECODED),
    (22, 77, CONTINUE),
    (1, 78, DECODED),
    (22, 78, CONTINUE),
    (1, 79, DECODED),
    (22, 79, CONTINUE),
    (1, 80, DECODED),
    (22, 80, CONTINUE),
    (1, 81, DECODED),
    (22, 81, CONTINUE),
    (1, 82, DECODED),
    (22, 82, CONTINUE),
    (1, 83, DECODED),
    (22, 83, CONTINUE),
    (1, 84, DECODED),
    (22, 84, CONTINUE),
  ],
  [
    (2, 77, DECODED),
    (9, 77, DECODED),
    (23, 77, DECODED),
    (40, 77, CONTINUE),
    (2, 78, DECODED),
    (9, 78, DECODED),
    (23, 78, DECODED),
    (40, 78, CONTINUE),
    (2, 79, DECODED),
    (9, 79, DECODED),
    (23, 79, DECODED),
    (40, 79, CONTINUE),
    (2, 80, DECODED),
    (9, 80, DECODED),
    (23, 80, DECODED),
    (40, 80, CONTINUE),
  ],
  [
    (3, 77, DECODED),
    (6, 77, DECODED),
    (10, 77, DECODED),
    (15, 77, DECODED),
    (24, 77, DECODED),
    (31, 77, DECODED),
    (41, 77, DECODED),
    (56, 77, CONTINUE),
    (3, 78, DECODED),
    (6, 78, DECODED),
    (10, 78, DECODED),
    (15, 78, DECODED),
    (24, 78, DECODED),
    (31, 78, DECODED),
    (41, 78, DECODED),
    (56, 78, CONTINUE),
  ],
  [
    (3, 79, DECODED),
    (6, 79, DECODED),
    (10, 79, DECODED),
    (15, 79, DECODED),
    (24, 79, DECODED),
    (31, 79, DECODED),
    (41, 79, DECODED),
    (56, 79, CONTINUE),
    (3, 80, DECODED),
    (6, 80, DECODED),
    (10, 80, DECODED),
    (15, 80, DECODED),
    (24, 80, DECODED),
    (31, 80, DECODED),
    (41, 80, DECODED),
    (56, 80, CONTINUE),
  ],
  [
    (2, 81, DECODED),
    (9, 81, DECODED),
    (23, 81, DECODED),
    (40, 81, CONTINUE),
    (2, 82, DECODED),
    (9, 82, DECODED),
    (23, 82, DECODED),
    (40, 82, CONTINUE),
    (2, 83, DECODED),
    (9, 83, DECODED),
    (23, 83, DECODED),
    (40, 83, CONTINUE),
    (2, 84, DECODED),
    (9, 84, DECODED),
    (23, 84, DECODED),
    (40, 84, CONTINUE),
  ],
  [
    (3, 81, DECODED),
    (6, 81, DECODED),
    (10, 81, DECODED),
    (15, 81, DECODED),
    (24, 81, DECODED),
    (31, 81, DECODED),
    (41, 81, DECODED),
    (56, 81, CONTINUE),
    (3, 82, DECODED),
    (6, 82, DECODED),
    (10, 82, DECODED),
    (15, 82, DECODED),
    (24, 82, DECODED),
    (31, 82, DECODED),
    (41, 82, DECODED),
    (56, 82, CONTINUE),
  ],
  [
    (3, 83, DECODED),
    (6, 83, DECODED),
    (10, 83, DECODED),
    (15, 83, DECODED),
    (24, 83, DECODED),
    (31, 83, DECODED),
    (41, 83, DECODED),
    (56, 83, CONTINUE),
    (3, 84, DECODED),
    (6, 84, DECODED),
    (10, 84, DECODED),
    (15, 84, DECODED),
    (24, 84, DECODED),
    (31, 84, DECODED),
    (41, 84, DECODED),
    (56, 84, CONTINUE),
  ],
  [
    (0, 85, DECODED),
    (0, 86, DECODED),
    (0, 87, DECODED),
    (0, 89, DECODED),
    (0, 106, DECODED),
    (0, 107, DECODED),
    (0, 113, DECODED),
    (0, 118, DECODED),
    (0, 119, DECODED),
    (0, 120, DECODED),
    (0, 121, DECODED),
    (0, 122, DECODED),
    (70, 0, OK),
    (71, 0, OK),
    (73, 0, OK),
    (74, 0, END_OF_STRING),
  ],
  [
    (1, 85, DECODED),
    (22, 85, CONTINUE),
    (1, 86, DECODED),
    (22, 86, CONTINUE),
    (1, 87, DECODED),
    (22, 87, CONTINUE),
    (1, 89, DECODED),
    (22, 89, CONTINUE),
    (1, 106, DECODED),
    (22, 106, CONTINUE),
    (1, 107, DECODED),
    (22, 107, CONTINUE),
    (1, 113, DECODED),
    (22, 113, CONTINUE),
    (1, 118, DECODED),
    (22, 118, CONTINUE),
  ],
  [
    (2, 85, DECODED),
    (9, 85, DECODED),
    (23, 85, DECODED),
    (40, 85, CONTINUE),
    (2, 86, DECODED),
    (9, 86, DECODED),
    (23, 86, DECODED),
    (40, 86, CONTINUE),
    (2, 87, DECODED),
    (9, 87, DECODED),
    (23, 87, DECODED),
    (40, 87, CONTINUE),
    (2, 89, DECODED),
    (9, 89, DECODED),
    (23, 89, DECODED),
    (40, 89, CONTINUE),
  ],
  [
    (3, 85, DECODED),
    (6, 85, DECODED),
    (10, 85, DECODED),
    (15, 85, DECODED),
    (24, 85, DECODED),
    (31, 85, DECODED),
    (41, 85, DECODED),
    (56, 85, CONTINUE),
    (3, 86, DECODED),
    (6, 86, DECODED),
    (10, 86, DECODED),
    (15, 86, DECODED),
    (24, 86, DECODED),
    (31, 86, DECODED),
    (41, 86, DECODED),
    (56, 86, CONTINUE),
  ],
  [
    (3, 87, DECODED),
    (6, 87, DECODED),
    (10, 87, DECODED),
    (15, 87, DECODED),
    (24, 87, DECODED),
    (31, 87, DECODED),
    (41, 87, DECODED),
    (56, 87, CONTINUE),
    (3, 89, DECODED),
    (6, 89, DECODED),
    (10, 89, DECODED),
    (15, 89, DECODED),
    (24, 89, DECODED),
    (31, 89, DECODED),
    (41, 89, DECODED),
    (56, 89, CONTINUE),
  ],
  [
    (2, 106, DECODED),
    (9, 106, DECODED),
    (23, 106, DECODED),
    (40, 106, CONTINUE),
    (2, 107, DECODED),
    (9, 107, DECODED),
    (23, 107, DECODED),
    (40, 107, CONTINUE),
    (2, 113, DECODED),
    (9, 113, DECODED),
    (23, 113, DECODED),
    (40, 113, CONTINUE),
    (2, 118, DECODED),
    (9, 118, DECODED),
    (23, 118, DECODED),
    (40, 118, CONTINUE),
  ],
  [
    (3, 106, DECODED),
    (6, 106, DECODED),
    (10, 106, DECODED),
    (15, 106, DECODED),
    (24, 106, DECODED),
    (31, 106, DECODED),
    (41, 106, DECODED),
    (56, 106, CONTINUE),
    (3, 107, DECODED),
    (6, 107, DECODED),
    (10, 107, DECODED),
    (15, 107, DECODED),
    (24, 107, DECODED),
    (31, 107, DECODED),
    (41, 107, DECODED),
    (56, 107, CONTINUE),
  ],
  [
    (3, 113, DECODED),
    (6, 113, DECODED),
    (10, 113, DECODED),
    (15, 113, DECODED),
    (24, 113, DECODED),
    (31, 113, DECODED),
    (41, 113, DECODED),
    (56, 113, CONTINUE),
    (3, 118, DECODED),
    (6, 118, DECODED),
    (10, 118, DECODED),
    (15, 118, DECODED),
    (24, 118, DECODED),
    (31, 118, DECODED),
    (41, 118, DECODED),
    (56, 118, CONTINUE),
  ],
  [
    (1, 119, DECODED),
    (22, 119, CONTINUE),
    (1, 120, DECODED),
    (22, 120, CONTINUE),
    (1, 121, DECODED),
    (22, 121, CONTINUE),
    (1, 122, DECODED),
    (22, 122, CONTINUE),
    (0, 38, DECODED),
    (0, 42, DECODED),
    (0, 44, DECODED),
    (0, 59, DECODED),
    (0, 88, DECODED),
    (0, 90, DECODED),
    (75, 0, OK),
    (78, 0, OK),
  ],
  [
    (2, 119, DECODED),
    (9, 119, DECODED),
    (23, 119, DECODED),
    (40, 119, CONTINUE),
    (2, 120, DECODED),
    (9, 120, DECODED),
    (23, 120, DECODED),
    (40, 120, CONTINUE),
    (2, 121, DECODED),
    (9, 121, DECODED),
    (23, 121, DECODED),
    (40, 121, CONTINUE),
    (2, 122, DECODED),
    (9, 122, DECODED),
    (23, 122, DECODED),
    (40, 122, CONTINUE),
  ],
  [
    (3, 119, DECODED),
    (6, 119, DECODED),
    (10, 119, DECODED),
    (15, 119, DECODED),
    (24, 119, DECODED),
    (31, 119, DECODED),
    (41, 119, DECODED),
    (56, 119, CONTINUE),
    (3, 120, DECODED),
    (6, 120, DECODED),
    (10, 120, DECODED),
    (15, 120, DECODED),
    (24, 120, DECODED),
    (31, 120, DECODED),
    (41, 120, DECODED),
    (56, 120, CONTINUE),
  ],
  [
    (3, 121, DECODED),
    (6, 121, DECODED),
    (10, 121, DECODED),
    (15, 121, DECODED),
    (24, 121, DECODED),
    (31, 121, DECODED),
    (41, 121, DECODED),
    (56, 121, CONTINUE),
    (3, 122, DECODED),
    (6, 122, DECODED),
    (10, 122, DECODED),
    (15, 122, DECODED),
    (24, 122, DECODED),
    (31, 122, DECODED),
    (41, 122, DECODED),
    (56, 122, CONTINUE),
  ],
  [
    (1, 38, DECODED),
    (22, 38, CONTINUE),
    (1, 42, DECODED),
    (22, 42, CONTINUE),
    (1, 44, DECODED),
    (22, 44, CONTINUE),
    (1, 59, DECODED),
    (22, 59, CONTINUE),
    (1, 88, DECODED),
    (22, 88, CONTINUE),
    (1, 90, DECODED),
    (22, 90, CONTINUE),
    (76, 0, OK),
    (77, 0, OK),
    (79, 0, OK),
    (81, 0, OK),
  ],
  [
    (2, 38, DECODED),
    (9, 38, DECODED),
    (23, 38, DECODED),
    (40, 38, CONTINUE),
    (2, 42, DECODED),
    (9, 42, DECODED),
    (23, 42, DECODED),
    (40, 42, CONTINUE),
    (2, 44, DECODED),
    (9, 44, DECODED),
    (23, 44, DECODED),
    (40, 44, CONTINUE),
    (2, 59, DECODED),
    (9, 59, DECODED),
    (23, 59, DECODED),
    (40, 59, CONTINUE),
  ],
  [
    (3, 38, DECODED),
    (6, 38, DECODED),
    (10, 38, DECODED),
    (15, 38, DECODED),
    (24, 38, DECODED),
    (31, 38, DECODED),
    (41, 38, DECODED),
    (56, 38, CONTINUE),
    (3, 42, DECODED),
    (6, 42, DECODED),
    (10, 42, DECODED),
    (15, 42, DECODED),
    (24, 42, DECODED),
    (31, 42, DECODED),
    (41, 42, DECODED),
    (56, 42, CONTINUE),
  ],
  [
    (3, 44, DECODED),
    (6, 44, DECODED),
    (10, 44, DECODED),
    (15, 44, DECODED),
    (24, 44, DECODED),
    (31, 44, DECODED),
    (41, 44, DECODED),
    (56, 44, CONTINUE),
    (3, 59, DECODED),
    (6, 59, DECODED),
    (10, 59, DECODED),
    (15, 59, DECODED),
    (24, 59, DECODED),
    (31, 59, DECODED),
    (41, 59, DECODED),
    (56, 59, CONTINUE),
  ],
  [
    (2, 88, DECODED),
    (9, 88, DECODED),
    (23, 88, DECODED),
    (40, 88, CONTINUE),
    (2, 90, DECODED),
    (9, 90, DECODED),
    (23, 90, DECODED),
    (40, 90, CONTINUE),
    (0, 33, DECODED),
    (0, 34, DECODED),
    (0, 40, DECODED),
    (0, 41, DECODED),
    (0, 63, DECODED),
    (80, 0, OK),
    (82, 0, OK),
    (84, 0, OK),
  ],
  [
    (3, 88, DECODED),
    (6, 88, DECODED),
    (10, 88, DECODED),
    (15, 88, DECODED),
    (24, 88, DECODED),
    (31, 88, DECODED),
    (41, 88, DECODED),
    (56, 88, CONTINUE),
    (3, 90, DECODED),
    (6, 90, DECODED),
    (10, 90, DECODED),
    (15, 90, DECODED),
    (24, 90, DECODED),
    (31, 90, DECODED),
    (41, 90, DECODED),
    (56, 90, CONTINUE),
  ],
  [
    (1, 33, DECODED),
    (22, 33, CONTINUE),
    (1, 34, DECODED),
    (22, 34, CONTINUE),
    (1, 40, DECODED),
    (22, 40, CONTINUE),
    (1, 41, DECODED),
    (22, 41, CONTINUE),
    (1, 63, DECODED),
    (22, 63, CONTINUE),
    (0, 39, DECODED),
    (0, 43, DECODED),
    (0, 124, DECODED),
    (83, 0, OK),
    (85, 0, OK),
    (88, 0, OK),
  ],
  [
    (2, 33, DECODED),
    (9, 33, DECODED),
    (23, 33, DECODED),
    (40, 33, CONTINUE),
    (2, 34, DECODED),
    (9, 34, DECODED),
    (23, 34, DECODED),
    (40, 34, CONTINUE),
    (2, 40, DECODED),
    (9, 40, DECODED),
    (23, 40, DECODED),
    (40, 40, CONTINUE),
    (2, 41, DECODED),
    (9, 41, DECODED),
    (23, 41, DECODED),
    (40, 41, CONTINUE),
  ],
  [
    (3, 33, DECODED),
    (6, 33, DECODED),
    (10, 33, DECODED),
    (15, 33, DECODED),
    (24, 33, DECODED),
    (31, 33, DECODED),
    (41, 33, DECODED),
    (56, 33, CONTINUE),
    (3, 34, DECODED),
    (6, 34, DECODED),
    (10, 34, DECODED),
    (15, 34, DECODED),
    (24, 34, DECODED),
    (31, 34, DECODED),
    (41, 34, DECODED),
    (56, 34, CONTINUE),
  ],
  [
    (3, 40, DECODED),
    (6, 40, DECODED),
    (10, 40, DECODED),
    (15, 40, DECODED),
    (24, 40, DECODED),
    (31, 40, DECODED),
    (41, 40, DECODED),
    (56, 40, CONTINUE),
    (3, 41, DECODED),
    (6, 41, DECODED),
    (10, 41, DECODED),
    (15, 41, DECODED),
    (24, 41, DECODED),
    (31, 41, DECODED),
    (41, 41, DECODED),
    (56, 41, CONTINUE),
  ],
  [
    (2, 63, DECODED),
    (9, 63, DECODED),
    (23, 63, DECODED),
    (40, 63, CONTINUE),
    (1, 39, DECODED),
    (22, 39, CONTINUE),
    (1, 43, DECODED),
    (22, 43, CONTINUE),
    (1, 124, DECODED),
    (22, 124, CONTINUE),
    (0, 35, DECODED),
    (0, 62, DECODED),
    (86, 0, OK),
    (87, 0, OK),
    (89, 0, OK),
    (90, 0, OK),
  ],
  [
    (3, 63, DECODED),
    (6, 63, DECODED),
    (10, 63, DECODED),
    (15, 63, DECODED),
    (24, 63, DECODED),
    (31, 63, DECODED),
    (41, 63, DECODED),
    (56, 63, CONTINUE),
    (2, 39, DECODED),
    (9, 39, DECODED),
    (23, 39, DECODED),
    (40, 39, CONTINUE),
    (2, 43, DECODED),
    (9, 43, DECODED),
    (23, 43, DECODED),
    (40, 43, CONTINUE),
  ],
  [
    (3, 39, DECODED),
    (6, 39, DECODED),
    (10, 39, DECODED),
    (15, 39, DECODED),
    (24, 39, DECODED),
    (31, 39, DECODED),
    (41, 39, DECODED),
    (56, 39, CONTINUE),
    (3, 43, DECODED),
    (6, 43, DECODED),
    (10, 43, DECODED),
    (15, 43, DECODED),
    (24, 43, DECODED),
    (31, 43, DECODED),
    (41, 43, DECODED),
    (56, 43, CONTINUE),
  ],
  [
    (2, 124, DECODED),
    (9, 124, DECODED),
    (23, 124, DECODED),
    (40, 124, CONTINUE),
    (1, 35, DECODED),
    (22, 35, CONTINUE),
    (1, 62, DECODED),
    (22, 62, CONTINUE),
    (0, 0, DECODED),
    (0, 36, DECODED),
    (0, 64, DECODED),
    (0, 91, DECODED),
    (0, 93, DECODED),
    (0, 126, DECODED),
    (91, 0, OK),
    (92, 0, OK),
  ],
  [
    (3, 124, DECODED),
    (6, 124, DECODED),
    (10, 124, DECODED),
    (15, 124, DECODED),
    (24, 124, DECODED),
    (31, 124, DECODED),
    (41, 124, DECODED),
    (56, 124, CONTINUE),
    (2, 35, DECODED),
    (9, 35, DECODED),
    (23, 35, DECODED),
    (40, 35, CONTINUE),
    (2, 62, DECODED),
    (9, 62, DECODED),
    (23, 62, DECODED),
    (40, 62, CONTINUE),
  ],
  [
    (3, 35, DECODED),
    (6, 35, DECODED),
    (10, 35, DECODED),
    (15, 35, DECODED),
    (24, 35, DECODED),
    (31, 35, DECODED),
    (41, 35, DECODED),
    (56, 35, CONTINUE),
    (3, 62, DECODED),
    (6, 62, DECODED),
    (10, 62, DECODED),
    (15, 62, DECODED),
    (24, 62, DECODED),
    (31, 62, DECODED),
    (41, 62, DECODED),
    (56, 62, CONTINUE),
  ],
  [
    (1, 0, DECODED),
    (22, 0, CONTINUE),
    (1, 36, DECODED),
    (22, 36, CONTINUE),
    (1, 64, DECODED),
    (22, 64, CONTINUE),
    (1, 91, DECODED),
    (22, 91, CONTINUE),
    (1, 93, DECODED),
    (22, 93, CONTINUE),
    (1, 126, DECODED),
    (22, 126, CONTINUE),
    (0, 94, DECODED),
    (0, 125, DECODED),
    (93, 0, OK),
    (94, 0, OK),
  ],
  [
    (2, 0, DECODED),
    (9, 0, DECODED),
    (23, 0, DECODED),
    (40, 0, CONTINUE),
    (2, 36, DECODED),
    (9, 36, DECODED),
    (23, 36, DECODED),
    (40, 36, CONTINUE),
    (2, 64, DECODED),
    (9, 64, DECODED),
    (23, 64, DECODED),
    (40, 64, CONTINUE),
    (2, 91, DECODED),
    (9, 91, DECODED),
    (23, 91, DECODED),
    (40, 91, CONTINUE),
  ],
  [
    (3, 0, DECODED),
    (6, 0, DECODED),
    (10, 0, DECODED),
    (15, 0, DECODED),
    (24, 0, DECODED),
    (31, 0, DECODED),
    (41, 0, DECODED),
    (56, 0, CONTINUE),
    (3, 36, DECODED),
    (6, 36, DECODED),
    (10, 36, DECODED),
    (15, 36, DECODED),
    (24, 36, DECODED),
    (31, 36, DECODED),
    (41, 36, DECODED),
    (56, 36, CONTINUE),
  ],
  [
    (3, 64, DECODED),
    (6, 64, DECODED),
    (10, 64, DECODED),
    (15, 64, DECODED),
    (24, 64, DECODED),
    (31, 64, DECODED),
    (41, 64, DECODED),
    (56, 64, CONTINUE),
    (3, 91, DECODED),
    (6, 91, DECODED),
    (10, 91, DECODED),
    (15, 91, DECODED),
    (24, 91, DECODED),
    (31, 91, DECODED),
    (41, 91, DECODED),
    (56, 91, CONTINUE),
  ],
  [
    (2, 93, DECODED),
    (9, 93, DECODED),
    (23, 93, DECODED),
    (40, 93, CONTINUE),
    (2, 126, DECODED),
    (9, 126, DECODED),
    (23, 126, DECODED),
    (40, 126, CONTINUE),
    (1, 94, DECODED),
    (22, 94, CONTINUE),
    (1, 125, DECODED),
    (22, 125, CONTINUE),
    (0, 60, DECODED),
    (0, 96, DECODED),
    (0, 123, DECODED),
    (95, 0, OK),
  ],
  [
    (3, 93, DECODED),
    (6, 93, DECODED),
    (10, 93, DECODED),
    (15, 93, DECODED),
    (24, 93, DECODED),
    (31, 93, DECODED),
    (41, 93, DECODED),
    (56, 93, CONTINUE),
    (3, 126, DECODED),
    (6, 126, DECODED),
    (10, 126, DECODED),
    (15, 126, DECODED),
    (24, 126, DECODED),
    (31, 126, DECODED),
    (41, 126, DECODED),
    (56, 126, CONTINUE),
  ],
  [
    (2, 94, DECODED),
    (9, 94, DECODED),
    (23, 94, DECODED),
    (40, 94, CONTINUE),
    (2, 125, DECODED),
    (9, 125, DECODED),
    (23, 125, DECODED),
    (40, 125, CONTINUE),
    (1, 60, DECODED),
    (22, 60, CONTINUE),
    (1, 96, DECODED),
    (22, 96, CONTINUE),
    (1, 123, DECODED),
    (22, 123, CONTINUE),
    (96, 0, OK),
    (110, 0, OK),
  ],
  [
    (3, 94, DECODED),
    (6, 94, DECODED),
    (10, 94, DECODED),
    (15, 94, DECODED),
    (24, 94, DECODED),
    (31, 94, DECODED),
    (41, 94, DECODED),
    (56, 94, CONTINUE),
    (3, 125, DECODED),
    (6, 125, DECODED),
    (10, 125, DECODED),
    (15, 125, DECODED),
    (24, 125, DECODED),
    (31, 125, DECODED),
    (41, 125, DECODED),
    (56, 125, CONTINUE),
  ],
  [
    (2, 60, DECODED),
    (9, 60, DECODED),
    (23, 60, DECODED),
    (40, 60, CONTINUE),
    (2, 96, DECODED),
    (9, 96, DECODED),
    (23, 96, DECODED),
    (40, 96, CONTINUE),
    (2, 123, DECODED),
    (9, 123, DECODED),
    (23, 123, DECODED),
    (40, 123, CONTINUE),
    (97, 0, OK),
    (101, 0, OK),
    (111, 0, OK),
    (133, 0, OK),
  ],
  [
    (3, 60, DECODED),
    (6, 60, DECODED),
    (10, 60, DECODED),
    (15, 60, DECODED),
    (24, 60, DECODED),
    (31, 60, DECODED),
    (41, 60, DECODED),
    (56, 60, CONTINUE),
    (3, 96, DECODED),
    (6, 96, DECODED),
    (10, 96, DECODED),
    (15, 96, DECODED),
    (24, 96, DECODED),
    (31, 96, DECODED),
    (41, 96, DECODED),
    (56, 96, CONTINUE),
  ],
  [
    (3, 123, DECODED),
    (6, 123, DECODED),
    (10, 123, DECODED),
    (15, 123, DECODED),
    (24, 123, DECODED),
    (31, 123, DECODED),
    (41, 123, DECODED),
    (56, 123, CONTINUE),
    (98, 0, OK),
    (99, 0, OK),
    (102, 0, OK),
    (105, 0, OK),
    (112, 0, OK),
    (119, 0, OK),
    (134, 0, OK),
    (153, 0, OK),
  ],
  [
    (0, 92, DECODED),
    (0, 195, DECODED),
    (0, 208, DECODED),
    (100, 0, OK),
    (103, 0, OK),
    (104, 0, OK),
    (106, 0, OK),
    (107, 0, OK),
    (113, 0, OK),
    (116, 0, OK),
    (120, 0, OK),
    (126, 0, OK),
    (135, 0, OK),
    (142, 0, OK),
    (154, 0, OK),
    (169, 0, OK),
  ],
  [
    (1, 92, DECODED),
    (22, 92, CONTINUE),
    (1, 195, DECODED),
    (22, 195, CONTINUE),
    (1, 208, DECODED),
    (22, 208, CONTINUE),
    (0, 128, DECODED),
    (0, 130, DECODED),
    (0, 131, DECODED),
    (0, 162, DECODED),
    (0, 184, DECODED),
    (0, 194, DECODED),
    (0, 224, DECODED),
    (0, 226, DECODED),
    (108, 0, OK),
    (109, 0, OK),
  ],
  [
    (2, 92, DECODED),
    (9, 92, DECODED),
    (23, 92, DECODED),
    (40, 92, CONTINUE),
    (2, 195, DECODED),
    (9, 195, DECODED),
    (23, 195, DECODED),
    (40, 195, CONTINUE),
    (2, 208, DECODED),
    (9, 208, DECODED),
    (23, 208, DECODED),
    (40, 208, CONTINUE),
    (1, 128, DECODED),
    (22, 128, CONTINUE),
    (1, 130, DECODED),
    (22, 130, CONTINUE),
  ],
  [
    (3, 92, DECODED),
    (6, 92, DECODED),
    (10, 92, DECODED),
    (15, 92, DECODED),
    (24, 92, DECODED),
    (31, 92, DECODED),
    (41, 92, DECODED),
    (56, 92, CONTINUE),
    (3, 195, DECODED),
    (6, 195, DECODED),
    (10, 195, DECODED),
    (15, 195, DECODED),
    (24, 195, DECODED),
    (31, 195, DECODED),
    (41, 195, DECODED),
    (56, 195, CONTINUE),
  ],
  [
    (3, 208, DECODED),
    (6, 208, DECODED),
    (10, 208, DECODED),
    (15, 208, DECODED),
    (24, 208, DECODED),
    (31, 208, DECODED),
    (41, 208, DECODED),
    (56, 208, CONTINUE),
    (2, 128, DECODED),
    (9, 128, DECODED),
    (23, 128, DECODED),
    (40, 128, CONTINUE),
    (2, 130, DECODED),
    (9, 130, DECODED),
    (23, 130, DECODED),
    (40, 130, CONTINUE),
  ],
  [
    (3, 128, DECODED),
    (6, 128, DECODED),
    (10, 128, DECODED),
    (15, 128, DECODED),
    (24, 128, DECODED),
    (31, 128, DECODED),
    (41, 128, DECODED),
    (56, 128, CONTINUE),
    (3, 130, DECODED),
    (6, 130, DECODED),
    (10, 130, DECODED),
    (15, 130, DECODED),
    (24, 130, DECODED),
    (31, 130, DECODED),
    (41, 130, DECODED),
    (56, 130, CONTINUE),
  ],
  [
    (1, 131, DECODED),
    (22, 131, CONTINUE),
    (1, 162, DECODED),
    (22, 162, CONTINUE),
    (1, 184, DECODED),
    (22, 184, CONTINUE),
    (1, 194, DECODED),
    (22, 194, CONTINUE),
    (1, 224, DECODED),
    (22, 224, CONTINUE),
    (1, 226, DECODED),
    (22, 226, CONTINUE),
    (0, 153, DECODED),
    (0, 161, DECODED),
    (0, 167, DECODED),
    (0, 172, DECODED),
  ],
  [
    (2, 131, DECODED),
    (9, 131, DECODED),
    (23, 131, DECODED),
    (40, 131, CONTINUE),
    (2, 162, DECODED),
    (9, 162, DECODED),
    (23, 162, DECODED),
    (40, 162, CONTINUE),
    (2, 184, DECODED),
    (9, 184, DECODED),
    (23, 184, DECODED),
    (40, 184, CONTINUE),
    (2, 194, DECODED),
    (9, 194, DECODED),
    (23, 194, DECODED),
    (40, 194, CONTINUE),
  ],
  [
    (3, 131, DECODED),
    (6, 131, DECODED),
    (10, 131, DECODED),
    (15, 131, DECODED),
    (24, 131, DECODED),
    (31, 131, DECODED),
    (41, 131, DECODED),
    (56, 131, CONTINUE),
    (3, 162, DECODED),
    (6, 162, DECODED),
    (10, 162, DECODED),
    (15, 162, DECODED),
    (24, 162, DECODED),
    (31, 162, DECODED),
    (41, 162, DECODED),
    (56, 162, CONTINUE),
  ],
  [
    (3, 184, DECODED),
    (6, 184, DECODED),
    (10, 184, DECODED),
    (15, 184, DECODED),
    (24, 184, DECODED),
    (31, 184, DECODED),
    (41, 184, DECODED),
    (56, 184, CONTINUE),
    (3, 194, DECODED),
    (6, 194, DECODED),
    (10, 194, DECODED),
    (15, 194, DECODED),
    (24, 194, DECODED),
    (31, 194, DECODED),
    (41, 194, DECODED),
    (56, 194, CONTINUE),
  ],
  [
    (2, 224, DECODED),
    (9, 224, DECODED),
    (23, 224, DECODED),
    (40, 224, CONTINUE),
    (2, 226, DECODED),
    (9, 226, DECODED),
    (23, 226, DECODED),
    (40, 226, CONTINUE),
    (1, 153, DECODED),
    (22, 153, CONTINUE),
    (1, 161, DECODED),
    (22, 161, CONTINUE),
    (1, 167, DECODED),
    (22, 167, CONTINUE),
    (1, 172, DECODED),
    (22, 172, CONTINUE),
  ],
  [
    (3, 224, DECODED),
    (6, 224, DECODED),
    (10, 224, DECODED),
    (15, 224, DECODED),
    (24, 224, DECODED),
    (31, 224, DECODED),
    (41, 224, DECODED),
    (56, 224, CONTINUE),
    (3, 226, DECODED),
    (6, 226, DECODED),
    (10, 226, DECODED),
    (15, 226, DECODED),
    (24, 226, DECODED),
    (31, 226, DECODED),
    (41, 226, DECODED),
    (56, 226, CONTINUE),
  ],
  [
    (2, 153, DECODED),
    (9, 153, DECODED),
    (23, 153, DECODED),
    (40, 153, CONTINUE),
    (2, 161, DECODED),
    (9, 161, DECODED),
    (23, 161, DECODED),
    (40, 161, CONTINUE),
    (2, 167, DECODED),
    (9, 167, DECODED),
    (23, 167, DECODED),
    (40, 167, CONTINUE),
    (2, 172, DECODED),
    (9, 172, DECODED),
    (23, 172, DECODED),
    (40, 172, CONTINUE),
  ],
  [
    (3, 153, DECODED),
    (6, 153, DECODED),
    (10, 153, DECODED),
    (15, 153, DECODED),
    (24, 153, DECODED),
    (31, 153, DECODED),
    (41, 153, DECODED),
    (56, 153, CONTINUE),
    (3, 161, DECODED),
    (6, 161, DECODED),
    (10, 161, DECODED),
    (15, 161, DECODED),
    (24, 161, DECODED),
    (31, 161, DECODED),
    (41, 161, DECODED),
    (56, 161, CONTINUE),
  ],
  [
    (3, 167, DECODED),
    (6, 167, DECODED),
    (10, 167, DECODED),
    (15, 167, DECODED),
    (24, 167, DECODED),
    (31, 167, DECODED),
    (41, 167, DECODED),
    (56, 167, CONTINUE),
    (3, 172, DECODED),
    (6, 172, DECODED),
    (10, 172, DECODED),
    (15, 172, DECODED),
    (24, 172, DECODED),
    (31, 172, DECODED),
    (41, 172, DECODED),
    (56, 172, CONTINUE),
  ],
  [
    (114, 0, OK),
    (115, 0, OK),
    (117, 0, OK),
    (118, 0, OK),
    (121, 0, OK),
    (123, 0, OK),
    (127, 0, OK),
    (130, 0, OK),
    (136, 0, OK),
    (139, 0, OK),
    (143, 0, OK),
    (146, 0, OK),
    (155, 0, OK),
    (162, 0, OK),
    (170, 0, OK),
    (180, 0, OK),
  ],
  [
    (0, 176, DECODED),
    (0, 177, DECODED),
    (0, 179, DECODED),
    (0, 209, DECODED),
    (0, 216, DECODED),
    (0, 217, DECODED),
    (0, 227, DECODED),
    (0, 229, DECODED),
    (0, 230, DECODED),
    (122, 0, OK),
    (124, 0, OK),
    (125, 0, OK),
    (128, 0, OK),
    (129, 0, OK),
    (131, 0, OK),
    (132, 0, OK),
  ],
  [
    (1, 176, DECODED),
    (22, 176, CONTINUE),
    (1, 177, DECODED),
    (22, 177, CONTINUE),
    (1, 179, DECODED),
    (22, 179, CONTINUE),
    (1, 209, DECODED),
    (22, 209, CONTINUE),
    (1, 216, DECODED),
    (22, 216, CONTINUE),
    (1, 217, DECODED),
    (22, 217, CONTINUE),
    (1, 227, DECODED),
    (22, 227, CONTINUE),
    (1, 229, DECODED),
    (22, 229, CONTINUE),
  ],
  [
    (2, 176, DECODED),
    (9, 176, DECODED),
    (23, 176, DECODED),
    (40, 176, CONTINUE),
    (2, 177, DECODED),
    (9, 177, DECODED),
    (23, 177, DECODED),
    (40, 177, CONTINUE),
    (2, 179, DECODED),
    (9, 179, DECODED),
    (23, 179, DECODED),
    (40, 179, CONTINUE),
    (2, 209, DECODED),
    (9, 209, DECODED),
    (23, 209, DECODED),
    (40, 209, CONTINUE),
  ],
  [
    (3, 176, DECODED),
    (6, 176, DECODED),
    (10, 176, DECODED),
    (15, 176, DECODED),
    (24, 176, DECODED),
    (31, 176, DECODED),
    (41, 176, DECODED),
    (56, 176, CONTINUE),
    (3, 177, DECODED),
    (6, 177, DECODED),
    (10, 177, DECODED),
    (15, 177, DECODED),
    (24, 177, DECODED),
    (31, 177, DECODED),
    (41, 177, DECODED),
    (56, 177, CONTINUE),
  ],
  [
    (3, 179, DECODED),
    (6, 179, DECODED),
    (10, 179, DECODED),
    (15, 179, DECODED),
    (24, 179, DECODED),
    (31, 179, DECODED),
    (41, 179, DECODED),
    (56, 179, CONTINUE),
    (3, 209, DECODED),
    (6, 209, DECODED),
    (10, 209, DECODED),
    (15, 209, DECODED),
    (24, 209, DECODED),
    (31, 209, DECODED),
    (41, 209, DECODED),
    (56, 209, CONTINUE),
  ],
  [
    (2, 216, DECODED),
    (9, 216, DECODED),
    (23, 216, DECODED),
    (40, 216, CONTINUE),
    (2, 217, DECODED),
    (9, 217, DECODED),
    (23, 217, DECODED),
    (40, 217, CONTINUE),
    (2, 227, DECODED),
    (9, 227, DECODED),
    (23, 227, DECODED),
    (40, 227, CONTINUE),
    (2, 229, DECODED),
    (9, 229, DECODED),
    (23, 229, DECODED),
    (40, 229, CONTINUE),
  ],
  [
    (3, 216, DECODED),
    (6, 216, DECODED),
    (10, 216, DECODED),
    (15, 216, DECODED),
    (24, 216, DECODED),
    (31, 216, DECODED),
    (41, 216, DECODED),
    (56, 216, CONTINUE),
    (3, 217, DECODED),
    (6, 217, DECODED),
    (10, 217, DECODED),
    (15, 217, DECODED),
    (24, 217, DECODED),
    (31, 217, DECODED),
    (41, 217, DECODED),
    (56, 217, CONTINUE),
  ],
  [
    (3, 227, DECODED),
    (6, 227, DECODED),
    (10, 227, DECODED),
    (15, 227, DECODED),
    (24, 227, DECODED),
    (31, 227, DECODED),
    (41, 227, DECODED),
    (56, 227, CONTINUE),
    (3, 229, DECODED),
    (6, 229, DECODED),
    (10, 229, DECODED),
    (15, 229, DECODED),
    (24, 229, DECODED),
    (31, 229, DECODED),
    (41, 229, DECODED),
    (56, 229, CONTINUE),
  ],
  [
    (1, 230, DECODED),
    (22, 230, CONTINUE),
    (0, 129, DECODED),
    (0, 132, DECODED),
    (0, 133, DECODED),
    (0, 134, DECODED),
    (0, 136, DECODED),
    (0, 146, DECODED),
    (0, 154, DECODED),
    (0, 156, DECODED),
    (0, 160, DECODED),
    (0, 163, DECODED),
    (0, 164, DECODED),
    (0, 169, DECODED),
    (0, 170, DECODED),
    (0, 173, DECODED),
  ],
  [
    (2, 230, DECODED),
    (9, 230, DECODED),
    (23, 230, DECODED),
    (40, 230, CONTINUE),
    (1, 129, DECODED),
    (22, 129, CONTINUE),
    (1, 132, DECODED),
    (22, 132, CONTINUE),
    (1, 133, DECODED),
    (22, 133, CONTINUE),
    (1, 134, DECODED),
    (22, 134, CONTINUE),
    (1, 136, DECODED),
    (22, 136, CONTINUE),
    (1, 146, DECODED),
    (22, 146, CONTINUE),
  ],
  [
    (3, 230, DECODED),
    (6, 230, DECODED),
    (10, 230, DECODED),
    (15, 230, DECODED),
    (24, 230, DECODED),
    (31, 230, DECODED),
    (41, 230, DECODED),
    (56, 230, CONTINUE),
    (2, 129, DECODED),
    (9, 129, DECODED),
    (23, 129, DECODED),
    (40, 129, CONTINUE),
    (2, 132, DECODED),
    (9, 132, DECODED),
    (23, 132, DECODED),
    (40, 132, CONTINUE),
  ],
  [
    (3, 129, DECODED),
    (6, 129, DECODED),
    (10, 129, DECODED),
    (15, 129, DECODED),
    (24, 129, DECODED),
    (31, 129, DECODED),
    (41, 129, DECODED),
    (56, 129, CONTINUE),
    (3, 132, DECODED),
    (6, 132, DECODED),
    (10, 132, DECODED),
    (15, 132, DECODED),
    (24, 132, DECODED),
    (31, 132, DECODED),
    (41, 132, DECODED),
    (56, 132, CONTINUE),
  ],
  [
    (2, 133, DECODED),
    (9, 133, DECODED),
    (23, 133, DECODED),
    (40, 133, CONTINUE),
    (2, 134, DECODED),
    (9, 134, DECODED),
    (23, 134, DECODED),
    (40, 134, CONTINUE),
    (2, 136, DECODED),
    (9, 136, DECODED),
    (23, 136, DECODED),
    (40, 136, CONTINUE),
    (2, 146, DECODED),
    (9, 146, DECODED),
    (23, 146, DECODED),
    (40, 146, CONTINUE),
  ],
  [
    (3, 133, DECODED),
    (6, 133, DECODED),
    (10, 133, DECODED),
    (15, 133, DECODED),
    (24, 133, DECODED),
    (31, 133, DECODED),
    (41, 133, DECODED),
    (56, 133, CONTINUE),
    (3, 134, DECODED),
    (6, 134, DECODED),
    (10, 134, DECODED),
    (15, 134, DECODED),
    (24, 134, DECODED),
    (31, 134, DECODED),
    (41, 134, DECODED),
    (56, 134, CONTINUE),
  ],
  [
    (3, 136, DECODED),
    (6, 136, DECODED),
    (10, 136, DECODED),
    (15, 136, DECODED),
    (24, 136, DECODED),
    (31, 136, DECODED),
    (41, 136, DECODED),
    (56, 136, CONTINUE),
    (3, 146, DECODED),
    (6, 146, DECODED),
    (10, 146, DECODED),
    (15, 146, DECODED),
    (24, 146, DECODED),
    (31, 146, DECODED),
    (41, 146, DECODED),
    (56, 146, CONTINUE),
  ],
  [
    (1, 154, DECODED),
    (22, 154, CONTINUE),
    (1, 156, DECODED),
    (22, 156, CONTINUE),
    (1, 160, DECODED),
    (22, 160, CONTINUE),
    (1, 163, DECODED),
    (22, 163, CONTINUE),
    (1, 164, DECODED),
    (22, 164, CONTINUE),
    (1, 169, DECODED),
    (22, 169, CONTINUE),
    (1, 170, DECODED),
    (22, 170, CONTINUE),
    (1, 173, DECODED),
    (22, 173, CONTINUE),
  ],
  [
    (2, 154, DECODED),
    (9, 154, DECODED),
    (23, 154, DECODED),
    (40, 154, CONTINUE),
    (2, 156, DECODED),
    (9, 156, DECODED),
    (23, 156, DECODED),
    (40, 156, CONTINUE),
    (2, 160, DECODED),
    (9, 160, DECODED),
    (23, 160, DECODED),
    (40, 160, CONTINUE),
    (2, 163, DECODED),
    (9, 163, DECODED),
    (23, 163, DECODED),
    (40, 163, CONTINUE),
  ],
  [
    (3, 154, DECODED),
    (6, 154, DECODED),
    (10, 154, DECODED),
    (15, 154, DECODED),
    (24, 154, DECODED),
    (31, 154, DECODED),
    (41, 154, DECODED),
    (56, 154, CONTINUE),
    (3, 156, DECODED),
    (6, 156, DECODED),
    (10, 156, DECODED),
    (15, 156, DECODED),
    (24, 156, DECODED),
    (31, 156, DECODED),
    (41, 156, DECODED),
    (56, 156, CONTINUE),
  ],
  [
    (3, 160, DECODED),
    (6, 160, DECODED),
    (10, 160, DECODED),
    (15, 160, DECODED),
    (24, 160, DECODED),
    (31, 160, DECODED),
    (41, 160, DECODED),
    (56, 160, CONTINUE),
    (3, 163, DECODED),
    (6, 163, DECODED),
    (10, 163, DECODED),
    (15, 163, DECODED),
    (24, 163, DECODED),
    (31, 163, DECODED),
    (41, 163, DECODED),
    (56, 163, CONTINUE),
  ],
  [
    (2, 164, DECODED),
    (9, 164, DECODED),
    (23, 164, DECODED),
    (40, 164, CONTINUE),
    (2, 169, DECODED),
    (9, 169, DECODED),
    (23, 169, DECODED),
    (40, 169, CONTINUE),
    (2, 170, DECODED),
    (9, 170, DECODED),
    (23, 170, DECODED),
    (40, 170, CONTINUE),
    (2, 173, DECODED),
    (9, 173, DECODED),
    (23, 173, DECODED),
    (40, 173, CONTINUE),
  ],
  [
    (3, 164, DECODED),
    (6, 164, DECODED),
    (10, 164, DECODED),
    (15, 164, DECODED),
    (24, 164, DECODED),
    (31, 164, DECODED),
    (41, 164, DECODED),
    (56, 164, CONTINUE),
    (3, 169, DECODED),
    (6, 169, DECODED),
    (10, 169, DECODED),
    (15, 169, DECODED),
    (24, 169, DECODED),
    (31, 169, DECODED),
    (41, 169, DECODED),
    (56, 169, CONTINUE),
  ],
  [
    (3, 170, DECODED),
    (6, 170, DECODED),
    (10, 170, DECODED),
    (15, 170, DECODED),
    (24, 170, DECODED),
    (31, 170, DECODED),
    (41, 170, DECODED),
    (56, 170, CONTINUE),
    (3, 173, DECODED),
    (6, 173, DECODED),
    (10, 173, DECODED),
    (15, 173, DECODED),
    (24, 173, DECODED),
    (31, 173, DECODED),
    (41, 173, DECODED),
    (56, 173, CONTINUE),
  ],
  [
    (137, 0, OK),
    (138, 0, OK),
    (140, 0, OK),
    (141, 0, OK),
    (144, 0, OK),
    (145, 0, OK),
    (147, 0, OK),
    (150, 0, OK),
    (156, 0, OK),
    (159, 0, OK),
    (163, 0, OK),
    (166, 0, OK),
    (171, 0, OK),
    (174, 0, OK),
    (181, 0, OK),
    (190, 0, OK),
  ],
  [
    (0, 178, DECODED),
    (0, 181, DECODED),
    (0, 185, DECODED),
    (0, 186, DECODED),
    (0, 187, DECODED),
    (0, 189, DECODED),
    (0, 190, DECODED),
    (0, 196, DECODED),
    (0, 198, DECODED),
    (0, 228, DECODED),
    (0, 232, DECODED),
    (0, 233, DECODED),
    (148, 0, OK),
    (149, 0, OK),
    (151, 0, OK),
    (152, 0, OK),
  ],
  [
    (1, 178, DECODED),
    (22, 178, CONTINUE),
    (1, 181, DECODED),
    (22, 181, CONTINUE),
    (1, 185, DECODED),
    (22, 185, CONTINUE),
    (1, 186, DECODED),
    (22, 186, CONTINUE),
    (1, 187, DECODED),
    (22, 187, CONTINUE),
    (1, 189, DECODED),
    (22, 189, CONTINUE),
    (1, 190, DECODED),
    (22, 190, CONTINUE),
    (1, 196, DECODED),
    (22, 196, CONTINUE),
  ],
  [
    (2, 178, DECODED),
    (9, 178, DECODED),
    (23, 178, DECODED),
    (40, 178, CONTINUE),
    (2, 181, DECODED),
    (9, 181, DECODED),
    (23, 181, DECODED),
    (40, 181, CONTINUE),
    (2, 185, DECODED),
    (9, 185, DECODED),
    (23, 185, DECODED),
    (40, 185, CONTINUE),
    (2, 186, DECODED),
    (9, 186, DECODED),
    (23, 186, DECODED),
    (40, 186, CONTINUE),
  ],
  [
    (3, 178, DECODED),
    (6, 178, DECODED),
    (10, 178, DECODED),
    (15, 178, DECODED),
    (24, 178, DECODED),
    (31, 178, DECODED),
    (41, 178, DECODED),
    (56, 178, CONTINUE),
    (3, 181, DECODED),
    (6, 181, DECODED),
    (10, 181, DECODED),
    (15, 181, DECODED),
    (24, 181, DECODED),
    (31, 181, DECODED),
    (41, 181, DECODED),
    (56, 181, CONTINUE),
  ],
  [
    (3, 185, DECODED),
    (6, 185, DECODED),
    (10, 185, DECODED),
    (15, 185, DECODED),
    (24, 185, DECODED),
    (31, 185, DECODED),
    (41, 185, DECODED),
    (56, 185, CONTINUE),
    (3, 186, DECODED),
    (6, 186, DECODED),
    (10, 186, DECODED),
    (15, 186, DECODED),
    (24, 186, DECODED),
    (31, 186, DECODED),
    (41, 186, DECODED),
    (56, 186, CONTINUE),
  ],
  [
    (2, 187, DECODED),
    (9, 187, DECODED),
    (23, 187, DECODED),
    (40, 187, CONTINUE),
    (2, 189, DECODED),
    (9, 189, DECODED),
    (23, 189, DECODED),
    (40, 189, CONTINUE),
    (2, 190, DECODED),
    (9, 190, DECODED),
    (23, 190, DECODED),
    (40, 190, CONTINUE),
    (2, 196, DECODED),
    (9, 196, DECODED),
    (23, 196, DECODED),
    (40, 196, CONTINUE),
  ],
  [
    (3, 187, DECODED),
    (6, 187, DECODED),
    (10, 187, DECODED),
    (15, 187, DECODED),
    (24, 187, DECODED),
    (31, 187, DECODED),
    (41, 187, DECODED),
    (56, 187, CONTINUE),
    (3, 189, DECODED),
    (6, 189, DECODED),
    (10, 189, DECODED),
    (15, 189, DECODED),
    (24, 189, DECODED),
    (31, 189, DECODED),
    (41, 189, DECODED),
    (56, 189, CONTINUE),
  ],
  [
    (3, 190, DECODED),
    (6, 190, DECODED),
    (10, 190, DECODED),
    (15, 190, DECODED),
    (24, 190, DECODED),
    (31, 190, DECODED),
    (41, 190, DECODED),
    (56, 190, CONTINUE),
    (3, 196, DECODED),
    (6, 196, DECODED),
    (10, 196, DECODED),
    (15, 196, DECODED),
    (24, 196, DECODED),
    (31, 196, DECODED),
    (41, 196, DECODED),
    (56, 196, CONTINUE),
  ],
  [
    (1, 198, DECODED),
    (22, 198, CONTINUE),
    (1, 228, DECODED),
    (22, 228, CONTINUE),
    (1, 232, DECODED),
    (22, 232, CONTINUE),
    (1, 233, DECODED),
    (22, 233, CONTINUE),
    (0, 1, DECODED),
    (0, 135, DECODED),
    (0, 137, DECODED),
    (0, 138, DECODED),
    (0, 139, DECODED),
    (0, 140, DECODED),
    (0, 141, DECODED),
    (0, 143, DECODED),
  ],
  [
    (2, 198, DECODED),
    (9, 198, DECODED),
    (23, 198, DECODED),
    (40, 198, CONTINUE),
    (2, 228, DECODED),
    (9, 228, DECODED),
    (23, 228, DECODED),
    (40, 228, CONTINUE),
    (2, 232, DECODED),
    (9, 232, DECODED),
    (23, 232, DECODED),
    (40, 232, CONTINUE),
    (2, 233, DECODED),
    (9, 233, DECODED),
    (23, 233, DECODED),
    (40, 233, CONTINUE),
  ],
  [
    (3, 198, DECODED),
    (6, 198, DECODED),
    (10, 198, DECODED),
    (15, 198, DECODED),
    (24, 198, DECODED),
    (31, 198, DECODED),
    (41, 198, DECODED),
    (56, 198, CONTINUE),
    (3, 228, DECODED),
    (6, 228, DECODED),
    (10, 228, DECODED),
    (15, 228, DECODED),
    (24, 228, DECODED),
    (31, 228, DECODED),
    (41, 228, DECODED),
    (56, 228, CONTINUE),
  ],
  [
    (3, 232, DECODED),
    (6, 232, DECODED),
    (10, 232, DECODED),
    (15, 232, DECODED),
    (24, 232, DECODED),
    (31, 232, DECODED),
    (41, 232, DECODED),
    (56, 232, CONTINUE),
    (3, 233, DECODED),
    (6, 233, DECODED),
    (10, 233, DECODED),
    (15, 233, DECODED),
    (24, 233, DECODED),
    (31, 233, DECODED),
    (41, 233, DECODED),
    (56, 233, CONTINUE),
  ],
  [
    (1, 1, DECODED),
    (22, 1, CONTINUE),
    (1, 135, DECODED),
    (22, 135, CONTINUE),
    (1, 137, DECODED),
    (22, 137, CONTINUE),
    (1, 138, DECODED),
    (22, 138, CONTINUE),
    (1, 139, DECODED),
    (22, 139, CONTINUE),
    (1, 140, DECODED),
    (22, 140, CONTINUE),
    (1, 141, DECODED),
    (22, 141, CONTINUE),
    (1, 143, DECODED),
    (22, 143, CONTINUE),
  ],
  [
    (2, 1, DECODED),
    (9, 1, DECODED),
    (23, 1, DECODED),
    (40, 1, CONTINUE),
    (2, 135, DECODED),
    (9, 135, DECODED),
    (23, 135, DECODED),
    (40, 135, CONTINUE),
    (2, 137, DECODED),
    (9, 137, DECODED),
    (23, 137, DECODED),
    (40, 137, CONTINUE),
    (2, 138, DECODED),
    (9, 138, DECODED),
    (23, 138, DECODED),
    (40, 138, CONTINUE),
  ],
  [
    (3, 1, DECODED),
    (6, 1, DECODED),
    (10, 1, DECODED),
    (15, 1, DECODED),
    (24, 1, DECODED),
    (31, 1, DECODED),
    (41, 1, DECODED),
    (56, 1, CONTINUE),
    (3, 135, DECODED),
    (6, 135, DECODED),
    (10, 135, DECODED),
    (15, 135, DECODED),
    (24, 135, DECODED),
    (31, 135, DECODED),
    (41, 135, DECODED),
    (56, 135, CONTINUE),
  ],
  [
    (3, 137, DECODED),
    (6, 137, DECODED),
    (10, 137, DECODED),
    (15, 137, DECODED),
    (24, 137, DECODED),
    (31, 137, DECODED),
    (41, 137, DECODED),
    (56, 137, CONTINUE),
    (3, 138, DECODED),
    (6, 138, DECODED),
    (10, 138, DECODED),
    (15, 138, DECODED),
    (24, 138, DECODED),
    (31, 138, DECODED),
    (41, 138, DECODED),
    (56, 138, CONTINUE),
  ],
  [
    (2, 139, DECODED),
    (9, 139, DECODED),
    (23, 139, DECODED),
    (40, 139, CONTINUE),
    (2, 140, DECODED),
    (9, 140, DECODED),
    (23, 140, DECODED),
    (40, 140, CONTINUE),
    (2, 141, DECODED),
    (9, 141, DECODED),
    (23, 141, DECODED),
    (40, 141, CONTINUE),
    (2, 143, DECODED),
    (9, 143, DECODED),
    (23, 143, DECODED),
    (40, 143, CONTINUE),
  ],
  [
    (3, 139, DECODED),
    (6, 139, DECODED),
    (10, 139, DECODED),
    (15, 139, DECODED),
    (24, 139, DECODED),
    (31, 139, DECODED),
    (41, 139, DECODED),
    (56, 139, CONTINUE),
    (3, 140, DECODED),
    (6, 140, DECODED),
    (10, 140, DECODED),
    (15, 140, DECODED),
    (24, 140, DECODED),
    (31, 140, DECODED),
    (41, 140, DECODED),
    (56, 140, CONTINUE),
  ],
  [
    (3, 141, DECODED),
    (6, 141, DECODED),
    (10, 141, DECODED),
    (15, 141, DECODED),
    (24, 141, DECODED),
    (31, 141, DECODED),
    (41, 141, DECODED),
    (56, 141, CONTINUE),
    (3, 143, DECODED),
    (6, 143, DECODED),
    (10, 143, DECODED),
    (15, 143, DECODED),
    (24, 143, DECODED),
    (31, 143, DECODED),
    (41, 143, DECODED),
    (56, 143, CONTINUE),
  ],
  [
    (157, 0, OK),
    (158, 0, OK),
    (160, 0, OK),
    (161, 0, OK),
    (164, 0, OK),
    (165, 0, OK),
    (167, 0, OK),
    (168, 0, OK),
    (172, 0, OK),
    (173, 0, OK),
    (175, 0, OK),
    (177, 0, OK),
    (182, 0, OK),
    (185, 0, OK),
    (191, 0, OK),
    (207, 0, OK),
  ],
  [
    (0, 147, DECODED),
    (0, 149, DECODED),
    (0, 150, DECODED),
    (0, 151, DECODED),
    (0, 152, DECODED),
    (0, 155, DECODED),
    (0, 157, DECODED),
    (0, 158, DECODED),
    (0, 165, DECODED),
    (0, 166, DECODED),
    (0, 168, DECODED),
    (0, 174, DECODED),
    (0, 175, DECODED),
    (0, 180, DECODED),
    (0, 182, DECODED),
    (0, 183, DECODED),
  ],
  [
    (1, 147, DECODED),
    (22, 147, CONTINUE),
    (1, 149, DECODED),
    (22, 149, CONTINUE),
    (1, 150, DECODED),
    (22, 150, CONTINUE),
    (1, 151, DECODED),
    (22, 151, CONTINUE),
    (1, 152, DECODED),
    (22, 152, CONTINUE),
    (1, 155, DECODED),
    (22, 155, CONTINUE),
    (1, 157, DECODED),
    (22, 157, CONTINUE),
    (1, 158, DECODED),
    (22, 158, CONTINUE),
  ],
  [
    (2, 147, DECODED),
    (9, 147, DECODED),
    (23, 147, DECODED),
    (40, 147, CONTINUE),
    (2, 149, DECODED),
    (9, 149, DECODED),
    (23, 149, DECODED),
    (40, 149, CONTINUE),
    (2, 150, DECODED),
    (9, 150, DECODED),
    (23, 150, DECODED),
    (40, 150, CONTINUE),
    (2, 151, DECODED),
    (9, 151, DECODED),
    (23, 151, DECODED),
    (40, 151, CONTINUE),
  ],
  [
    (3, 147, DECODED),
    (6, 147, DECODED),
    (10, 147, DECODED),
    (15, 147, DECODED),
    (24, 147, DECODED),
    (31, 147, DECODED),
    (41, 147, DECODED),
    (56, 147, CONTINUE),
    (3, 149, DECODED),
    (6, 149, DECODED),
    (10, 149, DECODED),
    (15, 149, DECODED),
    (24, 149, DECODED),
    (31, 149, DECODED),
    (41, 149, DECODED),
    (56, 149, CONTINUE),
  ],
  [
    (3, 150, DECODED),
    (6, 150, DECODED),
    (10, 150, DECODED),
    (15, 150, DECODED),
    (24, 150, DECODED),
    (31, 150, DECODED),
    (41, 150, DECODED),
    (56, 150, CONTINUE),
    (3, 151, DECODED),
    (6, 151, DECODED),
    (10, 151, DECODED),
    (15, 151, DECODED),
    (24, 151, DECODED),
    (31, 151, DECODED),
    (41, 151, DECODED),
    (56, 151, CONTINUE),
  ],
  [
    (2, 152, DECODED),
    (9, 152, DECODED),
    (23, 152, DECODED),
    (40, 152, CONTINUE),
    (2, 155, DECODED),
    (9, 155, DECODED),
    (23, 155, DECODED),
    (40, 155, CONTINUE),
    (2, 157, DECODED),
    (9, 157, DECODED),
    (23, 157, DECODED),
    (40, 157, CONTINUE),
    (2, 158, DECODED),
    (9, 158, DECODED),
    (23, 158, DECODED),
    (40, 158, CONTINUE),
  ],
  [
    (3, 152, DECODED),
    (6, 152, DECODED),
    (10, 152, DECODED),
    (15, 152, DECODED),
    (24, 152, DECODED),
    (31, 152, DECODED),
    (41, 152, DECODED),
    (56, 152, CONTINUE),
    (3, 155, DECODED),
    (6, 155, DECODED),
    (10, 155, DECODED),
    (15, 155, DECODED),
    (24, 155, DECODED),
    (31, 155, DECODED),
    (41, 155, DECODED),
    (56, 155, CONTINUE),
  ],
  [
    (3, 157, DECODED),
    (6, 157, DECODED),
    (10, 157, DECODED),
    (15, 157, DECODED),
    (24, 157, DECODED),
    (31, 157, DECODED),
    (41, 157, DECODED),
    (56, 157, CONTINUE),
    (3, 158, DECODED),
    (6, 158, DECODED),
    (10, 158, DECODED),
    (15, 158, DECODED),
    (24, 158, DECODED),
    (31, 158, DECODED),
    (41, 158, DECODED),
    (56, 158, CONTINUE),
  ],
  [
    (1, 165, DECODED),
    (22, 165, CONTINUE),
    (1, 166, DECODED),
    (22, 166, CONTINUE),
    (1, 168, DECODED),
    (22, 168, CONTINUE),
    (1, 174, DECODED),
    (22, 174, CONTINUE),
    (1, 175, DECODED),
    (22, 175, CONTINUE),
    (1, 180, DECODED),
    (22, 180, CONTINUE),
    (1, 182, DECODED),
    (22, 182, CONTINUE),
    (1, 183, DECODED),
    (22, 183, CONTINUE),
  ],
  [
    (2, 165, DECODED),
    (9, 165, DECODED),
    (23, 165, DECODED),
    (40, 165, CONTINUE),
    (2, 166, DECODED),
    (9, 166, DECODED),
    (23, 166, DECODED),
    (40, 166, CONTINUE),
    (2, 168, DECODED),
    (9, 168, DECODED),
    (23, 168, DECODED),
    (40, 168, CONTINUE),
    (2, 174, DECODED),
    (9, 174, DECODED),
    (23, 174, DECODED),
    (40, 174, CONTINUE),
  ],
  [
    (3, 165, DECODED),
    (6, 165, DECODED),
    (10, 165, DECODED),
    (15, 165, DECODED),
    (24, 165, DECODED),
    (31, 165, DECODED),
    (41, 165, DECODED),
    (56, 165, CONTINUE),
    (3, 166, DECODED),
    (6, 166, DECODED),
    (10, 166, DECODED),
    (15, 166, DECODED),
    (24, 166, DECODED),
    (31, 166, DECODED),
    (41, 166, DECODED),
    (56, 166, CONTINUE),
  ],
  [
    (3, 168, DECODED),
    (6, 168, DECODED),
    (10, 168, DECODED),
    (15, 168, DECODED),
    (24, 168, DECODED),
    (31, 168, DECODED),
    (41, 168, DECODED),
    (56, 168, CONTINUE),
    (3, 174, DECODED),
    (6, 174, DECODED),
    (10, 174, DECODED),
    (15, 174, DECODED),
    (24, 174, DECODED),
    (31, 174, DECODED),
    (41, 174, DECODED),
    (56, 174, CONTINUE),
  ],
  [
    (2, 175, DECODED),
    (9, 175, DECODED),
    (23, 175, DECODED),
    (40, 175, CONTINUE),
    (2, 180, DECODED),
    (9, 180, DECODED),
    (23, 180, DECODED),
    (40, 180, CONTINUE),
    (2, 182, DECODED),
    (9, 182, DECODED),
    (23, 182, DECODED),
    (40, 182, CONTINUE),
    (2, 183, DECODED),
    (9, 183, DECODED),
    (23, 183, DECODED),
    (40, 183, CONTINUE),
  ],
  [
    (3, 175, DECODED),
    (6, 175, DECODED),
    (10, 175, DECODED),
    (15, 175, DECODED),
    (24, 175, DECODED),
    (31, 175, DECODED),
    (41, 175, DECODED),
    (56, 175, CONTINUE),
    (3, 180, DECODED),
    (6, 180, DECODED),
    (10, 180, DECODED),
    (15, 180, DECODED),
    (24, 180, DECODED),
    (31, 180, DECODED),
    (41, 180, DECODED),
    (56, 180, CONTINUE),
  ],
  [
    (3, 182, DECODED),
    (6, 182, DECODED),
    (10, 182, DECODED),
    (15, 182, DECODED),
    (24, 182, DECODED),
    (31, 182, DECODED),
    (41, 182, DECODED),
    (56, 182, CONTINUE),
    (3, 183, DECODED),
    (6, 183, DECODED),
    (10, 183, DECODED),
    (15, 183, DECODED),
    (24, 183, DECODED),
    (31, 183, DECODED),
    (41, 183, DECODED),
    (56, 183, CONTINUE),
  ],
  [
    (0, 188, DECODED),
    (0, 191, DECODED),
    (0, 197, DECODED),
    (0, 231, DECODED),
    (0, 239, DECODED),
    (176, 0, OK),
    (178, 0, OK),
    (179, 0, OK),
    (183, 0, OK),
    (184, 0, OK),
    (186, 0, OK),
    (187, 0, OK),
    (192, 0, OK),
    (199, 0, OK),
    (208, 0, OK),
    (223, 0, OK),
  ],
  [
    (1, 188, DECODED),
    (22, 188, CONTINUE),
    (1, 191, DECODED),
    (22, 191, CONTINUE),
    (1, 197, DECODED),
    (22, 197, CONTINUE),
    (1, 231, DECODED),
    (22, 231, CONTINUE),
    (1, 239, DECODED),
    (22, 239, CONTINUE),
    (0, 9, DECODED),
    (0, 142, DECODED),
    (0, 144, DECODED),
    (0, 145, DECODED),
    (0, 148, DECODED),
    (0, 159, DECODED),
  ],
  [
    (2, 188, DECODED),
    (9, 188, DECODED),
    (23, 188, DECODED),
    (40, 188, CONTINUE),
    (2, 191, DECODED),
    (9, 191, DECODED),
    (23, 191, DECODED),
    (40, 191, CONTINUE),
    (2, 197, DECODED),
    (9, 197, DECODED),
    (23, 197, DECODED),
    (40, 197, CONTINUE),
    (2, 231, DECODED),
    (9, 231, DECODED),
    (23, 231, DECODED),
    (40, 231, CONTINUE),
  ],
  [
    (3, 188, DECODED),
    (6, 188, DECODED),
    (10, 188, DECODED),
    (15, 188, DECODED),
    (24, 188, DECODED),
    (31, 188, DECODED),
    (41, 188, DECODED),
    (56, 188, CONTINUE),
    (3, 191, DECODED),
    (6, 191, DECODED),
    (10, 191, DECODED),
    (15, 191, DECODED),
    (24, 191, DECODED),
    (31, 191, DECODED),
    (41, 191, DECODED),
    (56, 191, CONTINUE),
  ],
  [
    (3, 197, DECODED),
    (6, 197, DECODED),
    (10, 197, DECODED),
    (15, 197, DECODED),
    (24, 197, DECODED),
    (31, 197, DECODED),
    (41, 197, DECODED),
    (56, 197, CONTINUE),
    (3, 231, DECODED),
    (6, 231, DECODED),
    (10, 231, DECODED),
    (15, 231, DECODED),
    (24, 231, DECODED),
    (31, 231, DECODED),
    (41, 231, DECODED),
    (56, 231, CONTINUE),
  ],
  [
    (2, 239, DECODED),
    (9, 239, DECODED),
    (23, 239, DECODED),
    (40, 239, CONTINUE),
    (1, 9, DECODED),
    (22, 9, CONTINUE),
    (1, 142, DECODED),
    (22, 142, CONTINUE),
    (1, 144, DECODED),
    (22, 144, CONTINUE),
    (1, 145, DECODED),
    (22, 145, CONTINUE),
    (1, 148, DECODED),
    (22, 148, CONTINUE),
    (1, 159, DECODED),
    (22, 159, CONTINUE),
  ],
  [
    (3, 239, DECODED),
    (6, 239, DECODED),
    (10, 239, DECODED),
    (15, 239, DECODED),
    (24, 239, DECODED),
    (31, 239, DECODED),
    (41, 239, DECODED),
    (56, 239, CONTINUE),
    (2, 9, DECODED),
    (9, 9, DECODED),
    (23, 9, DECODED),
    (40, 9, CONTINUE),
    (2, 142, DECODED),
    (9, 142, DECODED),
    (23, 142, DECODED),
    (40, 142, CONTINUE),
  ],
  [
    (3, 9, DECODED),
    (6, 9, DECODED),
    (10, 9, DECODED),
    (15, 9, DECODED),
    (24, 9, DECODED),
    (31, 9, DECODED),
    (41, 9, DECODED),
    (56, 9, CONTINUE),
    (3, 142, DECODED),
    (6, 142, DECODED),
    (10, 142, DECODED),
    (15, 142, DECODED),
    (24, 142, DECODED),
    (31, 142, DECODED),
    (41, 142, DECODED),
    (56, 142, CONTINUE),
  ],
  [
    (2, 144, DECODED),
    (9, 144, DECODED),
    (23, 144, DECODED),
    (40, 144, CONTINUE),
    (2, 145, DECODED),
    (9, 145, DECODED),
    (23, 145, DECODED),
    (40, 145, CONTINUE),
    (2, 148, DECODED),
    (9, 148, DECODED),
    (23, 148, DECODED),
    (40, 148, CONTINUE),
    (2, 159, DECODED),
    (9, 159, DECODED),
    (23, 159, DECODED),
    (40, 159, CONTINUE),
  ],
  [
    (3, 144, DECODED),
    (6, 144, DECODED),
    (10, 144, DECODED),
    (15, 144, DECODED),
    (24, 144, DECODED),
    (31, 144, DECODED),
    (41, 144, DECODED),
    (56, 144, CONTINUE),
    (3, 145, DECODED),
    (6, 145, DECODED),
    (10, 145, DECODED),
    (15, 145, DECODED),
    (24, 145, DECODED),
    (31, 145, DECODED),
    (41, 145, DECODED),
    (56, 145, CONTINUE),
  ],
  [
    (3, 148, DECODED),
    (6, 148, DECODED),
    (10, 148, DECODED),
    (15, 148, DECODED),
    (24, 148, DECODED),
    (31, 148, DECODED),
    (41, 148, DECODED),
    (56, 148, CONTINUE),
    (3, 159, DECODED),
    (6, 159, DECODED),
    (10, 159, DECODED),
    (15, 159, DECODED),
    (24, 159, DECODED),
    (31, 159, DECODED),
    (41, 159, DECODED),
    (56, 159, CONTINUE),
  ],
  [
    (0, 171, DECODED),
    (0, 206, DECODED),
    (0, 215, DECODED),
    (0, 225, DECODED),
    (0, 236, DECODED),
    (0, 237, DECODED),
    (188, 0, OK),
    (189, 0, OK),
    (193, 0, OK),
    (196, 0, OK),
    (200, 0, OK),
    (203, 0, OK),
    (209, 0, OK),
    (216, 0, OK),
    (224, 0, OK),
    (238, 0, OK),
  ],
  [
    (1, 171, DECODED),
    (22, 171, CONTINUE),
    (1, 206, DECODED),
    (22, 206, CONTINUE),
    (1, 215, DECODED),
    (22, 215, CONTINUE),
    (1, 225, DECODED),
    (22, 225, CONTINUE),
    (1, 236, DECODED),
    (22, 236, CONTINUE),
    (1, 237, DECODED),
    (22, 237, CONTINUE),
    (0, 199, DECODED),
    (0, 207, DECODED),
    (0, 234, DECODED),
    (0, 235, DECODED),
  ],
  [
    (2, 171, DECODED),
    (9, 171, DECODED),
    (23, 171, DECODED),
    (40, 171, CONTINUE),
    (2, 206, DECODED),
    (9, 206, DECODED),
    (23, 206, DECODED),
    (40, 206, CONTINUE),
    (2, 215, DECODED),
    (9, 215, DECODED),
    (23, 215, DECODED),
    (40, 215, CONTINUE),
    (2, 225, DECODED),
    (9, 225, DECODED),
    (23, 225, DECODED),
    (40, 225, CONTINUE),
  ],
  [
    (3, 171, DECODED),
    (6, 171, DECODED),
    (10, 171, DECODED),
    (15, 171, DECODED),
    (24, 171, DECODED),
    (31, 171, DECODED),
    (41, 171, DECODED),
    (56, 171, CONTINUE),
    (3, 206, DECODED),
    (6, 206, DECODED),
    (10, 206, DECODED),
    (15, 206, DECODED),
    (24, 206, DECODED),
    (31, 206, DECODED),
    (41, 206, DECODED),
    (56, 206, CONTINUE),
  ],
  [
    (3, 215, DECODED),
    (6, 215, DECODED),
    (10, 215, DECODED),
    (15, 215, DECODED),
    (24, 215, DECODED),
    (31, 215, DECODED),
    (41, 215, DECODED),
    (56, 215, CONTINUE),
    (3, 225, DECODED),
    (6, 225, DECODED),
    (10, 225, DECODED),
    (15, 225, DECODED),
    (24, 225, DECODED),
    (31, 225, DECODED),
    (41, 225, DECODED),
    (56, 225, CONTINUE),
  ],
  [
    (2, 236, DECODED),
    (9, 236, DECODED),
    (23, 236, DECODED),
    (40, 236, CONTINUE),
    (2, 237, DECODED),
    (9, 237, DECODED),
    (23, 237, DECODED),
    (40, 237, CONTINUE),
    (1, 199, DECODED),
    (22, 199, CONTINUE),
    (1, 207, DECODED),
    (22, 207, CONTINUE),
    (1, 234, DECODED),
    (22, 234, CONTINUE),
    (1, 235, DECODED),
    (22, 235, CONTINUE),
  ],
  [
    (3, 236, DECODED),
    (6, 236, DECODED),
    (10, 236, DECODED),
    (15, 236, DECODED),
    (24, 236, DECODED),
    (31, 236, DECODED),
    (41, 236, DECODED),
    (56, 236, CONTINUE),
    (3, 237, DECODED),
    (6, 237, DECODED),
    (10, 237, DECODED),
    (15, 237, DECODED),
    (24, 237, DECODED),
    (31, 237, DECODED),
    (41, 237, DECODED),
    (56, 237, CONTINUE),
  ],
  [
    (2, 199, DECODED),
    (9, 199, DECODED),
    (23, 199, DECODED),
    (40, 199, CONTINUE),
    (2, 207, DECODED),
    (9, 207, DECODED),
    (23, 207, DECODED),
    (40, 207, CONTINUE),
    (2, 234, DECODED),
    (9, 234, DECODED),
    (23, 234, DECODED),
    (40, 234, CONTINUE),
    (2, 235, DECODED),
    (9, 235, DECODED),
    (23, 235, DECODED),
    (40, 235, CONTINUE),
  ],
  [
    (3, 199, DECODED),
    (6, 199, DECODED),
    (10, 199, DECODED),
    (15, 199, DECODED),
    (24, 199, DECODED),
    (31, 199, DECODED),
    (41, 199, DECODED),
    (56, 199, CONTINUE),
    (3, 207, DECODED),
    (6, 207, DECODED),
    (10, 207, DECODED),
    (15, 207, DECODED),
    (24, 207, DECODED),
    (31, 207, DECODED),
    (41, 207, DECODED),
    (56, 207, CONTINUE),
  ],
  [
    (3, 234, DECODED),
    (6, 234, DECODED),
    (10, 234, DECODED),
    (15, 234, DECODED),
    (24, 234, DECODED),
    (31, 234, DECODED),
    (41, 234, DECODED),
    (56, 234, CONTINUE),
    (3, 235, DECODED),
    (6, 235, DECODED),
    (10, 235, DECODED),
    (15, 235, DECODED),
    (24, 235, DECODED),
    (31, 235, DECODED),
    (41, 235, DECODED),
    (56, 235, CONTINUE),
  ],
  [
    (194, 0, OK),
    (195, 0, OK),
    (197, 0, OK),
    (198, 0, OK),
    (201, 0, OK),
    (202, 0, OK),
    (204, 0, OK),
    (205, 0, OK),
    (210, 0, OK),
    (213, 0, OK),
    (217, 0, OK),
    (220, 0, OK),
    (225, 0, OK),
    (231, 0, OK),
    (239, 0, OK),
    (246, 0, OK),
  ],
  [
    (0, 192, DECODED),
    (0, 193, DECODED),
    (0, 200, DECODED),
    (0, 201, DECODED),
    (0, 202, DECODED),
    (0, 205, DECODED),
    (0, 210, DECODED),
    (0, 213, DECODED),
    (0, 218, DECODED),
    (0, 219, DECODED),
    (0, 238, DECODED),
    (0, 240, DECODED),
    (0, 242, DECODED),
    (0, 243, DECODED),
    (0, 255, DECODED),
    (206, 0, OK),
  ],
  [
    (1, 192, DECODED),
    (22, 192, CONTINUE),
    (1, 193, DECODED),
    (22, 193, CONTINUE),
    (1, 200, DECODED),
    (22, 200, CONTINUE),
    (1, 201, DECODED),
    (22, 201, CONTINUE),
    (1, 202, DECODED),
    (22, 202, CONTINUE),
    (1, 205, DECODED),
    (22, 205, CONTINUE),
    (1, 210, DECODED),
    (22, 210, CONTINUE),
    (1, 213, DECODED),
    (22, 213, CONTINUE),
  ],
  [
    (2, 192, DECODED),
    (9, 192, DECODED),
    (23, 192, DECODED),
    (40, 192, CONTINUE),
    (2, 193, DECODED),
    (9, 193, DECODED),
    (23, 193, DECODED),
    (40, 193, CONTINUE),
    (2, 200, DECODED),
    (9, 200, DECODED),
    (23, 200, DECODED),
    (40, 200, CONTINUE),
    (2, 201, DECODED),
    (9, 201, DECODED),
    (23, 201, DECODED),
    (40, 201, CONTINUE),
  ],
  [
    (3, 192, DECODED),
    (6, 192, DECODED),
    (10, 192, DECODED),
    (15, 192, DECODED),
    (24, 192, DECODED),
    (31, 192, DECODED),
    (41, 192, DECODED),
    (56, 192, CONTINUE),
    (3, 193, DECODED),
    (6, 193, DECODED),
    (10, 193, DECODED),
    (15, 193, DECODED),
    (24, 193, DECODED),
    (31, 193, DECODED),
    (41, 193, DECODED),
    (56, 193, CONTINUE),
  ],
  [
    (3, 200, DECODED),
    (6, 200, DECODED),
    (10, 200, DECODED),
    (15, 200, DECODED),
    (24, 200, DECODED),
    (31, 200, DECODED),
    (41, 200, DECODED),
    (56, 200, CONTINUE),
    (3, 201, DECODED),
    (6, 201, DECODED),
    (10, 201, DECODED),
    (15, 201, DECODED),
    (24, 201, DECODED),
    (31, 201, DECODED),
    (41, 201, DECODED),
    (56, 201, CONTINUE),
  ],
  [
    (2, 202, DECODED),
    (9, 202, DECODED),
    (23, 202, DECODED),
    (40, 202, CONTINUE),
    (2, 205, DECODED),
    (9, 205, DECODED),
    (23, 205, DECODED),
    (40, 205, CONTINUE),
    (2, 210, DECODED),
    (9, 210, DECODED),
    (23, 210, DECODED),
    (40, 210, CONTINUE),
    (2, 213, DECODED),
    (9, 213, DECODED),
    (23, 213, DECODED),
    (40, 213, CONTINUE),
  ],
  [
    (3, 202, DECODED),
    (6, 202, DECODED),
    (10, 202, DECODED),
    (15, 202, DECODED),
    (24, 202, DECODED),
    (31, 202, DECODED),
    (41, 202, DECODED),
    (56, 202, CONTINUE),
    (3, 205, DECODED),
    (6, 205, DECODED),
    (10, 205, DECODED),
    (15, 205, DECODED),
    (24, 205, DECODED),
    (31, 205, DECODED),
    (41, 205, DECODED),
    (56, 205, CONTINUE),
  ],
  [
    (3, 210, DECODED),
    (6, 210, DECODED),
    (10, 210, DECODED),
    (15, 210, DECODED),
    (24, 210, DECODED),
    (31, 210, DECODED),
    (41, 210, DECODED),
    (56, 210, CONTINUE),
    (3, 213, DECODED),
    (6, 213, DECODED),
    (10, 213, DECODED),
    (15, 213, DECODED),
    (24, 213, DECODED),
    (31, 213, DECODED),
    (41, 213, DECODED),
    (56, 213, CONTINUE),
  ],
  [
    (1, 218, DECODED),
    (22, 218, CONTINUE),
    (1, 219, DECODED),
    (22, 219, CONTINUE),
    (1, 238, DECODED),
    (22, 238, CONTINUE),
    (1, 240, DECODED),
    (22, 240, CONTINUE),
    (1, 242, DECODED),
    (22, 242, CONTINUE),
    (1, 243, DECODED),
    (22, 243, CONTINUE),
    (1, 255, DECODED),
    (22, 255, CONTINUE),
    (0, 203, DECODED),
    (0, 204, DECODED),
  ],
  [
    (2, 218, DECODED),
    (9, 218, DECODED),
    (23, 218, DECODED),
    (40, 218, CONTINUE),
    (2, 219, DECODED),
    (9, 219, DECODED),
    (23, 219, DECODED),
    (40, 219, CONTINUE),
    (2, 238, DECODED),
    (9, 238, DECODED),
    (23, 238, DECODED),
    (40, 238, CONTINUE),
    (2, 240, DECODED),
    (9, 240, DECODED),
    (23, 240, DECODED),
    (40, 240, CONTINUE),
  ],
  [
    (3, 218, DECODED),
    (6, 218, DECODED),
    (10, 218, DECODED),
    (15, 218, DECODED),
    (24, 218, DECODED),
    (31, 218, DECODED),
    (41, 218, DECODED),
    (56, 218, CONTINUE),
    (3, 219, DECODED),
    (6, 219, DECODED),
    (10, 219, DECODED),
    (15, 219, DECODED),
    (24, 219, DECODED),
    (31, 219, DECODED),
    (41, 219, DECODED),
    (56, 219, CONTINUE),
  ],
  [
    (3, 238, DECODED),
    (6, 238, DECODED),
    (10, 238, DECODED),
    (15, 238, DECODED),
    (24, 238, DECODED),
    (31, 238, DECODED),
    (41, 238, DECODED),
    (56, 238, CONTINUE),
    (3, 240, DECODED),
    (6, 240, DECODED),
    (10, 240, DECODED),
    (15, 240, DECODED),
    (24, 240, DECODED),
    (31, 240, DECODED),
    (41, 240, DECODED),
    (56, 240, CONTINUE),
  ],
  [
    (2, 242, DECODED),
    (9, 242, DECODED),
    (23, 242, DECODED),
    (40, 242, CONTINUE),
    (2, 243, DECODED),
    (9, 243, DECODED),
    (23, 243, DECODED),
    (40, 243, CONTINUE),
    (2, 255, DECODED),
    (9, 255, DECODED),
    (23, 255, DECODED),
    (40, 255, CONTINUE),
    (1, 203, DECODED),
    (22, 203, CONTINUE),
    (1, 204, DECODED),
    (22, 204, CONTINUE),
  ],
  [
    (3, 242, DECODED),
    (6, 242, DECODED),
    (10, 242, DECODED),
    (15, 242, DECODED),
    (24, 242, DECODED),
    (31, 242, DECODED),
    (41, 242, DECODED),
    (56, 242, CONTINUE),
    (3, 243, DECODED),
    (6, 243, DECODED),
    (10, 243, DECODED),
    (15, 243, DECODED),
    (24, 243, DECODED),
    (31, 243, DECODED),
    (41, 243, DECODED),
    (56, 243, CONTINUE),
  ],
  [
    (3, 255, DECODED),
    (6, 255, DECODED),
    (10, 255, DECODED),
    (15, 255, DECODED),
    (24, 255, DECODED),
    (31, 255, DECODED),
    (41, 255, DECODED),
    (56, 255, CONTINUE),
    (2, 203, DECODED),
    (9, 203, DECODED),
    (23, 203, DECODED),
    (40, 203, CONTINUE),
    (2, 204, DECODED),
    (9, 204, DECODED),
    (23, 204, DECODED),
    (40, 204, CONTINUE),
  ],
  [
    (3, 203, DECODED),
    (6, 203, DECODED),
    (10, 203, DECODED),
    (15, 203, DECODED),
    (24, 203, DECODED),
    (31, 203, DECODED),
    (41, 203, DECODED),
    (56, 203, CONTINUE),
    (3, 204, DECODED),
    (6, 204, DECODED),
    (10, 204, DECODED),
    (15, 204, DECODED),
    (24, 204, DECODED),
    (31, 204, DECODED),
    (41, 204, DECODED),
    (56, 204, CONTINUE),
  ],
  [
    (211, 0, OK),
    (212, 0, OK),
    (214, 0, OK),
    (215, 0, OK),
    (218, 0, OK),
    (219, 0, OK),
    (221, 0, OK),
    (222, 0, OK),
    (226, 0, OK),
    (228, 0, OK),
    (232, 0, OK),
    (235, 0, OK),
    (240, 0, OK),
    (243, 0, OK),
    (247, 0, OK),
    (250, 0, OK),
  ],
  [
    (0, 211, DECODED),
    (0, 212, DECODED),
    (0, 214, DECODED),
    (0, 221, DECODED),
    (0, 222, DECODED),
    (0, 223, DECODED),
    (0, 241, DECODED),
    (0, 244, DECODED),
    (0, 245, DECODED),
    (0, 246, DECODED),
    (0, 247, DECODED),
    (0, 248, DECODED),
    (0, 250, DECODED),
    (0, 251, DECODED),
    (0, 252, DECODED),
    (0, 253, DECODED),
  ],
  [
    (1, 211, DECODED),
    (22, 211, CONTINUE),
    (1, 212, DECODED),
    (22, 212, CONTINUE),
    (1, 214, DECODED),
    (22, 214, CONTINUE),
    (1, 221, DECODED),
    (22, 221, CONTINUE),
    (1, 222, DECODED),
    (22, 222, CONTINUE),
    (1, 223, DECODED),
    (22, 223, CONTINUE),
    (1, 241, DECODED),
    (22, 241, CONTINUE),
    (1, 244, DECODED),
    (22, 244, CONTINUE),
  ],
  [
    (2, 211, DECODED),
    (9, 211, DECODED),
    (23, 211, DECODED),
    (40, 211, CONTINUE),
    (2, 212, DECODED),
    (9, 212, DECODED),
    (23, 212, DECODED),
    (40, 212, CONTINUE),
    (2, 214, DECODED),
    (9, 214, DECODED),
    (23, 214, DECODED),
    (40, 214, CONTINUE),
    (2, 221, DECODED),
    (9, 221, DECODED),
    (23, 221, DECODED),
    (40, 221, CONTINUE),
  ],
  [
    (3, 211, DECODED),
    (6, 211, DECODED),
    (10, 211, DECODED),
    (15, 211, DECODED),
    (24, 211, DECODED),
    (31, 211, DECODED),
    (41, 211, DECODED),
    (56, 211, CONTINUE),
    (3, 212, DECODED),
    (6, 212, DECODED),
    (10, 212, DECODED),
    (15, 212, DECODED),
    (24, 212, DECODED),
    (31, 212, DECODED),
    (41, 212, DECODED),
    (56, 212, CONTINUE),
  ],
  [
    (3, 214, DECODED),
    (6, 214, DECODED),
    (10, 214, DECODED),
    (15, 214, DECODED),
    (24, 214, DECODED),
    (31, 214, DECODED),
    (41, 214, DECODED),
    (56, 214, CONTINUE),
    (3, 221, DECODED),
    (6, 221, DECODED),
    (10, 221, DECODED),
    (15, 221, DECODED),
    (24, 221, DECODED),
    (31, 221, DECODED),
    (41, 221, DECODED),
    (56, 221, CONTINUE),
  ],
  [
    (2, 222, DECODED),
    (9, 222, DECODED),
    (23, 222, DECODED),
    (40, 222, CONTINUE),
    (2, 223, DECODED),
    (9, 223, DECODED),
    (23, 223, DECODED),
    (40, 223, CONTINUE),
    (2, 241, DECODED),
    (9, 241, DECODED),
    (23, 241, DECODED),
    (40, 241, CONTINUE),
    (2, 244, DECODED),
    (9, 244, DECODED),
    (23, 244, DECODED),
    (40, 244, CONTINUE),
  ],
  [
    (3, 222, DECODED),
    (6, 222, DECODED),
    (10, 222, DECODED),
    (15, 222, DECODED),
    (24, 222, DECODED),
    (31, 222, DECODED),
    (41, 222, DECODED),
    (56, 222, CONTINUE),
    (3, 223, DECODED),
    (6, 223, DECODED),
    (10, 223, DECODED),
    (15, 223, DECODED),
    (24, 223, DECODED),
    (31, 223, DECODED),
    (41, 223, DECODED),
    (56, 223, CONTINUE),
  ],
  [
    (3, 241, DECODED),
    (6, 241, DECODED),
    (10, 241, DECODED),
    (15, 241, DECODED),
    (24, 241, DECODED),
    (31, 241, DECODED),
    (41, 241, DECODED),
    (56, 241, CONTINUE),
    (3, 244, DECODED),
    (6, 244, DECODED),
    (10, 244, DECODED),
    (15, 244, DECODED),
    (24, 244, DECODED),
    (31, 244, DECODED),
    (41, 244, DECODED),
    (56, 244, CONTINUE),
  ],
  [
    (1, 245, DECODED),
    (22, 245, CONTINUE),
    (1, 246, DECODED),
    (22, 246, CONTINUE),
    (1, 247, DECODED),
    (22, 247, CONTINUE),
    (1, 248, DECODED),
    (22, 248, CONTINUE),
    (1, 250, DECODED),
    (22, 250, CONTINUE),
    (1, 251, DECODED),
    (22, 251, CONTINUE),
    (1, 252, DECODED),
    (22, 252, CONTINUE),
    (1, 253, DECODED),
    (22, 253, CONTINUE),
  ],
  [
    (2, 245, DECODED),
    (9, 245, DECODED),
    (23, 245, DECODED),
    (40, 245, CONTINUE),
    (2, 246, DECODED),
    (9, 246, DECODED),
    (23, 246, DECODED),
    (40, 246, CONTINUE),
    (2, 247, DECODED),
    (9, 247, DECODED),
    (23, 247, DECODED),
    (40, 247, CONTINUE),
    (2, 248, DECODED),
    (9, 248, DECODED),
    (23, 248, DECODED),
    (40, 248, CONTINUE),
  ],
  [
    (3, 245, DECODED),
    (6, 245, DECODED),
    (10, 245, DECODED),
    (15, 245, DECODED),
    (24, 245, DECODED),
    (31, 245, DECODED),
    (41, 245, DECODED),
    (56, 245, CONTINUE),
    (3, 246, DECODED),
    (6, 246, DECODED),
    (10, 246, DECODED),
    (15, 246, DECODED),
    (24, 246, DECODED),
    (31, 246, DECODED),
    (41, 246, DECODED),
    (56, 246, CONTINUE),
  ],
  [
    (3, 247, DECODED),
    (6, 247, DECODED),
    (10, 247, DECODED),
    (15, 247, DECODED),
    (24, 247, DECODED),
    (31, 247, DECODED),
    (41, 247, DECODED),
    (56, 247, CONTINUE),
    (3, 248, DECODED),
    (6, 248, DECODED),
    (10, 248, DECODED),
    (15, 248, DECODED),
    (24, 248, DECODED),
    (31, 248, DECODED),
    (41, 248, DECODED),
    (56, 248, CONTINUE),
  ],
  [
    (2, 250, DECODED),
    (9, 250, DECODED),
    (23, 250, DECODED),
    (40, 250, CONTINUE),
    (2, 251, DECODED),
    (9, 251, DECODED),
    (23, 251, DECODED),
    (40, 251, CONTINUE),
    (2, 252, DECODED),
    (9, 252, DECODED),
    (23, 252, DECODED),
    (40, 252, CONTINUE),
    (2, 253, DECODED),
    (9, 253, DECODED),
    (23, 253, DECODED),
    (40, 253, CONTINUE),
  ],
  [
    (3, 250, DECODED),
    (6, 250, DECODED),
    (10, 250, DECODED),
    (15, 250, DECODED),
    (24, 250, DECODED),
    (31, 250, DECODED),
    (41, 250, DECODED),
    (56, 250, CONTINUE),
    (3, 251, DECODED),
    (6, 251, DECODED),
    (10, 251, DECODED),
    (15, 251, DECODED),
    (24, 251, DECODED),
    (31, 251, DECODED),
    (41, 251, DECODED),
    (56, 251, CONTINUE),
  ],
  [
    (3, 252, DECODED),
    (6, 252, DECODED),
    (10, 252, DECODED),
    (15, 252, DECODED),
    (24, 252, DECODED),
    (31, 252, DECODED),
    (41, 252, DECODED),
    (56, 252, CONTINUE),
    (3, 253, DECODED),
    (6, 253, DECODED),
    (10, 253, DECODED),
    (15, 253, DECODED),
    (24, 253, DECODED),
    (31, 253, DECODED),
    (41, 253, DECODED),
    (56, 253, CONTINUE),
  ],
  [
    (0, 254, DECODED),
    (227, 0, OK),
    (229, 0, OK),
    (230, 0, OK),
    (233, 0, OK),
    (234, 0, OK),
    (236, 0, OK),
    (237, 0, OK),
    (241, 0, OK),
    (242, 0, OK),
    (244, 0, OK),
    (245, 0, OK),
    (248, 0, OK),
    (249, 0, OK),
    (251, 0, OK),
    (252, 0, OK),
  ],
  [
    (1, 254, DECODED),
    (22, 254, CONTINUE),
    (0, 2, DECODED),
    (0, 3, DECODED),
    (0, 4, DECODED),
    (0, 5, DECODED),
    (0, 6, DECODED),
    (0, 7, DECODED),
    (0, 8, DECODED),
    (0, 11, DECODED),
    (0, 12, DECODED),
    (0, 14, DECODED),
    (0, 15, DECODED),
    (0, 16, DECODED),
    (0, 17, DECODED),
    (0, 18, DECODED),
  ],
  [
    (2, 254, DECODED),
    (9, 254, DECODED),
    (23, 254, DECODED),
    (40, 254, CONTINUE),
    (1, 2, DECODED),
    (22, 2, CONTINUE),
    (1, 3, DECODED),
    (22, 3, CONTINUE),
    (1, 4, DECODED),
    (22, 4, CONTINUE),
    (1, 5, DECODED),
    (22, 5, CONTINUE),
    (1, 6, DECODED),
    (22, 6, CONTINUE),
    (1, 7, DECODED),
    (22, 7, CONTINUE),
  ],
  [
    (3, 254, DECODED),
    (6, 254, DECODED),
    (10, 254, DECODED),
    (15, 254, DECODED),
    (24, 254, DECODED),
    (31, 254, DECODED),
    (41, 254, DECODED),
    (56, 254, CONTINUE),
    (2, 2, DECODED),
    (9, 2, DECODED),
    (23, 2, DECODED),
    (40, 2, CONTINUE),
    (2, 3, DECODED),
    (9, 3, DECODED),
    (23, 3, DECODED),
    (40, 3, CONTINUE),
  ],
  [
    (3, 2, DECODED),
    (6, 2, DECODED),
    (10, 2, DECODED),
    (15, 2, DECODED),
    (24, 2, DECODED),
    (31, 2, DECODED),
    (41, 2, DECODED),
    (56, 2, CONTINUE),
    (3, 3, DECODED),
    (6, 3, DECODED),
    (10, 3, DECODED),
    (15, 3, DECODED),
    (24, 3, DECODED),
    (31, 3, DECODED),
    (41, 3, DECODED),
    (56, 3, CONTINUE),
  ],
  [
    (2, 4, DECODED),
    (9, 4, DECODED),
    (23, 4, DECODED),
    (40, 4, CONTINUE),
    (2, 5, DECODED),
    (9, 5, DECODED),
    (23, 5, DECODED),
    (40, 5, CONTINUE),
    (2, 6, DECODED),
    (9, 6, DECODED),
    (23, 6, DECODED),
    (40, 6, CONTINUE),
    (2, 7, DECODED),
    (9, 7, DECODED),
    (23, 7, DECODED),
    (40, 7, CONTINUE),
  ],
  [
    (3, 4, DECODED),
    (6, 4, DECODED),
    (10, 4, DECODED),
    (15, 4, DECODED),
    (24, 4, DECODED),
    (31, 4, DECODED),
    (41, 4, DECODED),
    (56, 4, CONTINUE),
    (3, 5, DECODED),
    (6, 5, DECODED),
    (10, 5, DECODED),
    (15, 5, DECODED),
    (24, 5, DECODED),
    (31, 5, DECODED),
    (41, 5, DECODED),
    (56, 5, CONTINUE),
  ],
  [
    (3, 6, DECODED),
    (6, 6, DECODED),
    (10, 6, DECODED),
    (15, 6, DECODED),
    (24, 6, DECODED),
    (31, 6, DECODED),
    (41, 6, DECODED),
    (56, 6, CONTINUE),
    (3, 7, DECODED),
    (6, 7, DECODED),
    (10, 7, DECODED),
    (15, 7, DECODED),
    (24, 7, DECODED),
    (31, 7, DECODED),
    (41, 7, DECODED),
    (56, 7, CONTINUE),
  ],
  [
    (1, 8, DECODED),
    (22, 8, CONTINUE),
    (1, 11, DECODED),
    (22, 11, CONTINUE),
    (1, 12, DECODED),
    (22, 12, CONTINUE),
    (1, 14, DECODED),
    (22, 14, CONTINUE),
    (1, 15, DECODED),
    (22, 15, CONTINUE),
    (1, 16, DECODED),
    (22, 16, CONTINUE),
    (1, 17, DECODED),
    (22, 17, CONTINUE),
    (1, 18, DECODED),
    (22, 18, CONTINUE),
  ],
  [
    (2, 8, DECODED),
    (9, 8, DECODED),
    (23, 8, DECODED),
    (40, 8, CONTINUE),
    (2, 11, DECODED),
    (9, 11, DECODED),
    (23, 11, DECODED),
    (40, 11, CONTINUE),
    (2, 12, DECODED),
    (9, 12, DECODED),
    (23, 12, DECODED),
    (40, 12, CONTINUE),
    (2, 14, DECODED),
    (9, 14, DECODED),
    (23, 14, DECODED),
    (40, 14, CONTINUE),
  ],
  [
    (3, 8, DECODED),
    (6, 8, DECODED),
    (10, 8, DECODED),
    (15, 8, DECODED),
    (24, 8, DECODED),
    (31, 8, DECODED),
    (41, 8, DECODED),
    (56, 8, CONTINUE),
    (3, 11, DECODED),
    (6, 11, DECODED),
    (10, 11, DECODED),
    (15, 11, DECODED),
    (24, 11, DECODED),
    (31, 11, DECODED),
    (41, 11, DECODED),
    (56, 11, CONTINUE),
  ],
  [
    (3, 12, DECODED),
    (6, 12, DECODED),
    (10, 12, DECODED),
    (15, 12, DECODED),
    (24, 12, DECODED),
    (31, 12, DECODED),
    (41, 12, DECODED),
    (56, 12, CONTINUE),
    (3, 14, DECODED),
    (6, 14, DECODED),
    (10, 14, DECODED),
    (15, 14, DECODED),
    (24, 14, DECODED),
    (31, 14, DECODED),
    (41, 14, DECODED),
    (56, 14, CONTINUE),
  ],
  [
    (2, 15, DECODED),
    (9, 15, DECODED),
    (23, 15, DECODED),
    (40, 15, CONTINUE),
    (2, 16, DECODED),
    (9, 16, DECODED),
    (23, 16, DECODED),
    (40, 16, CONTINUE),
    (2, 17, DECODED),
    (9, 17, DECODED),
    (23, 17, DECODED),
    (40, 17, CONTINUE),
    (2, 18, DECODED),
    (9, 18, DECODED),
    (23, 18, DECODED),
    (40, 18, CONTINUE),
  ],
  [
    (3, 15, DECODED),
    (6, 15, DECODED),
    (10, 15, DECODED),
    (15, 15, DECODED),
    (24, 15, DECODED),
    (31, 15, DECODED),
    (41, 15, DECODED),
    (56, 15, CONTINUE),
    (3, 16, DECODED),
    (6, 16, DECODED),
    (10, 16, DECODED),
    (15, 16, DECODED),
    (24, 16, DECODED),
    (31, 16, DECODED),
    (41, 16, DECODED),
    (56, 16, CONTINUE),
  ],
  [
    (3, 17, DECODED),
    (6, 17, DECODED),
    (10, 17, DECODED),
    (15, 17, DECODED),
    (24, 17, DECODED),
    (31, 17, DECODED),
    (41, 17, DECODED),
    (56, 17, CONTINUE),
    (3, 18, DECODED),
    (6, 18, DECODED),
    (10, 18, DECODED),
    (15, 18, DECODED),
    (24, 18, DECODED),
    (31, 18, DECODED),
    (41, 18, DECODED),
    (56, 18, CONTINUE),
  ],
  [
    (0, 19, DECODED),
    (0, 20, DECODED),
    (0, 21, DECODED),
    (0, 23, DECODED),
    (0, 24, DECODED),
    (0, 25, DECODED),
    (0, 26, DECODED),
    (0, 27, DECODED),
    (0, 28, DECODED),
    (0, 29, DECODED),
    (0, 30, DECODED),
    (0, 31, DECODED),
    (0, 127, DECODED),
    (0, 220, DECODED),
    (0, 249, DECODED),
    (253, 0, OK),
  ],
  [
    (1, 19, DECODED),
    (22, 19, CONTINUE),
    (1, 20, DECODED),
    (22, 20, CONTINUE),
    (1, 21, DECODED),
    (22, 21, CONTINUE),
    (1, 23, DECODED),
    (22, 23, CONTINUE),
    (1, 24, DECODED),
    (22, 24, CONTINUE),
    (1, 25, DECODED),
    (22, 25, CONTINUE),
    (1, 26, DECODED),
    (22, 26, CONTINUE),
    (1, 27, DECODED),
    (22, 27, CONTINUE),
  ],
  [
    (2, 19, DECODED),
    (9, 19, DECODED),
    (23, 19, DECODED),
    (40, 19, CONTINUE),
    (2, 20, DECODED),
    (9, 20, DECODED),
    (23, 20, DECODED),
    (40, 20, CONTINUE),
    (2, 21, DECODED),
    (9, 21, DECODED),
    (23, 21, DECODED),
    (40, 21, CONTINUE),
    (2, 23, DECODED),
    (9, 23, DECODED),
    (23, 23, DECODED),
    (40, 23, CONTINUE),
  ],
  [
    (3, 19, DECODED),
    (6, 19, DECODED),
    (10, 19, DECODED),
    (15, 19, DECODED),
    (24, 19, DECODED),
    (31, 19, DECODED),
    (41, 19, DECODED),
    (56, 19, CONTINUE),
    (3, 20, DECODED),
    (6, 20, DECODED),
    (10, 20, DECODED),
    (15, 20, DECODED),
    (24, 20, DECODED),
    (31, 20, DECODED),
    (41, 20, DECODED),
    (56, 20, CONTINUE),
  ],
  [
    (3, 21, DECODED),
    (6, 21, DECODED),
    (10, 21, DECODED),
    (15, 21, DECODED),
    (24, 21, DECODED),
    (31, 21, DECODED),
    (41, 21, DECODED),
    (56, 21, CONTINUE),
    (3, 23, DECODED),
    (6, 23, DECODED),
    (10, 23, DECODED),
    (15, 23, DECODED),
    (24, 23, DECODED),
    (31, 23, DECODED),
    (41, 23, DECODED),
    (56, 23, CONTINUE),
  ],
  [
    (2, 24, DECODED),
    (9, 24, DECODED),
    (23, 24, DECODED),
    (40, 24, CONTINUE),
    (2, 25, DECODED),
    (9, 25, DECODED),
    (23, 25, DECODED),
    (40, 25, CONTINUE),
    (2, 26, DECODED),
    (9, 26, DECODED),
    (23, 26, DECODED),
    (40, 26, CONTINUE),
    (2, 27, DECODED),
    (9, 27, DECODED),
    (23, 27, DECODED),
    (40, 27, CONTINUE),
  ],
  [
    (3, 24, DECODED),
    (6, 24, DECODED),
    (10, 24, DECODED),
    (15, 24, DECODED),
    (24, 24, DECODED),
    (31, 24, DECODED),
    (41, 24, DECODED),
    (56, 24, CONTINUE),
    (3, 25, DECODED),
    (6, 25, DECODED),
    (10, 25, DECODED),
    (15, 25, DECODED),
    (24, 25, DECODED),
    (31, 25, DECODED),
    (41, 25, DECODED),
    (56, 25, CONTINUE),
  ],
  [
    (3, 26, DECODED),
    (6, 26, DECODED),
    (10, 26, DECODED),
    (15, 26, DECODED),
    (24, 26, DECODED),
    (31, 26, DECODED),
    (41, 26, DECODED),
    (56, 26, CONTINUE),
    (3, 27, DECODED),
    (6, 27, DECODED),
    (10, 27, DECODED),
    (15, 27, DECODED),
    (24, 27, DECODED),
    (31, 27, DECODED),
    (41, 27, DECODED),
    (56, 27, CONTINUE),
  ],
  [
    (1, 28, DECODED),
    (22, 28, CONTINUE),
    (1, 29, DECODED),
    (22, 29, CONTINUE),
    (1, 30, DECODED),
    (22, 30, CONTINUE),
    (1, 31, DECODED),
    (22, 31, CONTINUE),
    (1, 127, DECODED),
    (22, 127, CONTINUE),
    (1, 220, DECODED),
    (22, 220, CONTINUE),
    (1, 249, DECODED),
    (22, 249, CONTINUE),
    (254, 0, OK),
    (255, 0, OK),
  ],
  [
    (2, 28, DECODED),
    (9, 28, DECODED),
    (23, 28, DECODED),
    (40, 28, CONTINUE),
    (2, 29, DECODED),
    (9, 29, DECODED),
    (23, 29, DECODED),
    (40, 29, CONTINUE),
    (2, 30, DECODED),
    (9, 30, DECODED),
    (23, 30, DECODED),
    (40, 30, CONTINUE),
    (2, 31, DECODED),
    (9, 31, DECODED),
    (23, 31, DECODED),
    (40, 31, CONTINUE),
  ],
  [
    (3, 28, DECODED),
    (6, 28, DECODED),
    (10, 28, DECODED),
    (15, 28, DECODED),
    (24, 28, DECODED),
    (31, 28, DECODED),
    (41, 28, DECODED),
    (56, 28, CONTINUE),
    (3, 29, DECODED),
    (6, 29, DECODED),
    (10, 29, DECODED),
    (15, 29, DECODED),
    (24, 29, DECODED),
    (31, 29, DECODED),
    (41, 29, DECODED),
    (56, 29, CONTINUE),
  ],
  [
    (3, 30, DECODED),
    (6, 30, DECODED),
    (10, 30, DECODED),
    (15, 30, DECODED),
    (24, 30, DECODED),
    (31, 30, DECODED),
    (41, 30, DECODED),
    (56, 30, CONTINUE),
    (3, 31, DECODED),
    (6, 31, DECODED),
    (10, 31, DECODED),
    (15, 31, DECODED),
    (24, 31, DECODED),
    (31, 31, DECODED),
    (41, 31, DECODED),
    (56, 31, CONTINUE),
  ],
  [
    (2, 127, DECODED),
    (9, 127, DECODED),
    (23, 127, DECODED),
    (40, 127, CONTINUE),
    (2, 220, DECODED),
    (9, 220, DECODED),
    (23, 220, DECODED),
    (40, 220, CONTINUE),
    (2, 249, DECODED),
    (9, 249, DECODED),
    (23, 249, DECODED),
    (40, 249, CONTINUE),
    (0, 10, DECODED),
    (0, 13, DECODED),
    (0, 22, DECODED),
    (0, 0, ERROR),
  ],
  [
    (3, 127, DECODED),
    (6, 127, DECODED),
    (10, 127, DECODED),
    (15, 127, DECODED),
    (24, 127, DECODED),
    (31, 127, DECODED),
    (41, 127, DECODED),
    (56, 127, CONTINUE),
    (3, 220, DECODED),
    (6, 220, DECODED),
    (10, 220, DECODED),
    (15, 220, DECODED),
    (24, 220, DECODED),
    (31, 220, DECODED),
    (41, 220, DECODED),
    (56, 220, CONTINUE),
  ],
  [
    (3, 249, DECODED),
    (6, 249, DECODED),
    (10, 249, DECODED),
    (15, 249, DECODED),
    (24, 249, DECODED),
    (31, 249, DECODED),
    (41, 249, DECODED),
    (56, 249, CONTINUE),
    (1, 10, DECODED),
    (22, 10, CONTINUE),
    (1, 13, DECODED),
    (22, 13, CONTINUE),
    (1, 22, DECODED),
    (22, 22, CONTINUE),
    (0, 0, ERROR),
    (0, 0, 0x05),
  ],
  [
    (2, 10, DECODED),
    (9, 10, DECODED),
    (23, 10, DECODED),
    (40, 10, CONTINUE),
    (2, 13, DECODED),
    (9, 13, DECODED),
    (23, 13, DECODED),
    (40, 13, CONTINUE),
    (2, 22, DECODED),
    (9, 22, DECODED),
    (23, 22, DECODED),
    (40, 22, CONTINUE),
    (0, 0, ERROR),
    (0, 0, ERROR),
    (0, 0, ERROR),
    (0, 0, 0x05),
  ],
  [
    (3, 10, DECODED),
    (6, 10, DECODED),
    (10, 10, DECODED),
    (15, 10, DECODED),
    (24, 10, DECODED),
    (31, 10, DECODED),
    (41, 10, DECODED),
    (56, 10, CONTINUE),
    (3, 13, DECODED),
    (6, 13, DECODED),
    (10, 13, DECODED),
    (15, 13, DECODED),
    (24, 13, DECODED),
    (31, 13, DECODED),
    (41, 13, DECODED),
    (56, 13, CONTINUE),
  ],
  [
    (3, 22, DECODED),
    (6, 22, DECODED),
    (10, 22, DECODED),
    (15, 22, DECODED),
    (24, 22, DECODED),
    (31, 22, DECODED),
    (41, 22, DECODED),
    (56, 22, CONTINUE),
    (0, 0, ERROR),
    (0, 0, ERROR),
    (0, 0, ERROR),
    (0, 0, ERROR),
    (0, 0, ERROR),
    (0, 0, ERROR),
    (0, 0, ERROR),
    (0, 0, 0x05),
  ],
];

pub(crate) const ENCODE_TABLE: &[(u8, u64); 257] = &[
  (13, 0x1ff8),
  (23, 0x007f_ffd8),
  (28, 0x0fff_ffe2),
  (28, 0x0fff_ffe3),
  (28, 0x0fff_ffe4),
  (28, 0x0fff_ffe5),
  (28, 0x0fff_ffe6),
  (28, 0x0fff_ffe7),
  (28, 0x0fff_ffe8),
  (24, 0x00ff_ffea),
  (30, 0x3fff_fffc),
  (28, 0x0fff_ffe9),
  (28, 0x0fff_ffea),
  (30, 0x3fff_fffd),
  (28, 0x0fff_ffeb),
  (28, 0x0fff_ffec),
  (28, 0x0fff_ffed),
  (28, 0x0fff_ffee),
  (28, 0x0fff_ffef),
  (28, 0x0fff_fff0),
  (28, 0x0fff_fff1),
  (28, 0x0fff_fff2),
  (30, 0x3fff_fffe),
  (28, 0x0fff_fff3),
  (28, 0x0fff_fff4),
  (28, 0x0fff_fff5),
  (28, 0x0fff_fff6),
  (28, 0x0fff_fff7),
  (28, 0x0fff_fff8),
  (28, 0x0fff_fff9),
  (28, 0x0fff_fffa),
  (28, 0x0fff_fffb),
  (6, 0x14),
  (10, 0x3f8),
  (10, 0x3f9),
  (12, 0xffa),
  (13, 0x1ff9),
  (6, 0x15),
  (8, 0xf8),
  (11, 0x7fa),
  (10, 0x3fa),
  (10, 0x3fb),
  (8, 0xf9),
  (11, 0x7fb),
  (8, 0xfa),
  (6, 0x16),
  (6, 0x17),
  (6, 0x18),
  (5, 0x0),
  (5, 0x1),
  (5, 0x2),
  (6, 0x19),
  (6, 0x1a),
  (6, 0x1b),
  (6, 0x1c),
  (6, 0x1d),
  (6, 0x1e),
  (6, 0x1f),
  (7, 0x5c),
  (8, 0xfb),
  (15, 0x7ffc),
  (6, 0x20),
  (12, 0xffb),
  (10, 0x3fc),
  (13, 0x1ffa),
  (6, 0x21),
  (7, 0x5d),
  (7, 0x5e),
  (7, 0x5f),
  (7, 0x60),
  (7, 0x61),
  (7, 0x62),
  (7, 0x63),
  (7, 0x64),
  (7, 0x65),
  (7, 0x66),
  (7, 0x67),
  (7, 0x68),
  (7, 0x69),
  (7, 0x6a),
  (7, 0x6b),
  (7, 0x6c),
  (7, 0x6d),
  (7, 0x6e),
  (7, 0x6f),
  (7, 0x70),
  (7, 0x71),
  (7, 0x72),
  (8, 0xfc),
  (7, 0x73),
  (8, 0xfd),
  (13, 0x1ffb),
  (19, 0x7fff0),
  (13, 0x1ffc),
  (14, 0x3ffc),
  (6, 0x22),
  (15, 0x7ffd),
  (5, 0x3),
  (6, 0x23),
  (5, 0x4),
  (6, 0x24),
  (5, 0x5),
  (6, 0x25),
  (6, 0x26),
  (6, 0x27),
  (5, 0x6),
  (7, 0x74),
  (7, 0x75),
  (6, 0x28),
  (6, 0x29),
  (6, 0x2a),
  (5, 0x7),
  (6, 0x2b),
  (7, 0x76),
  (6, 0x2c),
  (5, 0x8),
  (5, 0x9),
  (6, 0x2d),
  (7, 0x77),
  (7, 0x78),
  (7, 0x79),
  (7, 0x7a),
  (7, 0x7b),
  (15, 0x7ffe),
  (11, 0x7fc),
  (14, 0x3ffd),
  (13, 0x1ffd),
  (28, 0x0fff_fffc),
  (20, 0xfffe6),
  (22, 0x003f_ffd2),
  (20, 0xfffe7),
  (20, 0xfffe8),
  (22, 0x003f_ffd3),
  (22, 0x003f_ffd4),
  (22, 0x003f_ffd5),
  (23, 0x007f_ffd9),
  (22, 0x003f_ffd6),
  (23, 0x007f_ffda),
  (23, 0x007f_ffdb),
  (23, 0x007f_ffdc),
  (23, 0x007f_ffdd),
  (23, 0x007f_ffde),
  (24, 0x00ff_ffeb),
  (23, 0x007f_ffdf),
  (24, 0x00ff_ffec),
  (24, 0x00ff_ffed),
  (22, 0x003f_ffd7),
  (23, 0x007f_ffe0),
  (24, 0x00ff_ffee),
  (23, 0x007f_ffe1),
  (23, 0x007f_ffe2),
  (23, 0x007f_ffe3),
  (23, 0x007f_ffe4),
  (21, 0x001f_ffdc),
  (22, 0x003f_ffd8),
  (23, 0x007f_ffe5),
  (22, 0x003f_ffd9),
  (23, 0x007f_ffe6),
  (23, 0x007f_ffe7),
  (24, 0x00ff_ffef),
  (22, 0x003f_ffda),
  (21, 0x001f_ffdd),
  (20, 0xfffe9),
  (22, 0x003f_ffdb),
  (22, 0x003f_ffdc),
  (23, 0x007f_ffe8),
  (23, 0x007f_ffe9),
  (21, 0x001f_ffde),
  (23, 0x007f_ffea),
  (22, 0x003f_ffdd),
  (22, 0x003f_ffde),
  (24, 0x00ff_fff0),
  (21, 0x001f_ffdf),
  (22, 0x003f_ffdf),
  (23, 0x007f_ffeb),
  (23, 0x007f_ffec),
  (21, 0x001f_ffe0),
  (21, 0x001f_ffe1),
  (22, 0x003f_ffe0),
  (21, 0x001f_ffe2),
  (23, 0x007f_ffed),
  (22, 0x003f_ffe1),
  (23, 0x007f_ffee),
  (23, 0x007f_ffef),
  (20, 0xfffea),
  (22, 0x003f_ffe2),
  (22, 0x003f_ffe3),
  (22, 0x003f_ffe4),
  (23, 0x007f_fff0),
  (22, 0x003f_ffe5),
  (22, 0x003f_ffe6),
  (23, 0x007f_fff1),
  (26, 0x03ff_ffe0),
  (26, 0x03ff_ffe1),
  (20, 0xfffeb),
  (19, 0x7fff1),
  (22, 0x003f_ffe7),
  (23, 0x007f_fff2),
  (22, 0x003f_ffe8),
  (25, 0x01ff_ffec),
  (26, 0x03ff_ffe2),
  (26, 0x03ff_ffe3),
  (26, 0x03ff_ffe4),
  (27, 0x07ff_ffde),
  (27, 0x07ff_ffdf),
  (26, 0x03ff_ffe5),
  (24, 0x00ff_fff1),
  (25, 0x01ff_ffed),
  (19, 0x7fff2),
  (21, 0x001f_ffe3),
  (26, 0x03ff_ffe6),
  (27, 0x07ff_ffe0),
  (27, 0x07ff_ffe1),
  (26, 0x03ff_ffe7),
  (27, 0x07ff_ffe2),
  (24, 0x00ff_fff2),
  (21, 0x001f_ffe4),
  (21, 0x001f_ffe5),
  (26, 0x03ff_ffe8),
  (26, 0x03ff_ffe9),
  (28, 0x0fff_fffd),
  (27, 0x07ff_ffe3),
  (27, 0x07ff_ffe4),
  (27, 0x07ff_ffe5),
  (20, 0xfffec),
  (24, 0x00ff_fff3),
  (20, 0xfffed),
  (21, 0x001f_ffe6),
  (22, 0x003f_ffe9),
  (21, 0x001f_ffe7),
  (21, 0x001f_ffe8),
  (23, 0x007f_fff3),
  (22, 0x003f_ffea),
  (22, 0x003f_ffeb),
  (25, 0x01ff_ffee),
  (25, 0x01ff_ffef),
  (24, 0x00ff_fff4),
  (24, 0x00ff_fff5),
  (26, 0x03ff_ffea),
  (23, 0x007f_fff4),
  (26, 0x03ff_ffeb),
  (27, 0x07ff_ffe6),
  (26, 0x03ff_ffec),
  (26, 0x03ff_ffed),
  (27, 0x07ff_ffe7),
  (27, 0x07ff_ffe8),
  (27, 0x07ff_ffe9),
  (27, 0x07ff_ffea),
  (27, 0x07ff_ffeb),
  (28, 0x0fff_fffe),
  (27, 0x07ff_ffec),
  (27, 0x07ff_ffed),
  (27, 0x07ff_ffee),
  (27, 0x07ff_ffef),
  (27, 0x07ff_fff0),
  (26, 0x03ff_ffee),
  (30, 0x3fff_ffff),
];
