#!/usr/bin/env bash
set -euxo pipefail
echo "-----BEGIN CERTIFICATE-----
MIIDGzCCAgOgAwIBAgIUNyNgj7AfQAqRUjCB/O1cEa9lLa8wDQYJKoZIhvcNAQEL
BQAwHTELMAkGA1UEBhMCRkkxDjAMBgNVBAMMBXZhaGlkMB4XDTI0MDUxNDEzMjEz
MVoXDTI1MDUxNDEzMjEzMVowHTELMAkGA1UEBhMCRkkxDjAMBgNVBAMMBXZhaGlk
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAxv/ZvnUxusA2OK8cIkBJ
mwb6AmZJno2e7hRmrF5392xunAduQ124r4D/tkPDbUaRR+QoIJLLk3Jw2J3HRhXe
yFdEBw1eFNu6YsvRx/kB1PDw5uCalSAqvsD6Psbf2FwvL+fCvLtKP0ZxK0WrE41K
XqgoN0C9CpkBntOkV9C75raAldwfXQu5qK9ceJxVli1+UhYGKUBT4uhXnBhLFpaS
J32jq9KXrTRBQdcNmmBfzn66BkOaT40bc+e278AIJFJl+zhVRLNHmNuTJqOibe3i
5/UZv7I7ARu5/DjKVCp4P6xWvs1dgQXR/MdLuE/vBI2GxHyYB0mkTxb7Zeo2jKTL
mQIDAQABo1MwUTAdBgNVHQ4EFgQUfhKIY70FG/SrFsSFoC3RUfL/x6EwHwYDVR0j
BBgwFoAUfhKIY70FG/SrFsSFoC3RUfL/x6EwDwYDVR0TAQH/BAUwAwEB/zANBgkq
hkiG9w0BAQsFAAOCAQEAbiHGCVEdBAql37HYj+4yXo6wHS++jJnGB0QdhS9AFS5R
9hPvsDPJNnE7xg/FBuSOJocgGALqf0rv4yC8xQrd+3Xu/r+7RwpaQDvUklC8JuDD
giGPfT0qQVnL75im3AweLEWYTdUdogN++TlylJemqYxSFhe/eabWw+Gqp3VNlWOs
bdcdYFlf2K9UP2P+fKP+OZcX+RCddiujZ/Uh78PqZQDyl2r5yBRkS14LkgnB6mIy
oV56YBqDV8gL2cIGHcpmEeOLjcTUQs4IaB1HZIgWJTALOchTcaGcey8fS8wcdcFV
MImfF1qweImlnjrzlZaMLMjuGOL4bhbmmJSGmC9E/g==
-----END CERTIFICATE-----" > $PGDATA/root-ca.crt
echo "-----BEGIN CERTIFICATE-----
MIIDMTCCAhmgAwIBAgIUCIvHpCaXTC3T1KFpBPyNv9zA4YswDQYJKoZIhvcNAQEL
BQAwHTELMAkGA1UEBhMCRkkxDjAMBgNVBAMMBXZhaGlkMB4XDTI0MDUxNDEzMjEz
MVoXDTI1MDUxNDEzMjEzMVowHTELMAkGA1UEBhMCRkkxDjAMBgNVBAMMBXZhaGlk
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA8sHwVGIM6+UbxzqEK3Er
kJTmy0B7K7GId311GWUxiOXZNYzBku18Lr83VU+S/BebcYG8ehki5+clSTVRZ3K3
7893RUswRGf41Kyt2ZG+kq2s9RcN9FIy+4wOWb0TdHEjbrzpcT+IjkH8OpKyuQDw
/SqcNqTdkHwpZePEJMnM/EOmZvkaRH0qyKPua7BEdvI4q53y0ehGwmkSCdRGZV/w
Y4X/Scti5mHIzi12Tm09coCs7pFtwiQyELWwI89bem8qiHvQjMYPjt92xRap7IpY
sZlw5E+CZzJFE9HZG5oN8Diy0SlHcr+hFZD9ExOD6PowHI0Vuq4twA7Ad3B7u1SZ
uQIDAQABo2kwZzAfBgNVHSMEGDAWgBR+EohjvQUb9KsWxIWgLdFR8v/HoTAJBgNV
HRMEAjAAMBoGA1UdEQQTMBGCCWxvY2FsaG9zdIcEfwAAATAdBgNVHQ4EFgQUGrcs
/+p6jkHr/+ahxKWlqetgOpkwDQYJKoZIhvcNAQELBQADggEBABGzp6eeHf85bQNl
UvVAKh8vosrIsN5oFMjnTEMAJQBCoFzWFeRF70kEs2tVBG3A7NpbSs7va4fFb2gC
oplsP8NwZ8x7xGoKXmdb+3U9Toun5xkld8bUePNu4X8njQ8JH+LJ19Up3t5S/Ilm
+ZMbqQD5IMbSndqJBSGtmaoF5ijW1VA069UmMKUZdoiTwN51NuoFEqdqHfROhXhM
jo2qd4OgilcqJbaLX+A1WNuM0J/Jq1psX4xHjOnKDBiW376q7R8d9l2iv/sRs4tb
UdYdltMX2sG1EHGtNaSUZD9QK7VFrQ/A//js/75sKkyHDDyW6Ca8ZDIvweilPZFH
x5GYJig=
-----END CERTIFICATE-----" > $PGDATA/cert.pem
echo "-----BEGIN PRIVATE KEY-----
MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDywfBUYgzr5RvH
OoQrcSuQlObLQHsrsYh3fXUZZTGI5dk1jMGS7XwuvzdVT5L8F5txgbx6GSLn5yVJ
NVFncrfvz3dFSzBEZ/jUrK3Zkb6Sraz1Fw30UjL7jA5ZvRN0cSNuvOlxP4iOQfw6
krK5APD9Kpw2pN2QfCll48Qkycz8Q6Zm+RpEfSrIo+5rsER28jirnfLR6EbCaRIJ
1EZlX/Bjhf9Jy2LmYcjOLXZObT1ygKzukW3CJDIQtbAjz1t6byqIe9CMxg+O33bF
FqnsilixmXDkT4JnMkUT0dkbmg3wOLLRKUdyv6EVkP0TE4Po+jAcjRW6ri3ADsB3
cHu7VJm5AgMBAAECggEARBVxfnEbd6ODlW5LeFWepsekLRgSE3CQuhaFG5C+gksY
jsTB25/ghsnZToNpUWubjIua3VGkcQ7qbaxW/uD1RnxU0qniSSUx7A/cGFuga8nq
6rhDESVmqBchRTjatnsuuVWhUUJE3cUS5SiUmH9zl0V2l3rIq0evYqStM7YnWA5j
TPcfTPD3BB24LmF6rCwSfYDZLhqtnI7EYaSjVOianiRDqVwtdjdIRqmAVgmG2itg
HquMK2eEpjNz9GbMOgw9qNW+oVR4VCatOPSHvDmOTWgBwO8elQsF0/YNwVrJN0MF
/XEFBoUCV6aXplRslOsOXI7VxbAaafl4C+MrLH7hIwKBgQD5sprhCCvmoA68wfg2
sJ0AeJKHNSmKxES7RlqUT2an4gKF5SLFdUlR6dwY3Tsij9fOhNfQeMMxz9vlt9Fx
FvAP8FPfIyQmmo7/M30zkKMeAOKiDSE0p/6IqpsGk/ECXRJ41X4OGTaL+2Pssrtl
U+el424wWxExAoJQRVJ/hUI3WwKBgQD44n217GOYiDNqqwakBNEK2ztn8y7X2+by
LaA4ZeDjaFOn47JGw3mhwWWffobLaR2Q2voGmG419LS9luLPbvzFhbP5QMDCArHY
VljZPiuX7/2itgxjpy6gU2ekrk1tWOnxhjAMBzNmh2fetDPWuVhwjz9baxPaSfaf
oQAWm+zTewKBgDGp54o4oNq3HRdIEUF3cVLFqIdB+KhED1OcU6nJ/SYJGu1cvMS/
ZjznocJERl3CdG78Fxy82D4RFLClFgBDSq4w482u5KLU/PofWJin/PmbvXfz2pXp
kAPIwxrU1AvfTSxBclgFhcbj0mUiy4kE3j8tdB4kDtBLqnWixBze+WOfAoGAPR9q
niYa45f3gKfV7qwcJp1mvoWzqGGiGzHnWlJy44Z4nQ/HdaeGFJqpeX0aX5RGJZAR
vVLsJiYdyT3oH+dy/pNyerFTZZJB2Q6DrX6eOCdBVBd/fW3OfqNdHc2MyGEAu0co
P5v5HKH+eWwqGv7T4Hjdp3bpnj9x6QwiOGs8w0cCgYEAllUcbP3C/ny2+wb1zE2Y
NoDhvas2dzuv/w3fb7xWxJCja+cjWuedvyn88g3n7d3ZwJoY6MbcNG42xdcDbFef
DfFDNISAIHpOuWdc9wJIXFuTZpCUGDTm3/qsl8ddjSnF3GLkj2nrbjdbnXX+EkKR
fKjjEhrpWlFz+k/9DZecURI=
-----END PRIVATE KEY-----" > $PGDATA/key.pem
chmod 0600 $PGDATA/key.pem
cat >> "$PGDATA/postgresql.conf" <<-EOF
ssl = on
ssl_ca_file = 'root-ca.crt'
ssl_cert_file = 'cert.pem'
ssl_key_file = 'key.pem'
EOF
cat > "$PGDATA/pg_hba.conf" <<-EOF
host    all wtx_scram   0.0.0.0/0   scram-sha-256
host    all wtx_scram       ::0/0   scram-sha-256
EOF

psql -v ON_ERROR_STOP=1 --username $POSTGRES_USER <<-EOF
    SET password_encryption TO 'scram-sha-256';
    CREATE ROLE wtx_scram PASSWORD 'wtx' LOGIN;
    GRANT ALL ON DATABASE wtx TO wtx_scram;
    ALTER DATABASE wtx OWNER TO wtx_scram;
EOF
