window.inflateOptions([
  {
    type: 'text',
    name: 'Font Family',
    description: 'The font family for terminal text.',
    path: ['xterm', 'fontFamily'],
  },
  {
    type: 'number',
    name: 'Font Size',
    description: 'The font size in CSS pixels for terminal text.',
    path: ['xterm', 'fontSize'],
    min: 4,
  },
  {
    type: 'enum',
    name: 'Regular Font Weight',
    description: 'The font weight for non-bold text.',
    path: ['xterm', 'fontWeight'],
    enum: [
      'normal',
      'bold',
      '100',
      '200',
      '300',
      '400',
      '500',
      '600',
      '700',
      '800',
      '900',
    ],
  },
  {
    type: 'enum',
    name: 'Bold Font Weight',
    description: 'The font weight for bold text.',
    path: ['xterm', 'fontWeightBold'],
    enum: [
      'normal',
      'bold',
      '100',
      '200',
      '300',
      '400',
      '500',
      '600',
      '700',
      '800',
      '900',
    ],
  },
  {
    type: 'boolean',
    name: 'Fit Terminal',
    description:
      'Automatically fits the terminal to the page, overriding terminal columns and rows.',
    path: ['wettyFitTerminal'],
  },
  {
    type: 'number',
    name: 'Terminal Columns',
    description:
      'The number of columns in the terminal. Overridden by the Fit Terminal option.',
    path: ['xterm', 'cols'],
    nullable: true,
  },
  {
    type: 'number',
    name: 'Terminal Rows',
    description:
      'The number of rows in the terminal. Overridden by the Fit Terminal option.',
    path: ['xterm', 'rows'],
    nullable: true,
  },
  {
    type: 'enum',
    name: 'Cursor Style',
    description: 'The style of the cursor',
    path: ['xterm', 'cursorStyle'],
    enum: ['block', 'underline', 'bar'],
  },
  {
    type: 'boolean',
    name: 'Blinking Cursor',
    description: 'Whether the cursor blinks',
    path: ['xterm', 'cursorBlink'],
  },
  {
    type: 'number',
    name: 'Bar Cursor Width',
    description:
      "The width of the cursor in CSS pixels. Only applies when Cursor Style is set to 'bar'.",
    path: ['xterm', 'cursorWidth'],
  },
  {
    type: 'boolean',
    name: 'Draw Bold Text In Bright Colors',
    description: 'Whether to draw bold text in bright colors',
    path: ['xterm', 'drawBoldTextInBrightColors'],
  },
  {
    type: 'number',
    name: 'Scroll Sensitivity',
    description: 'The scroll speed multiplier for regular scrolling.',
    path: ['xterm', 'scrollSensitivity'],
    float: true,
  },
  {
    type: 'enum',
    name: 'Fast Scroll Key',
    description: 'The modifier key to hold to multiply scroll speed.',
    path: ['xterm', 'fastScrollModifier'],
    enum: ['none', 'alt', 'shift', 'ctrl'],
  },
  {
    type: 'number',
    name: 'Fast Scroll Multiplier',
    description: 'The scroll speed multiplier used for fast scrolling.',
    path: ['xterm', 'fastScrollSensitivity'],
    float: true,
  },
  {
    type: 'number',
    name: 'Scrollback Rows',
    description:
      'The amount of scrollback rows, rows you can scroll up to after they leave the viewport, to keep.',
    path: ['xterm', 'scrollback'],
  },
  {
    type: 'number',
    name: 'Tab Stop Width',
    description: 'The size of tab stops in the terminal.',
    path: ['xterm', 'tabStopWidth'],
  },
]);
