/*
 * Decompiled with CFR 0.152.
 */
package adapter;

import adapter.formatter.IFormatter;
import adapter.formatter.Log4j2Formatter;
import adapter.loggerStrategy.ILoggerStrategy;
import adapter.loggerStrategy.Log4j2Strategy;

public final class LoggerAdapter {
    private final ILoggerStrategy loggerStrategy;
    private final IFormatter formatter;

    private LoggerAdapter(ILoggerStrategy loggerStrategy, IFormatter formatter) {
        this.loggerStrategy = loggerStrategy;
        this.formatter = formatter;
    }

    public static LoggerAdapter createDefault(String loggerName) {
        Log4j2Formatter formatter = new Log4j2Formatter();
        return new LoggerAdapter(new Log4j2Strategy(loggerName, formatter), formatter);
    }

    public static LoggerAdapter createLog4j2LoggerAdapter(Class<?> clazz) {
        Log4j2Formatter formatter = new Log4j2Formatter();
        return new LoggerAdapter(new Log4j2Strategy(clazz.getName(), formatter), formatter);
    }

    public void errorThrowable(String simpleMessage, Throwable throwable) {
        this.loggerStrategy.logError(this.formatter.getExceptionMessage(simpleMessage, throwable));
    }

    public void errorThrowable(Throwable throwable) {
        this.loggerStrategy.logError(this.formatter.getExceptionMessage(throwable));
    }

    public void errorThrowable(String simpleMessage) {
        this.loggerStrategy.logError(this.formatter.getExceptionMessage(simpleMessage));
    }

    public void fatalThrowable(String simpleMessage, Throwable throwable) {
        this.loggerStrategy.logFatal(this.formatter.getExceptionMessage(simpleMessage, throwable));
    }

    public void fatalThrowable(Throwable throwable) {
        this.loggerStrategy.logFatal(this.formatter.getExceptionMessage(throwable));
    }

    public void fatalThrowable(String simpleMessage) {
        this.loggerStrategy.logFatal(this.formatter.getExceptionMessage(simpleMessage));
    }

    public void debug(String message) {
        this.loggerStrategy.logDebug(message);
    }

    public void info(String message) {
        this.loggerStrategy.logInfo(message);
    }

    public void warn(String message) {
        this.loggerStrategy.logWarn(message);
    }

    public void error(String message) {
        this.loggerStrategy.logError(message);
    }

    public void fatal(String message) {
        this.loggerStrategy.logFatal(message);
    }
}

