/*
 * Decompiled with CFR 0.152.
 */
package adapter.loggerStrategy;

import adapter.formatter.IFormatter;
import adapter.loggerStrategy.ILoggerStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public final class Log4j2Strategy
implements ILoggerStrategy {
    private final Logger logger;
    private final IFormatter formatter;

    public Log4j2Strategy(String loggerName, IFormatter formatter) {
        this.logger = LogManager.getLogger((String)loggerName);
        this.formatter = formatter;
    }

    @Override
    public void logError(String message) {
        this.logger.error("{}", new Supplier[]{() -> this.formatter.makeErrorColor(message)});
    }

    @Override
    public void logFatal(String message) {
        this.logger.fatal("{}", new Supplier[]{() -> this.formatter.makeFatalColor(message)});
    }

    @Override
    public void logInfo(String message) {
        this.logger.info("{}", new Supplier[]{() -> this.formatter.makeInfoColor(message)});
    }

    @Override
    public void logDebug(String message) {
        this.logger.debug("{}", new Supplier[]{() -> this.formatter.makeDebugColor(message)});
    }

    @Override
    public void logWarn(String message) {
        this.logger.warn("{}", new Supplier[]{() -> this.formatter.makeWarnColor(message)});
    }
}

