import Vue from 'vue'

import Cookies from 'js-cookie'

import 'normalize.css/normalize.css' // A modern alternative to CSS resets

import Element from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'

import ams from '@ams-team/ams' // ams

import '@/styles/index.scss' // global css

import App from './App'
import router from './router'
import store from './store'

import i18n from './lang' // Internationalization
import './icons' // icon
// simulation data
// if (process.env.NODE_ENV !== 'production') require('@/mock')
import config from '@/config'
import installPlugin from '@/plugin'
import importDirective from '@/directive'
import { getToken } from '@/utils/auth'

import * as filters from './filters' // global filters

Vue.use(Element, {
  size: Cookies.get('size') || 'medium', // set element-ui default size
  i18n: (key, value) => i18n.t(key, value)
})

Vue.use(ams)
ams.config({
  resource: {
    requestInterceptor(options) {
      console.log('requestInterceptor', options)
      options.headers = {
        ...options.headers,
        Authorization: 'Bearer ' + getToken()
      }
      return options
    },
    api: {
      successCode: 200,
      withCredentials: false
    }
  }
})
// register global utility filters.
Object.keys(filters).forEach(key => {
  Vue.filter(key, filters[key])
})

/**
 * @description 注册admin内置插件
 */
installPlugin(Vue)
/**
 * 注册指令
 */
importDirective(Vue)
/**
 * @description 生产环境关掉提示
 */
Vue.config.productionTip = false
/**
 * @description 全局注册应用配置
 */
Vue.prototype.$config = config

new Vue({
  el: '#app',
  router,
  store,
  i18n,
  render: h => h(App)
})
