// GENERATED BY THE COMMAND ABOVE; DO NOT EDIT
// This file was generated by swaggo/swag at
// 2019-08-05 23:33:49.661937311 +0800 CST m=+0.482753463

package docs

import (
	"bytes"

	"github.com/alecthomas/template"
	"github.com/swaggo/swag"
)

var doc = `{
    "swagger": "2.0",
    "info": {
        "description": "Zeus 宙斯权限后台",
        "title": "Zeus 宙斯权限后台 API",
        "termsOfService": "http://swagger.io/terms/",
        "contact": {
            "name": "API Support",
            "email": "support@bullteam.cn"
        },
        "license": {
            "name": "Apache 2.0",
            "url": "http://www.apache.org/licenses/LICENSE-2.0.html"
        },
        "version": "V0.1"
    },
    "host": "127.0.0.1:8012",
    "basePath": "/v1",
    "paths": {
        "/healthcheck": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Health"
                ],
                "summary": "健康检查",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"\"}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/account/accountinfo": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "account"
                ],
                "summary": "获取个人中心用户信息",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[]}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/account/bindcode": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "account"
                ],
                "summary": "绑定2fa goole 验证码",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[]}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/account/domains": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "account"
                ],
                "summary": "获取用户管理域",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[]}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/account/emailverification": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "account"
                ],
                "summary": "验证邮件地址(验证)",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[]}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/account/info": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "description": "登陆用户信息接口",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "account"
                ],
                "summary": "登录用户信息",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "用户ID",
                        "name": "userId",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1,\"name\":\"wutong\"}}",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/model.User"
                            }
                        }
                    }
                }
            }
        },
        "/v1/account/password": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "account"
                ],
                "summary": "更新个人密码",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/account/third": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "account"
                ],
                "summary": "验证邮件地址(发送邮件)",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[]}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/account/thirdbind": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "account"
                ],
                "summary": "解除绑定第三方应用",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[]}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/account/thirdunbind": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "account"
                ],
                "summary": "解除绑定第三方应用",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[]}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/datas": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "DataPerm"
                ],
                "summary": "数据权限列表[分页+搜索]",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "条数",
                        "name": "limit",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "偏移量",
                        "name": "skip",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[...],\"total\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "DataPerm"
                ],
                "summary": "新增数据权限",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/datas/{id}": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "DataPerm"
                ],
                "summary": "数据权限详情",
                "parameters": [
                    {
                        "type": "string",
                        "description": "数据权限id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1,\"name\":\"test\"}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "DataPerm"
                ],
                "summary": "编辑数据权限",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "需要编辑的id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "DataPerm"
                ],
                "summary": "删除项目",
                "parameters": [
                    {
                        "type": "string",
                        "description": "要删除的id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/depts": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Department"
                ],
                "summary": "部门列表[分页+搜索]",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "条数",
                        "name": "limit",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "偏移量",
                        "name": "skip",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[...],\"total\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Department"
                ],
                "summary": "新增部门",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/depts/{id}": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Department"
                ],
                "summary": "部门信息",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "部门id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1,\"name\":\"test\"}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Department"
                ],
                "summary": "编辑部门",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "部门id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Department"
                ],
                "summary": "删除部门",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "部门id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/domains": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Domain"
                ],
                "summary": "项目列表[分页+搜索]",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "条数",
                        "name": "limit",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "偏移量",
                        "name": "skip",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[...],\"total\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Domain"
                ],
                "summary": "新增项目",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/domains/{id}": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Domain"
                ],
                "summary": "项目信息",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "项目id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1,\"name\":\"test\"}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Domain"
                ],
                "summary": "编辑项目",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "项目id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Domain"
                ],
                "summary": "删除项目",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "项目id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/log/login": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Log"
                ],
                "summary": "登录日志列表",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1,\"name\":\"test\"}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/log/login/{logId}": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Log"
                ],
                "summary": "登录日志信息",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1,\"name\":\"test\"}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/log/operation": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Log"
                ],
                "summary": "操作日志信息",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1,\"name\":\"test\"}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/log/operation/{logId}": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Log"
                ],
                "summary": "操作日志列表",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1,\"name\":\"test\"}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/menus": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "menu"
                ],
                "summary": "菜单列表",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[...],\"total\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "menu"
                ],
                "summary": "新增菜单",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/menus/": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "menu"
                ],
                "summary": "菜单信息",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1,\"name\":\"wutong\"}}",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/model.User"
                            }
                        }
                    },
                    "400": {
                        "description": "{\"code\":10004,\"msg\": \"用户信息不存在\"}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "menu"
                ],
                "summary": "编辑菜单",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "menu"
                ],
                "summary": "删除菜单",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/roles": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Role"
                ],
                "summary": "角色列表[分页+搜索]",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "条数",
                        "name": "limit",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "偏移量",
                        "name": "skip",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[...],\"total\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Role"
                ],
                "summary": "新增角色",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/roles/": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Role"
                ],
                "summary": "更新角色信息",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[...],\"total\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Role"
                ],
                "summary": "删除角色信息",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"result\":[...],\"total\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/roles/{id}": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Role"
                ],
                "summary": "角色信息",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "角色id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1,\"name\":\"test\"}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/users": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "新增用户",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/users/department/move": {
            "post": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "移动部门",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/users/login": {
            "post": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "用户登陆",
                "parameters": [
                    {
                        "type": "string",
                        "description": "登录名",
                        "name": "username",
                        "in": "formData",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "密码",
                        "name": "password",
                        "in": "formData",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "验证码ID",
                        "name": "captchaid",
                        "in": "formData"
                    },
                    {
                        "type": "string",
                        "description": "验证码",
                        "name": "captchaval",
                        "in": "formData"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1,\"name\":\"wutong\"}}",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/model.User"
                            }
                        }
                    },
                    "400": {
                        "description": "{\"code\":10004,\"msg\": \"用户信息不存在\"}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/users/login/refresh": {
            "post": {
                "consumes": [
                    "application/json",
                    "multipart/form-data"
                ],
                "produces": [
                    "application/json",
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "用户refresh-token接口",
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1,\"name\":\"wutong\"}}",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/model.User"
                            }
                        }
                    },
                    "400": {
                        "description": "{\"code\":10004,\"msg\": \"用户信息不存在\"}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/users/{id}": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "用户信息",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "用户id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1,\"name\":\"wutong\"}}",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/model.User"
                            }
                        }
                    },
                    "400": {
                        "description": "{\"code\":10004,\"msg\": \"用户信息不存在\"}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "编辑用户",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "用户id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "删除用户",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "用户id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/users/{id}/password": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "更新用户密码",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "用户id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/users/{id}/permissions": {
            "get": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "获取用户权限列表",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "用户id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "/v1/users/{id}/status": {
            "put": {
                "security": [
                    {
                        "ApiKeyAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "更新用户状态",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "用户id",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "{\"code\":200,\"data\":{\"id\":1}}",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            }
        }
    },
    "definitions": {
        "model.User": {
            "type": "object",
            "properties": {
                "created_time": {
                    "type": "string",
                    "example": "2019-07-10 0:39"
                },
                "department_id": {
                    "type": "integer",
                    "example": 1
                },
                "email": {
                    "type": "string",
                    "example": "xxxx@hotmail.com"
                },
                "faceicon": {
                    "type": "string",
                    "example": "http://xxx.com"
                },
                "id": {
                    "type": "integer",
                    "example": 1
                },
                "mobile": {
                    "type": "string",
                    "example": "186000000"
                },
                "realname": {
                    "type": "string",
                    "example": "黄梧桐"
                },
                "sex": {
                    "type": "integer",
                    "example": 1
                },
                "status": {
                    "type": "integer",
                    "example": 1
                },
                "title": {
                    "type": "string",
                    "example": "title"
                },
                "updated_time": {
                    "type": "string",
                    "example": "2019-07-10 0:39"
                },
                "username": {
                    "type": "string",
                    "example": "wutongci"
                }
            }
        }
    },
    "securityDefinitions": {
        "ApiKeyAuth": {
            "type": "apiKey",
            "name": "Authorization",
            "in": "header"
        }
    }
}`

type swaggerInfo struct {
	Version     string
	Host        string
	BasePath    string
	Title       string
	Description string
}

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo swaggerInfo

type s struct{}

func (s *s) ReadDoc() string {
	t, err := template.New("swagger_info").Parse(doc)
	if err != nil {
		return doc
	}

	var tpl bytes.Buffer
	if err := t.Execute(&tpl, SwaggerInfo); err != nil {
		return doc
	}

	return tpl.String()
}

func init() {
	swag.Register(swag.Name, &s{})
}
