/*!
 * 
 *   typed.js - A JavaScript Typing Animation Library
 *   Author: Matt Boldt <me@mattboldt.com>
 *   Version: v2.0.11
 *   Url: https://github.com/mattboldt/typed.js
 *   License(s): MIT
 * 
 */
!function webpackUniversalModuleDefinition(root,factory){"object"==typeof exports&&"object"==typeof module?module.exports=factory():"function"==typeof define&&define.amd?define([],factory):"object"==typeof exports?exports.Typed=factory():root.Typed=factory()}(this,(function(){return function(modules){var installedModules={};function __webpack_require__(moduleId){if(installedModules[moduleId])return installedModules[moduleId].exports;var module=installedModules[moduleId]={exports:{},id:moduleId,loaded:!1};return modules[moduleId].call(module.exports,module,module.exports,__webpack_require__),module.loaded=!0,module.exports}return __webpack_require__.m=modules,__webpack_require__.c=installedModules,__webpack_require__.p="",__webpack_require__(0)}([function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){return protoProps&&defineProperties(Constructor.prototype,protoProps),staticProps&&defineProperties(Constructor,staticProps),Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}var _initializerJs=__webpack_require__(1),_htmlParserJs=__webpack_require__(3),Typed=function(){function Typed(elementId,options){_classCallCheck(this,Typed),_initializerJs.initializer.load(this,options,elementId),this.begin()}return _createClass(Typed,[{key:"toggle",value:function toggle(){this.pause.status?this.start():this.stop()}},{key:"stop",value:function stop(){this.typingComplete||this.pause.status||(this.toggleBlinking(!0),this.pause.status=!0,this.options.onStop(this.arrayPos,this))}},{key:"start",value:function start(){this.typingComplete||this.pause.status&&(this.pause.status=!1,this.pause.typewrite?this.typewrite(this.pause.curString,this.pause.curStrPos):this.backspace(this.pause.curString,this.pause.curStrPos),this.options.onStart(this.arrayPos,this))}},{key:"destroy",value:function destroy(){this.reset(!1),this.options.onDestroy(this)}},{key:"reset",value:function reset(){var restart=arguments.length<=0||void 0===arguments[0]||arguments[0];clearInterval(this.timeout),this.replaceText(""),this.cursor&&this.cursor.parentNode&&(this.cursor.parentNode.removeChild(this.cursor),this.cursor=null),this.strPos=0,this.arrayPos=0,this.curLoop=0,restart&&(this.insertCursor(),this.options.onReset(this),this.begin())}},{key:"begin",value:function begin(){var _this=this;this.options.onBegin(this),this.typingComplete=!1,this.shuffleStringsIfNeeded(this),this.insertCursor(),this.bindInputFocusEvents&&this.bindFocusEvents(),this.timeout=setTimeout((function(){_this.currentElContent&&0!==_this.currentElContent.length?_this.backspace(_this.currentElContent,_this.currentElContent.length):_this.typewrite(_this.strings[_this.sequence[_this.arrayPos]],_this.strPos)}),this.startDelay)}},{key:"typewrite",value:function typewrite(curString,curStrPos){var _this2=this;this.fadeOut&&this.el.classList.contains(this.fadeOutClass)&&(this.el.classList.remove(this.fadeOutClass),this.cursor&&this.cursor.classList.remove(this.fadeOutClass));var humanize=this.humanizer(this.typeSpeed),numChars=1;!0!==this.pause.status?this.timeout=setTimeout((function(){curStrPos=_htmlParserJs.htmlParser.typeHtmlChars(curString,curStrPos,_this2);var pauseTime=0,substr=curString.substr(curStrPos);if("^"===substr.charAt(0)&&/^\^\d+/.test(substr)){var skip=1;skip+=(substr=/\d+/.exec(substr)[0]).length,pauseTime=parseInt(substr),_this2.temporaryPause=!0,_this2.options.onTypingPaused(_this2.arrayPos,_this2),curString=curString.substring(0,curStrPos)+curString.substring(curStrPos+skip),_this2.toggleBlinking(!0)}if("`"===substr.charAt(0)){for(;"`"!==curString.substr(curStrPos+numChars).charAt(0)&&(numChars++,!(curStrPos+numChars>curString.length)););var stringBeforeSkip=curString.substring(0,curStrPos),stringSkipped=curString.substring(stringBeforeSkip.length+1,curStrPos+numChars),stringAfterSkip=curString.substring(curStrPos+numChars+1);curString=stringBeforeSkip+stringSkipped+stringAfterSkip,numChars--}_this2.timeout=setTimeout((function(){_this2.toggleBlinking(!1),curStrPos>=curString.length?_this2.doneTyping(curString,curStrPos):_this2.keepTyping(curString,curStrPos,numChars),_this2.temporaryPause&&(_this2.temporaryPause=!1,_this2.options.onTypingResumed(_this2.arrayPos,_this2))}),pauseTime)}),humanize):this.setPauseStatus(curString,curStrPos,!0)}},{key:"keepTyping",value:function keepTyping(curString,curStrPos,numChars){0===curStrPos&&(this.toggleBlinking(!1),this.options.preStringTyped(this.arrayPos,this)),curStrPos+=numChars;var nextString=curString.substr(0,curStrPos);this.replaceText(nextString),this.typewrite(curString,curStrPos)}},{key:"doneTyping",value:function doneTyping(curString,curStrPos){var _this3=this;this.options.onStringTyped(this.arrayPos,this),this.toggleBlinking(!0),this.arrayPos===this.strings.length-1&&(this.complete(),!1===this.loop||this.curLoop===this.loopCount)||(this.timeout=setTimeout((function(){_this3.backspace(curString,curStrPos)}),this.backDelay))}},{key:"backspace",value:function backspace(curString,curStrPos){var _this4=this;if(!0!==this.pause.status){if(this.fadeOut)return this.initFadeOut();this.toggleBlinking(!1);var humanize=this.humanizer(this.backSpeed);this.timeout=setTimeout((function(){curStrPos=_htmlParserJs.htmlParser.backSpaceHtmlChars(curString,curStrPos,_this4);var curStringAtPosition=curString.substr(0,curStrPos);if(_this4.replaceText(curStringAtPosition),_this4.smartBackspace){var nextString=_this4.strings[_this4.arrayPos+1];nextString&&curStringAtPosition===nextString.substr(0,curStrPos)?_this4.stopNum=curStrPos:_this4.stopNum=0}curStrPos>_this4.stopNum?(curStrPos--,_this4.backspace(curString,curStrPos)):curStrPos<=_this4.stopNum&&(_this4.arrayPos++,_this4.arrayPos===_this4.strings.length?(_this4.arrayPos=0,_this4.options.onLastStringBackspaced(),_this4.shuffleStringsIfNeeded(),_this4.begin()):_this4.typewrite(_this4.strings[_this4.sequence[_this4.arrayPos]],curStrPos))}),humanize)}else this.setPauseStatus(curString,curStrPos,!0)}},{key:"complete",value:function complete(){this.options.onComplete(this),this.loop?this.curLoop++:this.typingComplete=!0}},{key:"setPauseStatus",value:function setPauseStatus(curString,curStrPos,isTyping){this.pause.typewrite=isTyping,this.pause.curString=curString,this.pause.curStrPos=curStrPos}},{key:"toggleBlinking",value:function toggleBlinking(isBlinking){this.cursor&&(this.pause.status||this.cursorBlinking!==isBlinking&&(this.cursorBlinking=isBlinking,isBlinking?this.cursor.classList.add("typed-cursor--blink"):this.cursor.classList.remove("typed-cursor--blink")))}},{key:"humanizer",value:function humanizer(speed){return Math.round(Math.random()*speed/2)+speed}},{key:"shuffleStringsIfNeeded",value:function shuffleStringsIfNeeded(){this.shuffle&&(this.sequence=this.sequence.sort((function(){return Math.random()-.5})))}},{key:"initFadeOut",value:function initFadeOut(){var _this5=this;return this.el.className+=" "+this.fadeOutClass,this.cursor&&(this.cursor.className+=" "+this.fadeOutClass),setTimeout((function(){_this5.arrayPos++,_this5.replaceText(""),_this5.strings.length>_this5.arrayPos?_this5.typewrite(_this5.strings[_this5.sequence[_this5.arrayPos]],0):(_this5.typewrite(_this5.strings[0],0),_this5.arrayPos=0)}),this.fadeOutDelay)}},{key:"replaceText",value:function replaceText(str){this.attr?this.el.setAttribute(this.attr,str):this.isInput?this.el.value=str:"html"===this.contentType?this.el.innerHTML=str:this.el.textContent=str}},{key:"bindFocusEvents",value:function bindFocusEvents(){var _this6=this;this.isInput&&(this.el.addEventListener("focus",(function(e){_this6.stop()})),this.el.addEventListener("blur",(function(e){_this6.el.value&&0!==_this6.el.value.length||_this6.start()})))}},{key:"insertCursor",value:function insertCursor(){this.showCursor&&(this.cursor||(this.cursor=document.createElement("span"),this.cursor.className="typed-cursor",this.cursor.innerHTML=this.cursorChar,this.el.parentNode&&this.el.parentNode.insertBefore(this.cursor,this.el.nextSibling)))}}]),Typed}();exports.default=Typed,module.exports=exports.default},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source)Object.prototype.hasOwnProperty.call(source,key)&&(target[key]=source[key])}return target},_createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){return protoProps&&defineProperties(Constructor.prototype,protoProps),staticProps&&defineProperties(Constructor,staticProps),Constructor}}();function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}var _defaultsJs,_defaultsJs2=_interopRequireDefault(__webpack_require__(2)),Initializer=function(){function Initializer(){_classCallCheck(this,Initializer)}return _createClass(Initializer,[{key:"load",value:function load(self,options,elementId){if(self.el="string"==typeof elementId?document.querySelector(elementId):elementId,self.options=_extends({},_defaultsJs2.default,options),self.isInput="input"===self.el.tagName.toLowerCase(),self.attr=self.options.attr,self.bindInputFocusEvents=self.options.bindInputFocusEvents,self.showCursor=!self.isInput&&self.options.showCursor,self.cursorChar=self.options.cursorChar,self.cursorBlinking=!0,self.elContent=self.attr?self.el.getAttribute(self.attr):self.el.textContent,self.contentType=self.options.contentType,self.typeSpeed=self.options.typeSpeed,self.startDelay=self.options.startDelay,self.backSpeed=self.options.backSpeed,self.smartBackspace=self.options.smartBackspace,self.backDelay=self.options.backDelay,self.fadeOut=self.options.fadeOut,self.fadeOutClass=self.options.fadeOutClass,self.fadeOutDelay=self.options.fadeOutDelay,self.isPaused=!1,self.strings=self.options.strings.map((function(s){return s.trim()})),"string"==typeof self.options.stringsElement?self.stringsElement=document.querySelector(self.options.stringsElement):self.stringsElement=self.options.stringsElement,self.stringsElement){self.strings=[],self.stringsElement.style.display="none";var strings=Array.prototype.slice.apply(self.stringsElement.children),stringsLength=strings.length;if(stringsLength)for(var i=0;i<stringsLength;i+=1){var stringEl=strings[i];self.strings.push(stringEl.innerHTML.trim())}}for(var i in self.strPos=0,self.arrayPos=0,self.stopNum=0,self.loop=self.options.loop,self.loopCount=self.options.loopCount,self.curLoop=0,self.shuffle=self.options.shuffle,self.sequence=[],self.pause={status:!1,typewrite:!0,curString:"",curStrPos:0},self.typingComplete=!1,self.strings)self.sequence[i]=i;self.currentElContent=this.getCurrentElContent(self),self.autoInsertCss=self.options.autoInsertCss,this.appendAnimationCss(self)}},{key:"getCurrentElContent",value:function getCurrentElContent(self){var elContent="";return elContent=self.attr?self.el.getAttribute(self.attr):self.isInput?self.el.value:"html"===self.contentType?self.el.innerHTML:self.el.textContent}},{key:"appendAnimationCss",value:function appendAnimationCss(self){var cssDataName="data-typed-js-css";if(self.autoInsertCss&&(self.showCursor||self.fadeOut)&&!document.querySelector("["+cssDataName+"]")){var css=document.createElement("style");css.type="text/css",css.setAttribute(cssDataName,!0);var innerCss="";self.showCursor&&(innerCss+="\n        .typed-cursor{\n          opacity: 1;\n        }\n        .typed-cursor.typed-cursor--blink{\n          animation: typedjsBlink 0.7s infinite;\n          -webkit-animation: typedjsBlink 0.7s infinite;\n                  animation: typedjsBlink 0.7s infinite;\n        }\n        @keyframes typedjsBlink{\n          50% { opacity: 0.0; }\n        }\n        @-webkit-keyframes typedjsBlink{\n          0% { opacity: 1; }\n          50% { opacity: 0.0; }\n          100% { opacity: 1; }\n        }\n      "),self.fadeOut&&(innerCss+="\n        .typed-fade-out{\n          opacity: 0;\n          transition: opacity .25s;\n        }\n        .typed-cursor.typed-cursor--blink.typed-fade-out{\n          -webkit-animation: 0;\n          animation: 0;\n        }\n      "),0!==css.length&&(css.innerHTML=innerCss,document.body.appendChild(css))}}}]),Initializer}();exports.default=Initializer;var initializer=new Initializer;exports.initializer=initializer},function(module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var defaults={strings:["These are the default values...","You know what you should do?","Use your own!","Have a great day!"],stringsElement:null,typeSpeed:0,startDelay:0,backSpeed:0,smartBackspace:!0,shuffle:!1,backDelay:700,fadeOut:!1,fadeOutClass:"typed-fade-out",fadeOutDelay:500,loop:!1,loopCount:1/0,showCursor:!0,cursorChar:"|",autoInsertCss:!0,attr:null,bindInputFocusEvents:!1,contentType:"html",onBegin:function onBegin(self){},onComplete:function onComplete(self){},preStringTyped:function preStringTyped(arrayPos,self){},onStringTyped:function onStringTyped(arrayPos,self){},onLastStringBackspaced:function onLastStringBackspaced(self){},onTypingPaused:function onTypingPaused(arrayPos,self){},onTypingResumed:function onTypingResumed(arrayPos,self){},onReset:function onReset(self){},onStop:function onStop(arrayPos,self){},onStart:function onStart(arrayPos,self){},onDestroy:function onDestroy(self){}};exports.default=defaults,module.exports=exports.default},function(module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){return protoProps&&defineProperties(Constructor.prototype,protoProps),staticProps&&defineProperties(Constructor,staticProps),Constructor}}();function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}var HTMLParser=function(){function HTMLParser(){_classCallCheck(this,HTMLParser)}return _createClass(HTMLParser,[{key:"typeHtmlChars",value:function typeHtmlChars(curString,curStrPos,self){if("html"!==self.contentType)return curStrPos;var curChar=curString.substr(curStrPos).charAt(0);if("<"===curChar||"&"===curChar){var endTag="";for(endTag="<"===curChar?">":";";curString.substr(curStrPos+1).charAt(0)!==endTag&&!(++curStrPos+1>curString.length););curStrPos++}return curStrPos}},{key:"backSpaceHtmlChars",value:function backSpaceHtmlChars(curString,curStrPos,self){if("html"!==self.contentType)return curStrPos;var curChar=curString.substr(curStrPos).charAt(0);if(">"===curChar||";"===curChar){var endTag="";for(endTag=">"===curChar?"<":"&";curString.substr(curStrPos-1).charAt(0)!==endTag&&!(--curStrPos<0););curStrPos--}return curStrPos}}]),HTMLParser}();exports.default=HTMLParser;var htmlParser=new HTMLParser;exports.htmlParser=htmlParser}])}));