/*! @license ScrollReveal v4.0.7

	Copyright 2020 Fisssion LLC.

	Licensed under the GNU General Public License 3.0 for
	compatible open source projects and non-commercial use.

	For commercial sites, themes, projects, and applications,
	keep your source code private/proprietary by purchasing
	a commercial license from https://scrollrevealjs.org/
*/
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?module.exports=factory():"function"==typeof define&&define.amd?define(factory):(global=global||self).ScrollReveal=factory()}(this,(function(){"use strict";var defaults={delay:0,distance:"0",duration:600,easing:"cubic-bezier(0.5, 0, 0, 1)",interval:0,opacity:0,origin:"bottom",rotate:{x:0,y:0,z:0},scale:1,cleanup:!1,container:document.documentElement,desktop:!0,mobile:!0,reset:!1,useDelay:"always",viewFactor:0,viewOffset:{top:0,right:0,bottom:0,left:0},afterReset:function afterReset(){},afterReveal:function afterReveal(){},beforeReset:function beforeReset(){},beforeReveal:function beforeReveal(){}};function failure(){return document.documentElement.classList.remove("sr"),{clean:function clean(){},destroy:function destroy(){},reveal:function reveal(){},sync:function sync(){},get noop(){return!0}}}function success(){document.documentElement.classList.add("sr"),document.body?document.body.style.height="100%":document.addEventListener("DOMContentLoaded",(function(){document.body.style.height="100%"}))}var mount={success:success,failure:failure};
/*! @license is-dom-node v1.0.4

		Copyright 2018 Fisssion LLC.

		Permission is hereby granted, free of charge, to any person obtaining a copy
		of this software and associated documentation files (the "Software"), to deal
		in the Software without restriction, including without limitation the rights
		to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
		copies of the Software, and to permit persons to whom the Software is
		furnished to do so, subject to the following conditions:

		The above copyright notice and this permission notice shall be included in all
		copies or substantial portions of the Software.

		THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
		IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
		FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
		AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
		LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
		OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
		SOFTWARE.

	*/function isDomNode(x){return"object"==typeof window.Node?x instanceof window.Node:null!==x&&"object"==typeof x&&"number"==typeof x.nodeType&&"string"==typeof x.nodeName}
/*! @license is-dom-node-list v1.2.1

		Copyright 2018 Fisssion LLC.

		Permission is hereby granted, free of charge, to any person obtaining a copy
		of this software and associated documentation files (the "Software"), to deal
		in the Software without restriction, including without limitation the rights
		to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
		copies of the Software, and to permit persons to whom the Software is
		furnished to do so, subject to the following conditions:

		The above copyright notice and this permission notice shall be included in all
		copies or substantial portions of the Software.

		THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
		IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
		FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
		AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
		LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
		OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
		SOFTWARE.

	*/function isDomNodeList(x){var prototypeToString=Object.prototype.toString.call(x),regex=/^\[object (HTMLCollection|NodeList|Object)\]$/;return"object"==typeof window.NodeList?x instanceof window.NodeList:null!==x&&"object"==typeof x&&"number"==typeof x.length&&regex.test(prototypeToString)&&(0===x.length||isDomNode(x[0]))}
/*! @license Tealight v0.3.6

		Copyright 2018 Fisssion LLC.

		Permission is hereby granted, free of charge, to any person obtaining a copy
		of this software and associated documentation files (the "Software"), to deal
		in the Software without restriction, including without limitation the rights
		to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
		copies of the Software, and to permit persons to whom the Software is
		furnished to do so, subject to the following conditions:

		The above copyright notice and this permission notice shall be included in all
		copies or substantial portions of the Software.

		THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
		IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
		FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
		AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
		LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
		OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
		SOFTWARE.

	*/function tealight(target,context){if(void 0===context&&(context=document),target instanceof Array)return target.filter(isDomNode);if(isDomNode(target))return[target];if(isDomNodeList(target))return Array.prototype.slice.call(target);if("string"==typeof target)try{var query=context.querySelectorAll(target);return Array.prototype.slice.call(query)}catch(err){return[]}return[]}function isObject(x){return null!==x&&x instanceof Object&&(x.constructor===Object||"[object Object]"===Object.prototype.toString.call(x))}function each(collection,callback){var keys;if(isObject(collection))return Object.keys(collection).forEach((function(key){return callback(collection[key],key,collection)}));if(collection instanceof Array)return collection.forEach((function(item,i){return callback(item,i,collection)}));throw new TypeError("Expected either an array or object literal.")}function logger(message){for(var details=[],len=arguments.length-1;len-- >0;)details[len]=arguments[len+1];if(this.constructor.debug&&console){var report="%cScrollReveal: "+message;details.forEach((function(detail){return report+="\n — "+detail})),console.log(report,"color: #ea654b;")}}function rinse(){var this$1=this,struct=function(){return{active:[],stale:[]}},elementIds={active:[],stale:[]},sequenceIds={active:[],stale:[]},containerIds={active:[],stale:[]};try{each(tealight("[data-sr-id]"),(function(node){var id=parseInt(node.getAttribute("data-sr-id"));elementIds.active.push(id)}))}catch(e){throw e}each(this.store.elements,(function(element){-1===elementIds.active.indexOf(element.id)&&elementIds.stale.push(element.id)})),each(elementIds.stale,(function(staleId){return delete this$1.store.elements[staleId]})),each(this.store.elements,(function(element){-1===containerIds.active.indexOf(element.containerId)&&containerIds.active.push(element.containerId),element.hasOwnProperty("sequence")&&-1===sequenceIds.active.indexOf(element.sequence.id)&&sequenceIds.active.push(element.sequence.id)})),each(this.store.containers,(function(container){-1===containerIds.active.indexOf(container.id)&&containerIds.stale.push(container.id)})),each(containerIds.stale,(function(staleId){var stale=this$1.store.containers[staleId].node;stale.removeEventListener("scroll",this$1.delegate),stale.removeEventListener("resize",this$1.delegate),delete this$1.store.containers[staleId]})),each(this.store.sequences,(function(sequence){-1===sequenceIds.active.indexOf(sequence.id)&&sequenceIds.stale.push(sequence.id)})),each(sequenceIds.stale,(function(staleId){return delete this$1.store.sequences[staleId]}))}function clean(target){var this$1=this,dirty;try{each(tealight(target),(function(node){var id=node.getAttribute("data-sr-id");if(null!==id){dirty=!0;var element=this$1.store.elements[id];element.callbackTimer&&window.clearTimeout(element.callbackTimer.clock),node.setAttribute("style",element.styles.inline.generated),node.removeAttribute("data-sr-id"),delete this$1.store.elements[id]}}))}catch(e){return logger.call(this,"Clean failed.",e.message)}if(dirty)try{rinse.call(this)}catch(e){return logger.call(this,"Clean failed.",e.message)}}function destroy(){var this$1=this;each(this.store.elements,(function(element){element.node.setAttribute("style",element.styles.inline.generated),element.node.removeAttribute("data-sr-id")})),each(this.store.containers,(function(container){var target=container.node===document.documentElement?window:container.node;target.removeEventListener("scroll",this$1.delegate),target.removeEventListener("resize",this$1.delegate)})),this.store={containers:{},elements:{},history:[],sequences:{}}}
/*! @license Rematrix v0.3.0

		Copyright 2018 Julian Lloyd.

		Permission is hereby granted, free of charge, to any person obtaining a copy
		of this software and associated documentation files (the "Software"), to deal
		in the Software without restriction, including without limitation the rights
		to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
		copies of the Software, and to permit persons to whom the Software is
		furnished to do so, subject to the following conditions:

		The above copyright notice and this permission notice shall be included in
		all copies or substantial portions of the Software.

		THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
		IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
		FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
		AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
		LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
		OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
		THE SOFTWARE.
	*/function format(source){if(source.constructor!==Array)throw new TypeError("Expected array.");if(16===source.length)return source;if(6===source.length){var matrix=identity();return matrix[0]=source[0],matrix[1]=source[1],matrix[4]=source[2],matrix[5]=source[3],matrix[12]=source[4],matrix[13]=source[5],matrix}throw new RangeError("Expected array with either 6 or 16 values.")}function identity(){for(var matrix=[],i=0;i<16;i++)i%5==0?matrix.push(1):matrix.push(0);return matrix}function multiply(m,x){for(var fm=format(m),fx=format(x),product=[],i=0;i<4;i++)for(var row=[fm[i],fm[i+4],fm[i+8],fm[i+12]],j=0;j<4;j++){var k=4*j,col=[fx[k],fx[k+1],fx[k+2],fx[k+3]],result=row[0]*col[0]+row[1]*col[1]+row[2]*col[2]+row[3]*col[3];product[i+k]=result}return product}function parse(source){if("string"==typeof source){var match=source.match(/matrix(3d)?\(([^)]+)\)/),raw;if(match)return format(match[2].split(", ").map(parseFloat))}return identity()}function rotateX(angle){var theta=Math.PI/180*angle,matrix=identity();return matrix[5]=matrix[10]=Math.cos(theta),matrix[6]=matrix[9]=Math.sin(theta),matrix[9]*=-1,matrix}function rotateY(angle){var theta=Math.PI/180*angle,matrix=identity();return matrix[0]=matrix[10]=Math.cos(theta),matrix[2]=matrix[8]=Math.sin(theta),matrix[2]*=-1,matrix}function rotateZ(angle){var theta=Math.PI/180*angle,matrix=identity();return matrix[0]=matrix[5]=Math.cos(theta),matrix[1]=matrix[4]=Math.sin(theta),matrix[4]*=-1,matrix}function scale(scalar,scalarY){var matrix=identity();return matrix[0]=scalar,matrix[5]="number"==typeof scalarY?scalarY:scalar,matrix}function translateX(distance){var matrix=identity();return matrix[12]=distance,matrix}function translateY(distance){var matrix=identity();return matrix[13]=distance,matrix}var getPrefixedCssProp=function(){var properties={},style=document.documentElement.style;function getPrefixedCssProperty(name,source){if(void 0===source&&(source=style),name&&"string"==typeof name){if(properties[name])return properties[name];if("string"==typeof source[name])return properties[name]=name;if("string"==typeof source["-webkit-"+name])return properties[name]="-webkit-"+name;throw new RangeError('Unable to find "'+name+'" style property.')}throw new TypeError("Expected a string.")}return getPrefixedCssProperty.clearCache=function(){return properties={}},getPrefixedCssProperty}();function style(element){var computed=window.getComputedStyle(element.node),position=computed.position,config=element.config,inline={},inlineStyle,inlineMatch=(element.node.getAttribute("style")||"").match(/[\w-]+\s*:\s*[^;]+\s*/gi)||[];inline.computed=inlineMatch?inlineMatch.map((function(m){return m.trim()})).join("; ")+";":"",inline.generated=inlineMatch.some((function(m){return m.match(/visibility\s?:\s?visible/i)}))?inline.computed:inlineMatch.concat(["visibility: visible"]).map((function(m){return m.trim()})).join("; ")+";";var computedOpacity=parseFloat(computed.opacity),configOpacity=isNaN(parseFloat(config.opacity))?parseFloat(computed.opacity):parseFloat(config.opacity),opacity={computed:computedOpacity!==configOpacity?"opacity: "+computedOpacity+";":"",generated:computedOpacity!==configOpacity?"opacity: "+configOpacity+";":""},transformations=[];if(parseFloat(config.distance)){var axis="top"===config.origin||"bottom"===config.origin?"Y":"X",distance=config.distance;"top"!==config.origin&&"left"!==config.origin||(distance=/^-/.test(distance)?distance.substr(1):"-"+distance);var ref=distance.match(/(^-?\d+\.?\d?)|(em$|px$|%$)/g),value=ref[0],unit;switch(ref[1]){case"em":distance=parseInt(computed.fontSize)*value;break;case"px":distance=value;break;case"%":distance="Y"===axis?element.node.getBoundingClientRect().height*value/100:element.node.getBoundingClientRect().width*value/100;break;default:throw new RangeError("Unrecognized or missing distance unit.")}"Y"===axis?transformations.push(translateY(distance)):transformations.push(translateX(distance))}config.rotate.x&&transformations.push(rotateX(config.rotate.x)),config.rotate.y&&transformations.push(rotateY(config.rotate.y)),config.rotate.z&&transformations.push(rotateZ(config.rotate.z)),1!==config.scale&&(0===config.scale?transformations.push(scale(2e-4)):transformations.push(scale(config.scale)));var transform={};if(transformations.length){transform.property=getPrefixedCssProp("transform"),transform.computed={raw:computed[transform.property],matrix:parse(computed[transform.property])},transformations.unshift(transform.computed.matrix);var product=transformations.reduce(multiply);transform.generated={initial:transform.property+": matrix3d("+product.join(", ")+");",final:transform.property+": matrix3d("+transform.computed.matrix.join(", ")+");"}}else transform.generated={initial:"",final:""};var transition={};if(opacity.generated||transform.generated.initial){transition.property=getPrefixedCssProp("transition"),transition.computed=computed[transition.property],transition.fragments=[];var delay=config.delay,duration=config.duration,easing=config.easing,hasCustomTransition;opacity.generated&&transition.fragments.push({delayed:"opacity "+duration/1e3+"s "+easing+" "+delay/1e3+"s",instant:"opacity "+duration/1e3+"s "+easing+" 0s"}),transform.generated.initial&&transition.fragments.push({delayed:transform.property+" "+duration/1e3+"s "+easing+" "+delay/1e3+"s",instant:transform.property+" "+duration/1e3+"s "+easing+" 0s"}),transition.computed&&!transition.computed.match(/all 0s|none 0s/)&&transition.fragments.unshift({delayed:transition.computed,instant:transition.computed});var composed=transition.fragments.reduce((function(composition,fragment,i){return composition.delayed+=0===i?fragment.delayed:", "+fragment.delayed,composition.instant+=0===i?fragment.instant:", "+fragment.instant,composition}),{delayed:"",instant:""});transition.generated={delayed:transition.property+": "+composed.delayed+";",instant:transition.property+": "+composed.instant+";"}}else transition.generated={delayed:"",instant:""};return{inline:inline,opacity:opacity,position:position,transform:transform,transition:transition}}function animate(element,force){void 0===force&&(force={});var pristine=force.pristine||this.pristine,delayed="always"===element.config.useDelay||"onload"===element.config.useDelay&&pristine||"once"===element.config.useDelay&&!element.seen,shouldReveal=element.visible&&!element.revealed,shouldReset=!element.visible&&element.revealed&&element.config.reset;return force.reveal||shouldReveal?triggerReveal.call(this,element,delayed):force.reset||shouldReset?triggerReset.call(this,element):void 0}function triggerReveal(element,delayed){var styles=[element.styles.inline.generated,element.styles.opacity.computed,element.styles.transform.generated.final];delayed?styles.push(element.styles.transition.generated.delayed):styles.push(element.styles.transition.generated.instant),element.revealed=element.seen=!0,element.node.setAttribute("style",styles.filter((function(s){return""!==s})).join(" ")),registerCallbacks.call(this,element,delayed)}function triggerReset(element){var styles=[element.styles.inline.generated,element.styles.opacity.generated,element.styles.transform.generated.initial,element.styles.transition.generated.instant];element.revealed=!1,element.node.setAttribute("style",styles.filter((function(s){return""!==s})).join(" ")),registerCallbacks.call(this,element)}function registerCallbacks(element,isDelayed){var this$1=this,duration=isDelayed?element.config.duration+element.config.delay:element.config.duration,beforeCallback=element.revealed?element.config.beforeReveal:element.config.beforeReset,afterCallback=element.revealed?element.config.afterReveal:element.config.afterReset,elapsed=0;element.callbackTimer&&(elapsed=Date.now()-element.callbackTimer.start,window.clearTimeout(element.callbackTimer.clock)),beforeCallback(element.node),element.callbackTimer={start:Date.now(),clock:window.setTimeout((function(){afterCallback(element.node),element.callbackTimer=null,element.revealed&&!element.config.reset&&element.config.cleanup&&clean.call(this$1,element.node)}),duration-elapsed)}}var nextUniqueId=(uid=0,function(){return uid++}),uid;function sequence(element,pristine){if(void 0===pristine&&(pristine=this.pristine),!element.visible&&element.revealed&&element.config.reset)return animate.call(this,element,{reset:!0});var seq=this.store.sequences[element.sequence.id],i=element.sequence.index;if(seq){var visible=new SequenceModel(seq,"visible",this.store),revealed=new SequenceModel(seq,"revealed",this.store);if(seq.models={visible:visible,revealed:revealed},!revealed.body.length){var nextId=seq.members[visible.body[0]],nextElement=this.store.elements[nextId];if(nextElement)return cue.call(this,seq,visible.body[0],-1,pristine),cue.call(this,seq,visible.body[0],1,pristine),animate.call(this,nextElement,{reveal:!0,pristine:pristine})}if(!seq.blocked.head&&i===[].concat(revealed.head).pop()&&i>=[].concat(visible.body).shift())return cue.call(this,seq,i,-1,pristine),animate.call(this,element,{reveal:!0,pristine:pristine});if(!seq.blocked.foot&&i===[].concat(revealed.foot).shift()&&i<=[].concat(visible.body).pop())return cue.call(this,seq,i,1,pristine),animate.call(this,element,{reveal:!0,pristine:pristine})}}function Sequence(interval){var i=Math.abs(interval);if(isNaN(i))throw new RangeError("Invalid sequence interval.");this.id=nextUniqueId(),this.interval=Math.max(i,16),this.members=[],this.models={},this.blocked={head:!1,foot:!1}}function SequenceModel(seq,prop,store){var this$1=this;this.head=[],this.body=[],this.foot=[],each(seq.members,(function(id,index){var element=store.elements[id];element&&element[prop]&&this$1.body.push(index)})),this.body.length&&each(seq.members,(function(id,index){var element=store.elements[id];element&&!element[prop]&&(index<this$1.body[0]?this$1.head.push(index):this$1.foot.push(index))}))}function cue(seq,i,direction,pristine){var this$1=this,blocked=["head",null,"foot"][1+direction],nextId=seq.members[i+direction],nextElement=this.store.elements[nextId];seq.blocked[blocked]=!0,setTimeout((function(){seq.blocked[blocked]=!1,nextElement&&sequence.call(this$1,nextElement,pristine)}),seq.interval)}function initialize(){var this$1=this;rinse.call(this),each(this.store.elements,(function(element){var styles=[element.styles.inline.generated];element.visible?(styles.push(element.styles.opacity.computed),styles.push(element.styles.transform.generated.final),element.revealed=!0):(styles.push(element.styles.opacity.generated),styles.push(element.styles.transform.generated.initial),element.revealed=!1),element.node.setAttribute("style",styles.filter((function(s){return""!==s})).join(" "))})),each(this.store.containers,(function(container){var target=container.node===document.documentElement?window:container.node;target.addEventListener("scroll",this$1.delegate),target.addEventListener("resize",this$1.delegate)})),this.delegate(),this.initTimeout=null}function isMobile(agent){return void 0===agent&&(agent=navigator.userAgent),/Android|iPhone|iPad|iPod/i.test(agent)}function deepAssign(target){for(var sources=[],len=arguments.length-1;len-- >0;)sources[len]=arguments[len+1];if(isObject(target))return each(sources,(function(source){each(source,(function(data,key){isObject(data)?(target[key]&&isObject(target[key])||(target[key]={}),deepAssign(target[key],data)):target[key]=data}))})),target;throw new TypeError("Target must be an object literal.")}function reveal(target,options,syncing){var this$1=this;void 0===options&&(options={}),void 0===syncing&&(syncing=!1);var containerBuffer=[],sequence$$1,interval=options.interval||defaults.interval;try{interval&&(sequence$$1=new Sequence(interval));var nodes=tealight(target),elements;if(!nodes.length)throw new Error("Invalid reveal target.");each(nodes.reduce((function(elementBuffer,elementNode){var element={},existingId=elementNode.getAttribute("data-sr-id");existingId?(deepAssign(element,this$1.store.elements[existingId]),element.node.setAttribute("style",element.styles.inline.computed)):(element.id=nextUniqueId(),element.node=elementNode,element.seen=!1,element.revealed=!1,element.visible=!1);var config=deepAssign({},element.config||this$1.defaults,options);if(!config.mobile&&isMobile()||!config.desktop&&!isMobile())return existingId&&clean.call(this$1,element),elementBuffer;var containerNode=tealight(config.container)[0],containerId;if(!containerNode)throw new Error("Invalid container.");return containerNode.contains(elementNode)?(null===(containerId=getContainerId(containerNode,containerBuffer,this$1.store.containers))&&(containerId=nextUniqueId(),containerBuffer.push({id:containerId,node:containerNode})),element.config=config,element.containerId=containerId,element.styles=style(element),sequence$$1&&(element.sequence={id:sequence$$1.id,index:sequence$$1.members.length},sequence$$1.members.push(element.id)),elementBuffer.push(element),elementBuffer):elementBuffer}),[]),(function(element){this$1.store.elements[element.id]=element,element.node.setAttribute("data-sr-id",element.id)}))}catch(e){return logger.call(this,"Reveal failed.",e.message)}each(containerBuffer,(function(container){this$1.store.containers[container.id]={id:container.id,node:container.node}})),sequence$$1&&(this.store.sequences[sequence$$1.id]=sequence$$1),!0!==syncing&&(this.store.history.push({target:target,options:options}),this.initTimeout&&window.clearTimeout(this.initTimeout),this.initTimeout=window.setTimeout(initialize.bind(this),0))}function getContainerId(node){for(var collections=[],len=arguments.length-1;len-- >0;)collections[len]=arguments[len+1];var id=null;return each(collections,(function(collection){each(collection,(function(container){null===id&&container.node===node&&(id=container.id)}))})),id}function sync(){var this$1=this;each(this.store.history,(function(record){reveal.call(this$1,record.target,record.options,!0)})),initialize.call(this)}var polyfill=function(x){return(x>0)-(x<0)||+x},mathSign=Math.sign||polyfill,polyfill$1=(clock=Date.now(),function(callback){var currentTime=Date.now();currentTime-clock>16?(clock=currentTime,callback(currentTime)):setTimeout((function(){return polyfill$1(callback)}),0)}),clock,miniraf=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||polyfill$1;function getGeometry(target,isContainer){var height=isContainer?target.node.clientHeight:target.node.offsetHeight,width=isContainer?target.node.clientWidth:target.node.offsetWidth,offsetTop=0,offsetLeft=0,node=target.node;do{isNaN(node.offsetTop)||(offsetTop+=node.offsetTop),isNaN(node.offsetLeft)||(offsetLeft+=node.offsetLeft),node=node.offsetParent}while(node);return{bounds:{top:offsetTop,right:offsetLeft+width,bottom:offsetTop+height,left:offsetLeft},height:height,width:width}}function getScrolled(container){var top,left;return container.node===document.documentElement?(top=window.pageYOffset,left=window.pageXOffset):(top=container.node.scrollTop,left=container.node.scrollLeft),{top:top,left:left}}function isElementVisible(element){void 0===element&&(element={});var container=this.store.containers[element.containerId];if(container){var viewFactor=Math.max(0,Math.min(1,element.config.viewFactor)),viewOffset=element.config.viewOffset,elementBounds_top=element.geometry.bounds.top+element.geometry.height*viewFactor,elementBounds_right=element.geometry.bounds.right-element.geometry.width*viewFactor,elementBounds_bottom=element.geometry.bounds.bottom-element.geometry.height*viewFactor,elementBounds_left=element.geometry.bounds.left+element.geometry.width*viewFactor,containerBounds_top=container.geometry.bounds.top+container.scroll.top+viewOffset.top,containerBounds_right=container.geometry.bounds.right+container.scroll.left-viewOffset.right,containerBounds_bottom=container.geometry.bounds.bottom+container.scroll.top-viewOffset.bottom,containerBounds_left=container.geometry.bounds.left+container.scroll.left+viewOffset.left;return elementBounds_top<containerBounds_bottom&&elementBounds_right>containerBounds_left&&elementBounds_bottom>containerBounds_top&&elementBounds_left<containerBounds_right||"fixed"===element.styles.position}}function delegate(event,elements){var this$1=this;void 0===event&&(event={type:"init"}),void 0===elements&&(elements=this.store.elements),miniraf((function(){var stale="init"===event.type||"resize"===event.type;each(this$1.store.containers,(function(container){stale&&(container.geometry=getGeometry.call(this$1,container,!0));var scroll=getScrolled.call(this$1,container);container.scroll&&(container.direction={x:mathSign(scroll.left-container.scroll.left),y:mathSign(scroll.top-container.scroll.top)}),container.scroll=scroll})),each(elements,(function(element){(stale||void 0===element.geometry)&&(element.geometry=getGeometry.call(this$1,element)),element.visible=isElementVisible.call(this$1,element)})),each(elements,(function(element){element.sequence?sequence.call(this$1,element):animate.call(this$1,element)})),this$1.pristine=!1}))}function isTransformSupported(){var style=document.documentElement.style;return"transform"in style||"WebkitTransform"in style}function isTransitionSupported(){var style=document.documentElement.style;return"transition"in style||"WebkitTransition"in style}var version="4.0.7",boundDelegate,boundDestroy,boundReveal,boundClean,boundSync,config,debug,instance;function ScrollReveal(options){var invokedWithoutNew,buffer;if(void 0===options&&(options={}),void 0===this||Object.getPrototypeOf(this)!==ScrollReveal.prototype)return new ScrollReveal(options);if(!ScrollReveal.isSupported())return logger.call(this,"Instantiation failed.","This browser is not supported."),mount.failure();try{buffer=deepAssign({},config||defaults,options)}catch(e){return logger.call(this,"Invalid configuration.",e.message),mount.failure()}try{var container;if(!tealight(buffer.container)[0])throw new Error("Invalid container.")}catch(e){return logger.call(this,e.message),mount.failure()}return!(config=buffer).mobile&&isMobile()||!config.desktop&&!isMobile()?(logger.call(this,"This device is disabled.","desktop: "+config.desktop,"mobile: "+config.mobile),mount.failure()):(mount.success(),this.store={containers:{},elements:{},history:[],sequences:{}},this.pristine=!0,boundDelegate=boundDelegate||delegate.bind(this),boundDestroy=boundDestroy||destroy.bind(this),boundReveal=boundReveal||reveal.bind(this),boundClean=boundClean||clean.bind(this),boundSync=boundSync||sync.bind(this),Object.defineProperty(this,"delegate",{get:function(){return boundDelegate}}),Object.defineProperty(this,"destroy",{get:function(){return boundDestroy}}),Object.defineProperty(this,"reveal",{get:function(){return boundReveal}}),Object.defineProperty(this,"clean",{get:function(){return boundClean}}),Object.defineProperty(this,"sync",{get:function(){return boundSync}}),Object.defineProperty(this,"defaults",{get:function(){return config}}),Object.defineProperty(this,"version",{get:function(){return"4.0.7"}}),Object.defineProperty(this,"noop",{get:function(){return!1}}),instance||(instance=this))}return ScrollReveal.isSupported=function(){return isTransformSupported()&&isTransitionSupported()},Object.defineProperty(ScrollReveal,"debug",{get:function(){return debug||!1},set:function(value){return debug="boolean"==typeof value?value:debug}}),ScrollReveal(),ScrollReveal}));