# Contributing Guidelines

To qualify for the __official limited edition Hacktoberfest shirt__, you must register [here](https://hacktoberfest.digitalocean.com/) and make four Pull Requests (PRs) between October 1-31 (in any time zone). PRs can be made to any public repo on GitHub, not only the ones with issues labeled Hacktoberfest. 
This year, the __first 75,000__ participants who complete the challenge will earn a T-shirt.

## How to make your contribution count towards Hacktoberfest 2020

1. Always try to create quality contributions.

2. Any type of code that is copied from somewhere else, which is only an effort towards making a <b>+1</b> to your PR count may lead to disqualification and your PR marking as `invalid` or `spam`

3. You can always refer to the issues created in the repo to get an idea of what you should do to improve the project.

4. Beginners who are going to generate their first PR are also welcome, but always try to explore enough before making a contribution. This will also give you a good exposure as well as a quality contribution.

You can check out the steps you need to follow to contribute


## Steps to follow to start Contributing :scroll:

### 0. Star The Repo :star2:

Star the repo by pressing the topmost-right button to start your wonderful journey.


### 1. Fork the repo :fork_and_knife:

You can get your own fork/copy of <a href="https://github.com/devclub-biet-jhansi/binary-search-visualisation"> Binary search Visualisation </a> by using the <kbd><b>Fork</b></kbd> button at top-right of your screen.


### 2. Clone it to your local machine :busts_in_silhouette:

`NOTE: commands are to be executed on Linux, Mac, and Windows(using Powershell)`

You need to clone (download) it to local machine using

```sh
$ git clone https://github.com/devclub-biet-jhansi/binary-search-visualisation.git
```

> This makes a local copy of the repository in your machine.

Once you have cloned the `binary-search-visualisation` repository in Github, move to that folder first using change directory command on Linux, Mac, and Windows(PowerShell to be used).

```sh
# This will change directory to a folder binary-search-visualisation
$ cd binary-search-visualisation
```

Move to this folder for all other commands.

Now Make your contribution on the project and commit your changes to a new branch

### 3. Create a new branch :bangbang:

Whenever you are going to contribute. Please create a separate branch using command and keep your `master` branch clean (i.e. synced with remote branch).

```sh
# It will create a new branch with name Branch_Name and switch to branch Folder_Name
$ git checkout -b BranchName
```

Create a separate branch for contribution and try to use the same name of the branch as of folder.

To switch to the desired branch

```sh
# To switch from one folder to other
$ git checkout BranchName
```

To add the changes to the branch. Use

```sh
# To add all files to branch Folder_Name
$ git add .
```

Type in a message relevant for the code reviewer using

```sh
# This message get associated with all files you have changed
$ git commit -m 'relevant message'
```

Now, Push your awesome work to your remote repository using

```sh
# To push your work to your remote repository
$ git push -u origin BranchName
```

Finally, go to your repository in the browser and click on `compare and pull requests`.
Then add a title and description to your pull request that explains your precious effort.

 Always feel free to drop a comment or create an issue if you find something missing. Our excellent contributors will always get it done.
 
 Happy Coding 🎉🎉


