# Web and Mobile Development

## What is web development?

According to the Chrome DevRel team, web development refers to the ability to build "beautiful, accessible, fast, and secure websites that work cross-browser, and for all of your users." [source](https://web.dev/about/).

## What is mobile development?

"Mobile application development is the process of creating software applications that run on a mobile device, and a typical mobile application utilizes a network connection to work with remote computing resources. Hence, the mobile development process involves creating installable software bundles (code, binaries, assets, etc.), implementing backend services such as data access with an API, and testing the application on target devices." [source](https://aws.amazon.com/mobile/mobile-application-development/)

## Why should you learn web and mobile development as a student?

You want to create an online store to showcase and sell a certain product or service. The online store will be accessed primarily through websites or mobile phones to increase the reach of your offering. The required skills for building this online store include front-end development to create an interactive interface for your customers and back-end development to manage the application's data. To make the application scalable, reliable, and available, you will need to deploy it on a cloud platform.

You can learn more about web development by visiting [AWS Amplify](https://aws.amazon.com/amplify/)

---

### Level :one: - Getting Started

| Title                                                                                                           | Description                                                                                         | Format         |
|-----------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------|----------------|
| [Create a “Todo app” to store and retrieve items in a cloud ](https://docs.amplify.aws/start/q/integration/js/) | This application can be built using various libraries and frameworks. |     Tutorial           |
| [Building a Serverless Web App with Amplify](https://catalog.us-east-1.prod.workshops.aws/workshops/1665a9b6-958b-4b70-ba52-14127b8fa99f/en-US) |In this tutorial, you'll be introduced to foundational concepts including authentication, storage, and functions. | Workshop |
| [Java Academy](https://catalog.workshops.aws/java-academy/en-US) | Full suite of tutorials to learn and upskill in Java. | Workshop Suite |

---

### Level :two: - Intermediate

| Title                                                                                                                                                        | Description                                                                                                                                                                    | Format           |
|--------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
| [Build a Product Marketplace iOS app Using AWS Amplify and Swift](https://amplify.aws/learn/courses/Swift-Course-70a6d)                                          | This course will show you how to make an iOS app from end to end using AWS Amplify to authenticate users, save data in a database, and store images.                           | Videos, Workshop |
| [Build a Membership Website with Amplify, Stripe, and Next.js](https://amplify.aws/learn/courses/Build-a-Membership-Website-c61a0)                           | Learn how to build a membership website that allows you to collect payments from your members using Stripe.                                                                    | Videos, Workshop |
| [Full Stack for Front-End Developers: Build a full stack app using Amplify and React App](https://amplify.aws/learn/courses/Fullstack-for-Frontend-Developers-e7319) | In this course, you'll learn how to build a fullstack application with AWS Amplify Studio. We'll build a notes application which has authentication, authorization, and data.  | Videos, Workshop |
| [Build a 'Mythical Misfits' project using Code Catalyst](https://docs.aws.amazon.com/codecatalyst/latest/userguide/getting-started-template-project.html) |In this tutorial, you'll use a modern three-tier web application blueprint to create a project in CodeCatalyst. | Tutorial |

---

### Level :three: - Advanced

| Title                                                                                                                                     | Description                                                                                                                                 | Format         |
|-------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------|----------------|
| [Build a Product Roadmap with Next.js and Amplify](https://aws.amazon.com/blogs/mobile/build-a-product-roadmap-with-next-js-and-amplify/) | In this workshop, we’ll build an admin page for product managers to login and update the roadmap and have it reflected on the roadmap page. | Blog, Workshop |
| [Text to Speech on Android Using AWS Amplify](https://aws.amazon.com/blogs/mobile/text-to-speech-on-android-using-aws-amplify/)           | You will learn how to use the Predictions category to implement text to speech in an Android app.                                           | Blog, Workshop |
