# Serverless

## What is Serverless?

"Serverless is a cloud-native development model that allows developers to build and run applications without having to manage servers. There are still servers in serverless, but they are abstracted away from app development. A cloud provider handles the routine work of provisioning, maintaining, and scaling the server infrastructure. Developers can simply package their code in containers for deployment." - [source](https://www.redhat.com/en/topics/cloud-native-apps/what-is-serverless)

## Why should you learn about Serverless as a student?

You are building an application for yourself and your peers to manage your coursework and study progress. Building it in a serverless environment is the easiest and fastest way to create this application. You can build an API to manage schedules and attendance with endpoints that your front-end application can call to trigger functions in the cloud. 

You can learn more about serverless by visiting [Serverless on AWS](https://aws.amazon.com/serverless/)

---

### Level :one: - Getting Started

| Title                                                                                                                                         | Description                                                                                                                                                                                                           | Format         |
|-----------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------|
| [AppSync Immersion Day](https://appsync-immersionday.workshop.aws/)                                                                           | The AWS AppSync immersion day workshop provides an introduction to implementing serverless GraphQl APIs connected to multiple data sources with AppSync                                                               | Workshop, Labs |
| [Lambda and DynamoDB Workshop](https://github.com/alexdebrie/lambda-dynamodb-workshop) | A self-guided workshop on GitHub guiding you through connecting a Lambda function to a DynamoDB database | Workshop |
| [Serverless 101](https://serverlessland.com/learn/serverless-101) | Videos describing serverless concepts | Videos |

---

### Level :two: - Intermediate

| Title                                                                                                                    | Description                                                                                                                                                                                                                  | Format         |
|--------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------|
| [EMR Serverless Workshop](https://catalog.us-east-1.prod.workshops.aws/workshops/e8e8fbb5-c3fb-4f86-bf77-0ba1fe402c55)   | This workshop shows you how to configure and run EMR Serverless and try out various features and use cases                                                                                                                   | Workshop, Labs |
| [Serverless Learning Plan](https://explore.skillbuilder.aws/learn/public/learning_plan/view/92/serverless-learning-plan) | A Serverless Learning Plan pulls together training content for a serverless technologies. Organized assets from foundational to advanced. Use this Learning Plans as a starting point to discover training about serverless. | Videos         |
| [Wild Rydes Serverless Workshops](https://github.com/aws-samples/aws-serverless-workshops) | 15 intermediate level workshops to explore many aspects of serverless architecture | Workshop         |

---

### Level :three: - Advanced

| Title                                                                                                                                                  | Description                                                                                                                                                       | Format         |
|--------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------|
| [AWS Serverless Data Lake Jumpstart](https://catalog.us-east-1.prod.workshops.aws/workshops/276faf92-bffc-4843-8a8e-8078add48194)                      | This workshop is prepared to guide participants on how to use AWS serverless services to build a cloud-native and future-proof serverless data lake architecture. | Workshop, Labs |
| [Serverless Optimization Workshop (Performance and Cost)](https://catalog.us-east-1.prod.workshops.aws/workshops/2d960419-7d15-44e7-b540-fd3ebeb7ce2e) | A hands-on look at some best practice techniques to optimize your serverless workloads to reduce costs and improve performance.                                   | Workshop, Labs |
