# Security

## What is Security?

"IT security is a set of cybersecurity strategies that prevents unauthorized access to organizational assets such as computers, networks, and data. It maintains the integrity and confidentiality of sensitive information, blocking the access of sophisticated hackers." - [source](https://www.cisco.com/c/en/us/products/security/what-is-it-security.html)

## Why should you learn about Security as a student?

You have made an application for your college event registrations that handles fee collection. Since you will need to collect sensitive personal information such as credit card information, __encryption__ must be used to protect this data. You need to have __access control__ policies in place to limit data exposure and implement __multifactor authentication__ for reliable authorized logins. To ensure that these security protocols are properly implemented you need to be well-versed in __Security__, __Privacy__ and __Safety__ protocols.

You can learn more about Security services by visiting [AWS Cloud Security](https://aws.amazon.com/security/)

---

### Level :one: - Getting Started

| Title                                                                                                                                                                    | Description                                                                                                                                                                                                 | Format |
|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------|
| [AWS Security Fundamentals - Skillbuilder](https://explore.skillbuilder.aws/learn/course/external/view/elearning/48/aws-security-fundamentals-second-edition?src=detail) | In this self-paced course, you will learn fundamental AWS cloud security concepts, including AWS access control, data encryption methods, and how network access to your AWS infrastructure can be secured. | Course |

---

### Level :two: - Intermediate

| Title                                                                      | Description                                                                                                                                                        | Format |
|----------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------|
| [Cybersecurity Specialist](https://awseducate.instructure.com/courses/196)<sup>[1]</sup> | Learn about AWS Shared Security Responsibility Model, Network Security, Access Control and Management, Encryption, Security Logging and Monitoring in this course. | Videos |
| [Online Privacy](https://awseducate.instructure.com/courses/237)<sup>[1]</sup>           | In this course you will make yourself aware on how you can secure your online privacy by changing everyday habits when interacting with social platforms.          | Videos |

<sup>[1]</sup> requires logging into [AWS Educate](https://www.awseducate.com/student/s) before clicking on the resource link.

---

### Level :three: - Advanced

| Title                                                                                                                                                                                                                    | Description                                                                                                                                               | Format   |
|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------|----------|
| [Ransomware on S3 - Security Event Simulation and Detection](https://catalog.us-east-1.prod.workshops.aws/workshops/fc7b7cf3-f494-48e2-8954-258ffdd76ed6)                                                                | In this workshop, you will be simulating a scenario by creating a few IAM users and then infiltrating the security using a few scripts                    | Workshop |
| [Unauthorized IAM Credential Use - Security Event Simulation and Detection](https://catalog.us-east-1.prod.workshops.aws/workshops/6a8ad836-10a6-4694-9a3b-f53f193041de)                                                 | During this workshop, you will simulate the unauthorized use of IAM credentials using a script invoked within AWS CloudShell.                             | Workshop |
| [Implementing a True Passwordless Authentication with Amazon Cognito and Transmit Security](https://aws.amazon.com/blogs/apn/implementing-a-true-passwordless-authentication-with-amazon-cognito-and-transmit-security/) | Use Amazon Cognito for your application authentication and leverage Transmit Security to provide end users with a passwordless authentication experience. | Workshop |
