# Internet of Things (IoT)

## What is the Internet of Things?

"The term IoT, or Internet of Things, refers to the collective network of connected devices and the technology that facilitates communication between them and the cloud, as well as between the devices themselves. Thanks to the advent of inexpensive computer chips and high bandwidth telecommunication, we now have billions of devices  connected to the internet. This means everyday devices like toothbrushes, vacuums, cars, and machines can use sensors to collect data and respond intelligently to users." - [source](https://aws.amazon.com/what-is/iot/)

## Why should you learn about the Internet of Things as a student?

Imagine that you are taking care of a small garden in your backyard. Since you have classes to attend, you are unable to regularly water the plants. The Internet of Things might provide a solution to this problem. You can use sensors to monitor the moisture in the soil and implement a smart irrigation system. As soon as the sensor sends a message that the moisture has dropped below a certain threshold, the irrigation system will be activated and water will be supplied to all the plants.

You can learn more about the Internet of Things by visiting [AWS Internet of Things](https://aws.amazon.com/iot/)

AWS Robotics has a GitHub repo with [valuable learning content](https://github.com/aws-robotics).


---

### Level :one: - Getting Started

| Title                                                                                                                                                                                                                 | Description                                                                                                                                                                                           | Format      |
|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------|
| [Get Started with AWS IoT](https://catalog.us-east-1.prod.workshops.aws/workshops/6d30487a-48e1-4631-b6bc-5602582800b5/en-US/)                                                                                        | This workshop provides a 3-hour guided walkthrough to create your proof-of-concept IoT project on AWS. It covers AWS IoT Core, Device Management, and Device Defender features                        | Workshop    |
| [AWS IoT Events Workshop](https://iotevents.workshop.aws/)                                                                                                                                                            | AWS IoT Events is an AWS service that helps companies continuously monitor their equipment and fleets of devices for failure or changes in operation and trigger alerts to respond when events occur. | Workshop    |
| [IoT Microcontrollers: Onboarding a Raspberry Pi Using AWS Greengrass](https://explore.skillbuilder.aws/learn/course/external/view/elearning/378/iot-microcontrollers-onboarding-a-raspberry-pi-using-aws-greengrass) | This course provides a walkthrough of setting up Greengrass core on a Raspberry Pi.                                                                                                                   | Course, Lab |
| [IoT ESP32 Workshop](https://iot-esp32.workshop.aws/)                                                                                                                                                                 | Workshop focused on creating progressive real world projects integrating AWS IoT and the ESP32 MCU                                                                                                    | Workshop    |

---

### Level :two: - Intermediate

| Title                                                                                                                                                                                                                 | Description                                                                                                                                                                                                                           | Format       |
|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------|
| [AWS IoT Immersion Day Workshop](https://catalog.workshops.aws/aws-iot-immersionday-workshop/en-US)                                                                                                                   | AWS IoT Immersion Day workshop is a collection of labs to guide AWS IoT Partners through all the different aspects of using AWS IoT and the relevant downstream services.                                                             | Workshop     |
| [AWS IoT for Automotive](https://catalog.workshops.aws/awsiotforautomotive)                                                                                                                                           | In this workshop, participants learn the basics of developing a next-generation vehicle communication platform using AWS IoT Core. Topics include basic telemetry ingest, IoT Jobs, Shadows and Greengrass.                           | Workshop     |

---

### Level :three: - Advanced

| Title                                                                                                                                                                    | Description                                                                                                                                                                                                           | Format     |
|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------|
| [Building a Digital Twin with Photogrammetry and AWS IoT TwinMaker](https://aws.amazon.com/blogs/iot/building-a-digital-twin-with-photogrammetry-and-aws-iot-twinmaker/) | You will learn how you can use photographs taken by a drone to create a 3D model of real world environments within a digital twin                                                                                     | Blog, Labs |
| [AWS IoT TwinMaker Advanced Workshop](https://catalog.us-east-1.prod.workshops.aws/workshops/c9cd344a-0d0b-42cb-8734-09667433f89c)                                       | You will walk step by step through the build out of an Amazon TimeStream Component for AWS IoT TwinMaker, create entities, a scene, and visualize your dashboard in Grafana.                                          | Workshop   |
