# Database

## What are Databases?

A database is an organized collection of structured information, or data, typically stored electronically in a computer system. A database is usually controlled by a database management system (DBMS). - [source](https://www.oracle.com/in/database/what-is-database/)

Database is a technology domain when you have a requirement to store large amounts of data and manage it. With databases organizing such data and retrieving it becomes fast and easy.

## Why should you learn about Databases as a student?

Let's take an example where you want to create a web site to showcase your college events. You need to make sure that operations like create, read, update, and delete are possible when managing the events. You can use a database to store the events created on the frontend of your web site. Whenever you perform an operation to add, delete, or modify an event on your website, the event's record will be edited in the database and then updated on the web application.

You can learn more about databases on AWS by visiting - [AWS Cloud Databases](https://aws.amazon.com/products/databases/)

---

### Level :one: - Getting Started

| Title                                                                                                                                                                                                                | Description                                                                                                                           | Format       |
|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------|--------------|
| [Getting Started with Amazon Timestream](https://explore.skillbuilder.aws/learn/course/external/view/elearning/14501/getting-started-with-amazon-timestream)                                                         | Timestream is a database service for usecases involving IoT and time   sensitive data                                                 | Video Course |
| [Getting Started with Amazon Neptune](https://explore.skillbuilder.aws/learn/course/external/view/elearning/14165/getting-started-with-amazon-neptune)                                                               | Amazon Neptune is specially used for connections between data and   services. Learn more about Amazon Neptune in this course.         | Video Course |
| [Getting Started with Amazon Keyspaces](https://explore.skillbuilder.aws/learn/course/external/view/elearning/13688/getting-started-with-amazon-keyspaces)                                                           | When you require fast access to data in a highly scalable environment for   your application, you will need Amazon Keyspaces          | Video Course |
| [Getting Started with Amazon DocumentDB (with MongoDB compatibility)](https://explore.skillbuilder.aws/learn/course/external/view/elearning/12290/getting-started-with-amazon-documentdb-with-mongodb-compatibility) | While working with unstructured data, you would need a NoSQL database   service, Amazon DocumentDB does just that for you.            | Video Course |
| [Getting Started with Amazon RDS for MariaDB](https://explore.skillbuilder.aws/learn/course/external/view/elearning/12331/getting-started-with-amazon-rds-for-mariadb)                                               | Amazon RDS is used in scenarios where you would want to work with structured data using a relational database service. | Video Course |

---

### Level :two: - Intermediate

| Title                                                                                                    | Description                                                                                                                             | Format         |
|----------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------|----------------|
| [Amazon RDS for SQL Server Workshop](https://rdssms.workshop.aws/)                                       | This is an advanced hands on workshop on creating Relational Database on Cloud                                                          | Workshop, Labs |
| [Amazon RDS for PostgreSQL - Workshop](https://rdspg.workshop.aws/)                                      | PostgreSQL is also a form of relational database management system. Learn more on how Amazon RDS makes PostgreSQL easy to use and setup | Workshop, Labs |
| [Amazon DocumentDB (with MongoDB compatibility) workshop](https://documentdb-immersionday.workshop.aws/) | When working with NoSQL, you would need to learn Amazon DocumentDB, in this workshop learn how to use DocumentDB for your project       | Workshop, Labs |

---

### Level :three: - Advanced

| Title                                                                            | Description                                                                                                                                                                         | Format         |
|----------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------|
| [SQL Server Immersion Day](https://sql-immersionday.workshop.aws/)               | This is a beginner to advance course with a long duration to completely understand how to host SQL applications on AWS                                                              | Workshop, Labs |
| [Amazon Aurora PostgreSQL Immersion Day](https://aurora-pg-lab.workshop.aws/)    | Amazon Aurora is a relational database service which provides a higher performance compared to Amazon RDS, Learn more about this high performance database service in this workshop | Workshop, Labs |
| [Amazon DynamoDB Workshops and Labs](https://amazon-dynamodb-labs.workshop.aws/) | Amazon DynamoDB is a NoSQL database service with lower latency and higher performance than Amazon DocumentDB. Deep dive into DynamoDB service by exploring this workshop            | Workshop, Labs |
