# Containers and Kubernetes

## What are Containers?

"A container is a standard unit of software that packages up code and all its dependencies so the application runs quickly and reliably from one computing environment to another." [source](https://www.docker.com/resources/what-container/).

## What is Kubernetes?

"Kubernetes is a portable, extensible, open source platform for managing containerized workloads and services, that facilitates both declarative configuration and automation." [source](https://kubernetes.io/docs/concepts/overview/)

## Why should you learn Containers and Kubernetes as a student?

Containers simplify project deployment and development tasks. Your application might be required to run in different computing environments, and containerization helps you to package your software and all its dependencies into a single unit.

Imagine that you are developing an Event Planner application to support your college events. You may want to run the application on different environments because a large audience will be using it. You may also be uncertain about the amount of traffic that your application will receive. In this case you can use containers to package all the software and its dependencies in a single package while deploying it using Kubernetes to ensure it can scale to meet changes in demand.

You can learn more about Container and Kubernetes services by visiting:
- [Amazon Elastic Container Service (Amazon ECS)](https://aws.amazon.com/ecs/)
- [Amazon Elastic Kubernetes Service (EKS)](https://aws.amazon.com/eks/)
- [AWS Fargate](https://aws.amazon.com/fargate/)
- [Amazon Elastic Container Registry (Amazon ECR)](https://aws.amazon.com/ecr/)

---

### Level :one: - Getting Started

| Title                                                                                                                                            | Description                                                                                                                                                                                 | Format |
|--------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------|
| [Introduction to Containers](https://explore.skillbuilder.aws/learn/course/external/view/elearning/106/introduction-to-containers)               | An introductory course for beginners who are just getting started learning about Containers                                                                            | Videos |
| [Getting Started with Amazon ECS](https://explore.skillbuilder.aws/learn/course/external/view/elearning/13597/getting-started-with-amazon-ecs)   | This is an introductory video course to get started with Amazon Elastic Container Service                                                                                                   | Videos |
| [Getting started with AWS Fargate](https://explore.skillbuilder.aws/learn/course/external/view/elearning/13380/getting-started-with-aws-fargate) | After familiarizing yourself with Amazon ECS, you can do this course to learn how to run containers without having to manage servers or clusters of Amazon EC2 instances using AWS Fargate. | Videos |


---

### Level :two: - Intermediate

| Title                                                                       | Description                                                                               | Format       |
|-----------------------------------------------------------------------------|-------------------------------------------------------------------------------------------|--------------|
| [Amazon Elastic Container Service (Amazon ECS)](https://ecsworkshop.com/)   | A mix of video courses and labs about Amazon Elastic Container Services                   | Videos, Labs |
| [Amazon Elastic Kubernetes Service (EKS)](https://www.eksworkshop.com/)     | This is an introductory video course to get started with Amazon Elastic Container Service | Videos, Labs |
| [Containers from the Couch](https://www.youtube.com/containersfromthecouch) | Follow this YouTube channel that covers everything about Containers and Kubernetes      | Videos       |

---

### Level :three: - Advanced

| Title                                                                                                                                                                                                                           | Description                                                                                          | Format                  |
|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------|-------------------------|
| [Build and deploy a scalable machine learning system on Kubernetes with Kubeflow on AWS](https://aws.amazon.com/blogs/machine-learning/build-and-deploy-a-scalable-machine-learning-system-on-kubernetes-with-kubeflow-on-aws/) | This blog demonstrates the functionality of Kubernetes with a demo application using Kubeflow on AWS | Documentation, Tutorial |
| [Deep Dive on AWS App Runner Private Services](https://aws.amazon.com/blogs/containers/deep-dive-on-aws-app-runner-private-services/)                                                                                           | Build a front-end web application (Gaming Leaderboard) using AWS App Runner                          | Documentation, Tutorial |
|                                                                                                                                                                                                                                 |                                                                                                      |                         |