# Artificial Intelligence and Machine Learning

## What is Machine Learning?

According to Columbia University, "artificial intelligence refers to the general ability of computers to emulate human thought and perform tasks in real-world environments, while machine learning refers to the technologies and algorithms that enable systems to identify patterns, make decisions, and improve themselves through experience and data." [source](https://ai.engineering.columbia.edu/ai-vs-machine-learning/). 

## Why should you learn Machine Learning as a student?

Machine learning helps you automate tasks, which would usually be time consuming and difficult if done manually. You may have seen how you receive recommendations on the Amazon shopping app about what to buy based on your previous purchases. Machine learning achieves this feat by analyzing lots of data to learn obvious patterns on how one product is related to another. For example, you can use machine learning to train a chatbot that can answer queries about a specific product when a user has doubts before purchasing it.

You can learn more about Machine Learning services by visiting https://aws.amazon.com/machine-learning/

---

# Machine Learning Camp for AWS Cloud Clubs

If you're a member or a leader of an [AWS Cloud Club](https://www.meetup.com/pro/cloud-clubs/), you can participate in "ML Camp" located here: "[Build Your First Machine Learning Web App](https://s12d.com/mlapi-camp)", where you'll learn the basics of applied Machine Learning on AWS.

What's "Camp"? It's a workshop, only better! With a trained facilitator, work through the modules in the workshop [here](https://s12d.com/mlapi-camp). They include quizzes and challenges and the ability to earn a badge on completion of the Camp. While this experience is normally available for AWS Cloud Clubs, reach out to awscloudclubs@amazon.com if you'd like to run this Camp in a non-Cloud Club environment.

- Training Video - coming soon
- Powerpoint for instructors is available - please email us at awscloudclubs@amazon.com

---

### Level :one: - Getting Started

| Title                                                                                                                                                                                                                                                                                                     | Description                                                                                                                                                                 | Format        |
|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------|
| [Foundations of Generative AI for Beginners](https://www.coursera.org/learn/aws-generative-ai-for-beginners)                                                                                                                                                                                                                          | Beginner-level Coursera course on Generative AI                                                                                                               | Videos |
| [AWS Machine Learning University](https://github.com/aws-samples/aws-machine-learning-university-accelerated-nlp/?trk=el_a134p000006gNt0AAE&trkCampaign=Machine_Learning_University_NLP_github&sc_channel=el&sc_campaign=Machine_Learning_University_Webpage_NLP_github_CTA&sc_outcome=Product_Marketing) | Make use of this extensive collection which contains slides, notebooks and datasets for the Machine Learning                                                                | Demos, Labs   |
| [Machine Learning University interactive portal](https://mlu-explain.github.io/)                                                                                                                                                                                                                          | An interactive way of understanding Machine learning concepts                                                                                                               | Documentation |
| [AWS Power Hour: Machine Learning Eight episode course](https://pages.awscloud.com/global-traincert-twitch-power-hour-machine-learning.html)                                                                                                                                                              | A detailed course for students who like to learn from watching video content                                                                                                | Videos        |
| [Machine Learning Foundations](https://awseducate.instructure.com/courses/756) <sup>[1]</sup>                                                                                                                                                                                                                            | A beginner course about Machine learning on AWS Educate | Videos        |

---

### Level :two: - Intermediate


| Title                                                                                                                                     | Description                                                                                    | Format       |
|-------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------|--------------|
| [AWS DeepRacer Student](https://aws.amazon.com/deepracer/student/)                                                                        | Learn about Reinforcement Learning by training a car in a virtual autonomous racing league | Game, Course |
| [QnA bot workshop](https://catalog.us-east-1.prod.workshops.aws/workshops/20c56f9e-9c0a-4174-a661-9f40d9f063ac/en-US)                 | Build a conversational AI bot                                 | Workshop     |
| [Speech AI workshop](https://catalog.us-east-1.prod.workshops.aws/workshops/acd49d39-dfcd-429a-83d6-d162b99b4c24/en-US)                   | Use AI to understand conversations                       | Workshop     |
| [Amazon SageMaker Lab course](https://catalog.us-east-1.prod.workshops.aws/workshops/80ba0ea5-7cf9-4b8c-9d3f-1cd988b6c071/en-US) | Get started with SageMaker using this eight-part lab course                                 | Workshop     |
| [Generative AI Workshop](https://catalog.workshops.aws/building-gen-ai-apps/en-US) | Generative AI delivered in modules starting at L100 with PartyRock and progressing to Bedrock                                 | Workshop     |
| [AWS DeepRacer primer](https://awseducate.instructure.com/courses/750) <sup>[1]</sup>                                                                    | Learn more about DeepRacer in this course                                                      | Videos       |


---

### Level :three: - Advanced

| Title                                                                                                                                                                                                                                             | Description                                                                                                                                                               | Format             |
|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------|
| [Advanced ML Courses on AWS Educate](https://www.awseducate.com/student/s/) <sup>[1]</sup>                                                                                                                                                                                    | Advanced courses - filter on 'Machine Learning & AI - Advanced'                                                                       | Course Collection              |
| [How to encrypt sensitive caller voice input in Amazon Lex](https://aws.amazon.com/blogs/security/how-to-encrypt-sensitive-caller-authentication-voice-input-in-amazon-lex/)                                                                      | Protect a caller's sensitive voice data captured through Amazon Lex by using data encryption using an AWS Lambda functions                                                                                                                                     | Lab, Documentation |
| [Build a loyalty points anomaly detector using Amazon Lookout for Metrics](https://aws.amazon.com/blogs/machine-learning/build-a-loyalty-points-anomaly-detector-using-amazon-lookout-for-metrics/)                                               | Amazon Lookout for Metrics uses ML to detect outliers and determine their root causes | Lab, Documentation |
| [Build a water consumption forecasting solution for a water utility agency using Amazon Forecast](https://aws.amazon.com/blogs/machine-learning/build-a-water-consumption-forecasting-solution-for-a-water-utility-agency-using-amazon-forecast/) | Amazon Forecast is a ML service for time series forecasting                                                                                                 | Lab, Documentation |
| [Upscale images with Stable Diffusion in Amazon SageMaker JumpStart](https://aws.amazon.com/blogs/machine-learning/upscale-images-with-stable-diffusion-in-amazon-sagemaker-jumpstart/)                                                           | Build a solution to increase the resolution of a given image using ML                                               | Lab, Documentation |

<sup>[1]</sup> requires logging into [AWS Educate](https://www.awseducate.com/student/s) before clicking on the resource link.

---

See also - [Data Science and Data Analytics](../DataScience_DataAnalytics)
