export default {
  id: 'socialMedia',
  title: 'Review your social media privacy settings',
  description: `Over the years social media companies are able to gather staggering amounts of data about you, your interests, who you talk to, where you go, what you buy, and so much more.

  \n\nIf you‘re not ready to give up social media quite yet, you should take the time to review your security and privacy settings. Visualizing the amount of information that social media companies know about you may be enough to curb that unhealthy newsfeed obsession.`,
  apps: [
    {
      name: 'Jumbo',
      image: '/static/img/jumbo.png',
      url: 'https://www.jumboprivacy.com/',
      sources: {
        ios: 'https://apps.apple.com/us/app/jumbo-privacy/id1454039975',
        android: 'https://play.google.com/store/apps/details?id=com.jumboprivacy'
      }
    }
  ],
  resources: [
    {
      name: 'Facebook privacy settings',
      url: 'https://www.facebook.com/settings?tab=privacy',
    },
    {
      name: 'Facebook ad personalization settings',
      url:
        'https://www.facebook.com/ads/preferences/?entry_product=ad_settings_screen',
    },
    {
      name: 'Facebook location history',
      url: 'https://www.facebook.com/settings?tab=location',
    },
    {
      name: 'Facebook face recognition settings',
      url: 'https://www.facebook.com/settings?tab=facerec',
    },
    {
      name: 'Your Facebook information',
      url: 'https://www.facebook.com/settings?tab=your_facebook_information',
    },
    {
      name: 'Facebook security settings',
      url: 'https://www.facebook.com/settings?tab=security',
    },
    {
      name: 'Twitter personalization settings',
      url: 'https://twitter.com/settings/account/personalization',
    },
    {
      name: 'Twitter privacy and safety settings',
      url: 'https://twitter.com/settings/safety',
    },
    {
      name: 'Google activity',
      url: 'https://myactivity.google.com/myactivity',
    },
    {
      name: 'Google location history',
      url: 'https://www.google.com/maps/timeline?authuser=0&pb',
    },
    {
      name: 'Google ad personalization settings',
      url: 'https://adssettings.google.com/authenticated',
    },
    {
      name: 'Google purchase history',
      url:
        'https://myaccount.google.com/purchases?utm_source=google-account&utm_medium=web',
    },
    {
      name: 'Google subscription history',
      url:
        'https://myaccount.google.com/subscriptions?utm_source=google-account&utm_medium=web',
    },
    {
      name: 'Google reservation history',
      url:
        'https://myaccount.google.com/reservations?utm_source=google-account&utm_medium=web&continue=https%3A%2F%2Fmyaccount.google.com%2Fpayments-and-subscriptions',
    },
    {
      name:
        're:consent browser extension gives you more privacy control on the web',
      url: 'https://cliqz.com/en/magazine/re-consent',
    },
    {
      name: 'Opt out of all the data sharing you wouldn’t opt in to',
      url: 'http://simpleoptout.com/',
    },
  ],
};
