export default {
  id: 'phishing',
  title: 'Educate yourself about phishing attacks',
  description: `Phishing is an attempt to obtain sensitive information (like an account password) by disguising as a trustworthy person or company. Phishing often occurs via email where a hacker will use social engineering to convince someone to click a link that goes to a fake login page. The fake login page then sends anything the victim types (including usernames and passwords) to the hacker.

  \n\nIn recent years phishing attacks have become increasingly sophisticated and hackers are learning to use data that people put on the web to create highly specific and targeted attacks.

  \n\n**Smart people are not immune to phishing.**

  \n\nYou should learn the basics of phishing and how to identify a phishing attempt.`,
  resources: [
    {
      name: 'Jigsaw Google: Can you spot when you’re being phished?',
      url:
        'https://phishingquiz.withgoogle.com/',
    },
    {
      name: 'Podcast: What kind of idiot gets phished?',
      url:
        'https://www.gimletmedia.com/reply-all/97-what-kind-of-idiot-gets-phished',
    },
    {
      name: 'Common phishing attacks and how to protect against them',
      url:
        'https://www.tripwire.com/state-of-security/security-awareness/6-common-phishing-attacks-and-how-to-protect-against-them/',
    },
    {
      name: 'Resisting phishing attacks with three golden rules',
      url: 'https://www.wired.com/story/resist-phishing-attacks/',
    },
    {
      name: 'Google Password Alert Chrome extension',
      url:
        'https://chrome.google.com/webstore/detail/password-alert/noondiphcddnnabmjcihcjfbhfklnnep?hl=en',
    },
  ],
};
