export default {
  id: 'geotagging',
  title: 'Review and remove metadata attached to photos you share',
  description: `Geotagging is the process of adding geographical identification to media files (photos and videos, for example). Anyone who has access to these tagged media files can read this data and learn where the photo was taken. Most social media sites strip the EXIF data from photos, but if you're hosting your own photos, be aware that the geolocation can give away your exact location.

  \n\nYou should understand how location metadata is attached to your media and take steps to ensure you are not uploading sensitive information with your files.
  `,
  resources: [
    {
      name: 'Are Location-Tagged Photos Really a Privacy Concern?',
      url: 'https://www.howtogeek.com/340566/are-location-tagged-photos-really-a-privacy-concern/',
    },
    {
      name: 'Software Roundup: 5 of The Best Apps to Remove EXIF Data from Images',
      url: 'https://www.maketecheasier.com/best-apps-remove-exif-data-from-images/',
    },
    {
      name: 'Geotagging',
      url: 'https://en.wikipedia.org/wiki/Geotagging',
    },
    {
      name: 'What is geotag security and how it helps to protect your family',
      url: 'https://www.geotag-security.com/',
    },
    {
      name: 'Web photos that reveal secrets, like where you live',
      url:
        'https://www.nytimes.com/2010/08/12/technology/personaltech/12basics.html',
    },
    {
      name: 'How to avoid the potential risks of geotagging',
      url: 'https://www.wikihow.com/Avoid-the-Potential-Risks-of-Geotagging',
    },
    {
      name: 'How to turn off geotagging for photos on iPhone and iPad',
      url:
        'https://www.techbout.com/turn-off-geotagging-for-photos-iphone-ipad-8738/',
    },
    {
      name: 'How To turn off geotagging on Android devices',
      url: 'https://www.technobezz.com/turn-off-geotagging-android-devices/',
    },
  ],
};
