# Security checklist
A checklist for staying safe on the internet.

### This project has moved
In the interest of maintaining fewer services, codebases, and domains, I've integrated this project into my [personal website](https://github.com/brianlovin/brian-lovin-next). View the live project at [brianlovin.com/security](https://brianlovin.com/security).

### Motivation
This project is the result of a conversation started during a [recent episode](https://spec.fm/podcasts/design-details/249464) of the [Design Details Podcast](https://spec.fm/podcasts/design-details/) and a subsequent tweet by [Michael Knepprath](https://twitter.com/mknepprath/status/1083966912420372481).

### Contributing
This project should be considered a living document of resources and applications that improve people's digital security and privacy. Contributions, edits, and extensions are welcome!

If you have resources to add to existing sections, please open a pull request.

- Aim for reputable sources for guides and news coverage.
- If adding an app, please include links to as many platforms as possible. See `config/*.js` for examples of how data is formatted.
- Try to use approachable human-readable language. Remember that even non-technical folks need to stay safe online.

If you would like to create a new category of security and privacy resources, please open an issue first with your proposed category. Please explain why this additional category should stand alone from other existing sections.

### Run this locally
1. `$ git clone git@github.com:brianlovin/security-checklist.git`
2. `$ cd security-checklist`
3. `$ npm install`
4. `$ npm run dev`
5. View the running app in your browser at `http://localhost:3000`

### Deploying
You can deploy this project yourself with ZEIT + Now by configuring `now.json` and running `$ now`.

### Feedback
Please open issues at any time for general feedback, or you can reach me directly at hi@brianlovin.com.
