<img class="logo" src="assets/logo/logo.png">

# Mannequin.js

**Mannequin.js** is a library of an articulated mannequin figures.
The shape and the movements of the figures are done purely in JavaScript.
The library is used in the course *Fundamentals of Computer Graphics*
for Computer Sciences undergraduate students from the
[Faculty of Mathematics and Informatics](https://www.fmi.uni-sofia.bg/en)
at [Sofia University](https://www.uni-sofia.bg/index.php/eng).


### Documentation

* [User guide and API](https://boytchev.github.io/mannequin.js/docs/userguide.html)
* [Ръководство на потребителя](https://boytchev.github.io/mannequin.js/docs/userguide-bg.html)


### Demos

<div class="gallery">

	<a class="style-block" href="https://boytchev.github.io/mannequin.js/docs/example-posture.html">
		<img src="https://boytchev.github.io/mannequin.js/docs/snapshots/example-posture.jpg">
	</a>

	<a class="style-block" href="https://boytchev.github.io/mannequin.js/docs/example-figure-types.html">
		<img src="https://boytchev.github.io/mannequin.js/docs/snapshots/example-figure-types.jpg">
	</a>

	<a class="style-block" href="https://boytchev.github.io/mannequin.js/docs/example-custom-body-parts.html">
		<img src="https://boytchev.github.io/mannequin.js/docs/snapshots/example-custom-body-parts.jpg">
	</a>

	<a class="style-block" href="https://boytchev.github.io/mannequin.js/docs/example-point.html">
		<img src="https://boytchev.github.io/mannequin.js/docs/snapshots/example-point.jpg">
	</a>

	<a class="style-block" href="https://boytchev.github.io/mannequin.js/docs/example-scene.html">
		<img src="https://boytchev.github.io/mannequin.js/docs/snapshots/example-scene.jpg">
	</a>
</div>

### Posture editor

[<img src="https://boytchev.github.io/mannequin.js/docs/snapshots/example-posture-editor.jpg">](https://boytchev.github.io/mannequin.js/src/editor/posture-editor.html)


### Community

List of sites that use mannequin.js or alternatives:

* [SetPose.com](https://setpose.com/) &ndash; free interactive 3D model reference for drawing figures, dynamic poses, and more online drawing mannequin
* [Marionettes](https://roipoussiere.frama.io/marionettes/) &ndash; a client-side library used to edit and preview 3d-model postures

<div class="footnote">
	<a href="docs/cookies.html">Cookies</a> &middot; 
	<a href="docs/licence.html">Licence</a> &middot; 
	<a href="https://github.com/boytchev/mannequin.js">GitHub</a> &middot; 
	<a href="https://www.npmjs.com/package/mannequin-js">NPM</a>
</div>


