"use strict";

// Source: https://stackoverflow.com/a/111545/4466589
function encodeQueryData(data) {
    let ret = [];
    for (let d in data) {
        if (data[d] === null || data[d] === undefined)
            continue;
        ret.push(encodeURIComponent(d) + "=" + encodeURIComponent(data[d]));
    }
    return ret.join("&");
}


// Source: https://stackoverflow.com/q/10420352/4466589
function fileSize(fileSizeInBytes) {
    let i = -1;
    let byteUnits = [' KiB', ' MiB', ' GiB', ' TiB', ' PiB', ' EiB', ' ZiB', ' YiB'];
    do {
        fileSizeInBytes = fileSizeInBytes / 1024;
        i++;
    } while (fileSizeInBytes > 1024);

    return Math.max(fileSizeInBytes, 0.1).toFixed(1) + byteUnits[i];
}

function humaniseDate(unixTime) {
    return (new Date(unixTime * 1000)).toLocaleDateString("en-GB", {
        day: "2-digit",
        month: "2-digit",
        year: "numeric"
    });
}

// a fetch() that errs on anything but HTTP 2XX
// Source: https://github.com/github/fetch/issues/155#issuecomment-108288863
function myFetch(url, options) {
    if (options == null) options = {}
    if (options.credentials == null) options.credentials = 'same-origin'
    return fetch(url, options).then(function(response) {
        if (response.status >= 200 && response.status < 300) {
            return Promise.resolve(response)
        } else {
            var error = new Error(response.statusText || response.status)
            error.response = response
            return Promise.reject(error)
        }
    })
}

/**
 * Returns the ISO 8601 week number for this date.
 *
 * Source: https://stackoverflow.com/a/9047794/4466589
 *
 * @param int dowOffset
 * @return int
 */
Date.prototype.getWeek = function (dowOffset) {
    /* getWeek() was developed by Nick Baicoianu at MeanFreePath: http://www.meanfreepath.com */

    dowOffset = 1;
    let newYear = new Date(this.getFullYear(),0,1);
    let day = newYear.getDay() - dowOffset; //the day of week the year begins on
    day = (day >= 0 ? day : day + 7);
    let daynum = Math.floor((this.getTime() - newYear.getTime() -
        (this.getTimezoneOffset()-newYear.getTimezoneOffset())*60000)/86400000) + 1;
    let weeknum;
    // if the year starts before the middle of a week
    if(day < 4) {
        weeknum = Math.floor((daynum+day-1)/7) + 1;
        if(weeknum > 52) {
            nYear = new Date(this.getFullYear() + 1,0,1);
            nday = nYear.getDay() - dowOffset;
            nday = nday >= 0 ? nday : nday + 7;
            /*if the next year starts before the middle of
              the week, it is week #1 of that year*/
            weeknum = nday < 4 ? 1 : 53;
        }
    }
    else {
        weeknum = Math.floor((daynum+day-1)/7);
    }
    return weeknum;
};