# awesome-seo

本清单是我在自2019年开始系统性学习Google SEO而整理的。清单我会不定期更新，也欢迎大家提PR分享你觉得不错的任何关于SEO的链接。

百度SEO和Google SEO是有差异的，不过在你学会Google SEO后，你自然知道如何去学习百度SEO了。

<details>
  <summary>关于为何要做SEO</summary>
  在互联网中，流量就是钱。掌握一定的SEO技术，可以让你：


  - 提升自己的网站流量，通过流量变现去盈利，构建你的被动收入；
  - 如果你做个人产品，产品需要去营销推广，而SEO可以帮你获取免费而稳定增长的流量；
  - SEO是个涉及面很广的行业，你还可以在此过程中不断的学习掌握一些新的技术。
    </details>

<details>
  <summary>我的SEO经历</summary>


  ![](https://img.bmpi.dev/5494437c-08e0-0d08-5f91-6bdb4fcdece6.png)

  这是我做过的一个流量站，这么多流量最终让我赚了近乎1500美刀的广告收入。对于SEO大佬来说，这些流量不值一提，但是对于个人开发者来说，这是一项值得长期投资的技能。
</details>

<details>
  <summary>微信/电报/Discord交流</summary>
  
  ![](https://img.bmpi.dev/a0ff26e9-23ec-ffee-08b2-22c19c026e8a.png)

  [Telegram](https://t.me/bmpi_group)

  [Discord](https://discord.gg/S9mzJfqfKD)
</details>

<details>
  <summary>SEO资源大礼包</summary>
  
  加入电报/微信群领取此礼包。
  
  ![](https://img.bmpi.dev/4524f561-8feb-4fd3-852a-603dacc9b5c0.png)
</details>

<details>
  <summary>Stargazers over time</summary>


  [![Stargazers over time](https://starchart.cc/madawei2699/awesome-seo.svg)](https://starchart.cc/madawei2699/awesome-seo)
</details>

---

## 基础概念

[![什么是SEO](https://img.bmpi.dev/227e91cc-a2a8-942e-19fe-8246d9a7abbd.png)](https://www.bmpi.dev/dev/what-is-seo/)

## 教程

[Google站长指南](https://developers.google.com/search/docs/advanced/guidelines/overview?ref_topic=9428048&visit_id=637455340508159753-1629045620&rd=1)

> 站长指南，搞SEO必看。

[The Beginner's Guide to SEO](https://moz.com/beginners-guide-to-seo)

> Moz的SEO新手教程，可以系统性学习SEO。

[The Authority Site System 3.0](https://www.authorityhacker.com/system/)

> 这个课程是关于如何从零构建权威站（英文Niche站）并变现的，SEO只是其中一部分，还包括Affiliate，付费广告等。（课程费用比较贵，我还没开始学）

## 图书

[SEO艺术](https://book.douban.com/subject/34890213/)

> 国内的SEO垃圾书很多，这本是国外SEO三位大佬合写，第三版是2015年写的，时效性还行，如果只看一本关于SEO书的话，这本就够了。

[这就是搜索引擎](https://book.douban.com/subject/7006719/)

> 这本书是科普搜索引擎内部技术的，虽然搞SEO不需要了解搜索引擎内部实现，但是对于一些技术性优化，了解一些搜索引擎的特点有助于你从宏观局面优化网站。

## 文章/视频

[How Search Works](https://www.youtube.com/watch?v=BNHR6IQJGZs)

> Google出品的关于搜索引擎科普小视频。

[12 SEO Best Practices That Everyone Should Follow](https://ahrefs.com/blog/seo-best-practices/)

> ahrefs写的关于SEO的最佳实践。

[17 Actionable Content Marketing Tips For More Traffic](https://backlinko.com/content-marketing-tips)

> SEO里很重要一个方向是内容营销，这篇文章是反向链接研究大佬Brian Dean写的关于内容营销的建议。

[Here’s What We Learned About SEO](https://backlinko.com/search-engine-ranking)

> 这篇通过大量数据分析研究搜索引擎排名的影响因素。

[What Is SEO Writing? How to Be a Better SEO Writer](https://ahrefs.com/blog/seo-writing/)

> 基于SEO的写作建议和框架。

[The Authority Site Business Model](https://www.authorityhacker.com/what-is-an-authority-site/)

> 英文内容站从建设到盈利的一条龙流程介绍文章。

[零成本搭建SEO友好博客指南](https://www.bmpi.dev/series/%E9%9B%B6%E6%88%90%E6%9C%AC%E6%90%AD%E5%BB%BA%E7%8E%B0%E4%BB%A3%E5%8D%9A%E5%AE%A2%E6%8C%87%E5%8D%97/)

> 从零开始打造一个SEO友好的博客，涵盖博客搭建、SEO优化、订阅推送、国内及国外网站加载速度优化。

[Logfile Analysis for SEO](https://www.suganthan.com/blog/logfile-analysis-seo/)

> 此篇文章详细讲解了如何分析网站访问日志来发现SEO中的问题。GA可以帮助我们了解用户访问情况，系统日志能帮助我们更好的了解爬虫请求、网站技术性SEO问题如301跳转等问题。

### Google Ads

[Google Ads Benchmarks for YOUR Industry](https://www.wordstream.com/blog/ws/2016/02/29/google-adwords-industry-benchmarks)

> Last updated: October 5, 2020. 了解每个行业的吸金能力。

[如何准确查询关键词热度和搜索量](https://www.onepound.cn/article_info-144.html)

> 了解热度，规避红海竞争。

## 工具

[ahrefs](https://ahrefs.com/)

> 价格感人的SEO全面分析工具，如果有钱必备吧。

[semrush](https://www.semrush.com/)

> 价格感人的SEO全面分析工具，如果有钱必备吧。

[webpagetest](https://www.webpagetest.org/)

> 网站测速工具，技术性SEO优化必备。

[google pagespeed insights](https://developers.google.com/speed/pagespeed/insights/)

> 网站测速工具，技术性SEO优化必备。

[majestic](https://majestic.com/)

> 网站反向链接分析插件。

[moz](https://moz.com/)

> Open Site Explorer/MozBar插件。

[linkresearchtools](https://smart.linkresearchtools.com/seo-tools/free-seo-tools/)

> 免费SEO工具。

[raventools](https://raventools.com/)

> 链接建设全面工具箱。

[authoritylabs](https://www.authoritylabs.com/)

> 跟踪搜索引擎排名/解决GA关键词未提供问题。

[alexa](https://www.alexa.com/)

> 网站流量查看。数据来源于用户系统安装的Alexa工具栏，也可能从ISP厂商获取的数据。

[quantcast](https://www.quantcast.com/)

> 网站流量查看工具。

[seoquake](https://www.seoquake.com/index.html)

> semrush出品的SEO Chrome插件。

[spyfu](https://www.spyfu.com/)

## Chrome插件

[SimilarWeb](https://chrome.google.com/webstore/detail/similarweb-traffic-rank-w/hoklmmgfnpapgjgcpechhaamimifchmp)

> 查看网站PV流量的工具，但是结果有时候准确，有时候偏差挺大的。

[SEOquake](https://chrome.google.com/webstore/detail/seoquake/akdgnmcogleenhbclghghlkkdndkjdjc)

> 查看网站的SEO相关的信息，如外链数量、索引数量、SEO的站内问题等。

[Keyword Surfer](https://chrome.google.com/webstore/detail/keyword-surfer/bafijghppfhdpldihckdcadbcobikaca)

> 关键词工具，可以查看一些关键词的月搜索量。也可以用Google Ads的Keyword Planner查看关键词的月搜索量。

[SEO Minion](https://chrome.google.com/webstore/detail/seo-minion/giihipjfimkajhlcilipnjeohabimjhi)

> 网站常见站内问题检视工具。

[META SEO inspector](https://chrome.google.com/webstore/detail/meta-seo-inspector/ibkclpciafdglkjkcibmohobjkcfkaef)

> 网页Meta信息查看工具。

## 博客/Twitter

[SEO Twitter List](https://twitter.com/i/lists/1341048200677842950)

> 我整理的一些SEO大佬的Twitter列表。

[backlinko](https://backlinko.com/)

> 反向链接研究大佬Brian Dean的博客。

[谷歌网站管理员中心博客](https://developers.google.com/search/blog)

> Google出品。

[ahrefs blog](https://ahrefs.com/blog/)

> ahrefs高质量的SEO博客，不过会在文章中推销他们价格感人的分析工具。

[moz](https://moz.com/blog)

> moz高质量的SEO博客。

[英文SEO实战派](https://www.seoactionblog.com/)

> 作者John，对Google英文内容站很有研究。

[富裕者联盟](https://www.fuyuzhe.com/)

> Affiliate大佬，可以学习一些网赚技术。

[Harris](https://www.yesharris.com/learning-seo-menu/)

> SEO知识时效性强的台湾博客。

[SEO前线](http://seoqx.com/)

> 对百度SEO很有研究的noname大佬的博客。

[其他SEO相关博客](https://ahrefs.com/blog/seo-blogs/)

> ahrefs整理的其他SEO相关的博客。

## 社区

[Reddit SEO](https://www.reddit.com/r/SEO/hot/)

[Black Hat World](https://www.blackhatworld.com/)

[Webmaster World](https://www.webmasterworld.com/home.htm)

[Warrior Forum](https://www.warriorforum.com/)

> 以上社区我都没怎么混过，只是偶尔会看一些帖子，如果你们有好的社区可以给我PR。

## 流量变现

当有了一定的SEO流量（如月PV达1万），如何将SEO流量变现是个更重要的课题。一般来说我们可以通过广告平台如Google Adsense集成[互联网广告](https://www.bmpi.dev/dev/what-is-internet-advertising/)，这种英文CPM/CPC一般并不高（广告CPM/CPC取决于网站的内容/地区，不同内容广告的CPM/CPC范围介于$0.3-$2/$0.2-$15之间)，而中文站的流量广告价值更低（相比英文站）。

![](https://img.bmpi.dev/91bc8569-0fdc-ea98-478e-33d63205f340.png)

流量网站的目的是提高[RPM](https://tg.bmpi.dev/web_cpc/420.html)，除了广告之外网站还可以接入Affiliate（类似国内淘宝客，你帮商家推广产品自己拿佣金或返利）和售卖实体或虚拟产品（会员、课程）来提高RPM。

## 其他

[Google Algorithm Update History](https://moz.com/google-algorithm-change)

> Google目前比较重要的一些算法有熊猫算法、企鹅算法及蜂鸟算法等。这是Moz追踪Google搜索算法的更新页面。

[State of the Web](https://httparchive.org/reports/state-of-the-web)

> httparchive出的关于互联网HTTP相关的一些重要统计数据的报告。
