# awesome-seo

[中文/Chinese](./README_CN.md)

The checklist has been being sorted out since I systematically studied Google SEO in 2019.
The checklist would be updated from time to time. 
Meanwhile, welcome to check in PRs, and share the great links about SEO.

There are differences between Baidu SEO and Google SEO. If you have learned the Google SEO, you would understand how to learn Baidu SEO.

> Anything you want to discuss, you can join me on this [slack channel](https://slack-redirect.i365.tech/).

<details>
  <summary>SEO, Why Do You Need It?</summary>

On the Internet, website traffic can be turned into money. If you have mastered certain SEO techniques, you will have the advantages as following:  
  - Increase website traffic, then monetize traffic, and build your passive income.
  - If you have individual product, and the product need to be marketed and promoted. SEO can help you get free and steadily growing traffic.
  - SEO industry covers a wide range of fields. You can study some new technologies in researching SEO process.
</details>

<details>
  <summary>My SEO Experience</summary>

  ![](https://img.bmpi.dev/5494437c-08e0-0d08-5f91-6bdb4fcdece6.png)

This is the traffic site I made. I earned almost $1500 US in advertising revenue.
For SEO masters, maybe those amount of website traffic is too ordinary. However, for personal developer, these skills are worthy for long-term investment.
</details>

<details>
  <summary>WeChat/Telegram/Discord</summary>

![](https://img.bmpi.dev/755b406f-43ae-e382-e13c-547116d3e7d5.png)

[Telegram](https://t.me/bmpi_group)

[Discord](https://discord.gg/S9mzJfqfKD)
</details>

<details>
  <summary>SEO Resource Pack</summary>
  
  Join the Telegraph/WeChat group to receive this gift package.
  
  ![](https://img.bmpi.dev/4524f561-8feb-4fd3-852a-603dacc9b5c0.png)
</details>

<details>
  <summary>Stargazers over time</summary>

  [![Stargazers over time](https://starchart.cc/madawei2699/awesome-seo.svg)](https://starchart.cc/madawei2699/awesome-seo)
</details>

---

## Basic Concept

![What is SEO](https://img.bmpi.dev/4351f5c8-cc00-d2a8-a75f-9010c9367893.png)

## Tutorials

[Google Webmaster Guidelines](https://developers.google.com/search/docs/advanced/guidelines/overview?ref_topic=9428048&visit_id=637455340508159753-1629045620&rd=1)
> Webmaster Guidelines, must-read for SEO.

[The Beginner's Guide to SEO](https://moz.com/beginners-guide-to-seo)
> SEO beginners tutorial on the Moz web, helps you learn SEO systematically.

[The Authority Site System 3.0](https://www.authorityhacker.com/system/)
> This course is about how to build an authority site ( Niche Site) from scratch and make money from it. SEO is only a part of it, it also includes Affiliates, Paid-advertising etc. (The course is pretty expensive, and I haven't started it yet)

[A Technical SEO’s Guide to Crawl Budget Optimization](https://prerender.io/resources/free-downloads/white-papers/crawl-budget-guide/)
> A comprehensive guide explaining the importance of crawl budgets in managing indexing for search engines, how it impacts website traffic, and provides optimization tips to improve online visibility and SEO results.


## Books

[The Art of SEO](https://book.douban.com/subject/3780812/)
> In this book, four of the most noted experts in the field of search engine optimization (SEO) provide you with proven guidelines and cutting-edge techniques. The third edition was written in 2015, so if you only want to read one book about SEO, this book is the best option.

[这就是搜索引擎](https://book.douban.com/subject/7006719/)(Chinese Book)
> This book is about the internal technology of popular science search engines. Although Using SEO does not need to understand the internal implementation of search engines, for some technical optimization, understanding the characteristics of some search engines will help you optimize your website from a macro perspective.

## Article/Video

[How Search Works](https://www.youtube.com/watch?v=BNHR6IQJGZs)
> The videos about popular science search engine that Google published.

[12 SEO Best Practices That Everyone Should Follow](https://ahrefs.com/blog/seo-best-practices/)
> SEO best practices that Ahrefs write.

[17 Actionable Content Marketing Tips For More Traffic](https://backlinko.com/content-marketing-tips)
> The content marketing is one of important directions in SEO. The article content mainly involves content marketing suggestions, and it written by Brian Dean who research backlink.

[Here’s What We Learned About SEO](https://backlinko.com/search-engine-ranking)
> The article studies the factors influencing search engine rankings through large amounts of data analysis.

[What Is SEO Writing? How to Be a Better SEO Writer](https://ahrefs.com/blog/seo-writing/)
> The article mainly introduce the writing framework of SEO, and suggestions about how to be a better SEO write.

[The Authority Site Business Model](https://www.authorityhacker.com/what-is-an-authority-site/)
> The article introduce the whole process that an authority site from construction to profitability.

[零成本搭建SEO友好型博客指南](https://www.bmpi.dev/series/%E9%9B%B6%E6%88%90%E6%9C%AC%E6%90%AD%E5%BB%BA%E7%8E%B0%E4%BB%A3%E5%8D%9A%E5%AE%A2%E6%8C%87%E5%8D%97/)(Chinese Blogs)

> This is a series of blogs that introduces how to build a SEO from scratch. These blogs content covered blog building, SEO optimization, subcribe and push, website loading speed optimization.

[Logfile Analysis for SEO](https://www.suganthan.com/blog/logfile-analysis-seo/)
> This article detail explains how to analyse website access logs to identify problems in SEO. Google Analytics can help us understand user access, and system logs can help us better understand crawler requests, website techical SEO issues such as 301 redirects and so on.

### Google Ads

[Google Ads Benchmarks for YOUR Industry](https://www.wordstream.com/blog/ws/2016/02/29/google-adwords-industry-benchmarks)
> Last updated: October 5, 2020. 
> It can help to learn about the money-sucking power of each industry.

[如何准确查询关键词热度和搜索量](https://www.onepound.cn/article_info-144.html)(Chinese Website)

> For knowing what's hot on the web and avoiding Red Sea competition.

## Tools

[ahrefs](https://ahrefs.com/)
> SEO conprehensive analysis tool. 

[semrush](https://www.semrush.com/)
> SEO conprehensive analysis tool. 

[webpagetest](https://www.webpagetest.org/)
> Website speed measurement tool, essential for technical SEO optimization.

[google pagespeed insights](https://developers.google.com/speed/pagespeed/insights/)
> Website speed measurement tool, essential for technical SEO optimization.

[majestic](https://majestic.com/)
> Website Backlink Analysis Plugins. 

[moz](https://moz.com/)
> Open Site Explorer/MozBar Plugins. 

[linkresearchtools](https://smart.linkresearchtools.com/seo-tools/free-seo-tools/)
> Free SEO Tools. 

[raventools](https://raventools.com/)
> A comprehensive toolbox for link building. 

[authoritylabs](https://www.authoritylabs.com/)
> Track search engine rankings / Solve the problem of GA that keywords not provided.

[quantcast](https://www.quantcast.com/)

> Website Traffic View Tools. 

[seoquake](https://www.seoquake.com/index.html)
> SEO Chrome Plugin that published by semrush. 

[spyfu](https://www.spyfu.com/)

[Prerender](https://prerender.io/)
> Prerender serves 100% cached versions of your web pages to search engine bots that have problems executing JavaScript.

## Chrome Plugins

[SimilarWeb](https://chrome.google.com/webstore/detail/similarweb-traffic-rank-w/hoklmmgfnpapgjgcpechhaamimifchmp)
> The plugin to check the PV traffic of website. But the results are sometimes accurate and sometimes biased.

[SEOquake](https://chrome.google.com/webstore/detail/seoquake/akdgnmcogleenhbclghghlkkdndkjdjc)
> Check the SEO-related information of the website, such as the number of external links, the number of indexes, and SEO Internal website issues, etc.

[Keyword Surfer](https://chrome.google.com/webstore/detail/keyword-surfer/bafijghppfhdpldihckdcadbcobikaca)
> This is a keyword tool to view monthly search volume for a number of keywords. 
> Of course, you also can use Keyword Planner of Google Ads to view monthly search volume for a number of keywords. 

[SEO Minion](https://chrome.google.com/webstore/detail/seo-minion/giihipjfimkajhlcilipnjeohabimjhi)
> The view tool for common internal issues of website.

[META SEO inspector](https://chrome.google.com/webstore/detail/meta-seo-inspector/ibkclpciafdglkjkcibmohobjkcfkaef)
> The view tool for meta data of website.

## Blog/Twitter

[SEO Twitter List](https://twitter.com/i/lists/1341048200677842950)
> The list mainly show SEO masters Twitter.

[backlinko](https://backlinko.com/)
> Brian Dean’s Blog (He has some achievements in backlink research.)

[Google Search Central Blog](https://developers.google.com/search/blog)
> Published by Google.

[ahrefs blog](https://ahrefs.com/blog/)
> High-quality blogs about SEO that published by ahrefs. 

[moz](https://moz.com/blog)
> High-quality blogs about SEO that published by moz. 

[英文SEO实战派](https://www.seoactionblog.com/)(Chinese Blog)
> Author: John. He has amount of research on Google Authority Site.

[富裕者联盟](https://www.fuyuzhe.com/)(Chinese Blog)
> The author is Affiliate master, It can help you learn some online earning techniques.

[Harris](https://www.yesharris.com/learning-seo-menu/)(Chinese Blog)
> About SEO Timeliness.

[SEO前线](http://seoqx.com/)(Chinese Blog)
> Author: noname. He main research Baidu SEO.

[Other](https://ahrefs.com/blog/seo-blogs/)
> Collected by ahrefs.

## Community

[Reddit SEO](https://www.reddit.com/r/SEO/hot/)

[Black Hat World](https://www.blackhatworld.com/)

[Webmaster World](https://www.webmasterworld.com/home.htm)

[Warrior Forum](https://www.warriorforum.com/)

> If you want to recommend other good communities, please commit PR.

## Traffic Monetization

When there is a certain amount of SEO traffic(such as monthly PV reaching 10,000), how to monetize SEO traffic becomes a more important topic. Gernerally speaking, we can integrate [Internet Advertising](https://www.bmpi.dev/dev/what-is-internet-advertising/) through advertising platforms such as Google Adsense.
This CPM/CPC is generally not high. The Advertising CPM/CPC depends on the content/region of website. The CPM/CPC range of different content ads is between $0.3-$2.0/$0.2-$15.

![](https://img.bmpi.dev/91bc8569-0fdc-ea98-478e-33d63205f340.png)

The purpose of the traffic site is to improve [RPM](https://tg.bmpi.dev/web_cpc/420.html). In addition to advertising, the website can also access Affiliate and sell products(members, courses) to increase RPM.

## Other

[Google Algorithm Update History](https://moz.com/google-algorithm-change)
> Currently, Google has some of more important Google algorithms including the Panda algorithm, the Penguin algorithm, and the Hummingbird algorithm.
> This is the page that Moz tracks updates to Google's search algorithm.

[State of the Web](https://httparchive.org/reports/state-of-the-web)
> Some reports on important statistics related to HTTP on the Internet, published by httparchive.
