# BlueprintUI Layout

[![npm version](https://badge.fury.io/js/@blueprintui%2Flayout.svg)](https://badge.fury.io/js/@blueprintui%2Flayout)

### [Documentation](https://blueprintui.dev/docs/layout)

Blueprint Layout offers a streamlined CSS library, specifically designed to effortlessly construct responsive UI. Utilize its declarative approach to create adaptive layouts that dynamically respond to varying container sizes, providing truly encapsulated component arrangements.

## Key Features:

- Intuitive, declarative layout design
- Versatile grid, block, and inline layout options
- Responsive container queries for adaptive components
- Ultra-lightweight at just ~3kb of CSS

### Grid

```html
<!-- responsive 12 column grid using container queries -->
<div bp-layout="grid gap:sm cols:6">
  <div>1</div>
  <div>2</div>
  <div>3</div>
  <div>4</div>
</div>
```

### Block

```html
<div bp-layout="block gap:sm">
  <div>1</div>
  <div>2</div>
  <div>3</div>
  <div>4</div>
</div>
```

### Inline

```html
<div bp-layout="inline gap:sm">
  <div>1</div>
  <div>2</div>
  <div>3</div>
  <div>4</div>
</div>
```

### Versions

Latest https://blueprintui.dev/docs/layout

Legacy v3 https://blueprintcss.dev