import { html } from 'lit';
import { unsafeHTML } from 'lit/directives/unsafe-html.js';
import { visualDiff } from '@web/test-runner-visual-regression';
import { createVisualFixture, removeFixture } from '@blueprintui/test';
import * as icon from './element.examples.js';
import '@blueprintui/icons/include.js';

import '@blueprintui/icons/shapes/accessibility.js';
import '@blueprintui/icons/shapes/accessibility-two.js';
import '@blueprintui/icons/shapes/add-circle.js';
import '@blueprintui/icons/shapes/add.js';
import '@blueprintui/icons/shapes/add-text.js';
import '@blueprintui/icons/shapes/administrator.js';
import '@blueprintui/icons/shapes/airplane.js';
import '@blueprintui/icons/shapes/alarm-clock.js';
import '@blueprintui/icons/shapes/alarm-off.js';
import '@blueprintui/icons/shapes/alert.js';
import '@blueprintui/icons/shapes/align-bottom.js';
import '@blueprintui/icons/shapes/align-center.js';
import '@blueprintui/icons/shapes/align-left.js';
import '@blueprintui/icons/shapes/align-left-text.js';
import '@blueprintui/icons/shapes/align-middle.js';
import '@blueprintui/icons/shapes/align-right.js';
import '@blueprintui/icons/shapes/align-right-text.js';
import '@blueprintui/icons/shapes/align-top.js';
import '@blueprintui/icons/shapes/analytics.js';
import '@blueprintui/icons/shapes/angle-double.js';
import '@blueprintui/icons/shapes/angle.js';
import '@blueprintui/icons/shapes/animation.js';
import '@blueprintui/icons/shapes/application.js';
import '@blueprintui/icons/shapes/applications.js';
import '@blueprintui/icons/shapes/archive.js';
import '@blueprintui/icons/shapes/arrow.js';
import '@blueprintui/icons/shapes/assign-user.js';
import '@blueprintui/icons/shapes/asterisk.js';
import '@blueprintui/icons/shapes/atom.js';
import '@blueprintui/icons/shapes/attachment.js';
import '@blueprintui/icons/shapes/auto.js';
import '@blueprintui/icons/shapes/avatar.js';
import '@blueprintui/icons/shapes/axis-chart.js';
import '@blueprintui/icons/shapes/backup.js';
import '@blueprintui/icons/shapes/backup-restore.js';
import '@blueprintui/icons/shapes/balance.js';
import '@blueprintui/icons/shapes/ban.js';
import '@blueprintui/icons/shapes/bank.js';
import '@blueprintui/icons/shapes/bar-chart.js';
import '@blueprintui/icons/shapes/bar-code.js';
import '@blueprintui/icons/shapes/bars.js';
import '@blueprintui/icons/shapes/battery.js';
import '@blueprintui/icons/shapes/bell-curve.js';
import '@blueprintui/icons/shapes/bell.js';
import '@blueprintui/icons/shapes/beta.js';
import '@blueprintui/icons/shapes/bicycle.js';
import '@blueprintui/icons/shapes/bitcoin.js';
import '@blueprintui/icons/shapes/block.js';
import '@blueprintui/icons/shapes/block-quote.js';
import '@blueprintui/icons/shapes/blocks-group.js';
import '@blueprintui/icons/shapes/bluetooth.js';
import '@blueprintui/icons/shapes/bluetooth-off.js';
import '@blueprintui/icons/shapes/boat.js';
import '@blueprintui/icons/shapes/bold.js';
import '@blueprintui/icons/shapes/bolt.js';
import '@blueprintui/icons/shapes/book.js';
import '@blueprintui/icons/shapes/bookmark.js';
import '@blueprintui/icons/shapes/box-plot.js';
import '@blueprintui/icons/shapes/briefcase.js';
import '@blueprintui/icons/shapes/bubble-chart.js';
import '@blueprintui/icons/shapes/bubble-exclamation.js';
import '@blueprintui/icons/shapes/bug.js';
import '@blueprintui/icons/shapes/building.js';
import '@blueprintui/icons/shapes/bullet-list.js';
import '@blueprintui/icons/shapes/bullseye.js';
import '@blueprintui/icons/shapes/bundle.js';
import '@blueprintui/icons/shapes/calculator.js';
import '@blueprintui/icons/shapes/calendar.js';
import '@blueprintui/icons/shapes/camera.js';
import '@blueprintui/icons/shapes/campervan.js';
import '@blueprintui/icons/shapes/capacitor.js';
import '@blueprintui/icons/shapes/car.js';
import '@blueprintui/icons/shapes/caravan.js';
import '@blueprintui/icons/shapes/caret.js';
import '@blueprintui/icons/shapes/cd-dvd.js';
import '@blueprintui/icons/shapes/center-text.js';
import '@blueprintui/icons/shapes/certificate.js';
import '@blueprintui/icons/shapes/chat-bubble.js';
import '@blueprintui/icons/shapes/check.js';
import '@blueprintui/icons/shapes/checkbox-list.js';
import '@blueprintui/icons/shapes/child-arrow.js';
import '@blueprintui/icons/shapes/ci-cd.js';
import '@blueprintui/icons/shapes/circle-arrow.js';
import '@blueprintui/icons/shapes/circle.js';
import '@blueprintui/icons/shapes/clipboard.js';
import '@blueprintui/icons/shapes/clock.js';
import '@blueprintui/icons/shapes/clone.js';
import '@blueprintui/icons/shapes/close-circle.js';
import '@blueprintui/icons/shapes/close.js';
import '@blueprintui/icons/shapes/cloud-chart.js';
import '@blueprintui/icons/shapes/cloud.js';
import '@blueprintui/icons/shapes/cloud-network.js';
import '@blueprintui/icons/shapes/cloud-scale.js';
import '@blueprintui/icons/shapes/cloud-traffic.js';
import '@blueprintui/icons/shapes/cluster.js';
import '@blueprintui/icons/shapes/code.js';
import '@blueprintui/icons/shapes/cog.js';
import '@blueprintui/icons/shapes/coin-bag.js';
import '@blueprintui/icons/shapes/collapse-card.js';
import '@blueprintui/icons/shapes/collapse.js';
import '@blueprintui/icons/shapes/color-palette.js';
import '@blueprintui/icons/shapes/color-picker.js';
import '@blueprintui/icons/shapes/command.js';
import '@blueprintui/icons/shapes/compass.js';
import '@blueprintui/icons/shapes/computer.js';
import '@blueprintui/icons/shapes/connect.js';
import '@blueprintui/icons/shapes/container.js';
import '@blueprintui/icons/shapes/container-volume.js';
import '@blueprintui/icons/shapes/contract.js';
import '@blueprintui/icons/shapes/control-lun.js';
import '@blueprintui/icons/shapes/copy.js';
import '@blueprintui/icons/shapes/copy-to-clipboard.js';
import '@blueprintui/icons/shapes/cpu.js';
import '@blueprintui/icons/shapes/credit-card.js';
import '@blueprintui/icons/shapes/crosshairs.js';
import '@blueprintui/icons/shapes/crown.js';
import '@blueprintui/icons/shapes/cursor-arrow.js';
import '@blueprintui/icons/shapes/cursor-hand-click.js';
import '@blueprintui/icons/shapes/cursor-hand-grab.js';
import '@blueprintui/icons/shapes/cursor-hand.js';
import '@blueprintui/icons/shapes/cursor-hand-open.js';
import '@blueprintui/icons/shapes/cursor-move.js';
import '@blueprintui/icons/shapes/curve-chart.js';
import '@blueprintui/icons/shapes/dashboard.js';
import '@blueprintui/icons/shapes/data-cluster.js';
import '@blueprintui/icons/shapes/date.js';
import '@blueprintui/icons/shapes/deploy.js';
import '@blueprintui/icons/shapes/design.js';
import '@blueprintui/icons/shapes/details.js';
import '@blueprintui/icons/shapes/devices.js';
import '@blueprintui/icons/shapes/digital-signature.js';
import '@blueprintui/icons/shapes/directory.js';
import '@blueprintui/icons/shapes/disconnect.js';
import '@blueprintui/icons/shapes/disconnected.js';
import '@blueprintui/icons/shapes/display.js';
import '@blueprintui/icons/shapes/dna.js';
import '@blueprintui/icons/shapes/document.js';
import '@blueprintui/icons/shapes/dollar-bill.js';
import '@blueprintui/icons/shapes/dollar.js';
import '@blueprintui/icons/shapes/dot-circle.js';
import '@blueprintui/icons/shapes/download-cloud.js';
import '@blueprintui/icons/shapes/download.js';
import '@blueprintui/icons/shapes/drag-handle-corner.js';
import '@blueprintui/icons/shapes/drag-handle.js';
import '@blueprintui/icons/shapes/e-check.js';
import '@blueprintui/icons/shapes/edit.js';
import '@blueprintui/icons/shapes/ellipsis-horizontal.js';
import '@blueprintui/icons/shapes/ellipsis-vertical.js';
import '@blueprintui/icons/shapes/email.js';
import '@blueprintui/icons/shapes/employee-group.js';
import '@blueprintui/icons/shapes/employee.js';
import '@blueprintui/icons/shapes/envelope.js';
import '@blueprintui/icons/shapes/eraser.js';
import '@blueprintui/icons/shapes/error.js';
import '@blueprintui/icons/shapes/euro.js';
import '@blueprintui/icons/shapes/event.js';
import '@blueprintui/icons/shapes/expand-card.js';
import '@blueprintui/icons/shapes/export.js';
import '@blueprintui/icons/shapes/eye-hide.js';
import '@blueprintui/icons/shapes/eye.js';
import '@blueprintui/icons/shapes/factory.js';
import '@blueprintui/icons/shapes/fast-forward.js';
import '@blueprintui/icons/shapes/favorite.js';
import '@blueprintui/icons/shapes/ferry.js';
import '@blueprintui/icons/shapes/file-group.js';
import '@blueprintui/icons/shapes/file.js';
import '@blueprintui/icons/shapes/file-settings.js';
import '@blueprintui/icons/shapes/file-share-2.js';
import '@blueprintui/icons/shapes/file-share.js';
import '@blueprintui/icons/shapes/file-zip.js';
import '@blueprintui/icons/shapes/film-strip.js';
import '@blueprintui/icons/shapes/filter-2.js';
import '@blueprintui/icons/shapes/filter.js';
import '@blueprintui/icons/shapes/filter-off.js';
import '@blueprintui/icons/shapes/firewall.js';
import '@blueprintui/icons/shapes/first-aid-kit.js';
import '@blueprintui/icons/shapes/fish.js';
import '@blueprintui/icons/shapes/flag.js';
import '@blueprintui/icons/shapes/flame.js';
import '@blueprintui/icons/shapes/flask.js';
import '@blueprintui/icons/shapes/floppy.js';
import '@blueprintui/icons/shapes/flow-chart.js';
import '@blueprintui/icons/shapes/folder.js';
import '@blueprintui/icons/shapes/folder-open.js';
import '@blueprintui/icons/shapes/font-size.js';
import '@blueprintui/icons/shapes/forking.js';
import '@blueprintui/icons/shapes/form.js';
import '@blueprintui/icons/shapes/fuel.js';
import '@blueprintui/icons/shapes/gavel.js';
import '@blueprintui/icons/shapes/grid-chart.js';
import '@blueprintui/icons/shapes/grid-view.js';
import '@blueprintui/icons/shapes/group.js';
import '@blueprintui/icons/shapes/half-star.js';
import '@blueprintui/icons/shapes/happy-face.js';
import '@blueprintui/icons/shapes/hard-disk.js';
import '@blueprintui/icons/shapes/hard-drive-disks.js';
import '@blueprintui/icons/shapes/hard-drive.js';
import '@blueprintui/icons/shapes/hashtag.js';
import '@blueprintui/icons/shapes/headphones.js';
import '@blueprintui/icons/shapes/heart-broken.js';
import '@blueprintui/icons/shapes/heart.js';
import '@blueprintui/icons/shapes/heat-map.js';
import '@blueprintui/icons/shapes/helix.js';
import '@blueprintui/icons/shapes/help-info.js';
import '@blueprintui/icons/shapes/help.js';
import '@blueprintui/icons/shapes/highlighter.js';
import '@blueprintui/icons/shapes/history.js';
import '@blueprintui/icons/shapes/home.js';
import '@blueprintui/icons/shapes/host-group.js';
import '@blueprintui/icons/shapes/host.js';
import '@blueprintui/icons/shapes/hourglass.js';
import '@blueprintui/icons/shapes/id-badge.js';
import '@blueprintui/icons/shapes/image-gallery.js';
import '@blueprintui/icons/shapes/image.js';
import '@blueprintui/icons/shapes/import.js';
import '@blueprintui/icons/shapes/inbox.js';
import '@blueprintui/icons/shapes/indent.js';
import '@blueprintui/icons/shapes/inductor.js';
import '@blueprintui/icons/shapes/info.js';
import '@blueprintui/icons/shapes/install.js';
import '@blueprintui/icons/shapes/internet-of-things.js';
import '@blueprintui/icons/shapes/italic.js';
import '@blueprintui/icons/shapes/justify-text.js';
import '@blueprintui/icons/shapes/key.js';
import '@blueprintui/icons/shapes/keyboard.js';
import '@blueprintui/icons/shapes/landscape.js';
import '@blueprintui/icons/shapes/language.js';
import '@blueprintui/icons/shapes/launchpad.js';
import '@blueprintui/icons/shapes/layers.js';
import '@blueprintui/icons/shapes/library.js';
import '@blueprintui/icons/shapes/license.js';
import '@blueprintui/icons/shapes/lightbulb.js';
import '@blueprintui/icons/shapes/lightning.js';
import '@blueprintui/icons/shapes/line-chart.js';
import '@blueprintui/icons/shapes/link.js';
import '@blueprintui/icons/shapes/list.js';
import '@blueprintui/icons/shapes/lock.js';
import '@blueprintui/icons/shapes/login.js';
import '@blueprintui/icons/shapes/logout.js';
import '@blueprintui/icons/shapes/map.js';
import '@blueprintui/icons/shapes/map-marker.js';
import '@blueprintui/icons/shapes/media-changer.js';
import '@blueprintui/icons/shapes/memory.js';
import '@blueprintui/icons/shapes/menu.js';
import '@blueprintui/icons/shapes/microphone.js';
import '@blueprintui/icons/shapes/microphone-mute.js';
import '@blueprintui/icons/shapes/minus-circle.js';
import '@blueprintui/icons/shapes/minus.js';
import '@blueprintui/icons/shapes/mobile.js';
import '@blueprintui/icons/shapes/mobile-phone.js';
import '@blueprintui/icons/shapes/moon.js';
import '@blueprintui/icons/shapes/mouse.js';
import '@blueprintui/icons/shapes/music-note.js';
import '@blueprintui/icons/shapes/namespace.js';
import '@blueprintui/icons/shapes/network-globe.js';
import '@blueprintui/icons/shapes/network-settings.js';
import '@blueprintui/icons/shapes/network-switch.js';
import '@blueprintui/icons/shapes/neutral-face.js';
import '@blueprintui/icons/shapes/new.js';
import '@blueprintui/icons/shapes/no-access.js';
import '@blueprintui/icons/shapes/no-wifi.js';
import '@blueprintui/icons/shapes/node-group.js';
import '@blueprintui/icons/shapes/node.js';
import '@blueprintui/icons/shapes/nodes.js';
import '@blueprintui/icons/shapes/note.js';
import '@blueprintui/icons/shapes/notification.js';
import '@blueprintui/icons/shapes/number-list.js';
import '@blueprintui/icons/shapes/objects.js';
import '@blueprintui/icons/shapes/on-holiday.js';
import '@blueprintui/icons/shapes/organization.js';
import '@blueprintui/icons/shapes/outdent.js';
import '@blueprintui/icons/shapes/paint-roller.js';
import '@blueprintui/icons/shapes/paperclip.js';
import '@blueprintui/icons/shapes/paste.js';
import '@blueprintui/icons/shapes/pause.js';
import '@blueprintui/icons/shapes/pencil.js';
import '@blueprintui/icons/shapes/peso.js';
import '@blueprintui/icons/shapes/phone-handset.js';
import '@blueprintui/icons/shapes/picture.js';
import '@blueprintui/icons/shapes/pie-chart.js';
import '@blueprintui/icons/shapes/piggy-bank.js';
import '@blueprintui/icons/shapes/pin.js';
import '@blueprintui/icons/shapes/pinboard.js';
import '@blueprintui/icons/shapes/plane.js';
import '@blueprintui/icons/shapes/play.js';
import '@blueprintui/icons/shapes/plugin.js';
import '@blueprintui/icons/shapes/pod.js';
import '@blueprintui/icons/shapes/pop-out.js';
import '@blueprintui/icons/shapes/portrait.js';
import '@blueprintui/icons/shapes/pound.js';
import '@blueprintui/icons/shapes/power.js';
import '@blueprintui/icons/shapes/printer.js';
import '@blueprintui/icons/shapes/qr-code.js';
import '@blueprintui/icons/shapes/rack-server.js';
import '@blueprintui/icons/shapes/radar.js';
import '@blueprintui/icons/shapes/receiver.js';
import '@blueprintui/icons/shapes/recycle.js';
import '@blueprintui/icons/shapes/redo.js';
import '@blueprintui/icons/shapes/refresh.js';
import '@blueprintui/icons/shapes/repeat.js';
import '@blueprintui/icons/shapes/replay-all.js';
import '@blueprintui/icons/shapes/replay-one.js';
import '@blueprintui/icons/shapes/resistor.js';
import '@blueprintui/icons/shapes/resize-down.js';
import '@blueprintui/icons/shapes/resize.js';
import '@blueprintui/icons/shapes/resource-pool.js';
import '@blueprintui/icons/shapes/rewind.js';
import '@blueprintui/icons/shapes/router.js';
import '@blueprintui/icons/shapes/ruble.js';
import '@blueprintui/icons/shapes/ruler-pencil.js';
import '@blueprintui/icons/shapes/rupee.js';
import '@blueprintui/icons/shapes/sad-face.js';
import '@blueprintui/icons/shapes/savings.js';
import '@blueprintui/icons/shapes/scatter-plot.js';
import '@blueprintui/icons/shapes/scissors.js';
import '@blueprintui/icons/shapes/scroll.js';
import '@blueprintui/icons/shapes/search.js';
import '@blueprintui/icons/shapes/server.js';
import '@blueprintui/icons/shapes/settings.js';
import '@blueprintui/icons/shapes/share.js';
import '@blueprintui/icons/shapes/shield-check.js';
import '@blueprintui/icons/shapes/shield.js';
import '@blueprintui/icons/shapes/shield-x.js';
import '@blueprintui/icons/shapes/shopping-bag.js';
import '@blueprintui/icons/shapes/shopping-cart.js';
import '@blueprintui/icons/shapes/shrink.js';
import '@blueprintui/icons/shapes/shuffle.js';
import '@blueprintui/icons/shapes/sign-in.js';
import '@blueprintui/icons/shapes/sign-out.js';
import '@blueprintui/icons/shapes/slider.js';
import '@blueprintui/icons/shapes/snowflake.js';
import '@blueprintui/icons/shapes/sort-by.js';
import '@blueprintui/icons/shapes/squid.js';
import '@blueprintui/icons/shapes/ssd.js';
import '@blueprintui/icons/shapes/star.js';
import '@blueprintui/icons/shapes/step-forward-2.js';
import '@blueprintui/icons/shapes/step-forward.js';
import '@blueprintui/icons/shapes/stop.js';
import '@blueprintui/icons/shapes/storage-adapter.js';
import '@blueprintui/icons/shapes/storage.js';
import '@blueprintui/icons/shapes/store.js';
import '@blueprintui/icons/shapes/strikethrough.js';
import '@blueprintui/icons/shapes/subscript.js';
import '@blueprintui/icons/shapes/success.js';
import '@blueprintui/icons/shapes/sun.js';
import '@blueprintui/icons/shapes/superscript.js';
import '@blueprintui/icons/shapes/switch.js';
import '@blueprintui/icons/shapes/sync.js';
import '@blueprintui/icons/shapes/table.js';
import '@blueprintui/icons/shapes/tablet.js';
import '@blueprintui/icons/shapes/tag.js';
import '@blueprintui/icons/shapes/tags.js';
import '@blueprintui/icons/shapes/talk-bubbles.js';
import '@blueprintui/icons/shapes/tape-drive.js';
import '@blueprintui/icons/shapes/target.js';
import '@blueprintui/icons/shapes/tasks.js';
import '@blueprintui/icons/shapes/terminal.js';
import '@blueprintui/icons/shapes/text-color.js';
import '@blueprintui/icons/shapes/text.js';
import '@blueprintui/icons/shapes/thermometer.js';
import '@blueprintui/icons/shapes/thin-client.js';
import '@blueprintui/icons/shapes/thumbs-down.js';
import '@blueprintui/icons/shapes/thumbs-up.js';
import '@blueprintui/icons/shapes/tick-chart.js';
import '@blueprintui/icons/shapes/timeline.js';
import '@blueprintui/icons/shapes/tools.js';
import '@blueprintui/icons/shapes/trailer.js';
import '@blueprintui/icons/shapes/trash.js';
import '@blueprintui/icons/shapes/tree.js';
import '@blueprintui/icons/shapes/tree-view.js';
import '@blueprintui/icons/shapes/truck.js';
import '@blueprintui/icons/shapes/two-way-arrows.js';
import '@blueprintui/icons/shapes/unarchive.js';
import '@blueprintui/icons/shapes/underline.js';
import '@blueprintui/icons/shapes/undo.js';
import '@blueprintui/icons/shapes/uninstall.js';
import '@blueprintui/icons/shapes/unknown-status.js';
import '@blueprintui/icons/shapes/unlink.js';
import '@blueprintui/icons/shapes/unlock.js';
import '@blueprintui/icons/shapes/update.js';
import '@blueprintui/icons/shapes/upload-cloud.js';
import '@blueprintui/icons/shapes/upload.js';
import '@blueprintui/icons/shapes/usb.js';
import '@blueprintui/icons/shapes/user.js';
import '@blueprintui/icons/shapes/users.js';
import '@blueprintui/icons/shapes/video-camera.js';
import '@blueprintui/icons/shapes/video-gallery.js';
import '@blueprintui/icons/shapes/view-cards.js';
import '@blueprintui/icons/shapes/view-columns.js';
import '@blueprintui/icons/shapes/view-list.js';
import '@blueprintui/icons/shapes/volume-down.js';
import '@blueprintui/icons/shapes/volume.js';
import '@blueprintui/icons/shapes/volume-mute.js';
import '@blueprintui/icons/shapes/volume-up.js';
import '@blueprintui/icons/shapes/wallet.js';
import '@blueprintui/icons/shapes/wand.js';
import '@blueprintui/icons/shapes/warning.js';
import '@blueprintui/icons/shapes/wifi.js';
import '@blueprintui/icons/shapes/window-max.js';
import '@blueprintui/icons/shapes/window-min.js';
import '@blueprintui/icons/shapes/window-restore.js';
import '@blueprintui/icons/shapes/won.js';
import '@blueprintui/icons/shapes/world.js';
import '@blueprintui/icons/shapes/wrench.js';
import '@blueprintui/icons/shapes/yen.js';
import '@blueprintui/icons/shapes/zoom-in.js';
import '@blueprintui/icons/shapes/zoom-out.js';

describe('bp-icon', () => {
  let fixture: HTMLElement;

  beforeEach(async () => {
    fixture = await createVisualFixture(html`
      ${unsafeHTML(icon.example())} ${unsafeHTML(icon.all())} ${unsafeHTML(icon.solid())} ${unsafeHTML(icon.badge())}
      ${unsafeHTML(icon.size())}
    `);
  });

  afterEach(() => {
    removeFixture(fixture);
  });

  it('light theme', async () => {
    await visualDiff(fixture, 'icon/light.png');
  });

  it('dark theme', async () => {
    document.documentElement.setAttribute('bp-theme', 'dark');
    await visualDiff(fixture, 'icon/dark.png');
  });
});
