﻿include_guard( DIRECTORY )

# Parse the VERSION file.
set_property(DIRECTORY APPEND PROPERTY CMAKE_CONFIGURE_DEPENDS VERSION)
file(READ "VERSION" VERSION_FILE_CONTENTS)
string(REGEX MATCH
  "([0-9]+)\.([0-9]+)\.([0-9]+)(-[a-zA-Z0-9]+)?"
  ${PROJECT_NAME}_VERSION_STRING ${VERSION_FILE_CONTENTS})
if(NOT ${PROJECT_NAME}_VERSION_STRING)
  message(FATAL_ERROR "Could not parse 'VERSION' file")
endif()
set(${PROJECT_NAME}_VERSION_MAJOR  ${CMAKE_MATCH_1})
set(${PROJECT_NAME}_VERSION_MINOR  ${CMAKE_MATCH_2})
set(${PROJECT_NAME}_VERSION_PATCH  ${CMAKE_MATCH_3})
set(${PROJECT_NAME}_VERSION_SUFFIX ${CMAKE_MATCH_4})

set(PROJECT_VERSION
  "${${PROJECT_NAME}_VERSION_MAJOR}.${${PROJECT_NAME}_VERSION_MINOR}.${${PROJECT_NAME}_VERSION_PATCH}")

set(${PROJECT_NAME}_VERSION
  "${${PROJECT_NAME}_VERSION_MAJOR}.${${PROJECT_NAME}_VERSION_MINOR}.${${PROJECT_NAME}_VERSION_PATCH}")
