# -*- coding: utf-8 -*-
"""
Tencent is pleased to support the open source community by making 蓝鲸智云PaaS平台社区版 (BlueKing PaaS
Community Edition) available.
Copyright (C) 2017-2018 THL A29 Limited, a Tencent company. All rights reserved.
Licensed under the MIT License (the "License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at http://opensource.org/licenses/MIT
Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
specific language governing permissions and limitations under the License.
"""

from builtins import str
from builtins import object
from django.db import models

from common.constants import APPROVAL_RESULT_CHOICE, RoleCodeEnum
from user_center.manager import WxBkUserTmpRecordManager


class RoleApplyReocrd(models.Model):
    """
    用户角色权限申请记录
    """

    operator = models.CharField(u"申请人", max_length=32)
    create_time = models.DateTimeField(u"创建时间", auto_now_add=True, blank=True, null=True)
    apply_reason = models.TextField(u"申请原因", blank=True, null=True)
    apply_role = models.CharField(u"申请的角色", max_length=32, default=str(RoleCodeEnum.DEVELOPER))

    approver = models.CharField(u"审批人", max_length=32, blank=True, null=True)
    approval_result = models.CharField(u"审批结果", max_length=32, choices=APPROVAL_RESULT_CHOICE, default="applying")
    approval_time = models.DateTimeField(u"审批时间", null=True, blank=True)
    approval_reason = models.TextField(u"审批原因", blank=True, null=True)

    class Meta(object):
        verbose_name = u"用户角色权限表"
        verbose_name_plural = u"用户角色权限表"
        db_table = "console_user_role_apply_record"

    def __unicode__(self):
        return "%s(%s)" % (self.operator, self.apply_role)


class WxBkUserTmpRecord(models.Model):
    """
    微信与蓝鲸用户绑定过程临时表（后续可迁移到redis中，并设置过期时间）
    """

    username = models.CharField(u"用户名", max_length=32)
    bk_token = models.CharField(u"登录态token", max_length=255)
    wx_ticket = models.CharField(u"微信临时标识(state或二维码ticket)", max_length=127, unique=True, db_index=True)
    create_time = models.DateTimeField(u"创建时间", auto_now_add=True, blank=True, null=True)

    objects = WxBkUserTmpRecordManager()

    class Meta(object):
        verbose_name = u"微信与蓝鲸用户绑定过程临时表"
        verbose_name_plural = u"微信与蓝鲸用户绑定过程临时表"
        db_table = "console_wx_bkuser_tmp_record"

    def __unicode__(self):
        return self.username
