# API网关介绍

蓝鲸API网关（API Gateway）是蓝鲸体系的API托管服务。可以帮助开发者创建、发布、维护、和保护API，以快速、低成本、低风险地开放系统的数据或服务。
API网关支持组件编码接入和在线自助接入两种接入方式，并提供了统一的**用户认证**、**蓝鲸应用鉴权**、**请求转发**、**日志记录**等功能。


### 组件编码接入

API网关中，开发者编写组件代码，并通过 [通道管理](/esb/manager/channel/list/){:target="_blank"}，添加组件通道配置，提供API服务。

组件通道配置，通过 **组件代号**，与代码中的组件类进行关联。组件代号由API网关根据组件代码自动生成，规则如下：

- 组件代号由三部分组成：`前缀`.`系统名`.`组件类名`

- 前缀：默认为 `generic`

- 系统名：由组件类的 sys_name 属性指定，并转换为小写格式

- 组件类名：组件类的类名，类名非首字母的大写字母前加下划线，并转换为小写格式，如 GetHostList 转换为 get_host_list

根据上述规则，系统 CMDB 组件类 GetHostList 的组件代号为：`generic.cmdb.get_host_list`


### 在线自助接入

API网关中，开发者通过 [自助接入](/esb/manager/buffet_comp/list/){:target="_blank"}，在线配置接口信息，提供API服务。

自助接入方式，开发者不需要编写代码，仅通过配置，即可将自己的接口接入API网关。


## 名词解释

### 系统
系统主要用于对API进行分类，在API网关中，每一个API只能属于一个系统；系统的名称是系统的唯一标识，主要由字母和数字组成。
`注：系统 CC、JOB、GSE、DATA、AUTH、BK_LOGIN、BK_PAAS 为默认系统，注册系统时，不能使用`
